/*
 * Decompiled with CFR 0.152.
 */
package org.mpxj.openplan;

import java.time.LocalTime;
import java.util.List;
import org.apache.poi.poifs.filesystem.DirectoryEntry;
import org.mpxj.ProjectCalendar;
import org.mpxj.ProjectFile;
import org.mpxj.ProjectProperties;
import org.mpxj.openplan.ActivityCodeReader;
import org.mpxj.openplan.ActivityReader;
import org.mpxj.openplan.AssignmentReader;
import org.mpxj.openplan.CalendarDirectoryReader;
import org.mpxj.openplan.CodeDirectoryReader;
import org.mpxj.openplan.DependenciesReader;
import org.mpxj.openplan.DirectoryReader;
import org.mpxj.openplan.OpenPlanException;
import org.mpxj.openplan.RelationReader;
import org.mpxj.openplan.ResourceDirectoryReader;
import org.mpxj.openplan.Row;
import org.mpxj.openplan.TableReader;

class ProjectDirectoryReader
extends DirectoryReader {
    private final DirectoryEntry m_root;
    private final ProjectFile m_file;

    public ProjectDirectoryReader(DirectoryEntry root) {
        this.m_root = root;
        this.m_file = new ProjectFile();
    }

    public ProjectFile read(String name) {
        DirectoryEntry dir = this.getDirectoryEntry(this.m_root, name);
        List<Row> rows = new TableReader(dir, "PRJ").read();
        if (rows.size() != 1) {
            throw new OpenPlanException("Expecting 1 project row, found " + rows.size());
        }
        this.readProjectProperties(rows.get(0));
        DependenciesReader dependencies = new DependenciesReader(dir).read();
        CodeDirectoryReader codeReader = new CodeDirectoryReader(this.m_root);
        dependencies.getCodes().forEach(codeReader::read);
        ActivityCodeReader activityCodeReader = new ActivityCodeReader(dir, this.m_file);
        activityCodeReader.read(codeReader.getCodes());
        CalendarDirectoryReader calendarReader = new CalendarDirectoryReader(this.m_root, this.m_file);
        dependencies.getCalendars().forEach(calendarReader::read);
        ProjectCalendar defaultCalendar = calendarReader.getMap().get("< Default >");
        if (defaultCalendar != null) {
            this.m_file.setDefaultCalendar(defaultCalendar);
        } else {
            this.m_file.addDefaultBaseCalendar();
        }
        ResourceDirectoryReader resourceReader = new ResourceDirectoryReader(this.m_root, this.m_file);
        dependencies.getResources().forEach(resourceReader::read);
        ActivityReader activityReader = new ActivityReader(dir, this.m_file);
        activityReader.read(activityCodeReader.getCodeMap(), calendarReader.getMap());
        RelationReader relationReader = new RelationReader(dir, this.m_file);
        relationReader.read();
        AssignmentReader assignmentReader = new AssignmentReader(dir, this.m_file);
        assignmentReader.read();
        this.m_file.readComplete();
        return this.m_file;
    }

    private void readProjectProperties(Row row) {
        ProjectProperties props = this.m_file.getProjectProperties();
        props.setFileApplication("Deltek OpenPlan");
        props.setFileType("BK3");
        props.setBaselineFinish(row.getDate("BFDATE"));
        props.setBaselineStart(row.getDate("BSDATE"));
        props.setDefaultEndTime(LocalTime.of(row.getInteger("DEFENDHR"), row.getInteger("DEFENDMN")));
        props.setDefaultStartTime(LocalTime.of(row.getInteger("DEFSTARTHR"), row.getInteger("DEFSTARTMN")));
        props.setName(row.getString("DESCRIPTION"));
        props.setLastSaved(row.getDate("LASTUPDATE"));
        props.setMinutesPerDay(row.getInteger("MNPERDAY"));
        props.setMinutesPerMonth(row.getInteger("MNPERMON"));
        props.setMinutesPerWeek(row.getInteger("MNPERWK"));
        props.setCompany(row.getString("OPCOMPANY"));
        props.setManager(row.getString("OPMANAGER"));
        props.setFinishDate(row.getDate("SFDATE"));
        props.setStartDate(row.getDate("STARTDATE"));
        props.setStatusDate(row.getDate("STATDATE"));
    }
}

