/*
 * Decompiled with CFR 0.152.
 */
package org.mpxj.openplan;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.poi.poifs.filesystem.DirectoryEntry;
import org.mpxj.ProjectFile;
import org.mpxj.Relation;
import org.mpxj.RelationType;
import org.mpxj.Task;
import org.mpxj.openplan.Row;
import org.mpxj.openplan.TableReader;

class RelationReader {
    private final ProjectFile m_file;
    private final DirectoryEntry m_root;
    private static final Map<String, RelationType> TYPE_MAP = new HashMap<String, RelationType>();

    public RelationReader(DirectoryEntry root, ProjectFile file) {
        this.m_root = root;
        this.m_file = file;
    }

    public void read() {
        Map<UUID, Task> map = this.m_file.getTasks().stream().collect(Collectors.toMap(Task::getGUID, t -> t));
        for (Row row : new TableReader(this.m_root, "REL").read()) {
            Task predecessor = map.get(row.getUuid("PRED_ACT_UID"));
            Task successor = map.get(row.getUuid("SUCC_ACT_UID"));
            if (predecessor == null || successor == null) continue;
            successor.addPredecessor(new Relation.Builder().predecessorTask(predecessor).type(TYPE_MAP.getOrDefault(row.getString("REL_TYPE"), RelationType.FINISH_START)).lag(row.getDuration("REL_LAG")));
        }
    }

    static {
        TYPE_MAP.put("SS", RelationType.START_START);
        TYPE_MAP.put("SF", RelationType.START_FINISH);
        TYPE_MAP.put("FS", RelationType.FINISH_START);
        TYPE_MAP.put("FF", RelationType.FINISH_FINISH);
    }
}

