/*
 * Decompiled with CFR 0.152.
 */
package org.mpxj.openplan;

import java.time.LocalDateTime;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.poi.poifs.filesystem.DirectoryEntry;
import org.mpxj.Availability;
import org.mpxj.ProjectFile;
import org.mpxj.Resource;
import org.mpxj.UnitOfMeasureContainer;
import org.mpxj.common.HierarchyHelper;
import org.mpxj.openplan.DirectoryReader;
import org.mpxj.openplan.OpenPlanHierarchyHelper;
import org.mpxj.openplan.Row;
import org.mpxj.openplan.TableReader;

class ResourceDirectoryReader
extends DirectoryReader {
    private final ProjectFile m_file;
    private final DirectoryEntry m_root;

    public ResourceDirectoryReader(DirectoryEntry root, ProjectFile file) {
        this.m_root = root;
        this.m_file = file;
    }

    public void read(String name) {
        DirectoryEntry dir = this.getDirectoryEntry(this.m_root, name);
        HashMap<String, Resource> map = new HashMap<String, Resource>();
        List<Row> rows = new TableReader(dir, "RES").read();
        HierarchyHelper.sortHierarchy(rows, r -> r.getString("RES_ID"), r -> OpenPlanHierarchyHelper.getParentID(r.getString("RES_ID")), Comparator.comparing(o -> o.getString("RES_ID")));
        UnitOfMeasureContainer uom = this.m_file.getUnitsOfMeasure();
        for (Row row : rows) {
            String resourceID = row.getString("RES_ID");
            Resource parentResource = (Resource)map.get(OpenPlanHierarchyHelper.getParentID(resourceID));
            Resource resource = parentResource == null ? this.m_file.addResource() : parentResource.addResource();
            resource.setName(row.getString("DESCRIPTION"));
            resource.setEmailAddress(row.getString("EMAIL"));
            resource.setType(row.getResourceType("RES_CLASS"));
            resource.setResourceID(resourceID);
            resource.setGUID(row.getUuid("RES_UID"));
            resource.setUnitOfMeasure(uom.getOrCreateByAbbreviation(row.getString("UNIT")));
            map.put(resource.getResourceID(), resource);
        }
        this.readAvailability(dir, map);
    }

    private void readAvailability(DirectoryEntry dir, Map<String, Resource> map) {
        List<Row> rows = new TableReader(dir, "AVL").read();
        for (Row row : rows) {
            Resource resource = map.get(row.getString("RES_ID"));
            if (resource == null) {
                return;
            }
            Double units = row.getDouble("RES_LEVEL") / 8.0 * 100.0;
            LocalDateTime finish = row.getDate("RFDATE");
            LocalDateTime start = row.getDate("RSDATE");
            resource.getAvailability().add(new Availability(start, finish, units));
        }
    }
}

