/*
 * Decompiled with CFR 0.152.
 */
package org.mpxj.phoenix;

import java.io.InputStream;
import java.io.PrintWriter;
import java.time.DayOfWeek;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import java.util.UUID;
import org.mpxj.ActivityCode;
import org.mpxj.ActivityCodeValue;
import org.mpxj.ActivityType;
import org.mpxj.ChildTaskContainer;
import org.mpxj.ConstraintType;
import org.mpxj.CostRateTable;
import org.mpxj.CostRateTableEntry;
import org.mpxj.Duration;
import org.mpxj.EventManager;
import org.mpxj.ProjectCalendar;
import org.mpxj.ProjectCalendarDays;
import org.mpxj.ProjectCalendarHours;
import org.mpxj.ProjectConfig;
import org.mpxj.ProjectFile;
import org.mpxj.ProjectProperties;
import org.mpxj.Rate;
import org.mpxj.RecurrenceType;
import org.mpxj.RecurringData;
import org.mpxj.Relation;
import org.mpxj.Resource;
import org.mpxj.SchedulingProgressedActivities;
import org.mpxj.Task;
import org.mpxj.TimeUnit;
import org.mpxj.common.AlphanumComparator;
import org.mpxj.common.DebugLogPrintWriter;
import org.mpxj.common.LocalDateHelper;
import org.mpxj.common.LocalDateTimeHelper;
import org.mpxj.common.NumberHelper;
import org.mpxj.common.SlackHelper;
import org.mpxj.phoenix.schema.phoenix4.Project;
import org.mpxj.reader.AbstractProjectStreamReader;

class Phoenix4ProjectReader
extends AbstractProjectStreamReader {
    private PrintWriter m_log;
    private ProjectFile m_projectFile;
    private Map<String, Task> m_activityMap;
    private Map<UUID, ActivityCodeValue> m_activityCodeValues;
    private Map<Project.Storepoints.Storepoint.Activities.Activity, Map<UUID, UUID>> m_activityCodeCache;
    private EventManager m_eventManager;
    private List<UUID> m_codeSequence;
    private final boolean m_useActivityCodesForTaskHierarchy;
    private static final Map<String, ActivityType> ACTIVITY_TYPE_MAP = new HashMap<String, ActivityType>();
    private static final Map<String, ConstraintType> CONSTRAINT_TYPE_MAP;
    private static final Map<String, NonWorkingDayFunction> NON_WORKING_DAY_MAP;

    public Phoenix4ProjectReader(boolean useActivityCodesForTaskHierarchy) {
        this.m_useActivityCodesForTaskHierarchy = useActivityCodesForTaskHierarchy;
    }

    @Override
    public ProjectFile read(InputStream stream) {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProjectFile read(Project phoenixProject, Project.Layouts.Layout activeLayout, Project.Storepoints.Storepoint storepoint) {
        this.openLogFile();
        try {
            this.m_projectFile = new ProjectFile();
            this.m_activityMap = new HashMap<String, Task>();
            this.m_activityCodeValues = new HashMap<UUID, ActivityCodeValue>();
            this.m_activityCodeCache = new HashMap<Project.Storepoints.Storepoint.Activities.Activity, Map<UUID, UUID>>();
            this.m_codeSequence = new ArrayList<UUID>();
            this.m_eventManager = this.m_projectFile.getEventManager();
            ProjectConfig config = this.m_projectFile.getProjectConfig();
            config.setAutoResourceUniqueID(true);
            config.setAutoOutlineLevel(false);
            config.setAutoOutlineNumber(false);
            config.setAutoWBS(false);
            this.m_projectFile.getProjectProperties().setFileApplication("Phoenix");
            this.m_projectFile.getProjectProperties().setFileType("PPX");
            this.addListenersToProject(this.m_projectFile);
            this.readProjectProperties(phoenixProject, activeLayout, storepoint);
            this.readCalendars(storepoint);
            this.readActivityCodes(storepoint);
            this.readTasks(phoenixProject, activeLayout, storepoint);
            this.readResources(storepoint);
            this.readRelationships(storepoint);
            this.m_projectFile.readComplete();
            ProjectFile projectFile = this.m_projectFile;
            return projectFile;
        }
        finally {
            this.m_projectFile = null;
            this.m_activityMap = null;
            this.m_activityCodeValues = null;
            this.m_activityCodeCache = null;
            this.m_codeSequence = null;
            this.closeLogFile();
        }
    }

    private void readProjectProperties(Project phoenixProject, Project.Layouts.Layout activeLayout, Project.Storepoints.Storepoint storepoint) {
        Project.Settings phoenixSettings = phoenixProject.getSettings();
        ProjectProperties mpxjProperties = this.m_projectFile.getProjectProperties();
        mpxjProperties.setCreationDate(storepoint.getCreationTime());
        mpxjProperties.setName(phoenixSettings.getTitle());
        mpxjProperties.setDefaultDurationUnits(phoenixSettings.getBaseunit());
        mpxjProperties.setStatusDate(storepoint.getDataDate());
        mpxjProperties.setStartDate(storepoint.getStart());
        mpxjProperties.setSchedulingProgressedActivities(activeLayout.isRetainedLogic() != false ? SchedulingProgressedActivities.RETAINED_LOGIC : (activeLayout.isProgressOverride() != false ? SchedulingProgressedActivities.PROGRESS_OVERRIDE : SchedulingProgressedActivities.ACTUAL_DATES));
        mpxjProperties.setGUID(storepoint.getUuid());
    }

    private void readActivityCodes(Project.Storepoints.Storepoint phoenixProject) {
        int activityCodeSequence = 0;
        Project.Storepoints.Storepoint.ActivityCodes activityCodes = phoenixProject.getActivityCodes();
        if (activityCodes != null) {
            for (Project.Storepoints.Storepoint.ActivityCodes.Code code : activityCodes.getCode()) {
                this.readActivityCode(code, ++activityCodeSequence);
            }
        }
    }

    private void readActivityCode(Project.Storepoints.Storepoint.ActivityCodes.Code code, Integer activityCodeSequence) {
        ActivityCode activityCode = new ActivityCode.Builder(this.m_projectFile).sequenceNumber(activityCodeSequence).name(code.getName()).build();
        UUID codeUUID = this.getCodeUUID(code.getUuid(), code.getName());
        int activityCodeValueSequence = 0;
        for (Project.Storepoints.Storepoint.ActivityCodes.Code.Value typeValue : code.getValue()) {
            ActivityCodeValue activityCodeValue = new ActivityCodeValue.Builder(this.m_projectFile).activityCode(activityCode).sequenceNumber(++activityCodeValueSequence).name(typeValue.getName()).description(typeValue.getName()).build();
            activityCode.addValue(activityCodeValue);
            String name = typeValue.getName();
            UUID uuid = this.getValueUUID(codeUUID, typeValue.getUuid(), name);
            this.m_activityCodeValues.put(uuid, activityCodeValue);
        }
        this.m_projectFile.getActivityCodes().add(activityCode);
    }

    private void readCalendars(Project.Storepoints.Storepoint phoenixProject) {
        Project.Storepoints.Storepoint.Calendars calendars = phoenixProject.getCalendars();
        if (calendars != null) {
            for (Project.Storepoints.Storepoint.Calendars.Calendar calendar : calendars.getCalendar()) {
                this.readCalendar(calendar);
            }
            ProjectCalendar defaultCalendar = this.m_projectFile.getCalendarByName(phoenixProject.getDefaultCalendar());
            if (defaultCalendar != null) {
                this.m_projectFile.getProjectProperties().setDefaultCalendar(defaultCalendar);
            }
        }
    }

    private void readCalendar(Project.Storepoints.Storepoint.Calendars.Calendar calendar) {
        ProjectCalendar mpxjCalendar = this.m_projectFile.addCalendar();
        mpxjCalendar.setName(calendar.getName());
        for (DayOfWeek day : DayOfWeek.values()) {
            mpxjCalendar.setWorkingDay(day, true);
        }
        calendar.getNonWork().stream().filter(n -> NON_WORKING_DAY_MAP.containsKey(n.getType())).forEach(n -> NON_WORKING_DAY_MAP.get(n.getType()).apply(this, mpxjCalendar, (Project.Storepoints.Storepoint.Calendars.Calendar.NonWork)n));
        for (DayOfWeek day : DayOfWeek.values()) {
            ProjectCalendarHours hours = mpxjCalendar.addCalendarHours(day);
            if (!mpxjCalendar.isWorkingDay(day)) continue;
            hours.add(ProjectCalendarDays.DEFAULT_WORKING_MORNING);
            hours.add(ProjectCalendarDays.DEFAULT_WORKING_AFTERNOON);
        }
    }

    private void addNonWorkingDay(ProjectCalendar mpxjCalendar, Project.Storepoints.Storepoint.Calendars.Calendar.NonWork nonWorkingDay) {
        mpxjCalendar.setWorkingDay(nonWorkingDay.getWeekday(), false);
    }

    private RecurringData recurringData(RecurrenceType type, Project.Storepoints.Storepoint.Calendars.Calendar.NonWork nonWork) {
        RecurringData data = new RecurringData();
        data.setRecurrenceType(type);
        data.setFrequency(nonWork.getInterval());
        data.setStartDate(LocalDateHelper.getLocalDate(nonWork.getStart()));
        data.setUseEndDate(NumberHelper.getInt(nonWork.getCount()) == 0);
        if (data.getUseEndDate()) {
            data.setFinishDate(LocalDateHelper.getLocalDate(nonWork.getUntil()));
        } else {
            data.setOccurrences(nonWork.getCount());
        }
        return data;
    }

    private void addDailyRecurringException(ProjectCalendar mpxjCalendar, Project.Storepoints.Storepoint.Calendars.Calendar.NonWork nonWork) {
        if (NumberHelper.getInt(nonWork.getCount()) == 1) {
            mpxjCalendar.addCalendarException(LocalDateHelper.getLocalDate(nonWork.getStart()));
        } else {
            RecurringData data = this.recurringData(RecurrenceType.DAILY, nonWork);
            mpxjCalendar.addCalendarException(data);
        }
    }

    private void addWeeklyRecurringException(ProjectCalendar mpxjCalendar, Project.Storepoints.Storepoint.Calendars.Calendar.NonWork nonWork) {
        RecurringData data = this.recurringData(RecurrenceType.WEEKLY, nonWork);
        data.setWeeklyDay(nonWork.getStart().getDayOfWeek(), true);
        mpxjCalendar.addCalendarException(data);
    }

    private void addMonthlyRecurringException(ProjectCalendar mpxjCalendar, Project.Storepoints.Storepoint.Calendars.Calendar.NonWork nonWork) {
        RecurringData data = this.recurringData(RecurrenceType.MONTHLY, nonWork);
        data.setRelative(NumberHelper.getInt(nonWork.getNthDow()) != 0);
        if (data.getRelative()) {
            data.setDayNumber(nonWork.getNthDow());
            data.setDayOfWeek(nonWork.getStart().getDayOfWeek());
        } else {
            data.setDayNumber(nonWork.getStart().getDayOfMonth());
        }
        mpxjCalendar.addCalendarException(data);
    }

    private void addYearlyRecurringException(ProjectCalendar mpxjCalendar, Project.Storepoints.Storepoint.Calendars.Calendar.NonWork nonWork) {
        RecurringData data = this.recurringData(RecurrenceType.YEARLY, nonWork);
        data.setRelative(NumberHelper.getInt(nonWork.getNthDow()) != 0);
        data.setMonthNumber(nonWork.getStart().getMonthValue());
        if (data.getRelative()) {
            data.setDayNumber(nonWork.getNthDow());
            data.setDayOfWeek(nonWork.getStart().getDayOfWeek());
        } else {
            data.setDayNumber(nonWork.getStart().getDayOfMonth());
        }
        mpxjCalendar.addCalendarException(data);
    }

    private void readResources(Project.Storepoints.Storepoint phoenixProject) {
        Project.Storepoints.Storepoint.Resources resources = phoenixProject.getResources();
        if (resources != null) {
            for (Project.Storepoints.Storepoint.Resources.Resource res : resources.getResource()) {
                Resource resource = this.readResource(res);
                this.readAssignments(resource, res);
            }
        }
    }

    private Resource readResource(Project.Storepoints.Storepoint.Resources.Resource phoenixResource) {
        Resource mpxjResource = this.m_projectFile.addResource();
        TimeUnit rateUnits = phoenixResource.getMonetarybase();
        if (rateUnits == null) {
            rateUnits = TimeUnit.HOURS;
        }
        mpxjResource.setName(phoenixResource.getName());
        mpxjResource.setType(phoenixResource.getType());
        mpxjResource.setUnitOfMeasure(this.m_projectFile.getUnitsOfMeasure().getOrCreateByAbbreviation(phoenixResource.getUnitslabel()));
        mpxjResource.setGUID(phoenixResource.getUuid());
        CostRateTable costRateTable = new CostRateTable();
        costRateTable.add(new CostRateTableEntry(LocalDateTimeHelper.START_DATE_NA, LocalDateTimeHelper.END_DATE_NA, (Number)phoenixResource.getMonetarycostperuse(), new Rate(phoenixResource.getMonetaryrate(), rateUnits)));
        mpxjResource.setCostRateTable(0, costRateTable);
        this.m_eventManager.fireResourceReadEvent(mpxjResource);
        return mpxjResource;
    }

    private void readTasks(Project phoenixProject, Project.Layouts.Layout activeLayout, Project.Storepoints.Storepoint storepoint) {
        this.processLayouts(phoenixProject, activeLayout);
        this.processActivities(storepoint);
        this.updateDates();
    }

    private void processLayouts(Project phoenixProject, Project.Layouts.Layout activeLayout) {
        Project.Layouts.Layout.CodeOptions codeOptions = activeLayout.getCodeOptions();
        if (codeOptions != null) {
            for (Project.Layouts.Layout.CodeOptions.CodeOption option : codeOptions.getCodeOption()) {
                if (!option.isShown().booleanValue()) continue;
                this.m_codeSequence.add(this.getCodeUUID(option.getCodeUuid(), option.getCode()));
            }
        }
    }

    private void processActivities(Project.Storepoints.Storepoint phoenixProject) {
        List<Project.Storepoints.Storepoint.Activities.Activity> activities;
        AlphanumComparator comparator = new AlphanumComparator();
        List<Project.Storepoints.Storepoint.Activities.Activity> list = activities = phoenixProject.getActivities() == null ? Collections.emptyList() : phoenixProject.getActivities().getActivity();
        if (this.m_log != null) {
            this.m_log.println("{");
            StringJoiner codeJoiner = new StringJoiner(",");
            this.m_codeSequence.forEach(code -> codeJoiner.add("\"" + code + "\""));
            this.m_log.println("\"codeSequence\": [" + codeJoiner + "],");
            StringJoiner sequenceJoiner = new StringJoiner(",");
            this.m_activityCodeValues.forEach((key, value) -> sequenceJoiner.add("\"" + key + "\": " + value.getSequenceNumber()));
            this.m_log.println("\"activityCodeSequence\": {" + sequenceJoiner + "},");
            StringJoiner activityJoiner = new StringJoiner(",");
            for (Project.Storepoints.Storepoint.Activities.Activity activity : activities) {
                Map<UUID, UUID> codes = this.getActivityCodes(activity);
                StringJoiner activityCodeJoiner = new StringJoiner(",");
                codes.forEach((key, value) -> activityCodeJoiner.add("\"" + key + "\": \"" + value + "\""));
                activityJoiner.add("\"" + activity.getId() + "\": {" + activityCodeJoiner + "}");
            }
            this.m_log.println("\"activityCodes\": {" + activityJoiner + "}}");
        }
        activities.sort((o1, o2) -> comparator.compare(o1.getId(), o2.getId()));
        activities.sort((o1, o2) -> {
            Map<UUID, UUID> codes1 = this.getActivityCodes((Project.Storepoints.Storepoint.Activities.Activity)o1);
            Map<UUID, UUID> codes2 = this.getActivityCodes((Project.Storepoints.Storepoint.Activities.Activity)o2);
            for (UUID code : this.m_codeSequence) {
                UUID codeValue1 = codes1.get(code);
                UUID codeValue2 = codes2.get(code);
                if (codeValue1 == null || codeValue2 == null) {
                    if (codeValue1 == null && codeValue2 == null) continue;
                    if (codeValue1 == null) {
                        return -1;
                    }
                    if (codeValue2 == null) {
                        return 1;
                    }
                }
                if (codeValue1.equals(codeValue2)) continue;
                Integer sequence1 = this.m_activityCodeValues.get(codeValue1) != null ? this.m_activityCodeValues.get(codeValue1).getSequenceNumber() : null;
                Integer sequence2 = this.m_activityCodeValues.get(codeValue2) != null ? this.m_activityCodeValues.get(codeValue2).getSequenceNumber() : null;
                return NumberHelper.compare(sequence1, sequence2);
            }
            return comparator.compare(o1.getId(), o2.getId());
        });
        for (Project.Storepoints.Storepoint.Activities.Activity activity : activities) {
            this.processActivity(activity);
        }
    }

    private void processActivity(Project.Storepoints.Storepoint.Activities.Activity activity) {
        Task task = this.m_useActivityCodesForTaskHierarchy ? this.getParentTask(activity).addTask() : this.m_projectFile.addTask();
        this.populateActivityCodes(task, this.getActivityCodes(activity));
        task.setActivityID(activity.getId());
        task.setActivityType(ACTIVITY_TYPE_MAP.get(activity.getType()));
        task.setActualDuration(activity.getActualDuration());
        task.setActualFinish(activity.getActualFinish());
        task.setActualStart(activity.getActualStart());
        task.setCalendar(this.m_projectFile.getCalendarByName(activity.getCalendar()));
        task.setCreateDate(activity.getCreationTime());
        task.setFinish(activity.getCurrentFinish());
        task.setStart(activity.getCurrentStart());
        task.setName(activity.getDescription());
        task.setDuration(activity.getDurationAtCompletion());
        task.setEarlyFinish(activity.getEarlyFinish());
        task.setEarlyStart(activity.getEarlyStart());
        task.setFreeSlack(activity.getFreeFloat());
        task.setLateFinish(activity.getLateFinish());
        task.setLateStart(activity.getLateStart());
        task.setNotes(activity.getNotes());
        task.setPlannedDuration(activity.getOriginalDuration());
        task.setPhysicalPercentComplete(activity.getPhysicalPercentComplete());
        task.setRemainingDuration(activity.getRemainingDuration());
        task.setCost(activity.getTotalCost());
        task.setTotalSlack(activity.getTotalFloat());
        task.setMilestone(this.activityIsMilestone(activity));
        task.setGUID(activity.getUuid());
        if (activity.getConstraint() != null) {
            Project.Storepoints.Storepoint.Activities.Activity.Constraint constraint = activity.getConstraint();
            task.setConstraintType(CONSTRAINT_TYPE_MAP.get(constraint.getType()));
            task.setConstraintDate(constraint.getDatetime());
        }
        if (task.getMilestone()) {
            if (this.activityIsStartMilestone(activity)) {
                task.setFinish(task.getStart());
            } else {
                task.setStart(task.getFinish());
            }
        }
        if (task.getDuration().getDuration() == 0.0) {
            if (LocalDateTimeHelper.compare(task.getStart(), task.getFinish()) > 0) {
                task.setFinish(task.getStart());
            }
            if (task.getActualStart() != null && task.getActualFinish() != null && LocalDateTimeHelper.compare(task.getActualStart(), task.getActualFinish()) > 0) {
                task.setActualFinish(task.getActualStart());
            }
        }
        if (task.getActualStart() == null) {
            task.setPercentageComplete(0);
        } else if (task.getActualFinish() != null) {
            task.setPercentageComplete(100);
        } else {
            Duration remaining = activity.getRemainingDuration();
            Duration total = activity.getDurationAtCompletion();
            if (remaining != null && total != null && total.getDuration() != 0.0) {
                double percentComplete = (total.getDuration() - remaining.getDuration()) * 100.0 / total.getDuration();
                task.setPercentageComplete(percentComplete);
            }
        }
        SlackHelper.inferSlack(task);
        this.m_activityMap.put(activity.getId(), task);
    }

    private void populateActivityCodes(Task task, Map<UUID, UUID> codeAssignments) {
        for (UUID valueUUID : codeAssignments.values()) {
            ActivityCodeValue value = this.m_activityCodeValues.get(valueUUID);
            if (value == null) continue;
            task.addActivityCodeValue(value);
        }
    }

    private boolean activityIsMilestone(Project.Storepoints.Storepoint.Activities.Activity activity) {
        String type = activity.getType();
        return type != null && type.contains("Milestone");
    }

    private boolean activityIsStartMilestone(Project.Storepoints.Storepoint.Activities.Activity activity) {
        String type = activity.getType();
        return type != null && type.contains("StartMilestone");
    }

    private ChildTaskContainer getParentTask(Project.Storepoints.Storepoint.Activities.Activity activity) {
        Map<UUID, UUID> map = this.getActivityCodes(activity);
        ChildTaskContainer parent = this.m_projectFile;
        StringBuilder uniqueIdentifier = new StringBuilder();
        for (UUID activityCode : this.m_codeSequence) {
            UUID valueUUID = map.get(activityCode);
            String activityCodeText = this.m_activityCodeValues.get(valueUUID) != null ? this.m_activityCodeValues.get(valueUUID).getName() : null;
            if (activityCodeText == null) continue;
            if (uniqueIdentifier.length() != 0) {
                uniqueIdentifier.append('>');
            }
            uniqueIdentifier.append(valueUUID.toString());
            UUID uuid = UUID.nameUUIDFromBytes(uniqueIdentifier.toString().getBytes());
            Task newParent = this.findChildTaskByUUID(parent, uuid);
            if (newParent == null) {
                newParent = parent.addTask();
                newParent.setGUID(uuid);
                newParent.setName(activityCodeText);
            }
            parent = newParent;
        }
        return parent;
    }

    private Task findChildTaskByUUID(ChildTaskContainer parent, UUID uuid) {
        Task result = null;
        for (Task task : parent.getChildTasks()) {
            if (!uuid.equals(task.getGUID())) continue;
            result = task;
            break;
        }
        return result;
    }

    private void readAssignments(Resource mpxjResource, Project.Storepoints.Storepoint.Resources.Resource res) {
        for (Project.Storepoints.Storepoint.Resources.Resource.Assignment assignment : res.getAssignment()) {
            this.readAssignment(mpxjResource, assignment);
        }
    }

    private void readAssignment(Resource resource, Project.Storepoints.Storepoint.Resources.Resource.Assignment assignment) {
        Task task = this.m_activityMap.get(assignment.getActivity());
        if (task != null) {
            task.addResourceAssignment(resource);
        }
    }

    private void readRelationships(Project.Storepoints.Storepoint phoenixProject) {
        Project.Storepoints.Storepoint.Relationships relationships = phoenixProject.getRelationships();
        if (relationships != null) {
            for (Project.Storepoints.Storepoint.Relationships.Relationship relation : relationships.getRelationship()) {
                this.readRelation(relation);
            }
        }
    }

    private void readRelation(Project.Storepoints.Storepoint.Relationships.Relationship relation) {
        Task predecessor = this.m_activityMap.get(relation.getPredecessor());
        Task successor = this.m_activityMap.get(relation.getSuccessor());
        if (predecessor != null && successor != null) {
            successor.addPredecessor(new Relation.Builder().predecessorTask(predecessor).type(relation.getType()).lag(relation.getLag()));
        }
    }

    Map<UUID, UUID> getActivityCodes(Project.Storepoints.Storepoint.Activities.Activity activity) {
        return this.m_activityCodeCache.computeIfAbsent(activity, this::getActivityCodesForCache);
    }

    private Map<UUID, UUID> getActivityCodesForCache(Project.Storepoints.Storepoint.Activities.Activity activity) {
        HashMap<UUID, UUID> map = new HashMap<UUID, UUID>();
        for (Project.Storepoints.Storepoint.Activities.Activity.CodeAssignment ca : activity.getCodeAssignment()) {
            UUID code = this.getCodeUUID(ca.getCodeUuid(), ca.getCode());
            UUID value = this.getValueUUID(code, ca.getValueUuid(), ca.getValue());
            map.put(code, value);
        }
        return map;
    }

    private UUID getCodeUUID(UUID uuid, String name) {
        return uuid == null ? UUID.nameUUIDFromBytes(name.getBytes()) : uuid;
    }

    private UUID getValueUUID(UUID parent, UUID uuid, String name) {
        UUID result = uuid == null ? UUID.nameUUIDFromBytes((parent.toString() + ":" + name).getBytes()) : uuid;
        return result;
    }

    private void updateDates() {
        for (Task task : this.m_projectFile.getChildTasks()) {
            this.updateDates(task);
        }
    }

    private void updateDates(Task parentTask) {
        if (parentTask.hasChildTasks()) {
            int finished = 0;
            LocalDateTime plannedStartDate = parentTask.getStart();
            LocalDateTime plannedFinishDate = parentTask.getFinish();
            LocalDateTime actualStartDate = parentTask.getActualStart();
            LocalDateTime actualFinishDate = parentTask.getActualFinish();
            LocalDateTime earlyStartDate = parentTask.getEarlyStart();
            LocalDateTime earlyFinishDate = parentTask.getEarlyFinish();
            LocalDateTime lateStartDate = parentTask.getLateStart();
            LocalDateTime lateFinishDate = parentTask.getLateFinish();
            boolean critical = false;
            for (Task task : parentTask.getChildTasks()) {
                this.updateDates(task);
                plannedStartDate = LocalDateTimeHelper.min(plannedStartDate, task.getStart());
                plannedFinishDate = LocalDateTimeHelper.max(plannedFinishDate, task.getFinish());
                actualStartDate = LocalDateTimeHelper.min(actualStartDate, task.getActualStart());
                actualFinishDate = LocalDateTimeHelper.max(actualFinishDate, task.getActualFinish());
                earlyStartDate = LocalDateTimeHelper.min(earlyStartDate, task.getEarlyStart());
                earlyFinishDate = LocalDateTimeHelper.max(earlyFinishDate, task.getEarlyFinish());
                lateStartDate = LocalDateTimeHelper.min(lateStartDate, task.getLateStart());
                lateFinishDate = LocalDateTimeHelper.max(lateFinishDate, task.getLateFinish());
                if (task.getActualFinish() != null) {
                    ++finished;
                }
                critical = critical || task.getCritical();
            }
            parentTask.setStart(plannedStartDate);
            parentTask.setFinish(plannedFinishDate);
            parentTask.setActualStart(actualStartDate);
            parentTask.setEarlyStart(earlyStartDate);
            parentTask.setEarlyFinish(earlyFinishDate);
            parentTask.setLateStart(lateStartDate);
            parentTask.setLateFinish(lateFinishDate);
            if (finished == parentTask.getChildTasks().size()) {
                parentTask.setActualFinish(actualFinishDate);
            }
            if (plannedStartDate != null && plannedFinishDate != null) {
                Duration duration = this.m_projectFile.getDefaultCalendar().getWork(plannedStartDate, plannedFinishDate, TimeUnit.DAYS);
                parentTask.setDuration(duration);
            }
            parentTask.getTotalSlack();
            parentTask.setCritical(critical);
        }
    }

    private void openLogFile() {
        this.m_log = DebugLogPrintWriter.getInstance();
    }

    private void closeLogFile() {
        if (this.m_log != null) {
            this.m_log.flush();
            this.m_log.close();
        }
    }

    static {
        ACTIVITY_TYPE_MAP.put("Task", ActivityType.TASK_DEPENDENT);
        ACTIVITY_TYPE_MAP.put("Hammock", ActivityType.HAMMOCK);
        ACTIVITY_TYPE_MAP.put("StartMilestone", ActivityType.START_MILESTONE);
        ACTIVITY_TYPE_MAP.put("FinishMilestone", ActivityType.FINISH_MILESTONE);
        ACTIVITY_TYPE_MAP.put("StartFlag", ActivityType.START_FLAG);
        ACTIVITY_TYPE_MAP.put("FinishFlag", ActivityType.FINISH_FLAG);
        CONSTRAINT_TYPE_MAP = new HashMap<String, ConstraintType>();
        CONSTRAINT_TYPE_MAP.put("StartNoLater", ConstraintType.START_NO_LATER_THAN);
        CONSTRAINT_TYPE_MAP.put("StartNoEarlier", ConstraintType.START_NO_EARLIER_THAN);
        CONSTRAINT_TYPE_MAP.put("FinishNoLater", ConstraintType.FINISH_NO_LATER_THAN);
        CONSTRAINT_TYPE_MAP.put("FinishNoEarlier", ConstraintType.FINISH_NO_EARLIER_THAN);
        CONSTRAINT_TYPE_MAP.put("AsLateAsPossible", ConstraintType.AS_LATE_AS_POSSIBLE);
        CONSTRAINT_TYPE_MAP.put("MustStartOn", ConstraintType.MUST_START_ON);
        CONSTRAINT_TYPE_MAP.put("MustFinishOn", ConstraintType.MUST_FINISH_ON);
        NON_WORKING_DAY_MAP = new HashMap<String, NonWorkingDayFunction>();
        NON_WORKING_DAY_MAP.put("internal_weekly", Phoenix4ProjectReader::addNonWorkingDay);
        NON_WORKING_DAY_MAP.put("daily", Phoenix4ProjectReader::addDailyRecurringException);
        NON_WORKING_DAY_MAP.put("weekly", Phoenix4ProjectReader::addWeeklyRecurringException);
        NON_WORKING_DAY_MAP.put("monthly", Phoenix4ProjectReader::addMonthlyRecurringException);
        NON_WORKING_DAY_MAP.put("yearly", Phoenix4ProjectReader::addYearlyRecurringException);
    }

    static interface NonWorkingDayFunction {
        public void apply(Phoenix4ProjectReader var1, ProjectCalendar var2, Project.Storepoints.Storepoint.Calendars.Calendar.NonWork var3);
    }
}

