/*
 * Decompiled with CFR 0.152.
 */
package org.mpxj.primavera;

import java.time.LocalDateTime;
import java.util.UUID;
import org.mpxj.Duration;
import org.mpxj.TimeUnit;
import org.mpxj.common.NumberHelper;
import org.mpxj.primavera.DatatypeConverter;
import org.mpxj.primavera.Row;

abstract class AbstractRow
implements Row {
    private final boolean m_ignoreErrors;

    public AbstractRow(boolean ignoreErrors) {
        this.m_ignoreErrors = ignoreErrors;
    }

    @Override
    public final String getString(String name) {
        try {
            Object value = this.getObject(name);
            String result = value == null ? null : (value instanceof byte[] ? new String((byte[])value) : value.toString());
            return result;
        }
        catch (Exception ex) {
            if (this.m_ignoreErrors) {
                return null;
            }
            throw ex;
        }
    }

    @Override
    public final Integer getInteger(String name) {
        try {
            Object result = this.getObject(name);
            if (result != null && !(result instanceof Integer)) {
                result = ((Number)result).intValue();
            }
            return (Integer)result;
        }
        catch (Exception ex) {
            if (this.m_ignoreErrors) {
                return null;
            }
            throw ex;
        }
    }

    @Override
    public final Double getDouble(String name) {
        try {
            Object result = this.getObject(name);
            if (result != null && !(result instanceof Double)) {
                result = ((Number)result).doubleValue();
            }
            return (Double)result;
        }
        catch (Exception ex) {
            if (this.m_ignoreErrors) {
                return null;
            }
            throw ex;
        }
    }

    @Override
    public final boolean getBoolean(String name) {
        Boolean result = this.getBooleanObject(name);
        return result != null && result != false;
    }

    @Override
    public final Boolean getBooleanObject(String name) {
        try {
            Object value = this.getObject(name);
            if (value == null) {
                return null;
            }
            if (value instanceof Boolean) {
                return (Boolean)value;
            }
            if (value instanceof Number) {
                return ((Number)value).doubleValue() != 0.0;
            }
            if (value instanceof String) {
                return this.parseBoolean((String)value);
            }
            return null;
        }
        catch (Exception ex) {
            if (this.m_ignoreErrors) {
                return null;
            }
            throw ex;
        }
    }

    @Override
    public final int getInt(String name) {
        try {
            return NumberHelper.getInt((Number)this.getObject(name));
        }
        catch (Exception ex) {
            if (this.m_ignoreErrors) {
                return 0;
            }
            throw ex;
        }
    }

    @Override
    public final LocalDateTime getDate(String name) {
        try {
            return (LocalDateTime)this.getObject(name);
        }
        catch (Exception ex) {
            if (this.m_ignoreErrors) {
                return null;
            }
            throw ex;
        }
    }

    @Override
    public final Duration getDuration(String name) {
        try {
            Double value = this.getDouble(name);
            if (value == null) {
                return null;
            }
            return Duration.getInstance(value, TimeUnit.HOURS);
        }
        catch (Exception ex) {
            if (this.m_ignoreErrors) {
                return null;
            }
            throw ex;
        }
    }

    @Override
    public final UUID getUUID(String name) {
        try {
            return DatatypeConverter.parseUUID(this.getString(name));
        }
        catch (Exception ex) {
            if (this.m_ignoreErrors) {
                return null;
            }
            throw ex;
        }
    }

    protected abstract Object getObject(String var1);

    private Boolean parseBoolean(String value) {
        return value != null && (value.equalsIgnoreCase("true") || value.equalsIgnoreCase("y") || value.equalsIgnoreCase("yes"));
    }
}

