/*
 * Decompiled with CFR 0.152.
 */
package org.mpxj.primavera;

import java.util.Optional;
import org.mpxj.Duration;
import org.mpxj.ProjectFile;
import org.mpxj.ResourceAssignment;
import org.mpxj.TimeUnit;
import org.mpxj.common.NumberHelper;

abstract class AbstractUnitsHelper {
    private final Double m_plannedUnits;
    private final Double m_plannedUnitsPerTime;
    private final Double m_remainingUnits;
    private final Double m_remainingUnitsPerTime;

    public AbstractUnitsHelper(ResourceAssignment assignment) {
        ProjectFile file = assignment.getParentFile();
        this.m_plannedUnits = this.getDurationInHours(file, Optional.ofNullable(assignment.getPlannedWork()).orElseGet(assignment::getWork));
        this.m_plannedUnitsPerTime = this.getPercentage(assignment.getUnits());
        this.m_remainingUnitsPerTime = this.getPercentage(assignment.getRemainingUnits());
        if (assignment.getActualStart() == null && (assignment.getActualWork() == null || assignment.getActualWork().getDuration() == 0.0)) {
            this.m_remainingUnits = this.m_plannedUnits;
        } else {
            Double actualUnits = this.getDurationInHours(file, assignment.getActualWork());
            Double atCompletionUnits = this.getDurationInHours(file, assignment.getWork());
            this.m_remainingUnits = assignment.getActualFinish() == null && NumberHelper.getDouble(actualUnits) < NumberHelper.getDouble(atCompletionUnits) ? this.getDurationInHours(file, assignment.getRemainingWork()) : NumberHelper.DOUBLE_ZERO;
        }
    }

    public Double getPlannedUnits() {
        return this.m_plannedUnits;
    }

    public Double getPlannedUnitsPerTime() {
        return this.m_plannedUnitsPerTime;
    }

    public Double getRemainingUnits() {
        return this.m_remainingUnits;
    }

    public Double getRemainingUnitsPerTime() {
        return this.m_remainingUnitsPerTime;
    }

    private Double getDurationInHours(ProjectFile file, Duration duration) {
        Double result;
        if (duration == null) {
            result = null;
        } else {
            if (duration.getUnits() != TimeUnit.HOURS) {
                duration = duration.convertUnits(TimeUnit.HOURS, file.getProjectProperties());
            }
            result = (double)Math.round(duration.getDuration() * this.getScale()) / this.getScale();
        }
        return result;
    }

    private Double getPercentage(Number number) {
        Double result = null;
        if (number != null) {
            result = number.doubleValue() / 100.0;
        }
        return result;
    }

    protected abstract double getScale();
}

