/*
 * Decompiled with CFR 0.152.
 */
package org.mpxj.primavera;

import java.util.HashMap;
import java.util.Map;
import org.mpxj.AccrueType;

final class AccrueTypeHelper {
    private static final Map<String, AccrueType> XML_TYPE_MAP = new HashMap<String, AccrueType>();
    private static final Map<String, AccrueType> XER_TYPE_MAP;
    private static final Map<AccrueType, String> TYPE_XML_MAP;
    private static final Map<AccrueType, String> TYPE_XER_MAP;

    AccrueTypeHelper() {
    }

    public static AccrueType getInstanceFromXml(String value) {
        return XML_TYPE_MAP.get(value);
    }

    public static AccrueType getInstanceFromXer(String value) {
        return XER_TYPE_MAP.get(value);
    }

    public static String getXmlFromInstance(AccrueType value) {
        return TYPE_XML_MAP.get(value);
    }

    public static String getXerFromInstance(AccrueType value) {
        return TYPE_XER_MAP.get(value);
    }

    static {
        XML_TYPE_MAP.put("Uniform Over Activity", AccrueType.PRORATED);
        XML_TYPE_MAP.put("End of Activity", AccrueType.END);
        XML_TYPE_MAP.put("Start of Activity", AccrueType.START);
        XER_TYPE_MAP = new HashMap<String, AccrueType>();
        XER_TYPE_MAP.put("CL_Uniform", AccrueType.PRORATED);
        XER_TYPE_MAP.put("CL_End", AccrueType.END);
        XER_TYPE_MAP.put("CL_Start", AccrueType.START);
        TYPE_XML_MAP = new HashMap<AccrueType, String>();
        TYPE_XML_MAP.put(AccrueType.PRORATED, "Uniform Over Activity");
        TYPE_XML_MAP.put(AccrueType.END, "End of Activity");
        TYPE_XML_MAP.put(AccrueType.START, "Start of Activity");
        TYPE_XER_MAP = new HashMap<AccrueType, String>();
        TYPE_XER_MAP.put(AccrueType.PRORATED, "CL_Uniform");
        TYPE_XER_MAP.put(AccrueType.END, "CL_End");
        TYPE_XER_MAP.put(AccrueType.START, "CL_Start");
    }
}

