/*
 * Decompiled with CFR 0.152.
 */
package org.mpxj.primavera;

import java.util.List;
import java.util.Set;
import org.mpxj.ChildTaskContainer;
import org.mpxj.Task;

class ActivitySorter {
    final Set<Task> m_wbsTasks;

    public ActivitySorter(Set<Task> wbsTasks) {
        this.m_wbsTasks = wbsTasks;
    }

    public void sort(ChildTaskContainer container) {
        List<Task> tasks = container.getChildTasks();
        if (!tasks.isEmpty()) {
            tasks.forEach(this::sort);
            tasks.sort((t1, t2) -> {
                boolean t1IsWbs = this.m_wbsTasks.contains(t1);
                boolean t2IsWbs = this.m_wbsTasks.contains(t2);
                if (t1IsWbs && t2IsWbs) {
                    return t1.getID().compareTo(t2.getID());
                }
                if (!t1IsWbs && !t2IsWbs) {
                    String activityID1 = t1.getActivityID();
                    String activityID2 = t2.getActivityID();
                    if (activityID1 == null || activityID2 == null) {
                        return activityID1 == null && activityID2 == null ? 0 : (activityID1 == null ? 1 : -1);
                    }
                    return activityID1.compareTo(activityID2);
                }
                return t1IsWbs ? 1 : -1;
            });
        }
    }
}

