/*
 * Decompiled with CFR 0.152.
 */
package org.mpxj.primavera;

import java.util.HashMap;
import java.util.Map;
import org.mpxj.ActivityStatus;
import org.mpxj.Task;

final class ActivityStatusHelper {
    private static final Map<String, ActivityStatus> XML_TYPE_MAP = new HashMap<String, ActivityStatus>();
    private static final Map<ActivityStatus, String> TYPE_XML_MAP;
    private static final Map<String, ActivityStatus> XER_TYPE_MAP;
    private static final Map<ActivityStatus, String> TYPE_XER_MAP;

    ActivityStatusHelper() {
    }

    public static ActivityStatus getActivityStatus(Task mpxj) {
        ActivityStatus result = mpxj.getActualStart() == null ? ActivityStatus.NOT_STARTED : (mpxj.getActualFinish() == null ? ActivityStatus.IN_PROGRESS : ActivityStatus.COMPLETED);
        return result;
    }

    public static ActivityStatus getInstanceFromXml(String value) {
        return XML_TYPE_MAP.get(value);
    }

    public static ActivityStatus getInstanceFromXer(String value) {
        return XER_TYPE_MAP.get(value);
    }

    public static String getXmlFromInstance(ActivityStatus value) {
        return TYPE_XML_MAP.get((Object)value);
    }

    public static String getXerFromInstance(ActivityStatus value) {
        return TYPE_XER_MAP.get((Object)value);
    }

    static {
        XML_TYPE_MAP.put("Not Started", ActivityStatus.NOT_STARTED);
        XML_TYPE_MAP.put("In Progress", ActivityStatus.IN_PROGRESS);
        XML_TYPE_MAP.put("Completed", ActivityStatus.COMPLETED);
        TYPE_XML_MAP = new HashMap<ActivityStatus, String>();
        TYPE_XML_MAP.put(ActivityStatus.NOT_STARTED, "Not Started");
        TYPE_XML_MAP.put(ActivityStatus.IN_PROGRESS, "In Progress");
        TYPE_XML_MAP.put(ActivityStatus.COMPLETED, "Completed");
        XER_TYPE_MAP = new HashMap<String, ActivityStatus>();
        XER_TYPE_MAP.put("TK_NotStart", ActivityStatus.NOT_STARTED);
        XER_TYPE_MAP.put("TK_Active", ActivityStatus.IN_PROGRESS);
        XER_TYPE_MAP.put("TK_Complete", ActivityStatus.COMPLETED);
        TYPE_XER_MAP = new HashMap<ActivityStatus, String>();
        TYPE_XER_MAP.put(ActivityStatus.NOT_STARTED, "TK_NotStart");
        TYPE_XER_MAP.put(ActivityStatus.IN_PROGRESS, "TK_Active");
        TYPE_XER_MAP.put(ActivityStatus.COMPLETED, "TK_Complete");
    }
}

