/*
 * Decompiled with CFR 0.152.
 */
package org.mpxj.primavera;

import java.util.HashMap;
import java.util.Map;
import org.mpxj.ActivityType;

final class ActivityTypeHelper {
    public static final ActivityType NEW_ACTIVITY_DEFAULT_TYPE = ActivityType.TASK_DEPENDENT;
    public static final ActivityType EXISTING_ACTIVITY_DEFAULT_TYPE = ActivityType.RESOURCE_DEPENDENT;
    private static final Map<String, ActivityType> XML_TYPE_MAP = new HashMap<String, ActivityType>();
    private static final Map<ActivityType, String> TYPE_XML_MAP;
    private static final Map<String, ActivityType> XER_TYPE_MAP;
    private static final Map<ActivityType, String> TYPE_XER_MAP;

    ActivityTypeHelper() {
    }

    public static ActivityType getInstanceFromXml(String value) {
        return XML_TYPE_MAP.get(value);
    }

    public static ActivityType getInstanceFromXer(String value) {
        return XER_TYPE_MAP.get(value);
    }

    public static String getXmlFromInstance(ActivityType value) {
        if (value == null) {
            value = EXISTING_ACTIVITY_DEFAULT_TYPE;
        }
        return TYPE_XML_MAP.get((Object)value);
    }

    public static String getXerFromInstance(ActivityType value) {
        if (value == null) {
            value = EXISTING_ACTIVITY_DEFAULT_TYPE;
        }
        return TYPE_XER_MAP.get((Object)value);
    }

    static {
        XML_TYPE_MAP.put("Task Dependent", ActivityType.TASK_DEPENDENT);
        XML_TYPE_MAP.put("Resource Dependent", ActivityType.RESOURCE_DEPENDENT);
        XML_TYPE_MAP.put("Level of Effort", ActivityType.LEVEL_OF_EFFORT);
        XML_TYPE_MAP.put("Start Milestone", ActivityType.START_MILESTONE);
        XML_TYPE_MAP.put("Finish Milestone", ActivityType.FINISH_MILESTONE);
        XML_TYPE_MAP.put("WBS Summary", ActivityType.WBS_SUMMARY);
        XML_TYPE_MAP.put("0", ActivityType.TASK_DEPENDENT);
        TYPE_XML_MAP = new HashMap<ActivityType, String>();
        TYPE_XML_MAP.put(ActivityType.TASK_DEPENDENT, "Task Dependent");
        TYPE_XML_MAP.put(ActivityType.RESOURCE_DEPENDENT, "Resource Dependent");
        TYPE_XML_MAP.put(ActivityType.LEVEL_OF_EFFORT, "Level of Effort");
        TYPE_XML_MAP.put(ActivityType.START_MILESTONE, "Start Milestone");
        TYPE_XML_MAP.put(ActivityType.FINISH_MILESTONE, "Finish Milestone");
        TYPE_XML_MAP.put(ActivityType.WBS_SUMMARY, "WBS Summary");
        TYPE_XML_MAP.put(ActivityType.START_FLAG, "Start Milestone");
        TYPE_XML_MAP.put(ActivityType.FINISH_FLAG, "Finish Milestone");
        TYPE_XML_MAP.put(ActivityType.HAMMOCK, "Resource Dependent");
        XER_TYPE_MAP = new HashMap<String, ActivityType>();
        XER_TYPE_MAP.put("TT_Task", ActivityType.TASK_DEPENDENT);
        XER_TYPE_MAP.put("TT_Rsrc", ActivityType.RESOURCE_DEPENDENT);
        XER_TYPE_MAP.put("TT_LOE", ActivityType.LEVEL_OF_EFFORT);
        XER_TYPE_MAP.put("TT_Mile", ActivityType.START_MILESTONE);
        XER_TYPE_MAP.put("TT_FinMile", ActivityType.FINISH_MILESTONE);
        XER_TYPE_MAP.put("TT_WBS", ActivityType.WBS_SUMMARY);
        TYPE_XER_MAP = new HashMap<ActivityType, String>();
        TYPE_XER_MAP.put(ActivityType.TASK_DEPENDENT, "TT_Task");
        TYPE_XER_MAP.put(ActivityType.RESOURCE_DEPENDENT, "TT_Rsrc");
        TYPE_XER_MAP.put(ActivityType.LEVEL_OF_EFFORT, "TT_LOE");
        TYPE_XER_MAP.put(ActivityType.START_MILESTONE, "TT_Mile");
        TYPE_XER_MAP.put(ActivityType.FINISH_MILESTONE, "TT_FinMile");
        TYPE_XER_MAP.put(ActivityType.WBS_SUMMARY, "TT_WBS");
    }
}

