/*
 * Decompiled with CFR 0.152.
 */
package org.mpxj.primavera;

import org.mpxj.Duration;
import org.mpxj.RelationType;
import org.mpxj.Task;
import org.mpxj.TimeUnit;

final class ExternalRelation {
    private final Integer m_uniqueID;
    private final Integer m_externalTaskUniqueID;
    private final Task m_targetTask;
    private final RelationType m_type;
    private final Duration m_lag;
    private final boolean m_predecessor;
    private final String m_notes;

    public ExternalRelation(Integer uniqueID, Integer sourceUniqueID, Task targetTask, RelationType type, Duration lag, boolean predecessor, String notes) {
        this.m_uniqueID = uniqueID;
        this.m_externalTaskUniqueID = sourceUniqueID;
        this.m_targetTask = targetTask;
        this.m_type = type == null ? RelationType.FINISH_START : type;
        this.m_lag = lag == null ? Duration.getInstance(0, TimeUnit.DAYS) : lag;
        this.m_predecessor = predecessor;
        this.m_notes = notes;
    }

    public RelationType getType() {
        return this.m_type;
    }

    public Duration getLag() {
        return this.m_lag;
    }

    public Integer externalTaskUniqueID() {
        return this.m_externalTaskUniqueID;
    }

    public Task getTargetTask() {
        return this.m_targetTask;
    }

    public Integer getUniqueID() {
        return this.m_uniqueID;
    }

    public boolean getPredecessor() {
        return this.m_predecessor;
    }

    public String getNotes() {
        return this.m_notes;
    }

    public String toString() {
        return "[ExternalPredecessor " + this.m_externalTaskUniqueID + " -> " + this.m_targetTask + "]";
    }
}

