/*
 * Decompiled with CFR 0.152.
 */
package org.mpxj.primavera;

import java.util.HashMap;
import java.util.Map;
import org.mpxj.FieldType;
import org.mpxj.FieldTypeClass;
import org.mpxj.UserDefinedField;

final class FieldTypeClassHelper {
    private static final Map<String, FieldTypeClass> XML_TYPE_MAP = new HashMap<String, FieldTypeClass>();
    private static final Map<String, FieldTypeClass> XER_TYPE_MAP;
    private static final Map<FieldTypeClass, String> TYPE_XML_MAP;
    private static final Map<FieldTypeClass, String> TYPE_XER_MAP;

    FieldTypeClassHelper() {
    }

    public static FieldTypeClass getInstanceFromXml(String value) {
        return XML_TYPE_MAP.get(value);
    }

    public static FieldTypeClass getInstanceFromXer(String value) {
        return XER_TYPE_MAP.get(value);
    }

    public static String getXmlFromInstance(FieldType fieldType) {
        String result = TYPE_XML_MAP.get((Object)fieldType.getFieldTypeClass());
        if (result == null) {
            throw new RuntimeException("Unrecognized field type: " + fieldType);
        }
        if (result.equals("Activity") && fieldType instanceof UserDefinedField && ((UserDefinedField)fieldType).getSummaryTaskOnly()) {
            result = "WBS";
        }
        return result;
    }

    public static String getXerFromInstance(FieldType fieldType) {
        String result = TYPE_XER_MAP.get((Object)fieldType.getFieldTypeClass());
        if (result == null) {
            throw new RuntimeException("Unrecognized field type: " + fieldType);
        }
        if (result.equals("TASK") && fieldType instanceof UserDefinedField && ((UserDefinedField)fieldType).getSummaryTaskOnly()) {
            result = "PROJWBS";
        }
        return result;
    }

    static {
        XML_TYPE_MAP.put("Activity", FieldTypeClass.TASK);
        XML_TYPE_MAP.put("WBS", FieldTypeClass.TASK);
        XML_TYPE_MAP.put("Resource", FieldTypeClass.RESOURCE);
        XML_TYPE_MAP.put("Resource Assignment", FieldTypeClass.ASSIGNMENT);
        XML_TYPE_MAP.put("Project", FieldTypeClass.PROJECT);
        XER_TYPE_MAP = new HashMap<String, FieldTypeClass>();
        XER_TYPE_MAP.put("PROJWBS", FieldTypeClass.TASK);
        XER_TYPE_MAP.put("TASK", FieldTypeClass.TASK);
        XER_TYPE_MAP.put("RSRC", FieldTypeClass.RESOURCE);
        XER_TYPE_MAP.put("TASKRSRC", FieldTypeClass.ASSIGNMENT);
        XER_TYPE_MAP.put("PROJECT", FieldTypeClass.PROJECT);
        TYPE_XML_MAP = new HashMap<FieldTypeClass, String>();
        TYPE_XML_MAP.put(FieldTypeClass.TASK, "Activity");
        TYPE_XML_MAP.put(FieldTypeClass.RESOURCE, "Resource");
        TYPE_XML_MAP.put(FieldTypeClass.PROJECT, "Project");
        TYPE_XML_MAP.put(FieldTypeClass.ASSIGNMENT, "Resource Assignment");
        TYPE_XML_MAP.put(FieldTypeClass.CONSTRAINT, "Constraint");
        TYPE_XER_MAP = new HashMap<FieldTypeClass, String>();
        TYPE_XER_MAP.put(FieldTypeClass.TASK, "TASK");
        TYPE_XER_MAP.put(FieldTypeClass.RESOURCE, "RSRC");
        TYPE_XER_MAP.put(FieldTypeClass.ASSIGNMENT, "TASKRSRC");
        TYPE_XER_MAP.put(FieldTypeClass.PROJECT, "PROJECT");
    }
}

