/*
 * Decompiled with CFR 0.152.
 */
package org.mpxj.primavera;

import java.io.File;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import org.mpxj.EPS;
import org.mpxj.MPXJException;
import org.mpxj.ProjectFile;
import org.mpxj.common.AutoCloseableHelper;
import org.mpxj.common.NumberHelper;
import org.mpxj.common.SQLite;
import org.mpxj.primavera.PrimaveraDatabaseReader;
import org.mpxj.reader.AbstractProjectFileReader;

public final class PrimaveraDatabaseFileReader
extends AbstractProjectFileReader {
    private Integer m_projectID;

    public Map<Integer, String> listProjects(File file) throws MPXJException {
        Connection connection = null;
        try {
            connection = this.getDatabaseConnection(file);
            PrimaveraDatabaseReader reader = new PrimaveraDatabaseReader();
            reader.setConnection(connection);
            Map<Integer, String> map = reader.listProjects();
            return map;
        }
        catch (SQLException ex) {
            throw new MPXJException("Failed to create connection", ex);
        }
        finally {
            AutoCloseableHelper.closeQuietly(connection);
        }
    }

    public EPS listEps(File file) throws MPXJException {
        Connection connection = null;
        try {
            connection = this.getDatabaseConnection(file);
            PrimaveraDatabaseReader reader = new PrimaveraDatabaseReader();
            reader.setConnection(connection);
            EPS ePS = reader.listEps();
            return ePS;
        }
        catch (SQLException ex) {
            throw new MPXJException("Failed to create connection", ex);
        }
        finally {
            AutoCloseableHelper.closeQuietly(connection);
        }
    }

    public void setProjectID(int projectID) {
        this.m_projectID = projectID;
    }

    @Override
    public ProjectFile read(File file) throws MPXJException {
        Connection connection = null;
        try {
            connection = this.getDatabaseConnection(file);
            PrimaveraDatabaseReader reader = new PrimaveraDatabaseReader();
            reader.setConnection(connection);
            reader.setProjectID(NumberHelper.getInt(this.m_projectID));
            this.addListenersToReader(reader);
            ProjectFile projectFile = reader.read();
            return projectFile;
        }
        catch (SQLException ex) {
            throw new MPXJException("Failed to create connection", ex);
        }
        finally {
            AutoCloseableHelper.closeQuietly(connection);
        }
    }

    @Override
    public List<ProjectFile> readAll(File file) throws MPXJException {
        Connection connection = null;
        try {
            connection = this.getDatabaseConnection(file);
            PrimaveraDatabaseReader reader = new PrimaveraDatabaseReader();
            reader.setConnection(connection);
            this.addListenersToReader(reader);
            List<ProjectFile> list = reader.readAll();
            return list;
        }
        catch (SQLException ex) {
            throw new MPXJException("Failed to create connection", ex);
        }
        finally {
            AutoCloseableHelper.closeQuietly(connection);
        }
    }

    private Connection getDatabaseConnection(File file) throws SQLException {
        return SQLite.createConnection(file, SQLite.dateFormatProperties());
    }
}

