/*
 * Decompiled with CFR 0.152.
 */
package org.mpxj.primavera;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import org.mpxj.common.XmlHelper;

class PrimaveraInputStreamReader
extends InputStreamReader {
    public PrimaveraInputStreamReader(InputStream is, String charset) {
        super(is, PrimaveraInputStreamReader.decoder(charset));
    }

    @Override
    public int read() throws IOException {
        int c = super.read();
        if (!XmlHelper.validXmlChar(c)) {
            c = 65533;
        }
        return c;
    }

    @Override
    public int read(char[] cbuf, int offset, int length) throws IOException {
        int result = super.read(cbuf, offset, length);
        if (result > 0) {
            for (int index = 0; index < result; ++index) {
                if (XmlHelper.validXmlChar(cbuf[index])) continue;
                cbuf[index] = 65533;
            }
        }
        return result;
    }

    private static CharsetDecoder decoder(String charset) {
        CharsetDecoder decoder = Charset.forName(charset).newDecoder();
        decoder.onMalformedInput(CodingErrorAction.REPLACE);
        decoder.onUnmappableCharacter(CodingErrorAction.REPLACE);
        return decoder;
    }
}

