/*
 * Decompiled with CFR 0.152.
 */
package org.mpxj.primavera;

import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBException;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.poi.util.ReplacingInputStream;
import org.mpxj.ActivityCode;
import org.mpxj.ActivityCodeContainer;
import org.mpxj.ActivityCodeValue;
import org.mpxj.AssignmentField;
import org.mpxj.Availability;
import org.mpxj.BaselineStrategy;
import org.mpxj.ChildTaskContainer;
import org.mpxj.CostAccount;
import org.mpxj.CostAccountContainer;
import org.mpxj.CostRateTableEntry;
import org.mpxj.CriticalActivityType;
import org.mpxj.Currency;
import org.mpxj.CurrencyContainer;
import org.mpxj.Duration;
import org.mpxj.EventManager;
import org.mpxj.ExpenseCategory;
import org.mpxj.ExpenseCategoryContainer;
import org.mpxj.ExpenseItem;
import org.mpxj.FieldContainer;
import org.mpxj.FieldType;
import org.mpxj.FieldTypeClass;
import org.mpxj.HtmlNotes;
import org.mpxj.LocalTimeRange;
import org.mpxj.Location;
import org.mpxj.LocationContainer;
import org.mpxj.MPXJException;
import org.mpxj.Notes;
import org.mpxj.NotesTopic;
import org.mpxj.ParentNotes;
import org.mpxj.PercentCompleteType;
import org.mpxj.ProjectCalendar;
import org.mpxj.ProjectCalendarException;
import org.mpxj.ProjectCalendarHours;
import org.mpxj.ProjectCode;
import org.mpxj.ProjectCodeContainer;
import org.mpxj.ProjectCodeValue;
import org.mpxj.ProjectConfig;
import org.mpxj.ProjectFile;
import org.mpxj.ProjectFileSharedData;
import org.mpxj.ProjectProperties;
import org.mpxj.Rate;
import org.mpxj.Relation;
import org.mpxj.RelationType;
import org.mpxj.Resource;
import org.mpxj.ResourceAssignment;
import org.mpxj.ResourceAssignmentCode;
import org.mpxj.ResourceAssignmentCodeContainer;
import org.mpxj.ResourceAssignmentCodeValue;
import org.mpxj.ResourceCode;
import org.mpxj.ResourceCodeContainer;
import org.mpxj.ResourceCodeValue;
import org.mpxj.RoleCode;
import org.mpxj.RoleCodeContainer;
import org.mpxj.RoleCodeValue;
import org.mpxj.Shift;
import org.mpxj.ShiftContainer;
import org.mpxj.ShiftPeriod;
import org.mpxj.ShiftPeriodContainer;
import org.mpxj.Step;
import org.mpxj.StructuredNotes;
import org.mpxj.Task;
import org.mpxj.TaskField;
import org.mpxj.TimeUnit;
import org.mpxj.UnitOfMeasure;
import org.mpxj.UnitOfMeasureContainer;
import org.mpxj.UserDefinedField;
import org.mpxj.WorkContour;
import org.mpxj.common.BooleanHelper;
import org.mpxj.common.ColorHelper;
import org.mpxj.common.DayOfWeekHelper;
import org.mpxj.common.HierarchyHelper;
import org.mpxj.common.InputStreamHelper;
import org.mpxj.common.LocalDateHelper;
import org.mpxj.common.LocalDateTimeHelper;
import org.mpxj.common.NumberHelper;
import org.mpxj.common.UnmarshalHelper;
import org.mpxj.primavera.AccrueTypeHelper;
import org.mpxj.primavera.ActivityCodeScopeHelper;
import org.mpxj.primavera.ActivitySorter;
import org.mpxj.primavera.ActivityStatusHelper;
import org.mpxj.primavera.ActivityTypeHelper;
import org.mpxj.primavera.CalendarTypeHelper;
import org.mpxj.primavera.ClashMap;
import org.mpxj.primavera.ConstraintTypeHelper;
import org.mpxj.primavera.CriticalActivityTypeHelper;
import org.mpxj.primavera.CurveHelper;
import org.mpxj.primavera.DatatypeConverter;
import org.mpxj.primavera.ExternalRelation;
import org.mpxj.primavera.FieldTypeClassHelper;
import org.mpxj.primavera.NamespaceFilter;
import org.mpxj.primavera.PercentCompleteTypeHelper;
import org.mpxj.primavera.PrimaveraBaselineStrategy;
import org.mpxj.primavera.PrimaveraInputStreamReader;
import org.mpxj.primavera.PriorityHelper;
import org.mpxj.primavera.ProjectCalendarHelper;
import org.mpxj.primavera.RateSourceHelper;
import org.mpxj.primavera.RateTypeHelper;
import org.mpxj.primavera.RelationTypeHelper;
import org.mpxj.primavera.RelationshipLagCalendarHelper;
import org.mpxj.primavera.ResourceTypeHelper;
import org.mpxj.primavera.SchedulingProgressedActivitiesHelper;
import org.mpxj.primavera.SkillLevelHelper;
import org.mpxj.primavera.TaskTypeHelper;
import org.mpxj.primavera.TimephasedHelper;
import org.mpxj.primavera.TotalSlackCalculationTypeHelper;
import org.mpxj.primavera.UdfHelper;
import org.mpxj.primavera.WbsRowComparatorPMXML;
import org.mpxj.primavera.WorkHelper;
import org.mpxj.primavera.schema.APIBusinessObjects;
import org.mpxj.primavera.schema.ActivityCodeType;
import org.mpxj.primavera.schema.ActivityCodeTypeType;
import org.mpxj.primavera.schema.ActivityExpenseType;
import org.mpxj.primavera.schema.ActivityNoteType;
import org.mpxj.primavera.schema.ActivityStepType;
import org.mpxj.primavera.schema.ActivityType;
import org.mpxj.primavera.schema.BaselineProjectType;
import org.mpxj.primavera.schema.CalendarType;
import org.mpxj.primavera.schema.CodeAssignmentType;
import org.mpxj.primavera.schema.CostAccountType;
import org.mpxj.primavera.schema.CurrencyType;
import org.mpxj.primavera.schema.GlobalPreferencesType;
import org.mpxj.primavera.schema.NotebookTopicType;
import org.mpxj.primavera.schema.ProjectCodeType;
import org.mpxj.primavera.schema.ProjectCodeTypeType;
import org.mpxj.primavera.schema.ProjectListType;
import org.mpxj.primavera.schema.ProjectNoteType;
import org.mpxj.primavera.schema.ProjectType;
import org.mpxj.primavera.schema.RelationshipType;
import org.mpxj.primavera.schema.ResourceAssignmentCodeType;
import org.mpxj.primavera.schema.ResourceAssignmentCodeTypeType;
import org.mpxj.primavera.schema.ResourceAssignmentType;
import org.mpxj.primavera.schema.ResourceCodeType;
import org.mpxj.primavera.schema.ResourceCodeTypeType;
import org.mpxj.primavera.schema.ResourceCurveType;
import org.mpxj.primavera.schema.ResourceCurveValuesType;
import org.mpxj.primavera.schema.ResourceRateType;
import org.mpxj.primavera.schema.ResourceRoleType;
import org.mpxj.primavera.schema.ResourceType;
import org.mpxj.primavera.schema.RoleCodeType;
import org.mpxj.primavera.schema.RoleCodeTypeType;
import org.mpxj.primavera.schema.RoleRateType;
import org.mpxj.primavera.schema.RoleType;
import org.mpxj.primavera.schema.ScheduleOptionsType;
import org.mpxj.primavera.schema.ShiftPeriodType;
import org.mpxj.primavera.schema.ShiftType;
import org.mpxj.primavera.schema.UDFAssignmentType;
import org.mpxj.primavera.schema.UDFTypeType;
import org.mpxj.primavera.schema.UnitOfMeasureType;
import org.mpxj.primavera.schema.WBSType;
import org.mpxj.primavera.schema.WorkTimeType;
import org.mpxj.reader.AbstractProjectStreamReader;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public final class PrimaveraPMFileReader
extends AbstractProjectStreamReader {
    private static JAXBContext CONTEXT;
    private static JAXBException CONTEXT_EXCEPTION;
    private Integer m_projectID;
    private ProjectFile m_projectFile;
    private ProjectFileSharedData m_shared;
    private EventManager m_eventManager;
    private ClashMap m_activityClashMap;
    private ClashMap m_roleClashMap;
    private List<ExternalRelation> m_externalRelations;
    private boolean m_linkCrossProjectRelations;
    private BaselineStrategy m_baselineStrategy = PrimaveraBaselineStrategy.PLANNED_ATTRIBUTES;
    private static final Map<String, DayOfWeek> DAY_MAP;
    private static final Map<String, Boolean> MILESTONE_MAP;
    private static final WbsRowComparatorPMXML WBS_ROW_COMPARATOR;
    private static final Pattern ENCODING_PATTERN;
    private static final LocalTime NON_WORKING_END_TIME;

    public void setProjectID(int projectID) {
        this.m_projectID = projectID;
    }

    public boolean getLinkCrossProjectRelations() {
        return this.m_linkCrossProjectRelations;
    }

    public void setLinkCrossProjectRelations(boolean linkCrossProjectRelations) {
        this.m_linkCrossProjectRelations = linkCrossProjectRelations;
    }

    public void setBaselineStrategy(BaselineStrategy strategy) {
        this.m_baselineStrategy = strategy;
    }

    public BaselineStrategy getBaselineStrategy() {
        return this.m_baselineStrategy;
    }

    public Map<Integer, String> listProjects(InputStream is) throws MPXJException {
        APIBusinessObjects apibo = this.processFile(is);
        List<ProjectType> projects = apibo.getProject();
        HashMap<Integer, String> result = new HashMap<Integer, String>();
        projects.forEach(p -> result.put(p.getObjectId(), p.getName()));
        return result;
    }

    @Override
    public ProjectFile read(InputStream is) throws MPXJException {
        ProjectFile project = null;
        List<ProjectFile> projects = this.readAll(is);
        if (!projects.isEmpty()) {
            project = this.m_projectID == null ? projects.get(0) : (ProjectFile)projects.stream().filter(p -> this.m_projectID.equals(p.getProjectProperties().getUniqueID())).findFirst().orElse(null);
        }
        return project;
    }

    @Override
    public List<ProjectFile> readAll(InputStream is) throws MPXJException {
        APIBusinessObjects apibo = this.processFile(is);
        List<ProjectType> projects = apibo.getProject();
        List<BaselineProjectType> baselineProjects = apibo.getBaselineProject();
        ArrayList<ProjectFile> result = new ArrayList<ProjectFile>(projects.size() + baselineProjects.size());
        this.m_externalRelations = new ArrayList<ExternalRelation>();
        projects.forEach(project -> result.add(this.read(apibo, project)));
        baselineProjects.forEach(project -> result.add(this.read(apibo, project)));
        result.sort((o1, o2) -> Boolean.compare(o2.getProjectProperties().getExportFlag(), o1.getProjectProperties().getExportFlag()));
        this.linkCrossProjectRelations(result);
        this.populateBaselines(apibo, result);
        this.m_externalRelations = null;
        return result;
    }

    private void linkCrossProjectRelations(List<ProjectFile> projects) {
        if (this.m_linkCrossProjectRelations) {
            for (ExternalRelation externalRelation : this.m_externalRelations) {
                Task predecessor;
                Task successor;
                Task externalTask = this.findTaskInProjects(projects, externalRelation.externalTaskUniqueID());
                if (externalTask == null) continue;
                if (externalRelation.getPredecessor()) {
                    successor = externalRelation.getTargetTask();
                    predecessor = externalTask;
                } else {
                    successor = externalTask;
                    predecessor = externalRelation.getTargetTask();
                }
                ProjectFile successorProject = successor.getParentFile();
                successorProject.getRelations().addPredecessor(new Relation.Builder().predecessorTask(predecessor).successorTask(successor).type(externalRelation.getType()).lag(externalRelation.getLag()).uniqueID(externalRelation.getUniqueID()).notes(externalRelation.getNotes()));
                ProjectFile predecessorProject = predecessor.getParentFile();
                predecessorProject.getRelations().addPredecessor(new Relation.Builder().predecessorTask(predecessor).successorTask(successor).type(externalRelation.getType()).lag(externalRelation.getLag()).uniqueID(externalRelation.getUniqueID()).notes(externalRelation.getNotes()));
            }
        }
    }

    private void populateBaselines(APIBusinessObjects apibo, List<ProjectFile> projects) {
        if (projects.stream().anyMatch(p -> p.getProjectProperties().getBaselineProjectUniqueID() != null)) {
            this.populateBaselinesByUniqueID(projects);
        } else if (apibo.getProjectList() != null && apibo.getProjectList().getProject().stream().anyMatch(p -> !p.getBaselineProject().isEmpty())) {
            this.populateBaselinesByProjectList(apibo, projects);
        }
    }

    private void populateBaselinesByUniqueID(List<ProjectFile> projects) {
        Map<Integer, ProjectFile> map = projects.stream().collect(Collectors.toMap(p -> p.getProjectProperties().getUniqueID(), p -> p));
        for (ProjectFile project : projects) {
            ProjectFile baseline = map.get(project.getProjectProperties().getBaselineProjectUniqueID());
            if (baseline == null) continue;
            project.setBaseline(baseline);
        }
    }

    private void populateBaselinesByProjectList(APIBusinessObjects apibo, List<ProjectFile> projects) {
        Map<Integer, ProjectFile> map = projects.stream().collect(Collectors.toMap(p -> p.getProjectProperties().getUniqueID(), p -> p));
        block0: for (ProjectListType.Project project : apibo.getProjectList().getProject()) {
            ProjectFile parentProject;
            List<ProjectListType.Project.BaselineProject> baselineProjects = project.getBaselineProject();
            if (baselineProjects.isEmpty() || (parentProject = map.get(project.getObjectId())) == null) continue;
            int baselineIndex = 0;
            for (ProjectListType.Project.BaselineProject baseline : baselineProjects) {
                ProjectFile baselineProject = map.get(baseline.getObjectId());
                if (baselineProject == null) continue;
                parentProject.setBaseline(baselineProject, baselineIndex++);
                if (baselineIndex <= 10) continue;
                continue block0;
            }
        }
    }

    private Task findTaskInProjects(List<ProjectFile> projects, Integer uniqueID) {
        ProjectFile proj;
        Task result = null;
        Iterator<ProjectFile> iterator = projects.iterator();
        while (iterator.hasNext() && (result = (proj = iterator.next()).getTaskByUniqueID(uniqueID)) == null) {
        }
        return result;
    }

    private APIBusinessObjects processFile(InputStream stream) throws MPXJException {
        try {
            if (CONTEXT == null) {
                throw CONTEXT_EXCEPTION;
            }
            return (APIBusinessObjects)UnmarshalHelper.unmarshal(CONTEXT, this.configureInputSource(stream), new NamespaceFilter(), false);
        }
        catch (JAXBException | IOException | ParserConfigurationException | SAXException ex) {
            throw new MPXJException("Failed to parse file", (Exception)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ProjectFile read(APIBusinessObjects apibo, Object projectObject) {
        try {
            List<CodeAssignmentType> codes;
            List<ActivityExpenseType> activityExpenseType;
            List<ResourceAssignmentType> assignments;
            List<RelationshipType> relationships;
            List<ActivityNoteType> activityNotes;
            List<ActivityStepType> steps;
            List<ActivityType> activities;
            List<ProjectNoteType> projectNotes;
            List<WBSType> wbs;
            List<ActivityCodeType> activityCodes;
            List<ActivityCodeTypeType> activityCodeTypes;
            Object project;
            boolean readSharedData;
            this.m_activityClashMap = new ClashMap();
            this.m_roleClashMap = new ClashMap();
            boolean bl = readSharedData = this.m_shared == null;
            if (this.m_shared == null) {
                this.m_shared = new ProjectFileSharedData();
            }
            this.m_projectFile = new ProjectFile(this.m_shared);
            this.m_eventManager = this.m_projectFile.getEventManager();
            ProjectConfig config = this.m_projectFile.getProjectConfig();
            config.setAutoTaskUniqueID(false);
            config.setAutoResourceUniqueID(false);
            config.setAutoCalendarUniqueID(false);
            config.setAutoAssignmentUniqueID(false);
            config.setAutoWBS(false);
            config.setAutoRelationUniqueID(false);
            config.setBaselineStrategy(this.m_baselineStrategy);
            this.m_projectFile.getProjectProperties().setFileApplication("Primavera");
            this.m_projectFile.getProjectProperties().setFileType("PMXML");
            this.addListenersToProject(this.m_projectFile);
            if (readSharedData) {
                this.processCurrencies(apibo);
                this.processLocations(apibo);
                this.processUnitsOfMeasure(apibo);
                this.processExpenseCategories(apibo);
                this.processCostAccounts(apibo);
                this.processWorkContours(apibo);
                this.processNotebookTopics(apibo);
                this.processUdfDefintions(apibo);
                this.processActivityCodeDefinitions(apibo.getActivityCodeType(), apibo.getActivityCode());
                this.processProjectCodeDefinitions(apibo);
                this.processResourceCodeDefinitions(apibo);
                this.processRoleCodeDefinitions(apibo);
                this.processResourceAssignmentCodeDefinitions(apibo);
                this.processShifts(apibo);
            }
            this.processCalendars(apibo.getCalendar());
            this.processResources(apibo);
            this.processRoles(apibo);
            this.processRoleAssignments(apibo);
            this.processResourceRates(apibo);
            this.processRoleRates(apibo);
            if (projectObject instanceof ProjectType) {
                project = (ProjectType)projectObject;
                this.processCalendars(((ProjectType)project).getCalendar());
                this.processProjectProperties((ProjectType)project);
                activityCodeTypes = ((ProjectType)project).getActivityCodeType();
                activityCodes = ((ProjectType)project).getActivityCode();
                wbs = ((ProjectType)project).getWBS();
                projectNotes = ((ProjectType)project).getProjectNote();
                activities = ((ProjectType)project).getActivity();
                steps = ((ProjectType)project).getActivityStep();
                activityNotes = ((ProjectType)project).getActivityNote();
                relationships = ((ProjectType)project).getRelationship();
                assignments = ((ProjectType)project).getResourceAssignment();
                activityExpenseType = ((ProjectType)project).getActivityExpense();
                codes = ((ProjectType)project).getCode();
            } else {
                project = (BaselineProjectType)projectObject;
                this.processCalendars(((BaselineProjectType)project).getCalendar());
                this.processProjectProperties((BaselineProjectType)project);
                activityCodeTypes = ((BaselineProjectType)project).getActivityCodeType();
                activityCodes = ((BaselineProjectType)project).getActivityCode();
                wbs = ((BaselineProjectType)project).getWBS();
                projectNotes = ((BaselineProjectType)project).getProjectNote();
                activities = ((BaselineProjectType)project).getActivity();
                steps = ((BaselineProjectType)project).getActivityStep();
                activityNotes = ((BaselineProjectType)project).getActivityNote();
                relationships = ((BaselineProjectType)project).getRelationship();
                assignments = ((BaselineProjectType)project).getResourceAssignment();
                activityExpenseType = ((BaselineProjectType)project).getActivityExpense();
                codes = ((BaselineProjectType)project).getCode();
            }
            Map<Integer, Notes> wbsNotes = this.getWbsNotes(projectNotes);
            this.m_projectFile.getProjectProperties().setNotesObject(wbsNotes.get(0));
            this.processGlobalProperties(apibo);
            this.processActivityCodeDefinitions(activityCodeTypes, activityCodes);
            this.configureProjectCalendars();
            this.processProjectCodeAssignments(codes);
            this.processTasks(wbs, wbsNotes, activities, this.getActivityNotes(activityNotes));
            this.processPredecessors(relationships);
            this.processAssignments(assignments);
            this.processExpenseItems(activityExpenseType);
            this.processActivitySteps(steps);
            this.rollupValues();
            this.m_projectFile.updateStructure();
            this.m_projectFile.readComplete();
            ProjectFile projectFile = this.m_projectFile;
            return projectFile;
        }
        finally {
            this.m_projectFile = null;
            this.m_shared = null;
            this.m_activityClashMap = null;
            this.m_roleClashMap = null;
        }
    }

    private InputSource configureInputSource(InputStream stream) throws IOException {
        int bufferSize = 512;
        BufferedInputStream bis = new BufferedInputStream(stream);
        bis.mark(bufferSize);
        byte[] buffer = InputStreamHelper.read((InputStream)bis, bufferSize);
        bis.reset();
        ReplacingInputStream ris = new ReplacingInputStream((InputStream)bis, "&lt;/HTML&gt;&#0;", "&lt;/HTML&gt;");
        Matcher matcher = ENCODING_PATTERN.matcher(new String(buffer));
        InputSource result = matcher.find() ? new InputSource(new PrimaveraInputStreamReader((InputStream)ris, matcher.group(1))) : new InputSource((InputStream)ris);
        return result;
    }

    private void processUdfDefintions(APIBusinessObjects apibo) {
        for (UDFTypeType udf : apibo.getUDFType()) {
            this.processUdfDefinition(udf);
        }
    }

    private void processUdfDefinition(UDFTypeType udf) {
        FieldTypeClass fieldTypeClass = FieldTypeClassHelper.getInstanceFromXml(udf.getSubjectArea());
        if (fieldTypeClass == null) {
            return;
        }
        UserDefinedField field = new UserDefinedField.Builder(this.m_projectFile).uniqueID(udf.getObjectId()).externalName(udf.getTitle()).fieldTypeClass(fieldTypeClass).summaryTaskOnly(udf.getSubjectArea().equals("WBS")).dataType(UdfHelper.getDataTypeFromXml(udf.getDataType())).build();
        this.m_projectFile.getUserDefinedFields().add(field);
        this.m_projectFile.getCustomFields().add(field).setAlias(udf.getTitle()).setUniqueID(udf.getObjectId());
    }

    private void processGlobalProperties(APIBusinessObjects apibo) {
        List<GlobalPreferencesType> list = apibo.getGlobalPreferences();
        if (!list.isEmpty()) {
            GlobalPreferencesType prefs = list.get(0);
            ProjectProperties properties = this.m_projectFile.getProjectProperties();
            properties.setCreationDate(prefs.getCreateDate());
            properties.setLastSaved(prefs.getLastUpdateDate());
            properties.setMinutesPerDay((int)(NumberHelper.getDouble(prefs.getHoursPerDay()) * 60.0));
            properties.setMinutesPerWeek((int)(NumberHelper.getDouble(prefs.getHoursPerWeek()) * 60.0));
            properties.setMinutesPerMonth((int)(NumberHelper.getDouble(prefs.getHoursPerMonth()) * 60.0));
            properties.setMinutesPerYear((int)(NumberHelper.getDouble(prefs.getHoursPerYear()) * 60.0));
            properties.setWeekStartDay(DayOfWeekHelper.getInstance(NumberHelper.getInt(prefs.getStartDayOfWeek())));
            List<CurrencyType> currencyList = apibo.getCurrency();
            for (CurrencyType currency : currencyList) {
                if (!currency.getObjectId().equals(prefs.getBaseCurrencyObjectId())) continue;
                properties.setCurrencySymbol(currency.getSymbol());
                break;
            }
        }
    }

    private void processProjectCodeAssignments(List<CodeAssignmentType> codes) {
        ProjectProperties props = this.m_projectFile.getProjectProperties();
        for (CodeAssignmentType assignment : codes) {
            ProjectCodeValue codeValue;
            ProjectCode code = (ProjectCode)this.m_projectFile.getProjectCodes().getByUniqueID(assignment.getTypeObjectId());
            if (code == null || (codeValue = code.getValueByUniqueID(assignment.getValueObjectId())) == null) continue;
            props.addProjectCodeValue(codeValue);
        }
    }

    private void processResourceCodeAssignments(Resource resource, List<CodeAssignmentType> codes) {
        for (CodeAssignmentType assignment : codes) {
            ResourceCodeValue codeValue;
            ResourceCode code = (ResourceCode)this.m_projectFile.getResourceCodes().getByUniqueID(assignment.getTypeObjectId());
            if (code == null || (codeValue = code.getValueByUniqueID(assignment.getValueObjectId())) == null) continue;
            resource.addResourceCodeValue(codeValue);
        }
    }

    private void processRoleCodeAssignments(Resource resource, List<CodeAssignmentType> codes) {
        for (CodeAssignmentType assignment : codes) {
            RoleCodeValue codeValue;
            RoleCode code = (RoleCode)this.m_projectFile.getRoleCodes().getByUniqueID(assignment.getTypeObjectId());
            if (code == null || (codeValue = code.getValueByUniqueID(assignment.getValueObjectId())) == null) continue;
            resource.addRoleCodeValue(codeValue);
        }
    }

    private void processResourceAssignmentCodeAssignments(ResourceAssignment resourceAssignment, List<CodeAssignmentType> codes) {
        for (CodeAssignmentType assignment : codes) {
            ResourceAssignmentCodeValue codeValue;
            ResourceAssignmentCode code = (ResourceAssignmentCode)this.m_projectFile.getResourceAssignmentCodes().getByUniqueID(assignment.getTypeObjectId());
            if (code == null || (codeValue = code.getValueByUniqueID(assignment.getValueObjectId())) == null) continue;
            resourceAssignment.addResourceAssignmentCodeValue(codeValue);
        }
    }

    private void processProjectProperties(ProjectType project) {
        ProjectProperties properties = this.m_projectFile.getProjectProperties();
        properties.setBaselineProjectUniqueID(project.getCurrentBaselineProjectObjectId());
        properties.setCreationDate(project.getCreateDate() == null ? project.getDateAdded() : project.getCreateDate());
        properties.setCriticalActivityType(CriticalActivityTypeHelper.getInstanceFromXml(project.getCriticalActivityPathType()));
        properties.setFinishDate(project.getFinishDate());
        properties.setGUID(DatatypeConverter.parseUUID(project.getGUID()));
        properties.setName(project.getName());
        properties.setStartDate(project.getStartDate());
        properties.setStatusDate(project.getDataDate());
        properties.setProjectID(project.getId());
        properties.setUniqueID(project.getObjectId());
        properties.setExportFlag(!BooleanHelper.getBoolean(project.isExternal()));
        properties.setPlannedStart(project.getPlannedStartDate());
        properties.setScheduledFinish(project.getScheduledFinishDate());
        properties.setMustFinishBy(project.getMustFinishByDate());
        properties.setCriticalSlackLimit(Duration.getInstance(NumberHelper.getDouble(project.getCriticalActivityFloatLimit()), TimeUnit.HOURS));
        properties.setLocationUniqueID(project.getLocationObjectId());
        properties.setRelationshipLagCalendar(RelationshipLagCalendarHelper.getInstanceFromXml(project.getRelationshipLagCalendar()));
        properties.setWbsCodeSeparator(project.getWBSCodeSeparator());
        properties.setActivityIdPrefix(project.getActivityIdPrefix());
        properties.setActivityIdSuffix(project.getActivityIdSuffix());
        properties.setActivityIdIncrement(project.getActivityIdIncrement());
        properties.setActivityIdIncrementBasedOnSelectedActivity(BooleanHelper.getBoolean(project.isActivityIdBasedOnSelectedActivity()));
        properties.setProjectWebsiteUrl(this.nullIfEmpty(project.getWebSiteURL()));
        properties.setEnablePublication(BooleanHelper.getBoolean(project.isEnablePublication()));
        properties.setEnableSummarization(BooleanHelper.getBoolean(project.isEnableSummarization()));
        ProjectCalendar calendar = this.m_projectFile.getCalendarByUniqueID(project.getActivityDefaultCalendarObjectId());
        if (calendar != null) {
            this.m_projectFile.setDefaultCalendar(calendar);
        }
        this.processScheduleOptions(project.getScheduleOptions());
        this.populateUserDefinedFieldValues(properties, project.getUDF());
    }

    private void processProjectProperties(BaselineProjectType project) {
        ProjectProperties properties = this.m_projectFile.getProjectProperties();
        properties.setCreationDate(project.getCreateDate() == null ? project.getDateAdded() : project.getCreateDate());
        properties.setFinishDate(project.getFinishDate());
        properties.setGUID(DatatypeConverter.parseUUID(project.getGUID()));
        properties.setName(project.getName());
        properties.setStartDate(project.getPlannedStartDate());
        properties.setStatusDate(project.getDataDate());
        properties.setProjectID(project.getId());
        properties.setUniqueID(project.getObjectId());
        properties.setExportFlag(false);
        properties.setMustFinishBy(project.getMustFinishByDate());
        properties.setCriticalSlackLimit(Duration.getInstance(NumberHelper.getDouble(project.getCriticalActivityFloatLimit()), TimeUnit.HOURS));
        properties.setWbsCodeSeparator(project.getWBSCodeSeparator());
        properties.setBaselineTypeName(project.getBaselineTypeName());
        properties.setBaselineTypeUniqueID(project.getBaselineTypeObjectId());
        properties.setLastBaselineUpdateDate(project.getLastBaselineUpdateDate());
        properties.setProjectIsBaseline(true);
        properties.setProjectWebsiteUrl(project.getWebSiteURL());
        properties.setEnablePublication(BooleanHelper.getBoolean(project.isEnablePublication()));
        properties.setEnableSummarization(BooleanHelper.getBoolean(project.isEnableSummarization()));
        ProjectCalendar calendar = this.m_projectFile.getCalendarByUniqueID(project.getActivityDefaultCalendarObjectId());
        if (calendar != null) {
            this.m_projectFile.setDefaultCalendar(calendar);
        }
        this.processScheduleOptions(project.getScheduleOptions());
    }

    private void processActivityCodeDefinitions(List<ActivityCodeTypeType> types, List<ActivityCodeType> typeValues) {
        ActivityCode code;
        ActivityCodeContainer container = this.m_projectFile.getActivityCodes();
        HashMap<Integer, ActivityCode> map = new HashMap<Integer, ActivityCode>();
        for (ActivityCodeTypeType type : types) {
            code = new ActivityCode.Builder(this.m_projectFile).uniqueID(type.getObjectId()).scope(ActivityCodeScopeHelper.getInstanceFromXml(type.getScope())).scopeEpsUniqueID(type.getEPSObjectId()).scopeProjectUniqueID(type.getProjectObjectId()).sequenceNumber(type.getSequenceNumber()).name(type.getName()).secure(BooleanHelper.getBoolean(type.isIsSecureCode())).maxLength(type.getLength()).build();
            container.add(code);
            map.put(code.getUniqueID(), code);
        }
        typeValues = HierarchyHelper.sortHierarchy(typeValues, ActivityCodeType::getObjectId, ActivityCodeType::getParentObjectId);
        for (ActivityCodeType typeValue : typeValues) {
            code = (ActivityCode)map.get(typeValue.getCodeTypeObjectId());
            if (code == null) continue;
            ActivityCodeValue value = new ActivityCodeValue.Builder(this.m_projectFile).activityCode(code).uniqueID(typeValue.getObjectId()).sequenceNumber(typeValue.getSequenceNumber()).name(typeValue.getCodeValue()).description(typeValue.getDescription()).color(ColorHelper.parseHtmlColor(typeValue.getColor())).parentValue(code.getValueByUniqueID(typeValue.getParentObjectId())).build();
            code.addValue(value);
        }
    }

    private void processProjectCodeDefinitions(APIBusinessObjects apibo) {
        ProjectCodeContainer container = this.m_projectFile.getProjectCodes();
        HashMap<Integer, ProjectCode> map = new HashMap<Integer, ProjectCode>();
        for (ProjectCodeTypeType type : apibo.getProjectCodeType()) {
            ProjectCode code = new ProjectCode.Builder(this.m_projectFile).uniqueID(type.getObjectId()).sequenceNumber(type.getSequenceNumber()).name(type.getName()).secure(BooleanHelper.getBoolean(type.isIsSecureCode())).maxLength(type.getLength()).build();
            container.add(code);
            map.put(code.getUniqueID(), code);
        }
        List<ProjectCodeType> typeValues = HierarchyHelper.sortHierarchy(apibo.getProjectCode(), ProjectCodeType::getObjectId, ProjectCodeType::getParentObjectId);
        for (ProjectCodeType typeValue : typeValues) {
            ProjectCode code = (ProjectCode)map.get(typeValue.getCodeTypeObjectId());
            if (code == null) continue;
            ProjectCodeValue value = new ProjectCodeValue.Builder(this.m_projectFile).projectCode(code).uniqueID(typeValue.getObjectId()).sequenceNumber(typeValue.getSequenceNumber()).name(typeValue.getCodeValue()).description(typeValue.getDescription()).parentValue(code.getValueByUniqueID(typeValue.getParentObjectId())).build();
            code.addValue(value);
        }
    }

    private void processResourceCodeDefinitions(APIBusinessObjects apibo) {
        ResourceCodeContainer container = this.m_projectFile.getResourceCodes();
        HashMap<Integer, ResourceCode> map = new HashMap<Integer, ResourceCode>();
        for (ResourceCodeTypeType type : apibo.getResourceCodeType()) {
            ResourceCode code = new ResourceCode.Builder(this.m_projectFile).uniqueID(type.getObjectId()).sequenceNumber(type.getSequenceNumber()).name(type.getName()).secure(BooleanHelper.getBoolean(type.isIsSecureCode())).maxLength(type.getLength()).build();
            container.add(code);
            map.put(code.getUniqueID(), code);
        }
        List<ResourceCodeType> typeValues = HierarchyHelper.sortHierarchy(apibo.getResourceCode(), ResourceCodeType::getObjectId, ResourceCodeType::getParentObjectId);
        for (ResourceCodeType typeValue : typeValues) {
            ResourceCode code = (ResourceCode)map.get(typeValue.getCodeTypeObjectId());
            if (code == null) continue;
            ResourceCodeValue value = new ResourceCodeValue.Builder(this.m_projectFile).resourceCode(code).uniqueID(typeValue.getObjectId()).sequenceNumber(typeValue.getSequenceNumber()).name(typeValue.getCodeValue()).description(typeValue.getDescription()).parentValue(code.getValueByUniqueID(typeValue.getParentObjectId())).build();
            code.addValue(value);
        }
    }

    private void processRoleCodeDefinitions(APIBusinessObjects apibo) {
        RoleCodeContainer container = this.m_projectFile.getRoleCodes();
        HashMap<Integer, RoleCode> map = new HashMap<Integer, RoleCode>();
        for (RoleCodeTypeType type : apibo.getRoleCodeType()) {
            RoleCode code = new RoleCode.Builder(this.m_projectFile).uniqueID(type.getObjectId()).sequenceNumber(type.getSequenceNumber()).name(type.getName()).secure(BooleanHelper.getBoolean(type.isIsSecureCode())).maxLength(type.getLength()).build();
            container.add(code);
            map.put(code.getUniqueID(), code);
        }
        List<RoleCodeType> typeValues = HierarchyHelper.sortHierarchy(apibo.getRoleCode(), RoleCodeType::getObjectId, RoleCodeType::getParentObjectId);
        for (RoleCodeType typeValue : typeValues) {
            RoleCode code = (RoleCode)map.get(typeValue.getCodeTypeObjectId());
            if (code == null) continue;
            RoleCodeValue value = new RoleCodeValue.Builder(this.m_projectFile).roleCode(code).uniqueID(typeValue.getObjectId()).sequenceNumber(typeValue.getSequenceNumber()).name(typeValue.getCodeValue()).description(typeValue.getDescription()).parentValue(code.getValueByUniqueID(typeValue.getParentObjectId())).build();
            code.addValue(value);
        }
    }

    private void processResourceAssignmentCodeDefinitions(APIBusinessObjects apibo) {
        ResourceAssignmentCodeContainer container = this.m_projectFile.getResourceAssignmentCodes();
        HashMap<Integer, ResourceAssignmentCode> map = new HashMap<Integer, ResourceAssignmentCode>();
        for (ResourceAssignmentCodeTypeType type : apibo.getResourceAssignmentCodeType()) {
            ResourceAssignmentCode code = new ResourceAssignmentCode.Builder(this.m_projectFile).uniqueID(type.getObjectId()).sequenceNumber(type.getSequenceNumber()).name(type.getName()).secure(BooleanHelper.getBoolean(type.isIsSecureCode())).maxLength(type.getLength()).build();
            container.add(code);
            map.put(code.getUniqueID(), code);
        }
        List<ResourceAssignmentCodeType> typeValues = HierarchyHelper.sortHierarchy(apibo.getResourceAssignmentCode(), ResourceAssignmentCodeType::getObjectId, ResourceAssignmentCodeType::getParentObjectId);
        for (ResourceAssignmentCodeType typeValue : typeValues) {
            ResourceAssignmentCode code = (ResourceAssignmentCode)map.get(typeValue.getCodeTypeObjectId());
            if (code == null) continue;
            ResourceAssignmentCodeValue value = new ResourceAssignmentCodeValue.Builder(this.m_projectFile).resourceAssignmentCode(code).uniqueID(typeValue.getObjectId()).sequenceNumber(typeValue.getSequenceNumber()).name(typeValue.getCodeValue()).description(typeValue.getDescription()).parentValue(code.getValueByUniqueID(typeValue.getParentObjectId())).build();
            code.addValue(value);
        }
    }

    private void processLocations(APIBusinessObjects apibo) {
        LocationContainer container = this.m_projectFile.getLocations();
        apibo.getLocation().forEach(c -> container.add(new Location.Builder(this.m_projectFile).uniqueID(c.getObjectId()).name(c.getName()).addressLine1(c.getAddressLine1()).addressLine2(c.getAddressLine2()).city(c.getCity()).municipality(c.getMunicipality()).state(c.getState()).stateCode(c.getStateCode()).country(c.getCountry()).countryCode(c.getCountryCode()).postalCode(c.getPostalCode()).latitude(c.getLatitude()).longitude(c.getLongitude()).build()));
    }

    private void processCurrencies(APIBusinessObjects apibo) {
        CurrencyContainer container = this.m_projectFile.getCurrencies();
        apibo.getCurrency().forEach(c -> container.add(new Currency.Builder(this.m_projectFile).uniqueID(c.getObjectId()).currencyID(c.getId()).name(c.getName()).symbol(c.getSymbol()).exchangeRate(c.getExchangeRate()).decimalSymbol("Comma".equals(c.getDecimalSymbol()) ? "," : ".").numberOfDecimalPlaces(c.getDecimalPlaces()).digitGroupingSymbol("Comma".equals(c.getDigitGroupingSymbol()) ? "," : ".").positiveCurrencyFormat(c.getPositiveSymbol()).negativeCurrencyFormat(c.getNegativeSymbol()).build()));
    }

    private void processShifts(APIBusinessObjects apibo) {
        ShiftContainer shiftContainer = this.m_projectFile.getShifts();
        ShiftPeriodContainer shiftPeriodContainer = this.m_projectFile.getShiftPeriods();
        for (ShiftType xml : apibo.getShift()) {
            Shift shift = new Shift.Builder(this.m_projectFile).name(xml.getName()).uniqueID(xml.getObjectId()).build();
            shiftContainer.add(shift);
            for (ShiftPeriodType xmlPeriod : xml.getShiftPeriod()) {
                ShiftPeriod period = new ShiftPeriod.Builder(this.m_projectFile, shift).uniqueID(xmlPeriod.getObjectId()).start(xmlPeriod.getStartHour()).build();
                shiftPeriodContainer.add(period);
            }
        }
    }

    private void processExpenseCategories(APIBusinessObjects apibo) {
        ExpenseCategoryContainer container = this.m_projectFile.getExpenseCategories();
        apibo.getExpenseCategory().forEach(c -> container.add(new ExpenseCategory.Builder(this.m_projectFile).uniqueID(c.getObjectId()).name(c.getName()).sequenceNumber(c.getSequenceNumber()).build()));
    }

    private void processCostAccounts(APIBusinessObjects apibo) {
        CostAccountContainer container = this.m_projectFile.getCostAccounts();
        HierarchyHelper.sortHierarchy(apibo.getCostAccount(), CostAccountType::getObjectId, CostAccountType::getParentObjectId).forEach(c -> container.add(new CostAccount.Builder(this.m_projectFile).uniqueID(c.getObjectId()).id(c.getId()).name(c.getName()).notes(this.getNotes(c.getDescription())).sequenceNumber(c.getSequenceNumber()).parent((CostAccount)container.getByUniqueID(c.getParentObjectId())).build()));
    }

    private void processUnitsOfMeasure(APIBusinessObjects apibo) {
        UnitOfMeasureContainer container = this.m_projectFile.getUnitsOfMeasure();
        apibo.getUnitOfMeasure().forEach(u -> container.add(this.processUnitOfMeasure((UnitOfMeasureType)u)));
    }

    private UnitOfMeasure processUnitOfMeasure(UnitOfMeasureType u) {
        return new UnitOfMeasure.Builder(this.m_projectFile).uniqueID(u.getObjectId()).abbreviation(u.getAbbreviation()).name(u.getName()).sequenceNumber(u.getSequenceNumber()).build();
    }

    private void processExpenseItems(List<ActivityExpenseType> expenseItems) {
        for (ActivityExpenseType item : expenseItems) {
            Task task = this.m_projectFile.getTaskByUniqueID(this.m_activityClashMap.getID(item.getActivityObjectId()));
            if (task == null) continue;
            ExpenseItem.Builder builder = new ExpenseItem.Builder(task).account((CostAccount)this.m_projectFile.getCostAccounts().getByUniqueID(item.getCostAccountObjectId())).accrueType(AccrueTypeHelper.getInstanceFromXml(item.getAccrualType())).actualCost(item.getActualCost()).actualUnits(item.getActualUnits()).atCompletionUnits(item.getAtCompletionUnits()).autoComputeActuals(BooleanHelper.getBoolean(item.isAutoComputeActuals())).category((ExpenseCategory)this.m_projectFile.getExpenseCategories().getByUniqueID(item.getExpenseCategoryObjectId())).description(item.getExpenseDescription()).documentNumber(item.getDocumentNumber()).name(item.getExpenseItem()).plannedCost(item.getPlannedCost()).plannedUnits(item.getPlannedUnits()).pricePerUnit(item.getPricePerUnit()).remainingCost(item.getRemainingCost()).remainingUnits(item.getRemainingUnits()).uniqueID(item.getObjectId()).unitOfMeasure(item.getUnitOfMeasure()).vendor(item.getVendor()).atCompletionCost(NumberHelper.sumAsDouble(item.getActualCost(), item.getRemainingCost()));
            ExpenseItem ei = builder.build();
            task.getExpenseItems().add(ei);
            task.setPlannedCost(NumberHelper.sumAsDouble(task.getPlannedCost(), ei.getPlannedCost()));
            task.setActualCost(NumberHelper.sumAsDouble(task.getActualCost(), ei.getActualCost()));
            task.setRemainingCost(NumberHelper.sumAsDouble(task.getRemainingCost(), ei.getRemainingCost()));
            task.setCost(NumberHelper.sumAsDouble(task.getCost(), ei.getAtCompletionCost()));
            task.setFixedCost(NumberHelper.sumAsDouble(task.getFixedCost(), ei.getAtCompletionCost()));
        }
    }

    private void processCalendars(List<CalendarType> calendars) {
        HashMap<ProjectCalendar, Integer> baseCalendarMap = new HashMap<ProjectCalendar, Integer>();
        for (CalendarType calendarType : calendars) {
            ProjectCalendar calendar = this.processCalendar(calendarType);
            Integer baseCalendarID = calendarType.getBaseCalendarObjectId();
            if (baseCalendarID == null) continue;
            baseCalendarMap.put(calendar, baseCalendarID);
        }
        for (Map.Entry entry : baseCalendarMap.entrySet()) {
            ProjectCalendar baseCalendar = this.m_projectFile.getCalendarByUniqueID((Integer)entry.getValue());
            if (baseCalendar == null) continue;
            ((ProjectCalendar)entry.getKey()).setParent(baseCalendar);
        }
    }

    private void configureProjectCalendars() {
        ProjectConfig config = this.m_projectFile.getProjectConfig();
        config.setAutoCalendarUniqueID(true);
    }

    private ProjectCalendar processCalendar(CalendarType row) {
        List<WorkTimeType> workTime;
        ProjectCalendar calendar = this.m_projectFile.addCalendar();
        Integer id = row.getObjectId();
        calendar.setUniqueID(id);
        calendar.setName(row.getName());
        calendar.setType(CalendarTypeHelper.getInstanceFromXml(row.getType()));
        calendar.setPersonal(BooleanHelper.getBoolean(row.isIsPersonal()));
        if (BooleanHelper.getBoolean(row.isIsDefault()) && this.m_projectFile.getDefaultCalendar() == null) {
            this.m_projectFile.setDefaultCalendar(calendar);
        }
        HashMap<DayOfWeek, CalendarType.StandardWorkWeek.StandardWorkHours> hoursMap = new HashMap<DayOfWeek, CalendarType.StandardWorkWeek.StandardWorkHours>();
        CalendarType.StandardWorkWeek stdWorkWeek = row.getStandardWorkWeek();
        if (stdWorkWeek != null) {
            for (CalendarType.StandardWorkWeek.StandardWorkHours hours : stdWorkWeek.getStandardWorkHours()) {
                hoursMap.put(DAY_MAP.get(hours.getDayOfWeek()), hours);
            }
        }
        for (DayOfWeek day : DayOfWeek.values()) {
            CalendarType.StandardWorkWeek.StandardWorkHours hours = (CalendarType.StandardWorkWeek.StandardWorkHours)hoursMap.get(day);
            if (hours == null) {
                calendar.setWorkingDay(day, day != DayOfWeek.SATURDAY && day != DayOfWeek.SUNDAY);
                if (!calendar.isWorkingDay(day)) continue;
                calendar.addCalendarHours(day).add(ProjectCalendarHelper.getDefaultCalendarHours());
                continue;
            }
            ProjectCalendarHours calendarHours = calendar.addCalendarHours(day);
            workTime = hours.getWorkTime();
            if (workTime.isEmpty() || workTime.get(0) == null) {
                calendar.setWorkingDay(day, false);
                continue;
            }
            calendar.setWorkingDay(day, true);
            for (WorkTimeType work2 : workTime) {
                if (work2 == null) continue;
                calendarHours.add(new LocalTimeRange(work2.getStart(), this.getEndTime(work2.getFinish())));
            }
        }
        CalendarType.HolidayOrExceptions hoe = row.getHolidayOrExceptions();
        if (hoe != null) {
            for (CalendarType.HolidayOrExceptions.HolidayOrException ex : hoe.getHolidayOrException()) {
                DayOfWeek[] work;
                LocalDate startDate = LocalDateHelper.getLocalDate(ex.getDate());
                LocalDate endDate = LocalDateHelper.getLocalDate(ex.getDate());
                ProjectCalendarException pce = calendar.addCalendarException(startDate, endDate);
                workTime = ex.getWorkTime();
                if (workTime.size() == 1 && ((work = workTime.get(0)) == null || LocalTime.MIDNIGHT.equals(work.getStart()) && NON_WORKING_END_TIME.equals(work.getFinish()))) continue;
                work = workTime.iterator();
                while (work.hasNext()) {
                    WorkTimeType work2;
                    work2 = (WorkTimeType)work.next();
                    if (work2 == null || work2.getStart() == null || work2.getFinish() == null) continue;
                    pce.add(new LocalTimeRange(work2.getStart(), this.getEndTime(work2.getFinish())));
                }
            }
        }
        ProjectCalendarHelper.ensureWorkingTime(calendar);
        Double rowHoursPerDay = row.getHoursPerDay();
        Double rowHoursPerWeek = row.getHoursPerWeek();
        Double rowHoursPerMonth = row.getHoursPerMonth();
        Double rowHoursPerYear = row.getHoursPerYear();
        calendar.setCalendarMinutesPerDay((int)(NumberHelper.getDouble(rowHoursPerDay) * 60.0));
        calendar.setCalendarMinutesPerWeek((int)(NumberHelper.getDouble(rowHoursPerWeek) * 60.0));
        calendar.setCalendarMinutesPerMonth((int)(NumberHelper.getDouble(rowHoursPerMonth) * 60.0));
        calendar.setCalendarMinutesPerYear((int)(NumberHelper.getDouble(rowHoursPerYear) * 60.0));
        if (rowHoursPerDay == null || rowHoursPerWeek == null || rowHoursPerMonth == null || rowHoursPerYear == null) {
            int minutesPerWeek = 0;
            int workingDays = 0;
            for (DayOfWeek day : DayOfWeek.values()) {
                ProjectCalendarHours hours = calendar.getCalendarHours(day);
                if (hours == null || hours.isEmpty()) continue;
                ++workingDays;
                for (LocalTimeRange range : hours) {
                    minutesPerWeek = (int)((long)minutesPerWeek + range.getDurationAsMilliseconds() / 60000L);
                }
            }
            int minutesPerDay = minutesPerWeek / workingDays;
            int minutesPerMonth = minutesPerWeek * 4;
            int minutesPerYear = minutesPerMonth * 12;
            if (rowHoursPerDay == null) {
                calendar.setCalendarMinutesPerDay(minutesPerDay);
            }
            if (rowHoursPerWeek == null) {
                calendar.setCalendarMinutesPerWeek(minutesPerWeek);
            }
            if (rowHoursPerMonth == null) {
                calendar.setCalendarMinutesPerMonth(minutesPerMonth);
            }
            if (rowHoursPerYear == null) {
                calendar.setCalendarMinutesPerYear(minutesPerYear);
            }
        }
        return calendar;
    }

    private void processResources(APIBusinessObjects apibo) {
        List<ResourceType> resources = apibo.getResource();
        for (ResourceType xml : resources) {
            Resource resource = this.m_projectFile.addResource();
            this.m_roleClashMap.addID(xml.getObjectId());
            Double defaultUnitsPerTime = xml.getDefaultUnitsPerTime();
            if (defaultUnitsPerTime == null) {
                defaultUnitsPerTime = xml.getMaxUnitsPerTime();
            }
            defaultUnitsPerTime = defaultUnitsPerTime == null ? NumberHelper.DOUBLE_ZERO : Double.valueOf(defaultUnitsPerTime * 100.0);
            resource.setUniqueID(xml.getObjectId());
            resource.setName(xml.getName());
            resource.setCode(xml.getEmployeeId());
            resource.setEmailAddress(xml.getEmailAddress());
            resource.setGUID(DatatypeConverter.parseUUID(xml.getGUID()));
            resource.setNotesObject(this.getNotes(xml.getResourceNotes()));
            resource.setCreationDate(xml.getCreateDate());
            resource.setType(ResourceTypeHelper.getInstanceFromXml(xml.getResourceType()));
            resource.setDefaultUnits(defaultUnitsPerTime);
            resource.setParentResourceUniqueID(xml.getParentObjectId());
            resource.setResourceID(xml.getId());
            resource.setCalendar((ProjectCalendar)this.m_projectFile.getCalendars().getByUniqueID(xml.getCalendarObjectId()));
            resource.setCalculateCostsFromUnits(BooleanHelper.getBoolean(xml.isCalculateCostFromUnits()));
            resource.setSequenceNumber(xml.getSequenceNumber());
            resource.setActive(BooleanHelper.getBoolean(xml.isIsActive()));
            resource.setLocationUniqueID(xml.getLocationObjectId());
            resource.setUnitOfMeasureUniqueID(xml.getUnitOfMeasureObjectId());
            resource.setShiftUniqueID(xml.getShiftObjectId());
            resource.setPrimaryRoleUniqueID(xml.getPrimaryRoleObjectId());
            resource.setCurrencyUniqueID(xml.getCurrencyObjectId());
            this.processResourceCodeAssignments(resource, xml.getCode());
            this.populateUserDefinedFieldValues(resource, xml.getUDF());
            this.m_eventManager.fireResourceReadEvent(resource);
        }
    }

    private void processRoles(APIBusinessObjects apibo) {
        for (RoleType role : apibo.getRole()) {
            Resource resource = this.m_projectFile.addResource();
            resource.setRole(true);
            resource.setUniqueID(this.m_roleClashMap.getID(role.getObjectId()));
            resource.setName(role.getName());
            resource.setResourceID(role.getId());
            resource.setNotesObject(this.getHtmlNote(role.getResponsibilities()));
            resource.setSequenceNumber(role.getSequenceNumber());
            this.processRoleCodeAssignments(resource, role.getCode());
        }
    }

    private void processRoleAssignments(APIBusinessObjects apibo) {
        for (ResourceRoleType assignment : apibo.getResourceRole()) {
            Resource role;
            Resource resource = this.m_projectFile.getResourceByUniqueID(assignment.getResourceObjectId());
            if (resource == null || (role = this.m_projectFile.getResourceByUniqueID(assignment.getRoleObjectId())) == null) continue;
            resource.addRoleAssignment(role, SkillLevelHelper.getInstanceFromXml(assignment.getProficiency()));
        }
    }

    private Notes getNotes(String text) {
        HtmlNotes notes = this.getHtmlNote(text);
        return notes == null || notes.isEmpty() ? null : notes;
    }

    private String nullIfEmpty(String text) {
        return text == null || text.isEmpty() ? null : text;
    }

    private void processTasks(List<WBSType> wbs, Map<Integer, Notes> wbsNotes, List<ActivityType> activities, Map<Integer, Notes> activityNotes) {
        String activityID;
        Task task;
        HashSet<Task> wbsTasks = new HashSet<Task>();
        boolean baselineFromCurrentProject = this.m_projectFile.getProjectProperties().getBaselineProjectUniqueID() == null;
        wbs.sort(WBS_ROW_COMPARATOR);
        for (WBSType row : wbs) {
            task = this.m_projectFile.addTask();
            Integer uniqueID = row.getObjectId();
            this.m_activityClashMap.addID(uniqueID);
            wbsTasks.add(task);
            task.setUniqueID(uniqueID);
            task.setGUID(DatatypeConverter.parseUUID(row.getGUID()));
            task.setName(row.getName());
            task.setSummary(true);
            task.setStart(row.getAnticipatedStartDate());
            task.setFinish(row.getAnticipatedFinishDate());
            task.setWBS(row.getCode());
            task.setNotesObject(wbsNotes.get(uniqueID));
            task.setSequenceNumber(row.getSequenceNumber());
            this.populateUserDefinedFieldValues(task, row.getUDF());
        }
        this.m_projectFile.getChildTasks().clear();
        for (WBSType row : wbs) {
            task = this.m_projectFile.getTaskByUniqueID(row.getObjectId());
            Task parentTask = this.m_projectFile.getTaskByUniqueID(row.getParentObjectId());
            if (parentTask == null) {
                this.m_projectFile.getChildTasks().add(task);
                continue;
            }
            this.m_projectFile.getChildTasks().remove(task);
            parentTask.getChildTasks().add(task);
        }
        String prefix = this.m_projectFile.getProjectProperties().getProjectID();
        if (prefix != null && this.m_projectFile.getChildTasks().size() == 1 && (activityID = this.m_projectFile.getChildTasks().get(0).getWBS()) != null && activityID.equals(prefix)) {
            prefix = "";
        }
        this.populateWBS(prefix, this.m_projectFile);
        boolean forceCriticalToFalse = this.m_projectFile.getProjectProperties().getCriticalActivityType() == CriticalActivityType.LONGEST_PATH;
        for (ActivityType row : activities) {
            Integer uniqueID = row.getObjectId();
            Notes notes = activityNotes.get(uniqueID);
            uniqueID = this.m_activityClashMap.addID(uniqueID);
            Integer parentTaskID = row.getWBSObjectId();
            Task parentTask = this.m_projectFile.getTaskByUniqueID(parentTaskID);
            Task task2 = parentTask == null ? this.m_projectFile.addTask() : parentTask.addTask();
            task2.setUniqueID(uniqueID);
            task2.setGUID(DatatypeConverter.parseUUID(row.getGUID()));
            task2.setName(row.getName());
            task2.setNotesObject(notes);
            task2.setPercentCompleteType(PercentCompleteTypeHelper.getInstanceFromXml(row.getPercentCompleteType()));
            task2.setPercentageComplete(this.reversePercentage(row.getDurationPercentComplete()));
            task2.setPhysicalPercentComplete(this.reversePercentage(row.getPhysicalPercentComplete()));
            task2.setPercentageWorkComplete(this.reversePercentage(row.getUnitsPercentComplete()));
            task2.setActualWorkLabor(this.getDuration(row.getActualLaborUnits()));
            task2.setActualWorkNonlabor(this.getDuration(row.getActualNonLaborUnits()));
            task2.setPlannedWorkLabor(this.getDuration(row.getPlannedLaborUnits()));
            task2.setPlannedWorkNonlabor(this.getDuration(row.getPlannedNonLaborUnits()));
            task2.setRemainingWorkLabor(this.getDuration(row.getRemainingLaborUnits()));
            task2.setRemainingWorkNonlabor(this.getDuration(row.getRemainingNonLaborUnits()));
            task2.setActualWork(WorkHelper.addWork(task2.getActualWorkLabor(), task2.getActualWorkNonlabor()));
            task2.setPlannedWork(WorkHelper.addWork(task2.getPlannedWorkLabor(), task2.getPlannedWorkNonlabor()));
            task2.setRemainingWork(WorkHelper.addWork(task2.getRemainingWorkLabor(), task2.getRemainingWorkNonlabor()));
            task2.setWork(WorkHelper.addWork(task2.getActualWork(), task2.getRemainingWork()));
            task2.setPlannedDuration(this.getDuration(row.getPlannedDuration()));
            task2.setActualDuration(this.getDuration(row.getActualDuration()));
            task2.setRemainingDuration(this.getDuration(row.getRemainingDuration()));
            task2.setDuration(this.getDuration(row.getAtCompletionDuration()));
            task2.setConstraintDate(row.getPrimaryConstraintDate());
            task2.setConstraintType(ConstraintTypeHelper.getInstanceFromXml(row.getPrimaryConstraintType()));
            task2.setSecondaryConstraintDate(row.getSecondaryConstraintDate());
            task2.setSecondaryConstraintType(ConstraintTypeHelper.getInstanceFromXml(row.getSecondaryConstraintType()));
            task2.setActualStart(row.getActualStartDate());
            task2.setActualFinish(row.getActualFinishDate());
            task2.setPlannedStart(row.getPlannedStartDate());
            task2.setPlannedFinish(row.getPlannedFinishDate());
            task2.setRemainingEarlyStart(row.getRemainingEarlyStartDate());
            task2.setRemainingEarlyFinish(row.getRemainingEarlyFinishDate());
            task2.setRemainingLateStart(row.getRemainingLateStartDate());
            task2.setRemainingLateFinish(row.getRemainingLateFinishDate());
            task2.setEarlyStart(row.getRemainingEarlyStartDate());
            task2.setEarlyFinish(row.getRemainingEarlyFinishDate());
            task2.setLateStart(row.getRemainingLateStartDate());
            task2.setLateFinish(row.getRemainingLateFinishDate());
            task2.setPriority(PriorityHelper.getInstanceFromXml(row.getLevelingPriority()));
            task2.setCreateDate(row.getCreateDate());
            task2.setActivityID(row.getId());
            task2.setActivityType(ActivityTypeHelper.getInstanceFromXml(row.getType()));
            task2.setActivityStatus(ActivityStatusHelper.getInstanceFromXml(row.getStatus()));
            task2.setPrimaryResourceUniqueID(row.getPrimaryResourceObjectId());
            task2.setSuspendDate(row.getSuspendDate());
            task2.setResume(row.getResumeDate());
            task2.setType(TaskTypeHelper.getInstanceFromXml(row.getDurationType()));
            task2.setMilestone(BooleanHelper.getBoolean(MILESTONE_MAP.get(row.getType())));
            task2.setExternalEarlyStart(row.getExternalEarlyStartDate());
            task2.setExternalLateFinish(row.getExternalLateFinishDate());
            task2.setLongestPath(BooleanHelper.getBoolean(row.isIsLongestPath()));
            task2.setLocationUniqueID(row.getLocationObjectId());
            task2.setExpectedFinish(row.getExpectedFinishDate());
            if (parentTask != null) {
                task2.setWBS(parentTask.getWBS());
            }
            Integer calId = row.getCalendarObjectId();
            ProjectCalendar cal = this.m_projectFile.getCalendarByUniqueID(calId);
            task2.setCalendar(cal);
            task2.setStart(row.getStartDate());
            task2.setFinish(row.getFinishDate());
            this.populateField(task2, TaskField.START, TaskField.START, TaskField.ACTUAL_START, TaskField.REMAINING_EARLY_START, TaskField.PLANNED_START, TaskField.EARLY_START);
            this.populateField(task2, TaskField.FINISH, TaskField.FINISH, TaskField.ACTUAL_FINISH, TaskField.REMAINING_EARLY_FINISH, TaskField.EARLY_FINISH);
            if (task2.getFinish() == null) {
                Duration duration = task2.getRemainingDuration();
                if (duration != null && duration.getDuration() == 0.0) {
                    duration = null;
                }
                if (task2.getActualStart() == null || duration == null) {
                    task2.setFinish(task2.getPlannedFinish());
                } else {
                    LocalDateTime nextWorkStart;
                    ProjectCalendar calendar = task2.getEffectiveCalendar();
                    LocalDateTime finish = calendar.getDate(task2.getPlannedStart(), duration);
                    if (LocalDateTimeHelper.compare(finish, nextWorkStart = calendar.getNextWorkStart(finish)) == 0) {
                        finish = calendar.getPreviousWorkFinish(finish);
                    }
                    task2.setFinish(finish);
                }
            }
            task2.getCritical();
            this.populateUserDefinedFieldValues(task2, row.getUDF());
            this.readActivityCodes(task2, row.getCode());
            if (task2.getMilestone()) {
                if (task2.getActivityType() == org.mpxj.ActivityType.START_MILESTONE) {
                    task2.setFinish(task2.getStart());
                } else {
                    task2.setStart(task2.getFinish());
                }
            }
            if (forceCriticalToFalse) {
                task2.setCritical(false);
            }
            if (baselineFromCurrentProject) {
                this.populateBaselineFromCurrentProject(task2);
            }
            this.m_eventManager.fireTaskReadEvent(task2);
        }
        new ActivitySorter(wbsTasks).sort(this.m_projectFile);
        this.updateStructure();
    }

    private void populateBaselineFromCurrentProject(Task task) {
        task.setBaselineCost(task.getPlannedCost());
        task.setBaselineDuration(task.getPlannedDuration());
        task.setBaselineFinish(task.getPlannedFinish());
        task.setBaselineStart(task.getPlannedStart());
        task.setBaselineWork(task.getPlannedWork());
    }

    private void populateWBS(String prefix, ChildTaskContainer container) {
        for (Task task : container.getChildTasks()) {
            String wbs = prefix.isEmpty() ? task.getWBS() : prefix + this.m_projectFile.getProjectProperties().getWbsCodeSeparator() + task.getWBS();
            task.setWBS(wbs);
            task.setActivityID(wbs);
            this.populateWBS(wbs, task);
        }
    }

    private ProjectCalendar rollupCalendars(Task task) {
        ProjectCalendar result = null;
        if (task.hasChildTasks()) {
            ProjectCalendar firstCalendar;
            List calendars = task.getChildTasks().stream().map(this::rollupCalendars).distinct().collect(Collectors.toList());
            if (calendars.size() == 1 && (firstCalendar = (ProjectCalendar)calendars.get(0)) != null && firstCalendar != this.m_projectFile.getDefaultCalendar()) {
                result = firstCalendar;
                task.setCalendar(result);
            }
        } else {
            result = task.getCalendar();
        }
        return result;
    }

    private void rollupDates(Task parentTask) {
        if (parentTask.hasChildTasks()) {
            int finished = 0;
            LocalDateTime startDate = parentTask.getStart();
            LocalDateTime finishDate = parentTask.getFinish();
            LocalDateTime plannedStartDate = parentTask.getPlannedStart();
            LocalDateTime plannedFinishDate = parentTask.getPlannedFinish();
            LocalDateTime actualStartDate = parentTask.getActualStart();
            LocalDateTime actualFinishDate = parentTask.getActualFinish();
            LocalDateTime earlyStartDate = parentTask.getEarlyStart();
            LocalDateTime earlyFinishDate = parentTask.getEarlyFinish();
            LocalDateTime lateStartDate = parentTask.getLateStart();
            LocalDateTime lateFinishDate = parentTask.getLateFinish();
            LocalDateTime baselineStartDate = parentTask.getBaselineStart();
            LocalDateTime baselineFinishDate = parentTask.getBaselineFinish();
            LocalDateTime remainingEarlyStartDate = parentTask.getRemainingEarlyStart();
            LocalDateTime remainingEarlyFinishDate = parentTask.getRemainingEarlyFinish();
            LocalDateTime remainingLateStartDate = parentTask.getRemainingLateStart();
            LocalDateTime remainingLateFinishDate = parentTask.getRemainingLateFinish();
            boolean critical = false;
            for (Task task : parentTask.getChildTasks()) {
                this.rollupDates(task);
                startDate = LocalDateTimeHelper.min(startDate, task.getStart());
                finishDate = LocalDateTimeHelper.max(finishDate, task.getFinish());
                plannedStartDate = LocalDateTimeHelper.min(plannedStartDate, task.getPlannedStart());
                plannedFinishDate = LocalDateTimeHelper.max(plannedFinishDate, task.getPlannedFinish());
                actualStartDate = LocalDateTimeHelper.min(actualStartDate, task.getActualStart());
                actualFinishDate = LocalDateTimeHelper.max(actualFinishDate, task.getActualFinish());
                earlyStartDate = LocalDateTimeHelper.min(earlyStartDate, task.getEarlyStart());
                earlyFinishDate = LocalDateTimeHelper.max(earlyFinishDate, task.getEarlyFinish());
                remainingEarlyStartDate = LocalDateTimeHelper.min(remainingEarlyStartDate, task.getRemainingEarlyStart());
                remainingEarlyFinishDate = LocalDateTimeHelper.max(remainingEarlyFinishDate, task.getRemainingEarlyFinish());
                lateStartDate = LocalDateTimeHelper.min(lateStartDate, task.getLateStart());
                lateFinishDate = LocalDateTimeHelper.max(lateFinishDate, task.getLateFinish());
                remainingLateStartDate = LocalDateTimeHelper.min(remainingLateStartDate, task.getRemainingLateStart());
                remainingLateFinishDate = LocalDateTimeHelper.max(remainingLateFinishDate, task.getRemainingLateFinish());
                baselineStartDate = LocalDateTimeHelper.min(baselineStartDate, task.getBaselineStart());
                baselineFinishDate = LocalDateTimeHelper.max(baselineFinishDate, task.getBaselineFinish());
                if (task.getActualFinish() != null) {
                    ++finished;
                }
                critical = critical || task.getCritical();
            }
            parentTask.setStart(startDate);
            parentTask.setFinish(finishDate);
            parentTask.setPlannedStart(plannedStartDate);
            parentTask.setPlannedFinish(plannedFinishDate);
            parentTask.setActualStart(actualStartDate);
            parentTask.setEarlyStart(earlyStartDate);
            parentTask.setEarlyFinish(earlyFinishDate);
            parentTask.setRemainingEarlyStart(remainingEarlyStartDate);
            parentTask.setRemainingEarlyFinish(remainingEarlyFinishDate);
            parentTask.setLateStart(lateStartDate);
            parentTask.setLateFinish(lateFinishDate);
            parentTask.setRemainingLateStart(remainingLateStartDate);
            parentTask.setRemainingLateFinish(remainingLateFinishDate);
            parentTask.setBaselineStart(baselineStartDate);
            parentTask.setBaselineFinish(baselineFinishDate);
            if (finished == parentTask.getChildTasks().size()) {
                parentTask.setActualFinish(actualFinishDate);
            }
            Duration plannedDuration = null;
            Duration actualDuration = null;
            Duration remainingDuration = null;
            Duration duration = null;
            ProjectCalendar effectiveCalendar = parentTask.getEffectiveCalendar();
            if (effectiveCalendar != null) {
                if (plannedStartDate != null && plannedFinishDate != null) {
                    plannedDuration = effectiveCalendar.getWork(plannedStartDate, plannedFinishDate, TimeUnit.HOURS);
                    parentTask.setPlannedDuration(plannedDuration);
                }
                if (parentTask.getActualFinish() == null) {
                    LocalDateTime taskFinishDate;
                    LocalDateTime taskStartDate = parentTask.getRemainingEarlyStart();
                    if (taskStartDate == null && (taskStartDate = parentTask.getEarlyStart()) == null) {
                        taskStartDate = plannedStartDate;
                    }
                    if ((taskFinishDate = parentTask.getRemainingEarlyFinish()) == null && (taskFinishDate = parentTask.getEarlyFinish()) == null) {
                        taskFinishDate = plannedFinishDate;
                    }
                    if (taskStartDate != null) {
                        if (parentTask.getActualStart() != null) {
                            actualDuration = effectiveCalendar.getWork(parentTask.getActualStart(), taskStartDate, TimeUnit.HOURS);
                        }
                        if (taskFinishDate != null) {
                            remainingDuration = effectiveCalendar.getWork(taskStartDate, taskFinishDate, TimeUnit.HOURS);
                        }
                    }
                } else {
                    if (parentTask.getActualStart() != null) {
                        actualDuration = effectiveCalendar.getWork(parentTask.getActualStart(), parentTask.getActualFinish(), TimeUnit.HOURS);
                    }
                    remainingDuration = Duration.getInstance(0, TimeUnit.HOURS);
                }
                if (actualDuration != null && actualDuration.getDuration() < 0.0) {
                    actualDuration = null;
                }
                if (remainingDuration != null && remainingDuration.getDuration() < 0.0) {
                    remainingDuration = null;
                }
                duration = Duration.add(actualDuration, remainingDuration, effectiveCalendar);
            }
            parentTask.setActualDuration(actualDuration);
            parentTask.setRemainingDuration(remainingDuration);
            parentTask.setDuration(duration);
            if (plannedDuration != null && remainingDuration != null && plannedDuration.getDuration() != 0.0) {
                double durationPercentComplete = (plannedDuration.getDuration() - remainingDuration.getDuration()) / plannedDuration.getDuration() * 100.0;
                if (durationPercentComplete < 0.0) {
                    durationPercentComplete = 0.0;
                } else if (durationPercentComplete > 100.0) {
                    durationPercentComplete = 100.0;
                }
                parentTask.setPercentageComplete(durationPercentComplete);
                parentTask.setPercentCompleteType(PercentCompleteType.DURATION);
            }
            parentTask.getTotalSlack();
            parentTask.setCritical(critical);
        }
    }

    private void populateField(FieldContainer container, FieldType target, FieldType ... types) {
        for (FieldType type : types) {
            Object value = container.getCachedValue(type);
            if (value == null) continue;
            container.set(target, value);
            break;
        }
    }

    private void updateStructure() {
        int id = 1;
        Integer outlineLevel = 1;
        for (Task task : this.m_projectFile.getChildTasks()) {
            id = this.updateStructure(id, task, outlineLevel);
        }
    }

    private int updateStructure(int id, Task task, Integer outlineLevel) {
        task.setID(id++);
        task.setOutlineLevel(outlineLevel);
        outlineLevel = outlineLevel + 1;
        for (Task childTask : task.getChildTasks()) {
            id = this.updateStructure(id, childTask, outlineLevel);
        }
        return id;
    }

    private void processPredecessors(List<RelationshipType> relationships) {
        for (RelationshipType row : relationships) {
            Object relation;
            Integer predecessorID = row.getPredecessorActivityObjectId();
            Integer successorID = row.getSuccessorActivityObjectId();
            Task successorTask = this.m_projectFile.getTaskByUniqueID(this.m_activityClashMap.getID(successorID));
            Task predecessorTask = this.m_projectFile.getTaskByUniqueID(this.m_activityClashMap.getID(predecessorID));
            RelationType type = RelationTypeHelper.getInstanceFromXml(row.getType());
            Duration lag = this.getDuration(row.getLag());
            String comments = this.nullIfEmpty(row.getComments());
            if (successorTask != null && predecessorTask != null) {
                relation = successorTask.addPredecessor(new Relation.Builder().predecessorTask(predecessorTask).type(type).lag(lag).uniqueID(row.getObjectId()).notes(comments));
                this.m_eventManager.fireRelationReadEvent((Relation)relation);
                continue;
            }
            if (successorTask != null && predecessorTask == null) {
                relation = new ExternalRelation(row.getObjectId(), predecessorID, successorTask, type, lag, true, comments);
                this.m_externalRelations.add((ExternalRelation)relation);
                continue;
            }
            if (successorTask != null || predecessorTask == null) continue;
            relation = new ExternalRelation(row.getObjectId(), successorID, predecessorTask, type, lag, false, comments);
            this.m_externalRelations.add((ExternalRelation)relation);
        }
    }

    private void processWorkContours(APIBusinessObjects apibo) {
        apibo.getResourceCurve().forEach(this::processWorkContour);
    }

    private void processWorkContour(ResourceCurveType curve) {
        if (this.m_projectFile.getWorkContours().getByUniqueID(curve.getObjectId()) != null) {
            return;
        }
        ResourceCurveValuesType curveValues = curve.getValues();
        double[] values = new double[]{NumberHelper.getDouble(curveValues.getValue0()), NumberHelper.getDouble(curveValues.getValue5()), NumberHelper.getDouble(curveValues.getValue10()), NumberHelper.getDouble(curveValues.getValue15()), NumberHelper.getDouble(curveValues.getValue20()), NumberHelper.getDouble(curveValues.getValue25()), NumberHelper.getDouble(curveValues.getValue30()), NumberHelper.getDouble(curveValues.getValue35()), NumberHelper.getDouble(curveValues.getValue40()), NumberHelper.getDouble(curveValues.getValue45()), NumberHelper.getDouble(curveValues.getValue50()), NumberHelper.getDouble(curveValues.getValue55()), NumberHelper.getDouble(curveValues.getValue60()), NumberHelper.getDouble(curveValues.getValue65()), NumberHelper.getDouble(curveValues.getValue70()), NumberHelper.getDouble(curveValues.getValue75()), NumberHelper.getDouble(curveValues.getValue80()), NumberHelper.getDouble(curveValues.getValue85()), NumberHelper.getDouble(curveValues.getValue90()), NumberHelper.getDouble(curveValues.getValue95()), NumberHelper.getDouble(curveValues.getValue100())};
        this.m_projectFile.getWorkContours().add(new WorkContour(curve.getObjectId(), curve.getName(), BooleanHelper.getBoolean(curve.isIsDefault()), values));
    }

    private void processAssignments(List<ResourceAssignmentType> assignments) {
        for (ResourceAssignmentType row : assignments) {
            Task task = this.m_projectFile.getTaskByUniqueID(this.m_activityClashMap.getID(row.getActivityObjectId()));
            Integer roleID = this.m_roleClashMap.getID(row.getRoleObjectId());
            Integer resourceID = row.getResourceObjectId();
            if (resourceID == null && roleID != null) {
                resourceID = roleID;
                roleID = null;
            }
            Resource resource = this.m_projectFile.getResourceByUniqueID(resourceID);
            if (task == null || resource == null) continue;
            ProjectCalendar effectiveCalendar = task.getEffectiveCalendar();
            ResourceAssignment assignment = task.addResourceAssignment(resource);
            assignment.setUniqueID(row.getObjectId());
            assignment.setRemainingWork(this.getDuration(row.getRemainingUnits()));
            assignment.setPlannedWork(this.getDuration(row.getPlannedUnits()));
            assignment.setActualWork(this.getDuration(row.getActualUnits()));
            assignment.setRemainingCost(row.getRemainingCost());
            assignment.setPlannedCost(row.getPlannedCost());
            assignment.setActualCost(row.getActualCost());
            assignment.setActualStart(row.getActualStartDate());
            assignment.setActualFinish(row.getActualFinishDate());
            assignment.setPlannedStart(row.getPlannedStartDate());
            assignment.setPlannedFinish(row.getPlannedFinishDate());
            assignment.setGUID(DatatypeConverter.parseUUID(row.getGUID()));
            assignment.setActualOvertimeCost(row.getActualOvertimeCost());
            assignment.setActualOvertimeWork(this.getDuration(row.getActualOvertimeUnits()));
            assignment.setWorkContour(CurveHelper.getWorkContour(this.m_projectFile, row.getResourceCurveObjectId()));
            assignment.setRateIndex(RateTypeHelper.getInstanceFromXml(row.getRateType()));
            assignment.setRole(this.m_projectFile.getResourceByUniqueID(roleID));
            assignment.setOverrideRate(this.readRate(row.getCostPerQuantity()));
            assignment.setRateSource(RateSourceHelper.getInstanceFromXml(row.getRateSource()));
            assignment.setCalculateCostsFromUnits(BooleanHelper.getBoolean(row.isIsCostUnitsLinked()));
            assignment.setCostAccount((CostAccount)this.m_projectFile.getCostAccounts().getByUniqueID(row.getCostAccountObjectId()));
            assignment.setRemainingEarlyStart(row.getRemainingStartDate());
            assignment.setRemainingEarlyFinish(row.getRemainingFinishDate());
            this.populateField(assignment, AssignmentField.START, AssignmentField.ACTUAL_START, AssignmentField.REMAINING_EARLY_START, AssignmentField.PLANNED_START);
            this.populateField(assignment, AssignmentField.FINISH, AssignmentField.ACTUAL_FINISH, AssignmentField.REMAINING_EARLY_FINISH, AssignmentField.PLANNED_FINISH);
            Duration remainingWork = assignment.getRemainingWork();
            Duration actualWork = assignment.getActualWork();
            Duration totalWork = Duration.add(actualWork, remainingWork, effectiveCalendar);
            assignment.setWork(totalWork);
            Number remainingCost = assignment.getRemainingCost();
            Number actualCost = assignment.getActualCost();
            Double atCompletionCost = NumberHelper.sumAsDouble(actualCost, remainingCost);
            assignment.setCost(atCompletionCost);
            task.setPlannedCost(NumberHelper.sumAsDouble(task.getPlannedCost(), assignment.getPlannedCost()));
            task.setActualCost(NumberHelper.sumAsDouble(task.getActualCost(), actualCost));
            task.setRemainingCost(NumberHelper.sumAsDouble(task.getRemainingCost(), remainingCost));
            task.setCost(NumberHelper.sumAsDouble(task.getCost(), atCompletionCost));
            assignment.setUnits(NumberHelper.getDouble(row.getPlannedUnitsPerTime()) * 100.0);
            assignment.setRemainingUnits(NumberHelper.getDouble(row.getRemainingUnitsPerTime()) * 100.0);
            this.populateUserDefinedFieldValues(assignment, row.getUDF());
            assignment.setTimephasedPlannedWork(TimephasedHelper.read(effectiveCalendar, assignment.getPlannedStart(), row.getPlannedCurve()));
            assignment.setTimephasedActualWork(TimephasedHelper.read(effectiveCalendar, assignment.getActualStart(), row.getActualCurve()));
            assignment.setTimephasedWork(TimephasedHelper.read(effectiveCalendar, assignment.getRemainingEarlyStart(), row.getRemainingCurve()));
            this.processResourceAssignmentCodeAssignments(assignment, row.getCode());
            this.m_eventManager.fireAssignmentReadEvent(assignment);
        }
    }

    private void processResourceRates(APIBusinessObjects apibo) {
        ArrayList<ResourceRateType> rates = new ArrayList<ResourceRateType>(apibo.getResourceRate());
        rates.sort((r1, r2) -> {
            Integer id2;
            Integer id1 = r1.getResourceObjectId();
            int cmp = NumberHelper.compare(id1, id2 = r2.getResourceObjectId());
            if (cmp != 0) {
                return cmp;
            }
            LocalDateTime d1 = r1.getEffectiveDate();
            LocalDateTime d2 = r2.getEffectiveDate();
            return LocalDateTimeHelper.compare(d1, d2);
        });
        Resource resource = null;
        for (int i = 0; i < rates.size(); ++i) {
            ResourceRateType nextRow;
            ResourceRateType row = (ResourceRateType)rates.get(i);
            Integer resourceID = row.getResourceObjectId();
            if (resource == null || !resource.getUniqueID().equals(resourceID)) {
                resource = this.m_projectFile.getResourceByUniqueID(resourceID);
                if (resource == null) continue;
                resource.getCostRateTable(0).clear();
            }
            Rate[] values = new Rate[]{this.readRate(row.getPricePerUnit()), this.readRate(row.getPricePerUnit2()), this.readRate(row.getPricePerUnit3()), this.readRate(row.getPricePerUnit4()), this.readRate(row.getPricePerUnit5())};
            Double costPerUse = NumberHelper.getDouble(0.0);
            Double maxUnits = NumberHelper.getDouble(NumberHelper.getDouble(row.getMaxUnitsPerTime()) * 100.0);
            ShiftPeriod period = (ShiftPeriod)this.m_projectFile.getShiftPeriods().getByUniqueID(row.getShiftPeriodObjectId());
            LocalDateTime startDate = row.getEffectiveDate();
            LocalDateTime endDate = LocalDateTimeHelper.END_DATE_NA;
            if (i + 1 < rates.size() && NumberHelper.equals(resourceID, (nextRow = (ResourceRateType)rates.get(i + 1)).getResourceObjectId())) {
                endDate = nextRow.getEffectiveDate().minusMinutes(1L);
            }
            if (startDate == null || startDate.isBefore(LocalDateTimeHelper.START_DATE_NA)) {
                startDate = LocalDateTimeHelper.START_DATE_NA;
            }
            if (endDate == null || endDate.isAfter(LocalDateTimeHelper.END_DATE_NA)) {
                endDate = LocalDateTimeHelper.END_DATE_NA;
            }
            resource.getCostRateTable(0).add(new CostRateTableEntry(startDate, endDate, (Number)costPerUse, period, values));
            resource.getAvailability().add(new Availability(startDate, endDate, maxUnits));
        }
    }

    private Rate readRate(Double value) {
        if (value == null) {
            return null;
        }
        return new Rate(value, TimeUnit.HOURS);
    }

    private void processRoleRates(APIBusinessObjects apibo) {
        ArrayList<RoleRateType> rates = new ArrayList<RoleRateType>(apibo.getRoleRateNew().isEmpty() ? apibo.getRoleRate() : apibo.getRoleRateNew());
        rates.sort((r1, r2) -> {
            Integer id2;
            Integer id1 = r1.getRoleObjectId();
            int cmp = NumberHelper.compare(id1, id2 = r2.getRoleObjectId());
            if (cmp != 0) {
                return cmp;
            }
            LocalDateTime d1 = r1.getEffectiveDate();
            LocalDateTime d2 = r2.getEffectiveDate();
            return LocalDateTimeHelper.compare(d1, d2);
        });
        Resource resource = null;
        for (int i = 0; i < rates.size(); ++i) {
            RoleRateType row = (RoleRateType)rates.get(i);
            Integer resourceID = this.m_roleClashMap.getID(row.getRoleObjectId());
            if (resource == null || !resource.getUniqueID().equals(resourceID)) {
                resource = this.m_projectFile.getResourceByUniqueID(resourceID);
                if (resource == null) continue;
                resource.getCostRateTable(0).clear();
            }
            Rate[] values = new Rate[]{this.readRate(row.getPricePerUnit()), this.readRate(row.getPricePerUnit2()), this.readRate(row.getPricePerUnit3()), this.readRate(row.getPricePerUnit4()), this.readRate(row.getPricePerUnit5())};
            Double costPerUse = NumberHelper.getDouble(0.0);
            Double maxUnits = NumberHelper.getDouble(NumberHelper.getDouble(row.getMaxUnitsPerTime()) * 100.0);
            LocalDateTime startDate = row.getEffectiveDate();
            LocalDateTime endDate = LocalDateTimeHelper.END_DATE_NA;
            if (i + 1 < rates.size()) {
                RoleRateType nextRow = (RoleRateType)rates.get(i + 1);
                if (NumberHelper.equals(row.getRoleObjectId(), nextRow.getRoleObjectId())) {
                    endDate = nextRow.getEffectiveDate().minusMinutes(1L);
                }
            }
            if (startDate == null || startDate.isBefore(LocalDateTimeHelper.START_DATE_NA)) {
                startDate = LocalDateTimeHelper.START_DATE_NA;
            }
            if (endDate == null || endDate.isAfter(LocalDateTimeHelper.END_DATE_NA)) {
                endDate = LocalDateTimeHelper.END_DATE_NA;
            }
            resource.getCostRateTable(0).add(new CostRateTableEntry(startDate, endDate, (Number)costPerUse, values));
            resource.getAvailability().add(new Availability(startDate, endDate, maxUnits));
        }
    }

    private void processActivitySteps(List<ActivityStepType> activitySteps) {
        ArrayList<ActivityStepType> steps = new ArrayList<ActivityStepType>(activitySteps);
        steps.sort(Comparator.comparing(ActivityStepType::getSequenceNumber));
        for (ActivityStepType activityStep : steps) {
            Task task = this.m_projectFile.getTaskByUniqueID(this.m_activityClashMap.getID(activityStep.getActivityObjectId()));
            if (task == null) continue;
            Step step = new Step.Builder(task).name(activityStep.getName()).sequenceNumber(activityStep.getSequenceNumber()).uniqueID(activityStep.getObjectId()).weight(activityStep.getWeight()).percentComplete(NumberHelper.getDouble(activityStep.getPercentComplete()) * 100.0).description(this.getHtmlNote(activityStep.getDescription())).build();
            task.getSteps().add(step);
        }
    }

    private void processNotebookTopics(APIBusinessObjects apibo) {
        apibo.getNotebookTopic().forEach(this::processNotebookTopic);
    }

    private void processNotebookTopic(NotebookTopicType xml) {
        NotesTopic topic = new NotesTopic.Builder(this.m_projectFile).uniqueID(xml.getObjectId()).sequenceNumber(xml.getSequenceNumber()).availableForEPS(BooleanHelper.getBoolean(xml.isAvailableForEPS())).availableForProject(BooleanHelper.getBoolean(xml.isAvailableForProject())).availableForWBS(BooleanHelper.getBoolean(xml.isAvailableForWBS())).availableForActivity(BooleanHelper.getBoolean(xml.isAvailableForActivity())).name(xml.getName()).build();
        this.m_projectFile.getNotesTopics().add(topic);
    }

    private Map<Integer, Notes> getWbsNotes(List<ProjectNoteType> notes) {
        Map map = notes.stream().collect(Collectors.groupingBy(n -> n.getWBSObjectId() == null ? Integer.valueOf(0) : n.getWBSObjectId(), Collectors.toList()));
        return map.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> new ParentNotes(((List)e.getValue()).stream().map(n -> this.getNote(n.getObjectId(), n.getNotebookTopicObjectId(), n.getNote())).filter(Objects::nonNull).collect(Collectors.toList()))));
    }

    private Map<Integer, Notes> getActivityNotes(List<ActivityNoteType> notes) {
        Map map = notes.stream().filter(n -> n.getActivityObjectId() != null).collect(Collectors.groupingBy(ActivityNoteType::getActivityObjectId, Collectors.toList()));
        return map.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> new ParentNotes(((List)e.getValue()).stream().map(n -> this.getNote(n.getObjectId(), n.getNotebookTopicObjectId(), n.getNote())).filter(Objects::nonNull).collect(Collectors.toList()))));
    }

    private Notes getNote(Integer uniqueID, Integer topicID, String text) {
        HtmlNotes note = this.getHtmlNote(text);
        if (note == null || note.isEmpty()) {
            return null;
        }
        NotesTopic topic = (NotesTopic)this.m_projectFile.getNotesTopics().getByUniqueID(topicID);
        if (topic == null) {
            topic = this.m_projectFile.getNotesTopics().getDefaultTopic();
        }
        return new StructuredNotes(this.m_projectFile, uniqueID, topic, note);
    }

    private HtmlNotes getHtmlNote(String text) {
        if (text == null || text.isEmpty()) {
            return null;
        }
        String html = text.replaceAll("[\\uFEFF\\uFFFE\\x00]", "");
        HtmlNotes result = new HtmlNotes(html);
        return result.isEmpty() ? null : result;
    }

    private Duration getDuration(Double duration) {
        if (duration == null) {
            return null;
        }
        return Duration.getInstance(NumberHelper.getDouble(duration), TimeUnit.HOURS);
    }

    private LocalTime getEndTime(LocalTime date) {
        return date.plusMinutes(1L);
    }

    private Number reversePercentage(Double n) {
        return n == null ? null : NumberHelper.getDouble(n * 100.0);
    }

    private void populateUserDefinedFieldValues(FieldContainer mpxj, List<UDFAssignmentType> udfs) {
        for (UDFAssignmentType udf : udfs) {
            UserDefinedField fieldType = this.m_projectFile.getUserDefinedFields().getByUniqueID(udf.getTypeObjectId());
            if (fieldType == null) continue;
            mpxj.set(fieldType, this.getUdfValue(udf));
        }
    }

    private Object getUdfValue(UDFAssignmentType udf) {
        if (udf.getCostValue() != null) {
            return udf.getCostValue();
        }
        if (udf.getDoubleValue() != null) {
            return udf.getDoubleValue();
        }
        if (udf.getFinishDateValue() != null) {
            return udf.getFinishDateValue();
        }
        if (udf.getIndicatorValue() != null) {
            return udf.getIndicatorValue();
        }
        if (udf.getIntegerValue() != null) {
            return udf.getIntegerValue();
        }
        if (udf.getStartDateValue() != null) {
            return udf.getStartDateValue();
        }
        if (udf.getTextValue() != null) {
            return udf.getTextValue();
        }
        return null;
    }

    private void readActivityCodes(Task task, List<CodeAssignmentType> codes) {
        for (CodeAssignmentType assignment : codes) {
            ActivityCodeValue activityCodeValue;
            ActivityCode activityCode = (ActivityCode)this.m_projectFile.getActivityCodes().getByUniqueID(assignment.getTypeObjectId());
            if (activityCode == null || (activityCodeValue = activityCode.getValueByUniqueID(assignment.getValueObjectId())) == null) continue;
            task.addActivityCodeValue(activityCodeValue);
        }
    }

    private void processScheduleOptions(List<ScheduleOptionsType> list) {
        if (list == null || list.isEmpty()) {
            return;
        }
        ScheduleOptionsType options = list.get(0);
        ProjectProperties projectProperties = this.m_projectFile.getProjectProperties();
        projectProperties.setConsiderAssignmentsInOtherProjects(BooleanHelper.getBoolean(options.isIncludeExternalResAss()));
        projectProperties.setConsiderAssignmentsInOtherProjectsWithPriorityEqualHigherThan(options.getExternalProjectPriorityLimit());
        projectProperties.setPreserveScheduledEarlyAndLateDates(BooleanHelper.getBoolean(options.isPreserveScheduledEarlyAndLateDates()));
        projectProperties.setLevelAllResources(BooleanHelper.getBoolean(options.isLevelAllResources()));
        projectProperties.setLevelResourcesOnlyWithinActivityTotalFloat(BooleanHelper.getBoolean(options.isLevelWithinFloat()));
        projectProperties.setPreserveMinimumFloatWhenLeveling(options.getMinFloatToPreserve() == null ? null : Duration.getInstance(options.getMinFloatToPreserve(), TimeUnit.HOURS));
        projectProperties.setMaxPercentToOverallocateResources(options.getOverAllocationPercentage());
        projectProperties.setLevelingPriorities(options.getPriorityList());
        projectProperties.setIgnoreRelationshipsToAndFromOtherProjects(BooleanHelper.getBoolean(options.isIgnoreOtherProjectRelationships()));
        projectProperties.setMakeOpenEndedActivitiesCritical(BooleanHelper.getBoolean(options.isMakeOpenEndedActivitiesCritical()));
        projectProperties.setUseExpectedFinishDates(BooleanHelper.getBoolean(options.isUseExpectedFinishDates()));
        projectProperties.setComputeStartToStartLagFromEarlyStart(BooleanHelper.getBoolean(options.isStartToStartLagCalculationType()));
        projectProperties.setSchedulingProgressedActivities(SchedulingProgressedActivitiesHelper.getInstanceFromXml(options.getOutOfSequenceScheduleType()));
        projectProperties.setCalculateFloatBasedOnFinishDateOfEachProject(BooleanHelper.getBoolean(options.isCalculateFloatBasedOnFinishDate()));
        projectProperties.setRelationshipLagCalendar(RelationshipLagCalendarHelper.getInstanceFromXml(options.getRelationshipLagCalendar()));
        projectProperties.setTotalSlackCalculationType(TotalSlackCalculationTypeHelper.getInstanceFromXml(options.getComputeTotalFloatType()));
        projectProperties.setCalculateMultipleFloatPaths(BooleanHelper.getBoolean(options.isMultipleFloatPathsEnabled()));
        projectProperties.setCalculateMultipleFloatPathsUsingTotalFloat(BooleanHelper.getBoolean(options.isMultipleFloatPathsUseTotalFloat()));
        projectProperties.setDisplayMultipleFloatPathsEndingWithActivityUniqueID(options.getMultipleFloatPathsEndingActivityObjectId());
        projectProperties.setMaximumNumberOfFloatPathsToCalculate(options.getMaximumMultipleFloatPaths());
    }

    private void rollupValues() {
        this.m_projectFile.getChildTasks().forEach(this::rollupCalendars);
        this.m_projectFile.getChildTasks().forEach(this::rollupDates);
        this.m_projectFile.getChildTasks().forEach(this::rollupWork);
        this.m_projectFile.getChildTasks().forEach(this::rollupCosts);
        if (this.m_projectFile.getProjectProperties().getBaselineProjectUniqueID() == null) {
            this.m_projectFile.getTasks().stream().filter(Task::getSummary).forEach(this::populateBaselineFromCurrentProject);
        }
    }

    private void rollupCosts(Task parentTask) {
        if (parentTask.hasChildTasks()) {
            double plannedCost = 0.0;
            double actualCost = 0.0;
            double remainingCost = 0.0;
            double cost = 0.0;
            double fixedCost = 0.0;
            for (Task child : parentTask.getChildTasks()) {
                this.rollupCosts(child);
                plannedCost += NumberHelper.getDouble(child.getPlannedCost());
                actualCost += NumberHelper.getDouble(child.getActualCost());
                remainingCost += NumberHelper.getDouble(child.getRemainingCost());
                cost += NumberHelper.getDouble(child.getCost());
                fixedCost += NumberHelper.getDouble(child.getFixedCost());
            }
            parentTask.setPlannedCost(NumberHelper.getDouble(plannedCost));
            parentTask.setActualCost(NumberHelper.getDouble(actualCost));
            parentTask.setRemainingCost(NumberHelper.getDouble(remainingCost));
            parentTask.setCost(NumberHelper.getDouble(cost));
            parentTask.setFixedCost(NumberHelper.getDouble(fixedCost));
        }
    }

    private void rollupWork(Task parentTask) {
        if (parentTask.hasChildTasks()) {
            ProjectCalendar calendar = parentTask.getEffectiveCalendar();
            Duration actualWork = null;
            Duration plannedWork = null;
            Duration remainingWork = null;
            Duration work = null;
            for (Task task : parentTask.getChildTasks()) {
                this.rollupWork(task);
                actualWork = Duration.add(actualWork, task.getActualWork(), calendar);
                plannedWork = Duration.add(plannedWork, task.getPlannedWork(), calendar);
                remainingWork = Duration.add(remainingWork, task.getRemainingWork(), calendar);
                work = Duration.add(work, task.getWork(), calendar);
            }
            parentTask.setActualWork(actualWork);
            parentTask.setPlannedWork(plannedWork);
            parentTask.setRemainingWork(remainingWork);
            parentTask.setWork(work);
        }
    }

    static {
        try {
            System.setProperty("com.sun.xml.bind.v2.runtime.JAXBContextImpl.fastBoot", "true");
            CONTEXT = JAXBContext.newInstance((String)"org.mpxj.primavera.schema", (ClassLoader)PrimaveraPMFileReader.class.getClassLoader());
        }
        catch (JAXBException ex) {
            CONTEXT_EXCEPTION = ex;
            CONTEXT = null;
        }
        DAY_MAP = new HashMap<String, DayOfWeek>();
        DAY_MAP.put("Monday", DayOfWeek.MONDAY);
        DAY_MAP.put("Tuesday", DayOfWeek.TUESDAY);
        DAY_MAP.put("Wednesday", DayOfWeek.WEDNESDAY);
        DAY_MAP.put("Thursday", DayOfWeek.THURSDAY);
        DAY_MAP.put("Friday", DayOfWeek.FRIDAY);
        DAY_MAP.put("Saturday", DayOfWeek.SATURDAY);
        DAY_MAP.put("Sunday", DayOfWeek.SUNDAY);
        DAY_MAP.put("1", DayOfWeek.SUNDAY);
        DAY_MAP.put("2", DayOfWeek.MONDAY);
        DAY_MAP.put("3", DayOfWeek.TUESDAY);
        DAY_MAP.put("4", DayOfWeek.WEDNESDAY);
        DAY_MAP.put("5", DayOfWeek.THURSDAY);
        DAY_MAP.put("6", DayOfWeek.FRIDAY);
        DAY_MAP.put("7", DayOfWeek.SATURDAY);
        MILESTONE_MAP = new HashMap<String, Boolean>();
        MILESTONE_MAP.put("Task Dependent", Boolean.FALSE);
        MILESTONE_MAP.put("Resource Dependent", Boolean.FALSE);
        MILESTONE_MAP.put("Level of Effort", Boolean.FALSE);
        MILESTONE_MAP.put("Start Milestone", Boolean.TRUE);
        MILESTONE_MAP.put("Finish Milestone", Boolean.TRUE);
        MILESTONE_MAP.put("WBS Summary", Boolean.FALSE);
        WBS_ROW_COMPARATOR = new WbsRowComparatorPMXML();
        ENCODING_PATTERN = Pattern.compile(".*<\\?xml.*encoding=\"([^\"]+)\".*\\?>.*", 32);
        NON_WORKING_END_TIME = LocalTime.of(23, 59);
    }
}

