/*
 * Decompiled with CFR 0.152.
 */
package org.mpxj.primavera;

import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.mpxj.ActivityCode;
import org.mpxj.ActivityCodeScope;
import org.mpxj.ActivityCodeValue;
import org.mpxj.Availability;
import org.mpxj.AvailabilityTable;
import org.mpxj.Code;
import org.mpxj.CodeValue;
import org.mpxj.CostAccount;
import org.mpxj.CostRateTable;
import org.mpxj.CostRateTableEntry;
import org.mpxj.Currency;
import org.mpxj.CurrencySymbolPosition;
import org.mpxj.CustomField;
import org.mpxj.CustomFieldContainer;
import org.mpxj.DataType;
import org.mpxj.Duration;
import org.mpxj.ExpenseCategory;
import org.mpxj.ExpenseItem;
import org.mpxj.FieldContainer;
import org.mpxj.FieldType;
import org.mpxj.FieldTypeClass;
import org.mpxj.HtmlNotes;
import org.mpxj.LocalTimeRange;
import org.mpxj.Location;
import org.mpxj.Notes;
import org.mpxj.NotesTopic;
import org.mpxj.ParentNotes;
import org.mpxj.PercentCompleteType;
import org.mpxj.ProjectCalendar;
import org.mpxj.ProjectCalendarException;
import org.mpxj.ProjectCode;
import org.mpxj.ProjectCodeValue;
import org.mpxj.ProjectFile;
import org.mpxj.ProjectProperties;
import org.mpxj.Rate;
import org.mpxj.Relation;
import org.mpxj.Resource;
import org.mpxj.ResourceAssignment;
import org.mpxj.ResourceAssignmentCode;
import org.mpxj.ResourceAssignmentCodeValue;
import org.mpxj.ResourceCode;
import org.mpxj.ResourceCodeValue;
import org.mpxj.RoleCode;
import org.mpxj.RoleCodeValue;
import org.mpxj.Shift;
import org.mpxj.ShiftPeriod;
import org.mpxj.SkillLevel;
import org.mpxj.Step;
import org.mpxj.StructuredNotes;
import org.mpxj.Task;
import org.mpxj.TaskField;
import org.mpxj.TaskType;
import org.mpxj.TimeUnit;
import org.mpxj.UnitOfMeasure;
import org.mpxj.UserDefinedField;
import org.mpxj.WorkContour;
import org.mpxj.common.BooleanHelper;
import org.mpxj.common.ColorHelper;
import org.mpxj.common.DayOfWeekHelper;
import org.mpxj.common.FieldTypeHelper;
import org.mpxj.common.HtmlHelper;
import org.mpxj.common.LocalDateTimeHelper;
import org.mpxj.common.NumberHelper;
import org.mpxj.common.ObjectSequence;
import org.mpxj.common.RateHelper;
import org.mpxj.primavera.AccrueTypeHelper;
import org.mpxj.primavera.ActivityCodeScopeHelper;
import org.mpxj.primavera.ActivityStatusHelper;
import org.mpxj.primavera.ActivityTypeHelper;
import org.mpxj.primavera.CalendarTypeHelper;
import org.mpxj.primavera.ConstraintTypeHelper;
import org.mpxj.primavera.CriticalActivityTypeHelper;
import org.mpxj.primavera.CurveHelper;
import org.mpxj.primavera.DatatypeConverter;
import org.mpxj.primavera.FieldTypeClassHelper;
import org.mpxj.primavera.PercentCompleteTypeHelper;
import org.mpxj.primavera.PmxmlUnitsHelper;
import org.mpxj.primavera.PrimaveraPMObjectSequences;
import org.mpxj.primavera.PriorityHelper;
import org.mpxj.primavera.ProjectCalendarHelper;
import org.mpxj.primavera.RateSourceHelper;
import org.mpxj.primavera.RateTypeHelper;
import org.mpxj.primavera.RelationTypeHelper;
import org.mpxj.primavera.RelationshipLagCalendarHelper;
import org.mpxj.primavera.ResourceTypeHelper;
import org.mpxj.primavera.SchedulingProgressedActivitiesHelper;
import org.mpxj.primavera.SkillLevelHelper;
import org.mpxj.primavera.TaskHelper;
import org.mpxj.primavera.TaskTypeHelper;
import org.mpxj.primavera.TimephasedHelper;
import org.mpxj.primavera.TotalSlackCalculationTypeHelper;
import org.mpxj.primavera.UdfHelper;
import org.mpxj.primavera.WorkHelper;
import org.mpxj.primavera.WriterHelper;
import org.mpxj.primavera.schema.APIBusinessObjects;
import org.mpxj.primavera.schema.ActivityCodeType;
import org.mpxj.primavera.schema.ActivityCodeTypeType;
import org.mpxj.primavera.schema.ActivityExpenseType;
import org.mpxj.primavera.schema.ActivityNoteType;
import org.mpxj.primavera.schema.ActivityStepType;
import org.mpxj.primavera.schema.ActivityType;
import org.mpxj.primavera.schema.BaselineProjectType;
import org.mpxj.primavera.schema.CalendarType;
import org.mpxj.primavera.schema.CodeAssignmentType;
import org.mpxj.primavera.schema.CostAccountType;
import org.mpxj.primavera.schema.CurrencyType;
import org.mpxj.primavera.schema.ExpenseCategoryType;
import org.mpxj.primavera.schema.LocationType;
import org.mpxj.primavera.schema.NotebookTopicType;
import org.mpxj.primavera.schema.ObjectFactory;
import org.mpxj.primavera.schema.ProjectCodeType;
import org.mpxj.primavera.schema.ProjectCodeTypeType;
import org.mpxj.primavera.schema.ProjectNoteType;
import org.mpxj.primavera.schema.ProjectType;
import org.mpxj.primavera.schema.RelationshipType;
import org.mpxj.primavera.schema.ResourceAssignmentCodeType;
import org.mpxj.primavera.schema.ResourceAssignmentCodeTypeType;
import org.mpxj.primavera.schema.ResourceAssignmentType;
import org.mpxj.primavera.schema.ResourceCodeType;
import org.mpxj.primavera.schema.ResourceCodeTypeType;
import org.mpxj.primavera.schema.ResourceCurveType;
import org.mpxj.primavera.schema.ResourceCurveValuesType;
import org.mpxj.primavera.schema.ResourceRateType;
import org.mpxj.primavera.schema.ResourceRoleType;
import org.mpxj.primavera.schema.ResourceType;
import org.mpxj.primavera.schema.RoleCodeType;
import org.mpxj.primavera.schema.RoleCodeTypeType;
import org.mpxj.primavera.schema.RoleRateType;
import org.mpxj.primavera.schema.RoleType;
import org.mpxj.primavera.schema.ScheduleOptionsType;
import org.mpxj.primavera.schema.ShiftPeriodType;
import org.mpxj.primavera.schema.ShiftType;
import org.mpxj.primavera.schema.UDFAssignmentType;
import org.mpxj.primavera.schema.UDFTypeType;
import org.mpxj.primavera.schema.UnitOfMeasureType;
import org.mpxj.primavera.schema.WBSType;
import org.mpxj.primavera.schema.WorkTimeType;

final class PrimaveraPMProjectWriter {
    private static final String DEFAULT_PROJECT_ID = "PROJECT";
    private static final Integer DEFAULT_CURRENCY_ID = 1;
    private static final String[] DAY_NAMES = new String[]{"Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday"};
    private final ProjectFile m_projectFile;
    private final APIBusinessObjects m_apibo;
    private final Integer m_projectObjectID;
    private final PrimaveraPMObjectSequences m_sequences;
    private ObjectFactory m_factory;
    private List<WBSType> m_wbs;
    private List<ActivityType> m_activities;
    private List<ActivityStepType> m_activitySteps;
    private List<ResourceAssignmentType> m_assignments;
    private List<RelationshipType> m_relationships;
    private List<ActivityExpenseType> m_expenses;
    private List<ProjectNoteType> m_projectNotes;
    private List<ActivityNoteType> m_activityNotes;
    private List<UDFAssignmentType> m_udf;
    private ObjectSequence m_wbsSequence;
    private Set<FieldType> m_userDefinedFields;
    private boolean m_activityTypePopulated;
    private boolean m_projectFromPrimavera;

    public PrimaveraPMProjectWriter(APIBusinessObjects apibo, ProjectFile projectFile, Integer projectObjectID, PrimaveraPMObjectSequences sequences) {
        this.m_projectFile = projectFile;
        this.m_apibo = apibo;
        this.m_projectObjectID = projectObjectID;
        this.m_sequences = sequences;
    }

    public void writeProject() {
        this.write(false);
    }

    public void writeBaseline() {
        this.write(true);
    }

    private void write(boolean baseline) {
        try {
            this.m_factory = new ObjectFactory();
            this.m_activityTypePopulated = this.m_projectFile.getTasks().getPopulatedFields().contains(TaskField.ACTIVITY_TYPE);
            this.m_wbsSequence = new ObjectSequence(0);
            this.m_userDefinedFields = UdfHelper.getUserDefinedFieldsSet(this.m_projectFile);
            this.m_projectFromPrimavera = "Primavera".equals(this.m_projectFile.getProjectProperties().getFileApplication());
            if (baseline) {
                BaselineProjectType project = this.m_factory.createBaselineProjectType();
                this.m_apibo.getBaselineProject().add(project);
                this.m_wbs = project.getWBS();
                this.m_activities = project.getActivity();
                this.m_activitySteps = project.getActivityStep();
                this.m_assignments = project.getResourceAssignment();
                this.m_relationships = project.getRelationship();
                this.m_expenses = project.getActivityExpense();
                this.m_projectNotes = project.getProjectNote();
                this.m_activityNotes = project.getActivityNote();
                this.m_udf = project.getUDF();
                this.writeProjectProperties(project);
                this.writeCodeAssignments(this.m_projectFile.getProjectProperties().getProjectCodeValues(), project.getCode());
                this.writeActivityCodeDefinitions(project.getActivityCodeType(), project.getActivityCode());
                this.writeCalendars(project.getCalendar());
                this.writeTasks();
                this.writeAssignments();
                this.writeExpenseItems();
                this.writeActivitySteps();
            } else {
                ProjectType project = this.m_factory.createProjectType();
                this.m_apibo.getProject().add(project);
                this.m_wbs = project.getWBS();
                this.m_activities = project.getActivity();
                this.m_activitySteps = project.getActivityStep();
                this.m_assignments = project.getResourceAssignment();
                this.m_relationships = project.getRelationship();
                this.m_expenses = project.getActivityExpense();
                this.m_projectNotes = project.getProjectNote();
                this.m_activityNotes = project.getActivityNote();
                this.m_udf = project.getUDF();
                this.writeCurrencies();
                this.writeLocations();
                this.writeShifts();
                this.writeProjectProperties(project);
                this.writeUnitsOfMeasure();
                this.writeProjectCodeDefinitions();
                this.writeResourceCodeDefinitions();
                this.writeRoleCodeDefinitions();
                this.writeResourceAssignmentCodeDefinitions();
                this.writeCodeAssignments(this.m_projectFile.getProjectProperties().getProjectCodeValues(), project.getCode());
                this.writeActivityCodeDefinitions(project.getActivityCodeType(), project.getActivityCode());
                this.writeCalendars(project.getCalendar());
                this.writeUDF();
                this.writeActivityCodeDefinitions();
                this.writeUserDefinedFieldDefinitions();
                this.writeExpenseCategories();
                this.writeCostAccounts();
                this.writeResourceCurves();
                this.writeCalendars();
                this.writeResources();
                this.writeRoles();
                this.writeRoleAssignments();
                this.writeResourceRates();
                this.writeRoleRates();
                this.writeTasks();
                this.writeAssignments();
                this.writeExpenseItems();
                this.writeActivitySteps();
                this.writeTopics();
            }
        }
        finally {
            this.m_factory = null;
            this.m_wbsSequence = null;
            this.m_userDefinedFields = null;
        }
    }

    private void writeUDF() {
        this.m_udf.addAll(this.writeUserDefinedFieldAssignments(FieldTypeClass.PROJECT, false, this.m_projectFile.getProjectProperties()));
    }

    private void writeCurrencies() {
        if (this.m_projectFile.getCurrencies().isEmpty()) {
            ProjectProperties props = this.m_projectFile.getProjectProperties();
            CurrencyType currency = this.m_factory.createCurrencyType();
            this.m_apibo.getCurrency().add(currency);
            String positiveSymbol = this.getCurrencyFormat(props.getSymbolPosition());
            String negativeSymbol = "(" + positiveSymbol + ")";
            currency.setDecimalPlaces(props.getCurrencyDigits());
            currency.setDecimalSymbol(this.getSymbolName(props.getDecimalSeparator()));
            currency.setDigitGroupingSymbol(this.getSymbolName(props.getThousandsSeparator()));
            currency.setExchangeRate(1.0);
            currency.setId("CUR");
            currency.setName("Default Currency");
            currency.setNegativeSymbol(negativeSymbol);
            currency.setObjectId(DEFAULT_CURRENCY_ID);
            currency.setPositiveSymbol(positiveSymbol);
            currency.setSymbol(props.getCurrencySymbol());
            return;
        }
        for (Currency currency : this.m_projectFile.getCurrencies()) {
            CurrencyType xml = this.m_factory.createCurrencyType();
            xml.setObjectId(currency.getUniqueID());
            xml.setId(currency.getCurrencyID());
            xml.setName(currency.getName());
            xml.setSymbol(currency.getSymbol());
            xml.setExchangeRate(currency.getExchangeRate());
            xml.setDecimalSymbol(this.getSymbolName(currency.getDecimalSymbol()));
            xml.setDecimalPlaces(currency.getNumberOfDecimalPlaces());
            xml.setDigitGroupingSymbol(this.getSymbolName(currency.getDigitGroupingSymbol()));
            xml.setPositiveSymbol(currency.getPositiveCurrencyFormat());
            xml.setNegativeSymbol(currency.getNegativeCurrencyFormat());
            this.m_apibo.getCurrency().add(xml);
        }
    }

    private String getSymbolName(String s) {
        return s == null || s.isEmpty() ? null : this.getSymbolName(s.charAt(0));
    }

    private String getSymbolName(char c) {
        String result = null;
        switch (c) {
            case ',': {
                result = "Comma";
                break;
            }
            case '.': {
                result = "Period";
            }
        }
        return result;
    }

    private String getCurrencyFormat(CurrencySymbolPosition position) {
        String result;
        switch (position) {
            case AFTER: {
                result = "1.1#";
                break;
            }
            case AFTER_WITH_SPACE: {
                result = "1.1 #";
                break;
            }
            case BEFORE_WITH_SPACE: {
                result = "# 1.1";
                break;
            }
            default: {
                result = "#1.1";
            }
        }
        return result;
    }

    private void writeUserDefinedFieldDefinitions() {
        List<UDFTypeType> fields = this.m_apibo.getUDFType();
        for (FieldType type : this.m_userDefinedFields) {
            CustomField field = this.m_projectFile.getCustomFields().get(type);
            String title = field != null && field.getAlias() != null && !field.getAlias().isEmpty() ? field.getAlias() : type.getName();
            Integer uniqueID = field == null ? Integer.valueOf(FieldTypeHelper.getFieldID(type)) : field.getUniqueID();
            DataType dataType = type.getDataType();
            if (dataType == DataType.CUSTOM) {
                dataType = DataType.BINARY;
            }
            UDFTypeType udf = this.m_factory.createUDFTypeType();
            udf.setObjectId(uniqueID);
            udf.setDataType(UdfHelper.getXmlFromDataType(dataType));
            udf.setSubjectArea(FieldTypeClassHelper.getXmlFromInstance(type));
            udf.setTitle(title);
            fields.add(udf);
        }
        fields.sort(Comparator.comparing(UDFTypeType::getObjectId));
    }

    private void writeLocations() {
        List<LocationType> locations = this.m_apibo.getLocation();
        for (Location location : this.m_projectFile.getLocations()) {
            LocationType lt = this.m_factory.createLocationType();
            lt.setObjectId(location.getUniqueID());
            lt.setName(location.getName());
            lt.setAddressLine1(location.getAddressLine1());
            lt.setAddressLine2(location.getAddressLine2());
            lt.setCity(location.getCity());
            lt.setCountry(location.getCountry());
            lt.setCountryCode(location.getCountryCode());
            lt.setMunicipality(location.getMunicipality());
            lt.setPostalCode(location.getPostalCode());
            lt.setState(location.getState());
            lt.setStateCode(location.getStateCode());
            lt.setLatitude(location.getLatitude());
            lt.setLongitude(location.getLongitude());
            locations.add(lt);
        }
    }

    private void writeShifts() {
        List<ShiftType> shifts = this.m_apibo.getShift();
        for (Shift shift : this.m_projectFile.getShifts()) {
            ShiftType st = this.m_factory.createShiftType();
            st.setObjectId(shift.getUniqueID());
            st.setName(shift.getName());
            for (ShiftPeriod period : shift.getPeriods()) {
                ShiftPeriodType spt = this.m_factory.createShiftPeriodType();
                spt.setObjectId(period.getUniqueID());
                spt.setStartHour(period.getStart().getHour());
                st.getShiftPeriod().add(spt);
            }
            shifts.add(st);
        }
    }

    private void writeExpenseCategories() {
        List<ExpenseCategoryType> expenseCategories = this.m_apibo.getExpenseCategory();
        for (ExpenseCategory category : this.m_projectFile.getExpenseCategories()) {
            ExpenseCategoryType ect = this.m_factory.createExpenseCategoryType();
            ect.setObjectId(category.getUniqueID());
            ect.setName(category.getName());
            ect.setSequenceNumber(category.getSequenceNumber());
            expenseCategories.add(ect);
        }
    }

    private void writeCostAccounts() {
        List<CostAccountType> costAccounts = this.m_apibo.getCostAccount();
        this.m_projectFile.getCostAccounts().stream().sorted(Comparator.comparing(CostAccount::getUniqueID)).forEach(c -> this.writeCostAccount(costAccounts, (CostAccount)c));
    }

    private void writeCostAccount(List<CostAccountType> costAccounts, CostAccount account) {
        CostAccountType cat = this.m_factory.createCostAccountType();
        cat.setObjectId(account.getUniqueID());
        cat.setId(account.getID());
        cat.setName(account.getName());
        cat.setDescription(this.getNotes(account.getNotesObject()));
        cat.setSequenceNumber(account.getSequenceNumber());
        cat.setParentObjectId(account.getParentUniqueID());
        costAccounts.add(cat);
    }

    private void writeUnitsOfMeasure() {
        List<UnitOfMeasureType> units = this.m_apibo.getUnitOfMeasure();
        for (UnitOfMeasure uom : this.m_projectFile.getUnitsOfMeasure()) {
            UnitOfMeasureType unit = this.m_factory.createUnitOfMeasureType();
            unit.setObjectId(uom.getUniqueID());
            unit.setAbbreviation(uom.getAbbreviation());
            unit.setName(uom.getName());
            unit.setSequenceNumber(uom.getSequenceNumber());
            units.add(unit);
        }
    }

    private void writeResourceCurves() {
        List contours = this.m_projectFile.getWorkContours().stream().filter(w -> !w.isContourManual() && !w.isContourFlat()).sorted(Comparator.comparing(WorkContour::getName)).collect(Collectors.toList());
        List<ResourceCurveType> curves = this.m_apibo.getResourceCurve();
        for (WorkContour contour : contours) {
            ResourceCurveType curve = this.m_factory.createResourceCurveType();
            curves.add(curve);
            curve.setObjectId(contour.getUniqueID());
            curve.setName(contour.getName());
            ResourceCurveValuesType values = this.m_factory.createResourceCurveValuesType();
            curve.setValues(values);
            values.setValue0(contour.getCurveValues()[0]);
            values.setValue5(contour.getCurveValues()[1]);
            values.setValue10(contour.getCurveValues()[2]);
            values.setValue15(contour.getCurveValues()[3]);
            values.setValue20(contour.getCurveValues()[4]);
            values.setValue25(contour.getCurveValues()[5]);
            values.setValue30(contour.getCurveValues()[6]);
            values.setValue35(contour.getCurveValues()[7]);
            values.setValue40(contour.getCurveValues()[8]);
            values.setValue45(contour.getCurveValues()[9]);
            values.setValue50(contour.getCurveValues()[10]);
            values.setValue55(contour.getCurveValues()[11]);
            values.setValue60(contour.getCurveValues()[12]);
            values.setValue65(contour.getCurveValues()[13]);
            values.setValue70(contour.getCurveValues()[14]);
            values.setValue75(contour.getCurveValues()[15]);
            values.setValue80(contour.getCurveValues()[16]);
            values.setValue85(contour.getCurveValues()[17]);
            values.setValue90(contour.getCurveValues()[18]);
            values.setValue95(contour.getCurveValues()[19]);
            values.setValue100(contour.getCurveValues()[20]);
        }
    }

    private void writeProjectProperties(ProjectType project) {
        ProjectProperties mpxj = this.m_projectFile.getProjectProperties();
        String projectID = this.getProjectID(mpxj);
        project.setActivityDefaultActivityType(ActivityTypeHelper.getXmlFromInstance(ActivityTypeHelper.NEW_ACTIVITY_DEFAULT_TYPE));
        project.setActivityDefaultCalendarObjectId(mpxj.getDefaultCalendarUniqueID());
        project.setActivityDefaultDurationType(TaskTypeHelper.getXmlFromInstance(TaskType.FIXED_DURATION_AND_UNITS));
        project.setActivityDefaultPercentCompleteType(PercentCompleteTypeHelper.getXmlFromInstance(PercentCompleteType.DURATION));
        project.setActivityDefaultPricePerUnit(NumberHelper.DOUBLE_ZERO);
        project.setActivityIdBasedOnSelectedActivity(mpxj.getActivityIdIncrementBasedOnSelectedActivity());
        project.setActivityIdIncrement(mpxj.getActivityIdIncrement());
        project.setActivityIdPrefix(mpxj.getActivityIdPrefix());
        project.setActivityIdSuffix(mpxj.getActivityIdSuffix());
        project.setActivityPercentCompleteBasedOnActivitySteps(Boolean.FALSE);
        project.setAddActualToRemaining(Boolean.FALSE);
        project.setAllowNegativeActualUnitsFlag(Boolean.FALSE);
        project.setAssignmentDefaultDrivingFlag(Boolean.TRUE);
        project.setAssignmentDefaultRateType(RateTypeHelper.getXmlFromInstance(0));
        project.setCheckOutStatus(Boolean.FALSE);
        project.setCostQuantityRecalculateFlag(Boolean.FALSE);
        project.setCreateDate(mpxj.getCreationDate());
        project.setCriticalActivityFloatLimit(mpxj.getCriticalSlackLimit().convertUnits(TimeUnit.HOURS, mpxj).getDuration());
        project.setCriticalActivityPathType(CriticalActivityTypeHelper.getXmlFromInstance(mpxj.getCriticalActivityType()));
        project.setCurrentBaselineProjectObjectId(mpxj.getBaselineProjectUniqueID());
        project.setDateAdded(mpxj.getCreationDate());
        project.setDataDate(this.m_projectFile.getProjectProperties().getStatusDate());
        project.setDefaultPriceTimeUnits("Hour");
        project.setDiscountApplicationPeriod("Month");
        project.setEarnedValueComputeType("Activity Percent Complete");
        project.setEarnedValueETCComputeType("ETC = Remaining Cost for Activity");
        project.setEarnedValueETCUserValue(0.88);
        project.setEarnedValueUserPercent(0.06);
        project.setEnablePublication(mpxj.getEnablePublication());
        project.setEnableSummarization(mpxj.getEnableSummarization());
        project.setFiscalYearStartMonth(1);
        project.setFinishDate(mpxj.getFinishDate());
        project.setGUID(DatatypeConverter.printUUID(mpxj.getGUID()));
        project.setId(projectID);
        project.setLastUpdateDate(mpxj.getLastSaved());
        project.setLevelingPriority(10);
        project.setLinkActualToActualThisPeriod(Boolean.TRUE);
        project.setLinkPercentCompleteWithActual(Boolean.TRUE);
        project.setLinkPlannedAndAtCompletionFlag(Boolean.TRUE);
        project.setMustFinishByDate(mpxj.getMustFinishBy());
        project.setName(mpxj.getName() == null ? projectID : mpxj.getName());
        project.setObjectId(this.m_projectObjectID);
        project.setPlannedStartDate(WriterHelper.getProjectPlannedStart(mpxj));
        project.setPrimaryResourcesCanMarkActivitiesAsCompleted(Boolean.TRUE);
        project.setRelationshipLagCalendar(RelationshipLagCalendarHelper.getXmlFromInstance(mpxj.getRelationshipLagCalendar()));
        project.setResetPlannedToRemainingFlag(Boolean.FALSE);
        project.setResourceCanBeAssignedToSameActivityMoreThanOnce(Boolean.TRUE);
        project.setResourcesCanAssignThemselvesToActivities(Boolean.TRUE);
        project.setResourcesCanEditAssignmentPercentComplete(Boolean.FALSE);
        project.setResourcesCanMarkAssignmentAsCompleted(Boolean.FALSE);
        project.setResourcesCanViewInactiveActivities(Boolean.FALSE);
        project.setRiskLevel("Medium");
        project.setScheduledFinishDate(mpxj.getScheduledFinish());
        project.setStartDate(mpxj.getStartDate());
        project.setStatus("Active");
        project.setStrategicPriority(500);
        project.setSummarizeToWBSLevel(2);
        project.setSummaryLevel("Assignment Level");
        project.setUseProjectBaselineForEarnedValue(Boolean.TRUE);
        project.setWBSCodeSeparator(mpxj.getWbsCodeSeparator());
        project.setLocationObjectId(mpxj.getLocationUniqueID());
        project.setWebSiteURL(mpxj.getProjectWebsiteUrl());
        this.writeScheduleOptions(project.getScheduleOptions());
        this.writeWbsNote(null, mpxj.getNotesObject());
    }

    private void writeProjectProperties(BaselineProjectType project) {
        ProjectProperties mpxj = this.m_projectFile.getProjectProperties();
        String projectID = this.getProjectID(mpxj);
        project.setActivityDefaultActivityType(ActivityTypeHelper.getXmlFromInstance(ActivityTypeHelper.NEW_ACTIVITY_DEFAULT_TYPE));
        project.setActivityDefaultCalendarObjectId(mpxj.getDefaultCalendarUniqueID());
        project.setActivityDefaultDurationType(TaskTypeHelper.getXmlFromInstance(TaskType.FIXED_DURATION_AND_UNITS));
        project.setActivityDefaultPercentCompleteType(PercentCompleteTypeHelper.getXmlFromInstance(PercentCompleteType.DURATION));
        project.setActivityDefaultPricePerUnit(NumberHelper.DOUBLE_ZERO);
        project.setActivityIdBasedOnSelectedActivity(mpxj.getActivityIdIncrementBasedOnSelectedActivity());
        project.setActivityIdIncrement(mpxj.getActivityIdIncrement());
        project.setActivityIdPrefix(mpxj.getActivityIdPrefix());
        project.setActivityIdSuffix(mpxj.getActivityIdSuffix());
        project.setActivityPercentCompleteBasedOnActivitySteps(Boolean.FALSE);
        project.setAddActualToRemaining(Boolean.FALSE);
        project.setAssignmentDefaultDrivingFlag(Boolean.TRUE);
        project.setAssignmentDefaultRateType(RateTypeHelper.getXmlFromInstance(0));
        project.setCheckOutStatus(Boolean.FALSE);
        project.setCostQuantityRecalculateFlag(Boolean.FALSE);
        project.setCreateDate(mpxj.getCreationDate());
        project.setCriticalActivityFloatLimit(mpxj.getCriticalSlackLimit().convertUnits(TimeUnit.HOURS, mpxj).getDuration());
        project.setCriticalActivityPathType(CriticalActivityTypeHelper.getXmlFromInstance(mpxj.getCriticalActivityType()));
        project.setDateAdded(mpxj.getCreationDate());
        project.setDataDate(this.m_projectFile.getProjectProperties().getStatusDate());
        project.setDefaultPriceTimeUnits("Hour");
        project.setDiscountApplicationPeriod("Month");
        project.setEnablePublication(mpxj.getEnablePublication());
        project.setEnableSummarization(mpxj.getEnableSummarization());
        project.setFiscalYearStartMonth(1);
        project.setFinishDate(mpxj.getFinishDate());
        project.setGUID(DatatypeConverter.printUUID(mpxj.getGUID()));
        project.setId(projectID);
        project.setLastUpdateDate(mpxj.getLastSaved());
        project.setLevelingPriority(10);
        project.setLinkActualToActualThisPeriod(Boolean.TRUE);
        project.setLinkPercentCompleteWithActual(Boolean.TRUE);
        project.setLinkPlannedAndAtCompletionFlag(Boolean.TRUE);
        project.setMustFinishByDate(mpxj.getMustFinishBy());
        project.setName(mpxj.getName() == null ? projectID : mpxj.getName());
        project.setObjectId(this.m_projectObjectID);
        project.setPlannedStartDate(WriterHelper.getProjectPlannedStart(mpxj));
        project.setPrimaryResourcesCanMarkActivitiesAsCompleted(Boolean.TRUE);
        project.setResetPlannedToRemainingFlag(Boolean.FALSE);
        project.setResourceCanBeAssignedToSameActivityMoreThanOnce(Boolean.TRUE);
        project.setResourcesCanAssignThemselvesToActivities(Boolean.TRUE);
        project.setResourcesCanEditAssignmentPercentComplete(Boolean.FALSE);
        project.setRiskLevel("Medium");
        project.setStartDate(mpxj.getStartDate());
        project.setStatus("Active");
        project.setStrategicPriority(500);
        project.setSummarizeToWBSLevel(2);
        project.setWBSCodeSeparator(mpxj.getWbsCodeSeparator());
        project.setLocationObjectId(mpxj.getLocationUniqueID());
        project.setBaselineTypeName(mpxj.getBaselineTypeName());
        project.setBaselineTypeObjectId(mpxj.getBaselineProjectUniqueID());
        project.setLastBaselineUpdateDate(mpxj.getLastBaselineUpdateDate());
        project.setWebSiteURL(mpxj.getProjectWebsiteUrl());
        this.writeScheduleOptions(project.getScheduleOptions());
        this.writeWbsNote(null, mpxj.getNotesObject());
    }

    private void writeScheduleOptions(List<ScheduleOptionsType> list) {
        ScheduleOptionsType options = this.m_factory.createScheduleOptionsType();
        options.setProjectObjectId(this.m_projectObjectID);
        list.add(options);
        ProjectProperties projectProperties = this.m_projectFile.getProjectProperties();
        options.setIncludeExternalResAss(projectProperties.getConsiderAssignmentsInOtherProjects());
        options.setExternalProjectPriorityLimit(projectProperties.getConsiderAssignmentsInOtherProjectsWithPriorityEqualHigherThan());
        options.setPreserveScheduledEarlyAndLateDates(projectProperties.getPreserveScheduledEarlyAndLateDates());
        options.setLevelAllResources(projectProperties.getLevelAllResources());
        options.setLevelWithinFloat(projectProperties.getLevelResourcesOnlyWithinActivityTotalFloat());
        options.setMinFloatToPreserve((int)projectProperties.getPreserveMinimumFloatWhenLeveling().convertUnits(TimeUnit.HOURS, projectProperties).getDuration());
        options.setOverAllocationPercentage(this.getDouble(projectProperties.getMaxPercentToOverallocateResources()));
        options.setPriorityList("(0||priority_type(sort_type|ASC)())");
        options.setIgnoreOtherProjectRelationships(projectProperties.getIgnoreRelationshipsToAndFromOtherProjects());
        options.setMakeOpenEndedActivitiesCritical(projectProperties.getMakeOpenEndedActivitiesCritical());
        options.setUseExpectedFinishDates(projectProperties.getUseExpectedFinishDates());
        options.setStartToStartLagCalculationType(projectProperties.getComputeStartToStartLagFromEarlyStart());
        options.setOutOfSequenceScheduleType(SchedulingProgressedActivitiesHelper.getXmlFromInstance(projectProperties.getSchedulingProgressedActivities()));
        options.setCalculateFloatBasedOnFinishDate(projectProperties.getCalculateFloatBasedOnFinishDateOfEachProject());
        options.setRelationshipLagCalendar(RelationshipLagCalendarHelper.getXmlFromInstance(projectProperties.getRelationshipLagCalendar()));
        options.setComputeTotalFloatType(TotalSlackCalculationTypeHelper.getXmlFromInstance(projectProperties.getTotalSlackCalculationType()));
        options.setCriticalActivityFloatThreshold(projectProperties.getCriticalSlackLimit().convertUnits(TimeUnit.HOURS, projectProperties).getDuration());
        options.setCriticalActivityPathType(CriticalActivityTypeHelper.getXmlFromInstance(projectProperties.getCriticalActivityType()));
        options.setMultipleFloatPathsEnabled(projectProperties.getCalculateMultipleFloatPaths());
        options.setMultipleFloatPathsUseTotalFloat(projectProperties.getCalculateMultipleFloatPathsUsingTotalFloat());
        options.setMultipleFloatPathsEndingActivityObjectId(projectProperties.getDisplayMultipleFloatPathsEndingWithActivityUniqueID());
        options.setMaximumMultipleFloatPaths(projectProperties.getMaximumNumberOfFloatPathsToCalculate());
    }

    private String getProjectID(ProjectProperties mpxj) {
        String result = mpxj.getProjectID();
        if (result == null) {
            int id = this.m_sequences.getProjectID();
            result = id == 0 ? DEFAULT_PROJECT_ID : "PROJECT-" + id;
        }
        return result;
    }

    private void writeCalendars() {
        List<CalendarType> calendars = this.m_apibo.getCalendar();
        this.m_projectFile.getCalendars().stream().filter(c -> c.getType() != org.mpxj.CalendarType.PROJECT).forEach(c -> this.writeCalendar(calendars, (ProjectCalendar)c));
    }

    private void writeCalendars(List<CalendarType> calendars) {
        this.m_projectFile.getCalendars().stream().filter(c -> c.getType() == org.mpxj.CalendarType.PROJECT).forEach(c -> this.writeCalendar(calendars, (ProjectCalendar)c));
    }

    private void writeCalendar(List<CalendarType> calendars, ProjectCalendar calendar) {
        ProjectCalendar mpxj = ProjectCalendarHelper.normalizeCalendar(calendar);
        CalendarType xml = this.m_factory.createCalendarType();
        calendars.add(xml);
        String name = mpxj.getName();
        if (name == null || name.isEmpty()) {
            name = "(blank)";
        }
        if (calendar.getType() == org.mpxj.CalendarType.PROJECT) {
            xml.setProjectObjectId(this.m_projectObjectID);
        }
        xml.setBaseCalendarObjectId(mpxj.getParentUniqueID());
        xml.setIsDefault(mpxj == this.m_projectFile.getDefaultCalendar());
        xml.setIsPersonal(mpxj.getPersonal());
        xml.setName(name);
        xml.setObjectId(mpxj.getUniqueID());
        xml.setType(CalendarTypeHelper.getXmlFromInstance(mpxj.getType()));
        xml.setHoursPerDay(NumberHelper.getDouble(mpxj.getMinutesPerDay()) / 60.0);
        xml.setHoursPerWeek(NumberHelper.getDouble(mpxj.getMinutesPerWeek()) / 60.0);
        xml.setHoursPerMonth(NumberHelper.getDouble(mpxj.getMinutesPerMonth()) / 60.0);
        xml.setHoursPerYear(NumberHelper.getDouble(mpxj.getMinutesPerYear()) / 60.0);
        CalendarType.StandardWorkWeek xmlStandardWorkWeek = this.m_factory.createCalendarTypeStandardWorkWeek();
        xml.setStandardWorkWeek(xmlStandardWorkWeek);
        for (DayOfWeek day : DayOfWeekHelper.ORDERED_DAYS) {
            CalendarType.StandardWorkWeek.StandardWorkHours xmlHours = this.m_factory.createCalendarTypeStandardWorkWeekStandardWorkHours();
            xmlStandardWorkWeek.getStandardWorkHours().add(xmlHours);
            xmlHours.setDayOfWeek(this.getDayName(day));
            for (LocalTimeRange range : mpxj.getHours(day)) {
                WorkTimeType xmlWorkTime = this.m_factory.createWorkTimeType();
                xmlHours.getWorkTime().add(xmlWorkTime);
                xmlWorkTime.setStart(range.getStart());
                xmlWorkTime.setFinish(this.getEndTime(range.getEnd()));
            }
        }
        CalendarType.HolidayOrExceptions xmlExceptions = this.m_factory.createCalendarTypeHolidayOrExceptions();
        xml.setHolidayOrExceptions(xmlExceptions);
        List<ProjectCalendarException> expandedExceptions = mpxj.getExpandedCalendarExceptionsWithWorkWeeks();
        if (!expandedExceptions.isEmpty()) {
            HashSet<LocalDate> exceptionDates = new HashSet<LocalDate>();
            for (ProjectCalendarException mpxjException : expandedExceptions) {
                LocalDate date = mpxjException.getFromDate();
                while (!date.isAfter(mpxjException.getToDate())) {
                    if (exceptionDates.add(date)) {
                        CalendarType.HolidayOrExceptions.HolidayOrException xmlException = this.m_factory.createCalendarTypeHolidayOrExceptionsHolidayOrException();
                        xmlExceptions.getHolidayOrException().add(xmlException);
                        xmlException.setDate(date.atStartOfDay());
                        for (LocalTimeRange range : mpxjException) {
                            WorkTimeType xmlHours = this.m_factory.createWorkTimeType();
                            xmlException.getWorkTime().add(xmlHours);
                            xmlHours.setStart(range.getStart());
                            if (range.getEnd() == null) continue;
                            xmlHours.setFinish(this.getEndTime(range.getEnd()));
                        }
                    }
                    date = date.plusDays(1L);
                }
            }
        }
    }

    private void writeResources() {
        this.m_projectFile.getResources().stream().filter(r -> !r.getRole() && r.getUniqueID() != 0).forEach(this::writeResource);
    }

    private void writeResource(Resource mpxj) {
        ResourceType xml = this.m_factory.createResourceType();
        this.m_apibo.getResource().add(xml);
        String name = mpxj.getName();
        if (name == null || name.isEmpty()) {
            name = "(blank)";
        }
        Double defaultUnitsPerTime = mpxj.getDefaultUnits() == null ? NumberHelper.DOUBLE_ZERO : Double.valueOf(mpxj.getDefaultUnits().doubleValue() / 100.0);
        xml.setAutoComputeActuals(Boolean.TRUE);
        xml.setCalculateCostFromUnits(mpxj.getCalculateCostsFromUnits());
        xml.setCalendarObjectId(mpxj.getCalendarUniqueID());
        xml.setCurrencyObjectId(mpxj.getCurrencyUniqueID() == null ? DEFAULT_CURRENCY_ID : mpxj.getCurrencyUniqueID());
        xml.setEmailAddress(mpxj.getEmailAddress());
        xml.setEmployeeId(mpxj.getCode());
        xml.setGUID(DatatypeConverter.printUUID(mpxj.getGUID()));
        xml.setId(WriterHelper.getResourceID(mpxj));
        xml.setIsActive(mpxj.getActive());
        xml.setName(name);
        xml.setObjectId(mpxj.getUniqueID());
        xml.setParentObjectId(mpxj.getParentResourceUniqueID());
        xml.setResourceNotes(this.getNotes(mpxj.getNotesObject()));
        xml.setResourceType(ResourceTypeHelper.getXmlFromInstance(mpxj.getType()));
        xml.setSequenceNumber(mpxj.getSequenceNumber());
        xml.setLocationObjectId(mpxj.getLocationUniqueID());
        xml.setUnitOfMeasureObjectId(mpxj.getUnitOfMeasureUniqueID());
        xml.setShiftObjectId(mpxj.getShiftUniqueID());
        xml.setPrimaryRoleObjectId(mpxj.getPrimaryRoleUniqueID());
        xml.setDefaultUnitsPerTime(defaultUnitsPerTime);
        xml.setMaxUnitsPerTime(defaultUnitsPerTime);
        xml.getUDF().addAll(this.writeUserDefinedFieldAssignments(FieldTypeClass.RESOURCE, false, mpxj));
        this.writeCodeAssignments(mpxj.getResourceCodeValues(), xml.getCode());
    }

    private void writeRoles() {
        this.m_projectFile.getResources().stream().filter(r -> r.getRole() && r.getUniqueID() != 0).forEach(this::writeRole);
    }

    private void writeRole(Resource mpxj) {
        RoleType xml = this.m_factory.createRoleType();
        this.m_apibo.getRole().add(xml);
        xml.setObjectId(mpxj.getUniqueID());
        xml.setName(mpxj.getName());
        xml.setId(WriterHelper.getRoleID(mpxj));
        xml.setCalculateCostFromUnits(mpxj.getCalculateCostsFromUnits());
        xml.setResponsibilities(this.getNotes(mpxj.getNotesObject()));
        xml.setSequenceNumber(mpxj.getSequenceNumber());
        this.writeCodeAssignments(mpxj.getRoleCodeValues(), xml.getCode());
    }

    private void writeRoleAssignments() {
        this.m_projectFile.getResources().stream().filter(r -> !r.getRole() && r.getUniqueID() != 0).sorted(Comparator.comparing(Resource::getUniqueID)).forEach(this::writeRoleAssignments);
    }

    private void writeRoleAssignments(Resource resource) {
        for (Map.Entry entry : resource.getRoleAssignments().entrySet().stream().sorted(Comparator.comparing(e -> ((Resource)e.getKey()).getUniqueID())).collect(Collectors.toList())) {
            ResourceRoleType assignment = this.m_factory.createResourceRoleType();
            this.m_apibo.getResourceRole().add(assignment);
            assignment.setResourceObjectId(resource.getUniqueID());
            assignment.setRoleObjectId(((Resource)entry.getKey()).getUniqueID());
            assignment.setProficiency(SkillLevelHelper.getXmlFromInstance((SkillLevel)((Object)entry.getValue())));
        }
    }

    private String getNotes(Notes notes) {
        String result = notes == null || notes.isEmpty() ? "" : (notes instanceof HtmlNotes ? ((HtmlNotes)notes).getHtml() : HtmlHelper.getHtmlFromPlainText(notes.toString()));
        return result;
    }

    private void writeTasks() {
        Map<Task, Integer> wbsSequence = this.m_projectFile.getTasks().stream().filter(t -> t.getSummary() || this.m_activityTypePopulated && t.getActivityType() == null).collect(Collectors.toMap(t -> t, t -> t.getSequenceNumber() == null ? this.m_wbsSequence.getNext() : t.getSequenceNumber()));
        ArrayList<Task> tasks = new ArrayList<Task>(this.m_projectFile.getTasks());
        tasks.sort((t1, t2) -> NumberHelper.compare(t1.getUniqueID(), t2.getUniqueID()));
        tasks.forEach(t -> this.writeTask((Task)t, (Integer)wbsSequence.get(t)));
    }

    private void writeTask(Task task, Integer wbsSequence) {
        if (!task.getNull() && task.getUniqueID() != 0) {
            if (wbsSequence != null) {
                this.writeWBS(task, wbsSequence);
            } else {
                this.writeActivity(task);
            }
        }
    }

    private void writeWBS(Task mpxj, Integer sequence) {
        WBSType xml = this.m_factory.createWBSType();
        this.m_wbs.add(xml);
        String name = mpxj.getName();
        if (name == null || name.isEmpty()) {
            name = "(blank)";
        }
        xml.setCode(TaskHelper.getWbsCode(mpxj));
        xml.setGUID(DatatypeConverter.printUUID(mpxj.getGUID()));
        xml.setName(name);
        xml.setObjectId(mpxj.getUniqueID());
        xml.setParentObjectId(mpxj.getParentTaskUniqueID());
        xml.setProjectObjectId(this.m_projectObjectID);
        xml.setSequenceNumber(sequence);
        xml.setStatus("Active");
        xml.getUDF().addAll(this.writeUserDefinedFieldAssignments(FieldTypeClass.TASK, true, mpxj));
        this.writeWbsNote(mpxj.getUniqueID(), mpxj.getNotesObject());
    }

    private void writeActivity(Task mpxj) {
        String name;
        ActivityType xml = this.m_factory.createActivityType();
        this.m_activities.add(xml);
        Integer parentTaskUniqueID = mpxj.getParentTaskUniqueID();
        Integer parentObjectID = null;
        if (parentTaskUniqueID != null && parentTaskUniqueID != 0) {
            parentObjectID = parentTaskUniqueID;
        }
        if ((name = mpxj.getName()) == null || name.isEmpty()) {
            name = "(blank)";
        }
        LocalDateTime plannedStart = mpxj.getPlannedStart() == null ? mpxj.getStart() : mpxj.getPlannedStart();
        LocalDateTime plannedFinish = mpxj.getPlannedFinish() == null ? mpxj.getFinish() : mpxj.getPlannedFinish();
        ProjectCalendar effectiveCalendar = mpxj.getEffectiveCalendar();
        xml.setActualStartDate(mpxj.getActualStart());
        xml.setActualDuration(this.getDurationInHours(mpxj.getActualDuration()));
        xml.setActualFinishDate(mpxj.getActualFinish());
        xml.setActualLaborUnits(this.getDurationInHours(WorkHelper.getActualWorkLabor(mpxj)));
        xml.setActualNonLaborUnits(this.getDurationInHours(WorkHelper.zeroIfNull(mpxj.getActualWorkNonlabor())));
        xml.setAtCompletionDuration(this.getDurationInHours(mpxj.getDuration()));
        xml.setCalendarObjectId(effectiveCalendar == null ? null : effectiveCalendar.getUniqueID());
        xml.setDurationPercentComplete(this.getPercentage(mpxj.getPercentageComplete()));
        xml.setDurationType(TaskTypeHelper.getXmlFromInstance(mpxj.getType()));
        xml.setExpectedFinishDate(mpxj.getExpectedFinish());
        xml.setExternalEarlyStartDate(mpxj.getExternalEarlyStart());
        xml.setExternalLateFinishDate(mpxj.getExternalLateFinish());
        xml.setFinishDate(mpxj.getFinish());
        xml.setGUID(DatatypeConverter.printUUID(mpxj.getGUID()));
        xml.setId(WriterHelper.getActivityID(mpxj));
        xml.setIsLongestPath(mpxj.getLongestPath() ? Boolean.TRUE : null);
        xml.setLevelingPriority(PriorityHelper.getXmlFromInstance(mpxj.getPriority()));
        xml.setLocationObjectId(mpxj.getLocationUniqueID());
        xml.setName(name);
        xml.setObjectId(mpxj.getUniqueID());
        xml.setPercentCompleteType(PercentCompleteTypeHelper.getXmlFromInstance(mpxj.getPercentCompleteType()));
        xml.setPercentComplete(this.getPercentComplete(mpxj));
        xml.setPhysicalPercentComplete(this.getPercentage(mpxj.getPhysicalPercentComplete()));
        xml.setPlannedLaborUnits(this.getDurationInHours(WorkHelper.getPlannedWorkLabor(mpxj)));
        xml.setPlannedNonLaborUnits(this.getDurationInHours(WorkHelper.zeroIfNull(mpxj.getPlannedWorkNonlabor())));
        xml.setPrimaryConstraintType(ConstraintTypeHelper.getXmlFromInstance(mpxj.getConstraintType()));
        xml.setPrimaryConstraintDate(mpxj.getConstraintDate());
        xml.setPrimaryResourceObjectId(mpxj.getPrimaryResourceUniqueID());
        xml.setPlannedDuration(this.getDurationInHours(mpxj.getPlannedDuration() == null ? mpxj.getDuration() : mpxj.getPlannedDuration()));
        xml.setPlannedFinishDate(plannedFinish);
        xml.setPlannedStartDate(plannedStart);
        xml.setProjectObjectId(this.m_projectObjectID);
        xml.setRemainingDuration(this.getDurationInHours(mpxj.getRemainingDuration()));
        xml.setRemainingEarlyFinishDate(mpxj.getRemainingEarlyFinish());
        xml.setRemainingEarlyStartDate(mpxj.getRemainingEarlyStart());
        xml.setRemainingLateFinishDate(mpxj.getRemainingLateFinish());
        xml.setRemainingLateStartDate(mpxj.getRemainingLateStart());
        xml.setRemainingLaborCost(NumberHelper.DOUBLE_ZERO);
        xml.setRemainingNonLaborCost(NumberHelper.DOUBLE_ZERO);
        xml.setRemainingLaborUnits(this.getDurationInHours(WorkHelper.getRemainingWorkLabor(mpxj)));
        xml.setRemainingNonLaborUnits(this.getDurationInHours(WorkHelper.zeroIfNull(mpxj.getRemainingWorkNonlabor())));
        if (mpxj.getSuspendDate() != null) {
            xml.setResumeDate(mpxj.getResume());
        }
        xml.setSecondaryConstraintDate(mpxj.getSecondaryConstraintDate());
        xml.setSecondaryConstraintType(ConstraintTypeHelper.getXmlFromInstance(mpxj.getSecondaryConstraintType()));
        xml.setStartDate(mpxj.getStart());
        xml.setStatus(ActivityStatusHelper.getXmlFromInstance(ActivityStatusHelper.getActivityStatus(mpxj)));
        xml.setSuspendDate(mpxj.getSuspendDate());
        xml.setType(ActivityTypeHelper.getXmlFromInstance(mpxj.getActivityType()));
        xml.setUnitsPercentComplete(this.getPercentage(mpxj.getPercentageWorkComplete()));
        xml.setWBSObjectId(parentObjectID);
        xml.getUDF().addAll(this.writeUserDefinedFieldAssignments(FieldTypeClass.TASK, false, mpxj));
        this.writeActivityNote(mpxj);
        this.writePredecessors(mpxj);
        this.writeCodeAssignments(mpxj.getActivityCodeValues(), xml.getCode());
    }

    private void writeAssignments() {
        ArrayList assignments = new ArrayList();
        this.m_projectFile.getTasks().forEach(t -> assignments.addAll(t.getResourceAssignments()));
        assignments.stream().filter(WriterHelper::isValidAssignment).forEach(this::writeAssignment);
    }

    private void writeAssignment(ResourceAssignment mpxj) {
        Double unitsPercentComplete;
        ResourceAssignmentType xml = this.m_factory.createResourceAssignmentType();
        this.m_assignments.add(xml);
        Task task = mpxj.getTask();
        Double actualOvertimeUnits = Optional.ofNullable(this.getDurationInHours(mpxj.getActualOvertimeWork())).orElse(NumberHelper.DOUBLE_ZERO);
        LocalDateTime plannedStart = Optional.ofNullable(mpxj.getPlannedStart()).orElseGet(mpxj::getStart);
        plannedStart = Optional.ofNullable(plannedStart).orElseGet(task::getStart);
        LocalDateTime plannedFinish = Optional.ofNullable(mpxj.getPlannedFinish()).orElseGet(mpxj::getFinish);
        plannedFinish = Optional.ofNullable(plannedFinish).orElseGet(task::getFinish);
        plannedFinish = Optional.ofNullable(plannedFinish).orElse(plannedStart);
        Double actualWork = this.getDurationInHours(mpxj.getActualWork());
        Double atCompletionWork = this.getDurationInHours(Duration.add(mpxj.getActualWork(), mpxj.getRemainingWork(), mpxj.getEffectiveCalendar()));
        Double d = unitsPercentComplete = NumberHelper.getDouble(atCompletionWork) == 0.0 || NumberHelper.getDouble(actualWork) == 0.0 ? null : Double.valueOf(actualWork / atCompletionWork);
        if (mpxj.getResource().getRole()) {
            xml.setRoleObjectId(mpxj.getResourceUniqueID());
        } else {
            xml.setResourceObjectId(mpxj.getResourceUniqueID());
            xml.setRoleObjectId(mpxj.getRoleUniqueID());
        }
        xml.setActivityObjectId(mpxj.getTaskUniqueID());
        xml.setActualCost(this.getCurrency(mpxj.getActualCost()));
        xml.setActualFinishDate(mpxj.getActualFinish());
        xml.setActualOvertimeCost(this.getCurrency(mpxj.getActualOvertimeCost()));
        xml.setActualOvertimeUnits(actualOvertimeUnits);
        xml.setActualRegularUnits(this.getDurationInHours(mpxj.getActualWork()));
        xml.setActualStartDate(mpxj.getActualStart());
        xml.setActualUnits(actualWork);
        xml.setAtCompletionCost(this.getCurrency(NumberHelper.sumAsDouble(mpxj.getActualCost(), mpxj.getRemainingCost())));
        xml.setAtCompletionUnits(atCompletionWork);
        xml.setResourceCurveObjectId(CurveHelper.getCurveID(mpxj.getWorkContour()));
        xml.setFinishDate(mpxj.getFinish());
        xml.setGUID(DatatypeConverter.printUUID(mpxj.getGUID()));
        xml.setIsCostUnitsLinked(mpxj.getCalculateCostsFromUnits());
        xml.setObjectId(mpxj.getUniqueID());
        xml.setPlannedCost(this.getCurrency(mpxj.getPlannedCost()));
        xml.setPlannedFinishDate(plannedFinish);
        xml.setPlannedStartDate(plannedStart);
        xml.setProjectObjectId(this.m_projectObjectID);
        xml.setRemainingCost(this.getCurrency(mpxj.getRemainingCost()));
        xml.setStartDate(mpxj.getStart());
        xml.setWBSObjectId(task.getParentTaskUniqueID());
        xml.getUDF().addAll(this.writeUserDefinedFieldAssignments(FieldTypeClass.ASSIGNMENT, false, mpxj));
        xml.setRateType(RateTypeHelper.getXmlFromInstance(mpxj.getRateIndex()));
        xml.setCostPerQuantity(this.writeRate(mpxj.getOverrideRate()));
        xml.setRateSource(RateSourceHelper.getXmlFromInstance(mpxj.getRateSource()));
        xml.setCostAccountObjectId(mpxj.getCostAccountUniqueID());
        xml.setRemainingStartDate(mpxj.getRemainingEarlyStart());
        xml.setRemainingFinishDate(mpxj.getRemainingEarlyFinish());
        xml.setResourceType(ResourceTypeHelper.getXmlFromInstance(mpxj.getResource().getType()));
        PmxmlUnitsHelper unitsHelper = new PmxmlUnitsHelper(mpxj);
        xml.setPlannedUnits(unitsHelper.getPlannedUnits());
        xml.setPlannedUnitsPerTime(unitsHelper.getPlannedUnitsPerTime());
        xml.setRemainingUnits(unitsHelper.getRemainingUnits());
        xml.setRemainingUnitsPerTime(unitsHelper.getRemainingUnitsPerTime());
        xml.setRemainingDuration(this.getResourceAssignmentRemainingDuration(task, mpxj));
        xml.setUnitsPercentComplete(unitsPercentComplete);
        if (this.m_projectFromPrimavera) {
            ProjectCalendar calendar = task.getEffectiveCalendar();
            xml.setPlannedCurve(TimephasedHelper.write(calendar, mpxj.getTimephasedPlannedWork()));
            xml.setActualCurve(TimephasedHelper.write(calendar, mpxj.getTimephasedActualWork()));
            xml.setRemainingCurve(TimephasedHelper.write(calendar, mpxj.getTimephasedWork()));
        }
        this.writeCodeAssignments(mpxj.getResourceAssignmentCodeValues(), xml.getCode());
    }

    private Double getResourceAssignmentRemainingDuration(Task task, ResourceAssignment mpxj) {
        if (mpxj.getActualFinish() != null) {
            return 0.0;
        }
        if (mpxj.getRemainingUnits() == null || mpxj.getRemainingWork() == null || mpxj.getRemainingUnits().doubleValue() == 0.0) {
            return this.getDurationInHours(task.getEffectiveCalendar().getWork(mpxj.getRemainingEarlyStart(), mpxj.getRemainingEarlyFinish(), TimeUnit.HOURS));
        }
        double workPerHour = mpxj.getRemainingUnits().doubleValue();
        double remainingWork = mpxj.getRemainingWork().getDuration();
        return remainingWork * 100.0 / workPerHour;
    }

    private void writePredecessors(Task task) {
        List<Relation> relations = task.getPredecessors();
        for (Relation mpxj : relations) {
            RelationshipType xml = this.m_factory.createRelationshipType();
            this.m_relationships.add(xml);
            xml.setLag(this.getDurationInHours(mpxj.getLag()));
            xml.setObjectId(mpxj.getUniqueID());
            xml.setPredecessorActivityObjectId(mpxj.getPredecessorTask().getUniqueID());
            xml.setSuccessorActivityObjectId(mpxj.getSuccessorTask().getUniqueID());
            xml.setPredecessorProjectObjectId(this.m_projectObjectID);
            xml.setSuccessorProjectObjectId(this.m_projectObjectID);
            xml.setType(RelationTypeHelper.getXmlFromInstance(mpxj.getType()));
            xml.setComments(mpxj.getNotes());
        }
    }

    private void writeExpenseItems() {
        ArrayList<Task> tasks = new ArrayList<Task>(this.m_projectFile.getTasks());
        tasks.sort((t1, t2) -> NumberHelper.compare(t1.getUniqueID(), t2.getUniqueID()));
        tasks.forEach(this::writeExpenseItems);
    }

    private void writeExpenseItems(Task task) {
        List<ExpenseItem> items = task.getExpenseItems();
        if (items.isEmpty()) {
            return;
        }
        ArrayList<ExpenseItem> expenseItems = new ArrayList<ExpenseItem>(items);
        expenseItems.sort((i1, i2) -> NumberHelper.compare(i1.getUniqueID(), i2.getUniqueID()));
        for (ExpenseItem item : expenseItems) {
            ActivityExpenseType expense = this.m_factory.createActivityExpenseType();
            this.m_expenses.add(expense);
            Double pricePerUnit = Optional.ofNullable(item.getPricePerUnit()).orElse(NumberHelper.DOUBLE_ZERO);
            expense.setAccrualType(AccrueTypeHelper.getXmlFromInstance(item.getAccrueType()));
            expense.setActivityObjectId(task.getUniqueID());
            expense.setActualCost(this.getCurrency(item.getActualCost()));
            expense.setActualUnits(item.getActualUnits());
            expense.setAutoComputeActuals(item.getAutoComputeActuals());
            expense.setCostAccountObjectId(item.getAccountUniqueID());
            expense.setDocumentNumber(item.getDocumentNumber());
            expense.setExpenseCategoryObjectId(item.getCategoryUniqueID());
            expense.setExpenseDescription(item.getDescription());
            expense.setExpenseItem(item.getName());
            expense.setObjectId(item.getUniqueID());
            expense.setPlannedCost(this.getCurrency(item.getPlannedCost()));
            expense.setPlannedUnits(item.getPlannedUnits());
            expense.setPricePerUnit(pricePerUnit);
            expense.setProjectObjectId(this.m_projectObjectID);
            expense.setRemainingCost(this.getCurrency(item.getRemainingCost()));
            expense.setRemainingUnits(item.getRemainingUnits());
            expense.setUnitOfMeasure(item.getUnitOfMeasure());
            expense.setVendor(item.getVendor());
            expense.setWBSObjectId(task.getParentTaskUniqueID());
        }
    }

    private void writeActivitySteps() {
        ArrayList<Task> tasks = new ArrayList<Task>(this.m_projectFile.getTasks());
        tasks.sort((t1, t2) -> NumberHelper.compare(t1.getUniqueID(), t2.getUniqueID()));
        tasks.forEach(this::writeActivitySteps);
    }

    private void writeActivitySteps(Task task) {
        List<Step> items = task.getSteps();
        if (items.isEmpty()) {
            return;
        }
        ArrayList<Step> steps = new ArrayList<Step>(items);
        steps.sort((i1, i2) -> NumberHelper.compare(i1.getSequenceNumber(), i2.getSequenceNumber()));
        for (Step step : steps) {
            ActivityStepType activityStep = this.m_factory.createActivityStepType();
            this.m_activitySteps.add(activityStep);
            activityStep.setActivityObjectId(task.getUniqueID());
            activityStep.setDescription(this.getNotes(step.getDescriptionObject()));
            activityStep.setName(step.getName());
            activityStep.setObjectId(step.getUniqueID());
            activityStep.setPercentComplete(NumberHelper.getDouble(step.getPercentComplete()) / 100.0);
            activityStep.setIsCompleted(step.getComplete());
            activityStep.setSequenceNumber(step.getSequenceNumber());
            activityStep.setWeight(step.getWeight());
        }
    }

    private void writeResourceRates() {
        this.m_projectFile.getResources().stream().filter(r -> !r.getRole() && r.getUniqueID() != 0).forEach(this::writeResourceRates);
    }

    private void writeResourceRates(Resource resource) {
        CostRateTable table = resource.getCostRateTable(0);
        AvailabilityTable availabilityTable = resource.getAvailability();
        for (CostRateTableEntry entry : table) {
            if (!this.costRateTableWriteRequired(entry)) continue;
            Availability availability = availabilityTable.getEntryByDate(entry.getStartDate());
            Double maxUnits = availability == null || availability.getUnits() == null ? Double.valueOf(1.0) : Double.valueOf(availability.getUnits().doubleValue() / 100.0);
            ResourceRateType rate = this.m_factory.createResourceRateType();
            this.m_apibo.getResourceRate().add(rate);
            rate.setEffectiveDate(entry.getStartDate());
            rate.setMaxUnitsPerTime(maxUnits);
            rate.setObjectId(this.m_sequences.getRateObjectID());
            rate.setPricePerUnit(this.writeRate(entry.getRate(0)));
            rate.setPricePerUnit2(this.writeRate(entry.getRate(1)));
            rate.setPricePerUnit3(this.writeRate(entry.getRate(2)));
            rate.setPricePerUnit4(this.writeRate(entry.getRate(3)));
            rate.setPricePerUnit5(this.writeRate(entry.getRate(4)));
            rate.setResourceObjectId(resource.getUniqueID());
            rate.setShiftPeriodObjectId(entry.getShiftPeriod() == null ? null : entry.getShiftPeriod().getUniqueID());
        }
    }

    private Double writeRate(Rate rate) {
        if (rate == null || rate.getAmount() == 0.0) {
            return null;
        }
        return RateHelper.convertToHours(this.m_projectFile.getProjectProperties(), rate);
    }

    private void writeRoleRates() {
        this.m_projectFile.getResources().stream().filter(Resource::getRole).forEach(this::writeRoleRates);
    }

    private void writeRoleRates(Resource resource) {
        CostRateTable table = resource.getCostRateTable(0);
        AvailabilityTable availabilityTable = resource.getAvailability();
        for (CostRateTableEntry entry : table) {
            if (!this.costRateTableWriteRequired(entry)) continue;
            Availability availability = availabilityTable.getEntryByDate(entry.getStartDate());
            Double maxUnits = availability == null ? Double.valueOf(1.0) : Double.valueOf(availability.getUnits().doubleValue() / 100.0);
            RoleRateType rate = this.m_factory.createRoleRateType();
            this.m_apibo.getRoleRate().add(rate);
            rate.setEffectiveDate(entry.getStartDate());
            rate.setMaxUnitsPerTime(maxUnits);
            rate.setObjectId(this.m_sequences.getRateObjectID());
            rate.setPricePerUnit(this.writeRate(entry.getRate(0)));
            rate.setPricePerUnit2(this.writeRate(entry.getRate(1)));
            rate.setPricePerUnit3(this.writeRate(entry.getRate(2)));
            rate.setPricePerUnit4(this.writeRate(entry.getRate(3)));
            rate.setPricePerUnit5(this.writeRate(entry.getRate(4)));
            rate.setRoleObjectId(resource.getUniqueID());
        }
    }

    private boolean costRateTableWriteRequired(CostRateTableEntry entry) {
        boolean fromDate = LocalDateTimeHelper.compare(entry.getStartDate(), LocalDateTimeHelper.START_DATE_NA) > 0;
        boolean toDate = LocalDateTimeHelper.compare(entry.getEndDate(), LocalDateTimeHelper.END_DATE_NA) > 0;
        boolean nonZeroRates = false;
        for (int rateIndex = 0; rateIndex < 5; ++rateIndex) {
            if (entry.getRate(rateIndex) == null || entry.getRate(rateIndex).getAmount() == 0.0) continue;
            nonZeroRates = true;
            break;
        }
        return fromDate || toDate || nonZeroRates;
    }

    private void writeTopics() {
        for (NotesTopic entry : this.m_projectFile.getNotesTopics()) {
            NotebookTopicType xml = this.m_factory.createNotebookTopicType();
            this.m_apibo.getNotebookTopic().add(xml);
            xml.setAvailableForEPS(entry.getAvailableForEPS());
            xml.setAvailableForProject(entry.getAvailableForProject());
            xml.setAvailableForActivity(entry.getAvailableForActivity());
            xml.setAvailableForWBS(entry.getAvailableForWBS());
            xml.setName(entry.getName());
            xml.setObjectId(entry.getUniqueID());
            xml.setSequenceNumber(entry.getSequenceNumber());
        }
    }

    private void writeWbsNote(Integer wbsObjectID, Notes notes) {
        if (notes == null || notes.toString().isEmpty()) {
            return;
        }
        if (this.notesAreNativeFormat(notes)) {
            this.writeNativeWbsNote(wbsObjectID, (ParentNotes)notes);
        } else {
            this.writeDefaultWbsNote(wbsObjectID, notes.toString());
        }
    }

    private void writeDefaultWbsNote(Integer wbsObjectID, String notes) {
        ProjectNoteType xml = this.m_factory.createProjectNoteType();
        this.m_projectNotes.add(xml);
        xml.setNote(HtmlHelper.getHtmlFromPlainText(notes));
        xml.setNotebookTopicObjectId(this.m_projectFile.getNotesTopics().getDefaultTopic().getUniqueID());
        xml.setObjectId(this.m_sequences.getWbsNoteObjectID());
        xml.setProjectObjectId(this.m_projectObjectID);
        xml.setWBSObjectId(wbsObjectID);
    }

    private void writeNativeWbsNote(Integer wbsObjectID, ParentNotes notes) {
        for (Notes note : notes.getChildNotes()) {
            StructuredNotes structuredNotes = (StructuredNotes)note;
            ProjectNoteType xml = this.m_factory.createProjectNoteType();
            this.m_projectNotes.add(xml);
            xml.setNote(this.getNotes(structuredNotes.getNotes()));
            xml.setNotebookTopicObjectId(structuredNotes.getTopicID());
            xml.setObjectId(structuredNotes.getUniqueID());
            xml.setProjectObjectId(this.m_projectObjectID);
            xml.setWBSObjectId(wbsObjectID);
        }
    }

    private void writeActivityNote(Task task) {
        String notes = task.getNotes();
        if (notes.isEmpty()) {
            return;
        }
        if (this.notesAreNativeFormat(task.getNotesObject())) {
            this.writeNativeActivityNote(task);
        } else {
            this.writeDefaultActivityNote(task);
        }
    }

    private void writeDefaultActivityNote(Task task) {
        ActivityNoteType xml = this.m_factory.createActivityNoteType();
        this.m_activityNotes.add(xml);
        xml.setNote(HtmlHelper.getHtmlFromPlainText(task.getNotes()));
        xml.setNotebookTopicObjectId(this.m_projectFile.getNotesTopics().getDefaultTopic().getUniqueID());
        xml.setObjectId(this.m_sequences.getActivityNoteObjectID());
        xml.setProjectObjectId(this.m_projectObjectID);
        xml.setActivityObjectId(task.getUniqueID());
    }

    private void writeNativeActivityNote(Task task) {
        for (Notes note : ((ParentNotes)task.getNotesObject()).getChildNotes()) {
            StructuredNotes structuredNotes = (StructuredNotes)note;
            HtmlNotes htmlNotes = (HtmlNotes)structuredNotes.getNotes();
            ActivityNoteType xml = this.m_factory.createActivityNoteType();
            this.m_activityNotes.add(xml);
            xml.setNote(htmlNotes.getHtml());
            xml.setNotebookTopicObjectId(structuredNotes.getTopicID());
            xml.setObjectId(structuredNotes.getUniqueID());
            xml.setProjectObjectId(this.m_projectObjectID);
            xml.setActivityObjectId(task.getUniqueID());
        }
    }

    private boolean notesAreNativeFormat(Notes notes) {
        return notes instanceof ParentNotes && ((ParentNotes)notes).getChildNotes().stream().allMatch(n -> n instanceof StructuredNotes);
    }

    private List<UDFAssignmentType> writeUserDefinedFieldAssignments(FieldTypeClass type, boolean summaryTaskOnly, FieldContainer mpxj) {
        ArrayList<UDFAssignmentType> out = new ArrayList<UDFAssignmentType>();
        CustomFieldContainer customFields = this.m_projectFile.getCustomFields();
        for (FieldType fieldType : this.m_userDefinedFields) {
            Object value;
            if (type != fieldType.getFieldTypeClass() || type == FieldTypeClass.TASK && summaryTaskOnly && (fieldType instanceof TaskField || fieldType instanceof UserDefinedField && !((UserDefinedField)fieldType).getSummaryTaskOnly()) || (value = mpxj.getCachedValue(fieldType)) == null) continue;
            CustomField field = customFields.get(fieldType);
            int uniqueID = field == null ? FieldTypeHelper.getFieldID(fieldType) : NumberHelper.getInt(field.getUniqueID());
            DataType dataType = fieldType.getDataType();
            if (dataType == DataType.CUSTOM) {
                dataType = DataType.BINARY;
            }
            UDFAssignmentType udf = this.m_factory.createUDFAssignmentType();
            udf.setTypeObjectId(uniqueID);
            this.setUserFieldValue(udf, dataType, value);
            out.add(udf);
        }
        out.sort(Comparator.comparing(UDFAssignmentType::getTypeObjectId));
        return out;
    }

    private void writeActivityCodeDefinitions() {
        List<ActivityCodeTypeType> codes = this.m_apibo.getActivityCodeType();
        List<ActivityCodeType> values = this.m_apibo.getActivityCode();
        this.m_projectFile.getActivityCodes().stream().filter(c -> c.getScope() != ActivityCodeScope.PROJECT).sorted(Comparator.comparing(a -> a.getSequenceNumber() == null ? Integer.valueOf(0) : a.getSequenceNumber())).forEach(c -> this.writeActivityCodeDefinition(codes, values, (ActivityCode)c));
    }

    private void writeActivityCodeDefinitions(List<ActivityCodeTypeType> codes, List<ActivityCodeType> values) {
        this.m_projectFile.getActivityCodes().stream().filter(c -> c.getScope() == ActivityCodeScope.PROJECT).sorted(Comparator.comparing(a -> a.getSequenceNumber() == null ? Integer.valueOf(0) : a.getSequenceNumber())).forEach(c -> this.writeActivityCodeDefinition(codes, values, (ActivityCode)c));
    }

    private void writeActivityCodeDefinition(List<ActivityCodeTypeType> codes, List<ActivityCodeType> values, ActivityCode code) {
        ActivityCodeTypeType xml = this.m_factory.createActivityCodeTypeType();
        codes.add(xml);
        xml.setObjectId(code.getUniqueID());
        xml.setScope(ActivityCodeScopeHelper.getXmlFromInstance(code.getScope()));
        xml.setSequenceNumber(code.getSequenceNumber());
        xml.setName(code.getName());
        xml.setIsSecureCode(code.getSecure());
        xml.setLength(code.getMaxLength());
        if (code.getScope() != ActivityCodeScope.GLOBAL) {
            xml.setProjectObjectId(this.m_projectObjectID);
        }
        Comparator<ActivityCodeValue> comparator = Comparator.comparing(ActivityCodeValue::getSequenceNumber).thenComparing(ActivityCodeValue::getUniqueID);
        code.getChildValues().stream().sorted(comparator).forEach(v -> this.writeActivityCodeValueDefinition(xml, null, values, (ActivityCodeValue)v, comparator));
    }

    private void writeProjectCodeDefinitions() {
        for (ProjectCode code : this.m_projectFile.getProjectCodes()) {
            ProjectCodeTypeType xmlCode = this.m_factory.createProjectCodeTypeType();
            this.m_apibo.getProjectCodeType().add(xmlCode);
            xmlCode.setObjectId(code.getUniqueID());
            xmlCode.setName(code.getName());
            xmlCode.setSequenceNumber(code.getSequenceNumber());
            xmlCode.setIsSecureCode(code.getSecure());
            xmlCode.setLength(code.getMaxLength());
            for (ProjectCodeValue value : code.getValues()) {
                ProjectCodeType xmlValue = this.m_factory.createProjectCodeType();
                this.m_apibo.getProjectCode().add(xmlValue);
                xmlValue.setObjectId(value.getUniqueID());
                xmlValue.setCodeTypeObjectId(code.getUniqueID());
                xmlValue.setCodeValue(value.getName());
                xmlValue.setDescription(value.getDescription());
                xmlValue.setParentObjectId(value.getParentValueUniqueID());
                xmlValue.setSequenceNumber(value.getSequenceNumber());
            }
        }
    }

    private void writeResourceCodeDefinitions() {
        for (ResourceCode code : this.m_projectFile.getResourceCodes()) {
            ResourceCodeTypeType xmlCode = this.m_factory.createResourceCodeTypeType();
            this.m_apibo.getResourceCodeType().add(xmlCode);
            xmlCode.setObjectId(code.getUniqueID());
            xmlCode.setName(code.getName());
            xmlCode.setSequenceNumber(code.getSequenceNumber());
            xmlCode.setIsSecureCode(code.getSecure());
            xmlCode.setLength(code.getMaxLength());
            for (ResourceCodeValue value : code.getValues()) {
                ResourceCodeType xmlValue = this.m_factory.createResourceCodeType();
                this.m_apibo.getResourceCode().add(xmlValue);
                xmlValue.setObjectId(value.getUniqueID());
                xmlValue.setCodeTypeObjectId(code.getUniqueID());
                xmlValue.setCodeValue(value.getName());
                xmlValue.setDescription(value.getDescription());
                xmlValue.setParentObjectId(value.getParentValueUniqueID());
                xmlValue.setSequenceNumber(value.getSequenceNumber());
            }
        }
    }

    private void writeRoleCodeDefinitions() {
        for (RoleCode code : this.m_projectFile.getRoleCodes()) {
            RoleCodeTypeType xmlCode = this.m_factory.createRoleCodeTypeType();
            this.m_apibo.getRoleCodeType().add(xmlCode);
            xmlCode.setObjectId(code.getUniqueID());
            xmlCode.setName(code.getName());
            xmlCode.setSequenceNumber(code.getSequenceNumber());
            xmlCode.setIsSecureCode(code.getSecure());
            xmlCode.setLength(code.getMaxLength());
            for (RoleCodeValue value : code.getValues()) {
                RoleCodeType xmlValue = this.m_factory.createRoleCodeType();
                this.m_apibo.getRoleCode().add(xmlValue);
                xmlValue.setObjectId(value.getUniqueID());
                xmlValue.setCodeTypeObjectId(code.getUniqueID());
                xmlValue.setCodeValue(value.getName());
                xmlValue.setDescription(value.getDescription());
                xmlValue.setParentObjectId(value.getParentValueUniqueID());
                xmlValue.setSequenceNumber(value.getSequenceNumber());
            }
        }
    }

    private void writeResourceAssignmentCodeDefinitions() {
        for (ResourceAssignmentCode code : this.m_projectFile.getResourceAssignmentCodes()) {
            ResourceAssignmentCodeTypeType xmlCode = this.m_factory.createResourceAssignmentCodeTypeType();
            this.m_apibo.getResourceAssignmentCodeType().add(xmlCode);
            xmlCode.setObjectId(code.getUniqueID());
            xmlCode.setName(code.getName());
            xmlCode.setSequenceNumber(code.getSequenceNumber());
            xmlCode.setIsSecureCode(code.getSecure());
            xmlCode.setLength(code.getMaxLength());
            for (ResourceAssignmentCodeValue value : code.getValues()) {
                ResourceAssignmentCodeType xmlValue = this.m_factory.createResourceAssignmentCodeType();
                this.m_apibo.getResourceAssignmentCode().add(xmlValue);
                xmlValue.setObjectId(value.getUniqueID());
                xmlValue.setCodeTypeObjectId(code.getUniqueID());
                xmlValue.setCodeValue(value.getName());
                xmlValue.setDescription(value.getDescription());
                xmlValue.setParentObjectId(value.getParentValueUniqueID());
                xmlValue.setSequenceNumber(value.getSequenceNumber());
            }
        }
    }

    private void writeCodeAssignments(Map<? extends Code, ? extends CodeValue> map, List<CodeAssignmentType> assignments) {
        map.values().stream().sorted(Comparator.comparing(CodeValue::getUniqueID)).forEach(v -> this.writeCodeAssignment(assignments, (CodeValue)v));
    }

    private void writeCodeAssignment(List<CodeAssignmentType> assignments, CodeValue value) {
        CodeAssignmentType xml = this.m_factory.createCodeAssignmentType();
        assignments.add(xml);
        xml.setTypeObjectId(NumberHelper.getInt(value.getParentCodeUniqueID()));
        xml.setValueObjectId(NumberHelper.getInt(value.getUniqueID()));
    }

    private void writeActivityCodeValueDefinition(ActivityCodeTypeType code, ActivityCodeType parentValue, List<ActivityCodeType> values, ActivityCodeValue value, Comparator<ActivityCodeValue> comparator) {
        ActivityCodeType xml = this.m_factory.createActivityCodeType();
        values.add(xml);
        xml.setObjectId(value.getUniqueID());
        xml.setProjectObjectId(code.getProjectObjectId());
        xml.setCodeTypeObjectId(code.getObjectId());
        xml.setParentObjectId(parentValue == null ? null : parentValue.getObjectId());
        xml.setSequenceNumber(value.getSequenceNumber());
        xml.setCodeValue(value.getName());
        xml.setDescription(value.getDescription());
        xml.setColor(ColorHelper.getHtmlColor(value.getColor()));
        value.getChildValues().stream().sorted(comparator).forEach(v -> this.writeActivityCodeValueDefinition(code, xml, values, (ActivityCodeValue)v, comparator));
    }

    private void setUserFieldValue(UDFAssignmentType udf, DataType dataType, Object value) {
        switch (dataType) {
            case DURATION: {
                udf.setTextValue(((Duration)value).toString());
                break;
            }
            case CURRENCY: {
                if (!(value instanceof Double)) {
                    value = ((Number)value).doubleValue();
                }
                udf.setCostValue((Double)value);
                break;
            }
            case BINARY: {
                udf.setTextValue("");
                break;
            }
            case STRING: {
                udf.setTextValue(value == null ? null : value.toString());
                break;
            }
            case DATE: {
                udf.setStartDateValue((LocalDateTime)value);
                break;
            }
            case NUMERIC: {
                if (!(value instanceof Double)) {
                    value = ((Number)value).doubleValue();
                }
                udf.setDoubleValue((Double)value);
                break;
            }
            case BOOLEAN: {
                udf.setIntegerValue(BooleanHelper.getBoolean((Boolean)value) ? Integer.valueOf(1) : Integer.valueOf(0));
                break;
            }
            case INTEGER: 
            case SHORT: {
                udf.setIntegerValue(NumberHelper.getInteger((Number)value));
                break;
            }
            default: {
                throw new RuntimeException("Unconvertible data type: " + dataType);
            }
        }
    }

    private Double getDurationInHours(Duration duration) {
        Double result;
        if (duration == null) {
            result = null;
        } else {
            if (duration.getUnits() != TimeUnit.HOURS) {
                duration = duration.convertUnits(TimeUnit.HOURS, this.m_projectFile.getProjectProperties());
            }
            result = (double)Math.round(duration.getDuration() * 100.0) / 100.0;
        }
        return result;
    }

    private String getDayName(DayOfWeek day) {
        return DAY_NAMES[DayOfWeekHelper.getValue(day) - 1];
    }

    private Double getPercentage(Number number) {
        Double result = null;
        if (number != null) {
            result = number.doubleValue() / 100.0;
        }
        return result;
    }

    private Double getPercentComplete(Task task) {
        Number result;
        PercentCompleteType type = task.getPercentCompleteType();
        if (type == null) {
            type = PercentCompleteType.DURATION;
        }
        switch (type) {
            case PHYSICAL: {
                result = task.getPhysicalPercentComplete();
                break;
            }
            case UNITS: {
                result = task.getPercentageWorkComplete();
                break;
            }
            default: {
                result = task.getPercentageComplete();
            }
        }
        return this.getPercentage(result);
    }

    private Double getCurrency(Number number) {
        Double result = null;
        if (number != null) {
            result = (double)Math.round(number.doubleValue() * 1.0E8) / 1.0E8;
        }
        return result;
    }

    private Double getDouble(Number number) {
        Double result = null;
        if (number != null) {
            result = number.doubleValue();
        }
        return result;
    }

    private LocalTime getEndTime(LocalTime date) {
        return date.minusMinutes(1L);
    }

    ProjectFile getProjectFile() {
        return this.m_projectFile;
    }
}

