/*
 * Decompiled with CFR 0.152.
 */
package org.mpxj.primavera;

import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.mpxj.ActivityCode;
import org.mpxj.ActivityCodeContainer;
import org.mpxj.ActivityCodeValue;
import org.mpxj.AssignmentField;
import org.mpxj.Availability;
import org.mpxj.CostAccount;
import org.mpxj.CostAccountContainer;
import org.mpxj.CostRateTableEntry;
import org.mpxj.CriticalActivityType;
import org.mpxj.Currency;
import org.mpxj.CurrencyContainer;
import org.mpxj.CurrencySymbolPosition;
import org.mpxj.DataType;
import org.mpxj.Duration;
import org.mpxj.EventManager;
import org.mpxj.ExpenseCategory;
import org.mpxj.ExpenseCategoryContainer;
import org.mpxj.ExpenseItem;
import org.mpxj.FieldContainer;
import org.mpxj.FieldType;
import org.mpxj.FieldTypeClass;
import org.mpxj.HtmlNotes;
import org.mpxj.LocalTimeRange;
import org.mpxj.Location;
import org.mpxj.LocationContainer;
import org.mpxj.Notes;
import org.mpxj.NotesTopic;
import org.mpxj.NotesTopicContainer;
import org.mpxj.ParentNotes;
import org.mpxj.PercentCompleteType;
import org.mpxj.ProjectCalendar;
import org.mpxj.ProjectCalendarException;
import org.mpxj.ProjectCalendarHours;
import org.mpxj.ProjectCode;
import org.mpxj.ProjectCodeContainer;
import org.mpxj.ProjectCodeValue;
import org.mpxj.ProjectConfig;
import org.mpxj.ProjectFile;
import org.mpxj.ProjectFileSharedData;
import org.mpxj.ProjectProperties;
import org.mpxj.Rate;
import org.mpxj.Relation;
import org.mpxj.RelationType;
import org.mpxj.Resource;
import org.mpxj.ResourceAssignment;
import org.mpxj.ResourceAssignmentCode;
import org.mpxj.ResourceAssignmentCodeContainer;
import org.mpxj.ResourceAssignmentCodeValue;
import org.mpxj.ResourceCode;
import org.mpxj.ResourceCodeContainer;
import org.mpxj.ResourceCodeValue;
import org.mpxj.ResourceField;
import org.mpxj.RoleCode;
import org.mpxj.RoleCodeContainer;
import org.mpxj.RoleCodeValue;
import org.mpxj.SchedulingProgressedActivities;
import org.mpxj.Shift;
import org.mpxj.ShiftContainer;
import org.mpxj.ShiftPeriod;
import org.mpxj.ShiftPeriodContainer;
import org.mpxj.Step;
import org.mpxj.StructuredNotes;
import org.mpxj.Task;
import org.mpxj.TaskField;
import org.mpxj.TimeUnit;
import org.mpxj.UnitOfMeasure;
import org.mpxj.UnitOfMeasureContainer;
import org.mpxj.UserDefinedField;
import org.mpxj.UserDefinedFieldContainer;
import org.mpxj.common.BooleanHelper;
import org.mpxj.common.ColorHelper;
import org.mpxj.common.DayOfWeekHelper;
import org.mpxj.common.HierarchyHelper;
import org.mpxj.common.LocalDateTimeHelper;
import org.mpxj.common.NumberHelper;
import org.mpxj.common.ObjectSequence;
import org.mpxj.common.SlackHelper;
import org.mpxj.primavera.AccrueTypeHelper;
import org.mpxj.primavera.ActivityCodeScopeHelper;
import org.mpxj.primavera.ActivitySorter;
import org.mpxj.primavera.ActivityStatusHelper;
import org.mpxj.primavera.ActivityTypeHelper;
import org.mpxj.primavera.CalendarTypeHelper;
import org.mpxj.primavera.ClashMap;
import org.mpxj.primavera.ConstraintTypeHelper;
import org.mpxj.primavera.CriticalActivityTypeHelper;
import org.mpxj.primavera.CurveHelper;
import org.mpxj.primavera.ExternalRelation;
import org.mpxj.primavera.FieldTypeClassHelper;
import org.mpxj.primavera.PercentCompleteTypeHelper;
import org.mpxj.primavera.PrimaveraBaselineStrategy;
import org.mpxj.primavera.PriorityHelper;
import org.mpxj.primavera.ProjectCalendarHelper;
import org.mpxj.primavera.RateSourceHelper;
import org.mpxj.primavera.RateTypeHelper;
import org.mpxj.primavera.RelationTypeHelper;
import org.mpxj.primavera.RelationshipLagCalendarHelper;
import org.mpxj.primavera.ResourceTypeHelper;
import org.mpxj.primavera.Row;
import org.mpxj.primavera.SkillLevelHelper;
import org.mpxj.primavera.StructuredTextParser;
import org.mpxj.primavera.StructuredTextRecord;
import org.mpxj.primavera.TaskTypeHelper;
import org.mpxj.primavera.TimephasedHelper;
import org.mpxj.primavera.TotalSlackCalculationTypeHelper;
import org.mpxj.primavera.UdfHelper;
import org.mpxj.primavera.WorkHelper;

final class PrimaveraReader {
    private final ProjectFile m_project;
    private final EventManager m_eventManager;
    private final ClashMap m_activityClashMap = new ClashMap();
    private final ClashMap m_roleClashMap = new ClashMap();
    private final DateTimeFormatter m_twentyFourHourTimeFormat = DateTimeFormatter.ofPattern("H:mm");
    private final DateTimeFormatter m_twelveHourTimeFormat = new DateTimeFormatterBuilder().parseCaseInsensitive().appendPattern("h:mm a").toFormatter();
    private final Map<FieldType, String> m_resourceFields;
    private final Map<FieldType, String> m_roleFields;
    private final Map<FieldType, String> m_wbsFields;
    private final Map<FieldType, String> m_taskFields;
    private final Map<FieldType, String> m_assignmentFields;
    private final List<ExternalRelation> m_externalRelations = new ArrayList<ExternalRelation>();
    private final boolean m_matchPrimaveraWBS;
    private final boolean m_wbsIsFullPath;
    private final boolean m_ignoreErrors;
    private final Map<String, Map<Integer, List<Row>>> m_udfValues = new HashMap<String, Map<Integer, List<Row>>>();
    private final Map<Integer, List<Row>> m_activityCodeAssignments = new HashMap<Integer, List<Row>>();
    private final Map<Integer, List<Row>> m_resourceCodeAssignments = new HashMap<Integer, List<Row>>();
    private final Map<Integer, List<Row>> m_roleCodeAssignments = new HashMap<Integer, List<Row>>();
    private final Map<Integer, List<Row>> m_resourceAssignmentCodeAssignments = new HashMap<Integer, List<Row>>();
    private final ObjectSequence m_relationObjectID;
    private static final Map<String, Boolean> MILESTONE_MAP = new HashMap<String, Boolean>();
    private static final Map<String, CurrencySymbolPosition> CURRENCY_SYMBOL_POSITION_MAP;
    static final LocalDate EXCEPTION_EPOCH;

    public PrimaveraReader(ProjectFileSharedData shared, Map<FieldType, String> resourceFields, Map<FieldType, String> roleFields, Map<FieldType, String> wbsFields, Map<FieldType, String> taskFields, Map<FieldType, String> assignmentFields, boolean matchPrimaveraWBS, boolean wbsIsFullPath, boolean ignoreErrors) {
        this.m_project = new ProjectFile(shared);
        this.m_eventManager = this.m_project.getEventManager();
        ProjectConfig config = this.m_project.getProjectConfig();
        config.setAutoTaskUniqueID(false);
        config.setAutoResourceUniqueID(false);
        config.setAutoAssignmentUniqueID(false);
        config.setAutoWBS(false);
        config.setAutoRelationUniqueID(false);
        config.setBaselineStrategy(PrimaveraBaselineStrategy.PLANNED_ATTRIBUTES);
        this.m_resourceFields = resourceFields;
        this.m_roleFields = roleFields;
        this.m_wbsFields = wbsFields;
        this.m_taskFields = taskFields;
        this.m_assignmentFields = assignmentFields;
        this.m_matchPrimaveraWBS = matchPrimaveraWBS;
        this.m_wbsIsFullPath = wbsIsFullPath;
        this.m_ignoreErrors = ignoreErrors;
        this.m_relationObjectID = new ObjectSequence(1);
    }

    public ProjectFile getProject() {
        return this.m_project;
    }

    public List<ExternalRelation> getExternalRelations() {
        return this.m_externalRelations;
    }

    public void processProjectProperties(Integer projectID, List<Row> rows) {
        ProjectProperties properties = this.m_project.getProjectProperties();
        properties.setUniqueID(projectID);
        this.populateUserDefinedFieldValues("PROJECT", FieldTypeClass.PROJECT, properties, projectID);
        if (!rows.isEmpty()) {
            Row row = rows.get(0);
            properties.setBaselineProjectUniqueID(row.getInteger("sum_base_proj_id"));
            properties.setCreationDate(row.getDate("create_date"));
            properties.setCriticalActivityType(CriticalActivityTypeHelper.getInstanceFromXer(row.getString("critical_path_type")));
            properties.setGUID(row.getUUID("guid"));
            properties.setProjectID(row.getString("proj_short_name"));
            properties.setName(row.getString("proj_short_name"));
            properties.setDefaultTaskType(TaskTypeHelper.getInstanceFromXer(row.getString("def_duration_type")));
            properties.setStatusDate(row.getDate("last_recalc_date"));
            properties.setFiscalYearStartMonth(row.getInteger("fy_start_month_num"));
            properties.setExportFlag(row.getBoolean("export_flag"));
            properties.setPlannedStart(row.getDate("plan_start_date"));
            properties.setScheduledFinish(row.getDate("scd_end_date"));
            properties.setMustFinishBy(row.getDate("plan_end_date"));
            properties.setCriticalSlackLimit(Duration.getInstance(row.getInt("critical_drtn_hr_cnt"), TimeUnit.HOURS));
            properties.setLocationUniqueID(row.getInteger("location_id"));
            properties.setWbsCodeSeparator(row.getString("name_sep_char"));
            properties.setActivityIdPrefix(row.getString("task_code_prefix"));
            properties.setActivityIdSuffix(row.getInteger("task_code_base"));
            properties.setActivityIdIncrement(row.getInteger("task_code_step"));
            properties.setActivityIdIncrementBasedOnSelectedActivity(row.getBoolean("task_code_prefix_flag"));
            properties.setProjectWebsiteUrl(row.getString("proj_url"));
            ProjectCalendar calendar = this.m_project.getCalendarByUniqueID(row.getInteger("clndr_id"));
            if (calendar != null) {
                this.m_project.getProjectProperties().setDefaultCalendar(calendar);
            }
        }
        ProjectConfig config = this.m_project.getProjectConfig();
        config.setAutoCalendarUniqueID(true);
        if (this.m_project.getDefaultCalendar() == null) {
            this.m_project.setDefaultCalendar(this.m_project.getCalendars().findOrCreateDefaultCalendar());
        }
    }

    public void processProjectCodeAssignments(List<Row> rows) {
        ProjectProperties properties = this.m_project.getProjectProperties();
        for (Row row : rows) {
            ProjectCodeValue value;
            ProjectCode code = (ProjectCode)this.m_project.getProjectCodes().getByUniqueID(row.getInteger("proj_catg_type_id"));
            if (code == null || (value = code.getValueByUniqueID(row.getInteger("proj_catg_id"))) == null) continue;
            properties.addProjectCodeValue(value);
        }
    }

    public void processLocations(List<Row> locations) {
        LocationContainer container = this.m_project.getLocations();
        locations.forEach(row -> container.add(new Location.Builder(this.m_project).uniqueID(row.getInteger("location_id")).name(row.getString("location_name")).addressLine1(row.getString("address_line1")).addressLine2(row.getString("address_line2")).addressLine3(row.getString("address_line3")).city(row.getString("city_name")).municipality(row.getString("municipality_name")).state(row.getString("state_name")).stateCode(row.getString("state_code")).country(row.getString("country_name")).countryCode(row.getString("country_code")).postalCode(row.getString("postal_code")).latitude(row.getDouble("latitude")).longitude(row.getDouble("longitude")).build()));
    }

    public void processCurrencies(List<Row> currencies) {
        CurrencyContainer container = this.m_project.getCurrencies();
        currencies.forEach(row -> container.add(new Currency.Builder(this.m_project).uniqueID(row.getInteger("curr_id")).numberOfDecimalPlaces(row.getInteger("decimal_digit_cnt")).symbol(row.getString("curr_symbol")).decimalSymbol(row.getString("decimal_symbol")).digitGroupingSymbol(row.getString("digit_group_symbol")).positiveCurrencyFormat(row.getString("pos_curr_fmt_type")).negativeCurrencyFormat(row.getString("neg_curr_fmt_type")).name(row.getString("curr_type")).currencyID(row.getString("curr_short_name")).exchangeRate(row.getDouble("base_exch_rate")).build()));
    }

    public void processShifts(List<Row> shifts, List<Row> periods) {
        ShiftContainer shiftContainer = this.m_project.getShifts();
        shifts.forEach(r -> shiftContainer.add(new Shift.Builder(this.m_project).uniqueID(r.getInteger("shift_id")).name(r.getString("shift_name")).build()));
        ShiftPeriodContainer shiftPeriodContainer = this.m_project.getShiftPeriods();
        for (Row row : periods) {
            Shift shift = (Shift)shiftContainer.getByUniqueID(row.getInteger("shift_id"));
            if (shift == null) continue;
            ShiftPeriod period = new ShiftPeriod.Builder(this.m_project, shift).uniqueID(row.getInteger("shift_period_id")).start(row.getInteger("shift_start_hr_num")).build();
            shiftPeriodContainer.add(period);
        }
    }

    public void processExpenseCategories(List<Row> categories) {
        ExpenseCategoryContainer container = this.m_project.getExpenseCategories();
        categories.forEach(row -> container.add(new ExpenseCategory.Builder(this.m_project).uniqueID(row.getInteger("cost_type_id")).name(row.getString("cost_type")).sequenceNumber(row.getInteger("seq_num")).build()));
    }

    public void processCostAccounts(List<Row> accounts) {
        CostAccountContainer container = this.m_project.getCostAccounts();
        HierarchyHelper.sortHierarchy(accounts, v -> v.getInteger("acct_id"), v -> v.getInteger("parent_acct_id")).forEach(row -> container.add(new CostAccount.Builder(this.m_project).uniqueID(row.getInteger("acct_id")).id(row.getString("acct_short_name")).name(row.getString("acct_name")).notes(this.getNotes(row.getString("acct_descr"))).sequenceNumber(row.getInteger("acct_seq_num")).parent((CostAccount)container.getByUniqueID(row.getInteger("parent_acct_id"))).build()));
    }

    public void processUnitsOfMeasure(List<Row> units) {
        UnitOfMeasureContainer container = this.m_project.getUnitsOfMeasure();
        units.forEach(row -> container.add(this.processUnitOfMeasure((Row)row)));
    }

    private UnitOfMeasure processUnitOfMeasure(Row row) {
        return new UnitOfMeasure.Builder(this.m_project).uniqueID(row.getInteger("unit_id")).abbreviation(row.getString("unit_abbrev")).name(row.getString("unit_name")).sequenceNumber(row.getInteger("seq_num")).build();
    }

    public void processActivityCodeDefinitions(List<Row> types, List<Row> typeValues) {
        ActivityCode code;
        ActivityCodeContainer container = this.m_project.getActivityCodes();
        HashMap<Integer, ActivityCode> map = new HashMap<Integer, ActivityCode>();
        for (Row row : types) {
            code = new ActivityCode.Builder(this.m_project).uniqueID(row.getInteger("actv_code_type_id")).scope(ActivityCodeScopeHelper.getInstanceFromXer(row.getString("actv_code_type_scope"))).scopeEpsUniqueID(row.getInteger("wbs_id")).scopeProjectUniqueID(row.getInteger("proj_id")).sequenceNumber(row.getInteger("seq_num")).name(row.getString("actv_code_type")).secure(row.getBoolean("super_flag")).maxLength(row.getInteger("actv_short_len")).build();
            container.add(code);
            map.put(code.getUniqueID(), code);
        }
        typeValues = HierarchyHelper.sortHierarchy(typeValues, v -> v.getInteger("actv_code_id"), v -> v.getInteger("parent_actv_code_id"));
        for (Row row : typeValues) {
            code = (ActivityCode)map.get(row.getInteger("actv_code_type_id"));
            if (code == null) continue;
            ActivityCodeValue value = new ActivityCodeValue.Builder(this.m_project).activityCode(code).uniqueID(row.getInteger("actv_code_id")).sequenceNumber(row.getInteger("seq_num")).name(row.getString("short_name")).description(row.getString("actv_code_name")).color(ColorHelper.parseHexColor(row.getString("color"))).parentValue(code.getValueByUniqueID(row.getInteger("parent_actv_code_id"))).build();
            code.addValue(value);
        }
    }

    public void processProjectCodeDefinitions(List<Row> types, List<Row> typeValues) {
        ProjectCode code;
        ProjectCodeContainer container = this.m_project.getProjectCodes();
        HashMap<Integer, ProjectCode> map = new HashMap<Integer, ProjectCode>();
        for (Row row : types) {
            code = new ProjectCode.Builder(this.m_project).uniqueID(row.getInteger("proj_catg_type_id")).sequenceNumber(row.getInteger("seq_num")).name(row.getString("proj_catg_type")).maxLength(row.getInteger("proj_catg_short_len")).build();
            container.add(code);
            map.put(code.getUniqueID(), code);
        }
        typeValues = HierarchyHelper.sortHierarchy(typeValues, v -> v.getInteger("proj_catg_id"), v -> v.getInteger("parent_proj_catg_id"));
        for (Row row : typeValues) {
            code = (ProjectCode)map.get(row.getInteger("proj_catg_type_id"));
            if (code == null) continue;
            ProjectCodeValue value = new ProjectCodeValue.Builder(this.m_project).projectCode(code).uniqueID(row.getInteger("proj_catg_id")).sequenceNumber(row.getInteger("seq_num")).name(row.getString("proj_catg_short_name")).description(row.getString("proj_catg_name")).parentValue(code.getValueByUniqueID(row.getInteger("parent_proj_catg_id"))).build();
            code.addValue(value);
        }
    }

    public void processResourceCodeDefinitions(List<Row> types, List<Row> typeValues) {
        ResourceCode code;
        ResourceCodeContainer container = this.m_project.getResourceCodes();
        HashMap<Integer, ResourceCode> map = new HashMap<Integer, ResourceCode>();
        for (Row row : types) {
            code = new ResourceCode.Builder(this.m_project).uniqueID(row.getInteger("rsrc_catg_type_id")).sequenceNumber(row.getInteger("seq_num")).name(row.getString("rsrc_catg_type")).maxLength(row.getInteger("rsrc_catg_short_len")).build();
            container.add(code);
            map.put(code.getUniqueID(), code);
        }
        typeValues = HierarchyHelper.sortHierarchy(typeValues, v -> v.getInteger("rsrc_catg_id"), v -> v.getInteger("parent_rsrc_catg_id"));
        for (Row row : typeValues) {
            code = (ResourceCode)map.get(row.getInteger("rsrc_catg_type_id"));
            if (code == null) continue;
            ResourceCodeValue value = new ResourceCodeValue.Builder(this.m_project).resourceCode(code).uniqueID(row.getInteger("rsrc_catg_id")).sequenceNumber(row.getInteger("seq_num")).name(row.getString("rsrc_catg_short_name")).description(row.getString("rsrc_catg_name")).parentValue(code.getValueByUniqueID(row.getInteger("parent_rsrc_catg_id"))).build();
            code.addValue(value);
        }
    }

    public void processRoleCodeDefinitions(List<Row> types, List<Row> typeValues) {
        RoleCode code;
        RoleCodeContainer container = this.m_project.getRoleCodes();
        HashMap<Integer, RoleCode> map = new HashMap<Integer, RoleCode>();
        for (Row row : types) {
            code = new RoleCode.Builder(this.m_project).uniqueID(row.getInteger("role_catg_type_id")).sequenceNumber(row.getInteger("seq_num")).name(row.getString("role_catg_type")).maxLength(row.getInteger("role_catg_short_len")).build();
            container.add(code);
            map.put(code.getUniqueID(), code);
        }
        typeValues = HierarchyHelper.sortHierarchy(typeValues, v -> v.getInteger("role_catg_id"), v -> v.getInteger("parent_role_catg_id"));
        for (Row row : typeValues) {
            code = (RoleCode)map.get(row.getInteger("role_catg_type_id"));
            if (code == null) continue;
            RoleCodeValue value = new RoleCodeValue.Builder(this.m_project).roleCode(code).uniqueID(row.getInteger("role_catg_id")).sequenceNumber(row.getInteger("seq_num")).name(row.getString("role_catg_short_name")).description(row.getString("role_catg_name")).parentValue(code.getValueByUniqueID(row.getInteger("parent_role_catg_id"))).build();
            code.addValue(value);
        }
    }

    public void processResourceAssignmentCodeDefinitions(List<Row> types, List<Row> typeValues) {
        ResourceAssignmentCode code;
        ResourceAssignmentCodeContainer container = this.m_project.getResourceAssignmentCodes();
        HashMap<Integer, ResourceAssignmentCode> map = new HashMap<Integer, ResourceAssignmentCode>();
        for (Row row : types) {
            code = new ResourceAssignmentCode.Builder(this.m_project).uniqueID(row.getInteger("asgnmnt_catg_type_id")).sequenceNumber(row.getInteger("seq_num")).name(row.getString("asgnmnt_catg_type")).maxLength(row.getInteger("asgnmnt_catg_short_len")).build();
            container.add(code);
            map.put(code.getUniqueID(), code);
        }
        typeValues = HierarchyHelper.sortHierarchy(typeValues, v -> v.getInteger("asgnmnt_catg_id"), v -> v.getInteger("parent_asgnmnt_catg_id"));
        for (Row row : typeValues) {
            code = (ResourceAssignmentCode)map.get(row.getInteger("asgnmnt_catg_type_id"));
            if (code == null) continue;
            ResourceAssignmentCodeValue value = new ResourceAssignmentCodeValue.Builder(this.m_project).resourceAssignmentCode(code).uniqueID(row.getInteger("asgnmnt_catg_id")).sequenceNumber(row.getInteger("seq_num")).name(row.getString("asgnmnt_catg_short_name")).description(row.getString("asgnmnt_catg_name")).parentValue(code.getValueByUniqueID(row.getInteger("parent_asgnmnt_catg_id"))).build();
            code.addValue(value);
        }
    }

    public void processActivityCodeAssignments(List<Row> assignments) {
        for (Row row : assignments) {
            Integer taskID = row.getInteger("task_id");
            List list = this.m_activityCodeAssignments.computeIfAbsent(taskID, k -> new ArrayList());
            list.add(row);
        }
    }

    public void processResourceCodeAssignments(List<Row> assignments) {
        for (Row row : assignments) {
            Integer resourceID = row.getInteger("rsrc_id");
            List list = this.m_resourceCodeAssignments.computeIfAbsent(resourceID, k -> new ArrayList());
            list.add(row);
        }
    }

    public void processRoleCodeAssignments(List<Row> assignments) {
        for (Row row : assignments) {
            Integer resourceID = row.getInteger("role_id");
            List list = this.m_roleCodeAssignments.computeIfAbsent(resourceID, k -> new ArrayList());
            list.add(row);
        }
    }

    public void processResourceAssignmentCodeAssignments(List<Row> assignments) {
        for (Row row : assignments) {
            Integer resourceAssignmentID = row.getInteger("taskrsrc_id");
            List list = this.m_resourceAssignmentCodeAssignments.computeIfAbsent(resourceAssignmentID, k -> new ArrayList());
            list.add(row);
        }
    }

    public void processUdfDefinitions(List<Row> fields) {
        UserDefinedFieldContainer container = this.m_project.getUserDefinedFields();
        for (Row row : fields) {
            Integer fieldId = row.getInteger("udf_type_id");
            String tableName = row.getString("table_name");
            FieldTypeClass fieldTypeClass = FieldTypeClassHelper.getInstanceFromXer(tableName);
            if (fieldTypeClass == null) continue;
            UserDefinedField fieldType = new UserDefinedField.Builder(this.m_project).uniqueID(fieldId).internalName(row.getString("udf_type_name")).externalName(row.getString("udf_type_label")).fieldTypeClass(fieldTypeClass).summaryTaskOnly(tableName.equals("PROJWBS")).dataType(UdfHelper.getDataTypeFromXer(row.getString("logical_data_type"))).build();
            container.add(fieldType);
            this.m_project.getCustomFields().add(fieldType).setAlias(fieldType.getName()).setUniqueID(fieldId);
        }
    }

    public void processUdfValues(List<Row> values) {
        for (Row row : values) {
            UserDefinedField fieldType = this.m_project.getUserDefinedFields().getByUniqueID(row.getInteger("udf_type_id"));
            if (fieldType == null) continue;
            String tableName = FieldTypeClassHelper.getXerFromInstance(fieldType);
            Map tableData = this.m_udfValues.computeIfAbsent(tableName, k -> new HashMap());
            Integer id = row.getInteger("fk_id");
            List list = tableData.computeIfAbsent(id, k -> new ArrayList());
            list.add(row);
        }
    }

    public void processCalendars(List<Row> rows) {
        HashMap<ProjectCalendar, Integer> baseCalendarMap = new HashMap<ProjectCalendar, Integer>();
        for (Row row : rows) {
            ProjectCalendar calendar = this.processCalendar(row);
            Integer baseCalendarID = row.getInteger("base_clndr_id");
            if (baseCalendarID == null) continue;
            baseCalendarMap.put(calendar, baseCalendarID);
        }
        for (Map.Entry entry : baseCalendarMap.entrySet()) {
            ProjectCalendar baseCalendar = this.m_project.getCalendarByUniqueID((Integer)entry.getValue());
            if (baseCalendar == null) continue;
            ((ProjectCalendar)entry.getKey()).setParent(baseCalendar);
        }
    }

    public ProjectCalendar processCalendar(Row row) {
        String calendarData;
        ProjectCalendar calendar = this.m_project.addCalendar();
        Integer id = row.getInteger("clndr_id");
        calendar.setUniqueID(id);
        calendar.setName(row.getString("clndr_name"));
        calendar.setType(CalendarTypeHelper.getInstanceFromXer(row.getString("clndr_type")));
        calendar.setPersonal(row.getBoolean("rsrc_private"));
        if (row.getBoolean("default_flag") && this.m_project.getProjectProperties().getDefaultCalendarUniqueID() == null) {
            this.m_project.getProjectProperties().setDefaultCalendar(calendar);
        }
        if ((calendarData = row.getString("clndr_data")) != null && !calendarData.isEmpty()) {
            StructuredTextParser parser = new StructuredTextParser();
            parser.setRaiseExceptionOnParseError(false);
            StructuredTextRecord root = parser.parse(calendarData);
            StructuredTextRecord daysOfWeek = root.getChild("DaysOfWeek");
            StructuredTextRecord exceptions = root.getChild("Exceptions");
            if (daysOfWeek != null) {
                this.processCalendarDays(calendar, daysOfWeek);
            }
            if (exceptions != null) {
                this.processCalendarExceptions(calendar, exceptions);
            }
        }
        ProjectCalendarHelper.ensureWorkingTime(calendar);
        Double rowHoursPerDay = row.getDouble("day_hr_cnt");
        Double rowHoursPerWeek = row.getDouble("week_hr_cnt");
        Double rowHoursPerMonth = row.getDouble("month_hr_cnt");
        Double rowHoursPerYear = row.getDouble("year_hr_cnt");
        calendar.setCalendarMinutesPerDay((int)(NumberHelper.getDouble(rowHoursPerDay) * 60.0));
        calendar.setCalendarMinutesPerWeek((int)(NumberHelper.getDouble(rowHoursPerWeek) * 60.0));
        calendar.setCalendarMinutesPerMonth((int)(NumberHelper.getDouble(rowHoursPerMonth) * 60.0));
        calendar.setCalendarMinutesPerYear((int)(NumberHelper.getDouble(rowHoursPerYear) * 60.0));
        if (rowHoursPerDay == null || rowHoursPerWeek == null || rowHoursPerMonth == null || rowHoursPerYear == null) {
            int minutesPerWeek = 0;
            int workingDays = 0;
            for (DayOfWeek day : DayOfWeek.values()) {
                ProjectCalendarHours hours = calendar.getCalendarHours(day);
                if (hours == null || hours.isEmpty()) continue;
                ++workingDays;
                for (LocalTimeRange range : hours) {
                    minutesPerWeek = (int)((long)minutesPerWeek + range.getDurationAsMilliseconds() / 60000L);
                }
            }
            int minutesPerDay = minutesPerWeek / workingDays;
            int minutesPerMonth = minutesPerWeek * 4;
            int minutesPerYear = minutesPerMonth * 12;
            if (rowHoursPerDay == null) {
                calendar.setCalendarMinutesPerDay(minutesPerDay);
            }
            if (rowHoursPerWeek == null) {
                calendar.setCalendarMinutesPerWeek(minutesPerWeek);
            }
            if (rowHoursPerMonth == null) {
                calendar.setCalendarMinutesPerMonth(minutesPerMonth);
            }
            if (rowHoursPerYear == null) {
                calendar.setCalendarMinutesPerYear(minutesPerYear);
            }
        }
        this.m_eventManager.fireCalendarReadEvent(calendar);
        return calendar;
    }

    private void processCalendarDays(ProjectCalendar calendar, StructuredTextRecord daysOfWeek) {
        Map<DayOfWeek, StructuredTextRecord> days = daysOfWeek.getChildren().stream().filter(d -> DayOfWeekHelper.getInstance(Integer.parseInt(d.getRecordName())) != null).collect(Collectors.toMap(d -> DayOfWeekHelper.getInstance(Integer.parseInt(d.getRecordName())), d -> d));
        DayOfWeek[] dayOfWeekArray = DayOfWeek.values();
        int n = dayOfWeekArray.length;
        for (int i = 0; i < n; ++i) {
            DayOfWeek day;
            StructuredTextRecord dayRecord = days.get(day = dayOfWeekArray[i]);
            this.processCalendarHours(day, calendar, dayRecord == null ? StructuredTextRecord.EMPTY : dayRecord);
        }
    }

    private void processCalendarHours(DayOfWeek day, ProjectCalendar calendar, StructuredTextRecord dayRecord) {
        ProjectCalendarHours hours = calendar.addCalendarHours(day);
        List<StructuredTextRecord> recHours = dayRecord.getChildren();
        if (recHours.isEmpty()) {
            calendar.setWorkingDay(day, false);
        } else {
            calendar.setWorkingDay(day, true);
            for (StructuredTextRecord recWorkingHours : recHours) {
                this.addHours(hours, recWorkingHours);
            }
        }
    }

    private void addHours(ProjectCalendarHours ranges, StructuredTextRecord hoursRecord) {
        String startText = hoursRecord.getAttribute("s");
        String endText = hoursRecord.getAttribute("f");
        if (startText == null || endText == null || startText.isEmpty() || endText.isEmpty()) {
            return;
        }
        DateTimeFormatter formatter = startText.indexOf(32) == -1 ? this.m_twentyFourHourTimeFormat : this.m_twelveHourTimeFormat;
        try {
            LocalTime start = LocalTime.parse(startText, formatter);
            LocalTime end = LocalTime.parse(endText, formatter);
            ranges.add(new LocalTimeRange(start, end));
        }
        catch (DateTimeParseException ex) {
            if (this.m_ignoreErrors) {
                this.m_project.addIgnoredError(ex);
            }
            throw ex;
        }
    }

    private void processCalendarExceptions(ProjectCalendar calendar, StructuredTextRecord exceptions) {
        for (StructuredTextRecord exception : exceptions.getChildren()) {
            long daysFromEpoch;
            try {
                daysFromEpoch = Integer.parseInt(exception.getAttribute("d"));
            }
            catch (NumberFormatException ex) {
                if (this.m_ignoreErrors) {
                    this.m_project.addIgnoredError(ex);
                    continue;
                }
                throw ex;
            }
            LocalDate startEx = EXCEPTION_EPOCH.plusDays(daysFromEpoch);
            ProjectCalendarException pce = calendar.addCalendarException(startEx, startEx);
            for (StructuredTextRecord exceptionHours : exception.getChildren()) {
                this.addHours(pce, exceptionHours);
            }
        }
    }

    public void processResources(List<Row> rows) {
        for (Row row : rows) {
            Resource resource = this.m_project.addResource();
            this.processFields(this.m_resourceFields, row, resource);
            resource.setCalendar((ProjectCalendar)this.m_project.getCalendars().getByUniqueID(row.getInteger("clndr_id")));
            this.populateUserDefinedFieldValues("RSRC", FieldTypeClass.RESOURCE, resource, resource.getUniqueID());
            resource.setNotesObject(this.getNotes(resource.getNotes()));
            Double defaultUnitsPerTime = row.getDouble("def_qty_per_hr");
            defaultUnitsPerTime = defaultUnitsPerTime == null ? NumberHelper.DOUBLE_ZERO : Double.valueOf(defaultUnitsPerTime * 100.0);
            resource.setDefaultUnits(defaultUnitsPerTime);
            this.populateResourceCodeValues(resource);
            this.m_eventManager.fireResourceReadEvent(resource);
        }
    }

    public void processRoles(List<Row> rows) {
        for (Row row : rows) {
            Resource resource = this.m_project.addResource();
            this.processFields(this.m_roleFields, row, resource);
            resource.setRole(true);
            resource.setUniqueID(this.m_roleClashMap.addID(resource.getUniqueID()));
            resource.setNotesObject(this.getNotes(resource.getNotes()));
            this.populateRoleCodeValues(resource);
        }
    }

    private Notes getNotes(String text) {
        HtmlNotes notes = this.getHtmlNote(text);
        return notes == null || notes.isEmpty() ? null : notes;
    }

    private String nullIfEmpty(String text) {
        return text == null || text.isEmpty() ? null : text;
    }

    public void processResourceRates(List<Row> rows) {
        rows.sort((r1, r2) -> {
            Integer id2;
            Integer id1 = r1.getInteger("rsrc_id");
            int cmp = NumberHelper.compare(id1, id2 = r2.getInteger("rsrc_id"));
            if (cmp != 0) {
                return cmp;
            }
            LocalDateTime d1 = r1.getDate("start_date");
            LocalDateTime d2 = r2.getDate("start_date");
            return LocalDateTimeHelper.compare(d1, d2);
        });
        Resource resource = null;
        for (int i = 0; i < rows.size(); ++i) {
            Row row = rows.get(i);
            Integer resourceID = row.getInteger("rsrc_id");
            if (resource == null || !resource.getUniqueID().equals(resourceID)) {
                resource = this.m_project.getResourceByUniqueID(resourceID);
                if (resource == null) continue;
                resource.getCostRateTable(0).clear();
            }
            Rate[] values = new Rate[]{this.readRate(row.getDouble("cost_per_qty")), this.readRate(row.getDouble("cost_per_qty2")), this.readRate(row.getDouble("cost_per_qty3")), this.readRate(row.getDouble("cost_per_qty4")), this.readRate(row.getDouble("cost_per_qty5"))};
            Double costPerUse = NumberHelper.getDouble(0.0);
            Double maxUnits = NumberHelper.getDouble(NumberHelper.getDouble(row.getDouble("max_qty_per_hr")) * 100.0);
            ShiftPeriod period = (ShiftPeriod)this.m_project.getShiftPeriods().getByUniqueID(row.getInteger("shift_period_id"));
            LocalDateTime startDate = row.getDate("start_date");
            LocalDateTime endDate = LocalDateTimeHelper.END_DATE_NA;
            if (i + 1 < rows.size()) {
                Row nextRow = rows.get(i + 1);
                int nextResourceID = nextRow.getInt("rsrc_id");
                if (resourceID == nextResourceID) {
                    endDate = nextRow.getDate("start_date").minusMinutes(1L);
                }
            }
            if (startDate == null || startDate.isBefore(LocalDateTimeHelper.START_DATE_NA)) {
                startDate = LocalDateTimeHelper.START_DATE_NA;
            }
            if (endDate == null || endDate.isAfter(LocalDateTimeHelper.END_DATE_NA)) {
                endDate = LocalDateTimeHelper.END_DATE_NA;
            }
            resource.getCostRateTable(0).add(new CostRateTableEntry(startDate, endDate, (Number)costPerUse, period, values));
            resource.getAvailability().add(new Availability(startDate, endDate, maxUnits));
        }
    }

    private Rate readRate(Double value) {
        if (value == null) {
            return null;
        }
        return new Rate(value, TimeUnit.HOURS);
    }

    public void processRoleRates(List<Row> rows) {
        this.sortRoleTableRows(rows);
        Resource resource = null;
        for (int i = 0; i < rows.size(); ++i) {
            Row row = rows.get(i);
            Integer resourceID = this.m_roleClashMap.getID(row.getInteger("role_id"));
            if (resource == null || !resource.getUniqueID().equals(resourceID)) {
                resource = this.m_project.getResourceByUniqueID(resourceID);
                if (resource == null) continue;
                resource.getCostRateTable(0).clear();
            }
            Rate[] values = new Rate[]{this.readRate(row.getDouble("cost_per_qty")), this.readRate(row.getDouble("cost_per_qty2")), this.readRate(row.getDouble("cost_per_qty3")), this.readRate(row.getDouble("cost_per_qty4")), this.readRate(row.getDouble("cost_per_qty5"))};
            Double costPerUse = NumberHelper.getDouble(0.0);
            LocalDateTime startDate = row.getDate("start_date");
            LocalDateTime endDate = LocalDateTimeHelper.END_DATE_NA;
            if (i + 1 < rows.size()) {
                Row nextRow = rows.get(i + 1);
                if (NumberHelper.equals(row.getInteger("role_id"), nextRow.getInteger("role_id"))) {
                    endDate = nextRow.getDate("start_date").minusMinutes(1L);
                }
            }
            if (startDate == null || startDate.isBefore(LocalDateTimeHelper.START_DATE_NA)) {
                startDate = LocalDateTimeHelper.START_DATE_NA;
            }
            if (endDate == null || endDate.isAfter(LocalDateTimeHelper.END_DATE_NA)) {
                endDate = LocalDateTimeHelper.END_DATE_NA;
            }
            resource.getCostRateTable(0).add(new CostRateTableEntry(startDate, endDate, (Number)costPerUse, values));
        }
    }

    public void processRoleAvailability(List<Row> rows) {
        this.sortRoleTableRows(rows);
        Resource resource = null;
        for (int i = 0; i < rows.size(); ++i) {
            Row row = rows.get(i);
            Integer resourceID = this.m_roleClashMap.getID(row.getInteger("role_id"));
            if (resource == null || !resource.getUniqueID().equals(resourceID)) {
                resource = this.m_project.getResourceByUniqueID(resourceID);
                if (resource == null) continue;
                resource.getAvailability().clear();
            }
            Double maxUnits = NumberHelper.getDouble(NumberHelper.getDouble(row.getDouble("max_qty_per_hr")) * 100.0);
            LocalDateTime startDate = row.getDate("start_date");
            LocalDateTime endDate = LocalDateTimeHelper.END_DATE_NA;
            if (i + 1 < rows.size()) {
                Row nextRow = rows.get(i + 1);
                if (NumberHelper.equals(row.getInteger("role_id"), nextRow.getInteger("role_id"))) {
                    endDate = nextRow.getDate("start_date").minusMinutes(1L);
                }
            }
            if (startDate == null || startDate.isBefore(LocalDateTimeHelper.START_DATE_NA)) {
                startDate = LocalDateTimeHelper.START_DATE_NA;
            }
            if (endDate == null || endDate.isAfter(LocalDateTimeHelper.END_DATE_NA)) {
                endDate = LocalDateTimeHelper.END_DATE_NA;
            }
            resource.getAvailability().add(new Availability(startDate, endDate, maxUnits));
        }
    }

    private void sortRoleTableRows(List<Row> rows) {
        rows.sort((r1, r2) -> {
            Integer id2;
            Integer id1 = r1.getInteger("role_id");
            int cmp = NumberHelper.compare(id1, id2 = r2.getInteger("role_id"));
            if (cmp != 0) {
                return cmp;
            }
            LocalDateTime d1 = r1.getDate("start_date");
            LocalDateTime d2 = r2.getDate("start_date");
            return LocalDateTimeHelper.compare(d1, d2);
        });
    }

    public void processTasks(List<Row> wbs, List<Row> tasks, Map<Integer, Notes> wbsNotes, Map<Integer, Notes> taskNotes) {
        Task task;
        Task task2;
        ProjectProperties projectProperties = this.m_project.getProjectProperties();
        String projectName = projectProperties.getName();
        HashSet<Task> wbsTasks = new HashSet<Task>();
        boolean baselineFromCurrentProject = this.m_project.getProjectProperties().getBaselineProjectUniqueID() == null;
        for (Row row : wbs) {
            task2 = this.m_project.addTask();
            task2.setProject(projectName);
            task2.setSummary(true);
            this.processFields(this.m_wbsFields, row, task2);
            this.populateUserDefinedFieldValues("PROJWBS", FieldTypeClass.TASK, task2, task2.getUniqueID());
            task2.setNotesObject(wbsNotes.get(task2.getUniqueID()));
            this.m_activityClashMap.addID(task2.getUniqueID());
            wbsTasks.add(task2);
            this.m_eventManager.fireTaskReadEvent(task2);
        }
        this.m_project.getChildTasks().clear();
        for (Row row : wbs) {
            task2 = this.m_project.getTaskByUniqueID(row.getInteger("wbs_id"));
            Task parentTask = this.m_project.getTaskByUniqueID(row.getInteger("parent_wbs_id"));
            if (parentTask == null) {
                this.m_project.getChildTasks().add(task2);
            } else {
                parentTask.addChildTask(task2);
            }
            task2.setActivityID(task2.getWBS());
        }
        if (this.m_wbsIsFullPath) {
            this.m_project.getChildTasks().forEach(t -> this.populateWBS(null, (Task)t));
        }
        boolean forceCriticalToFalse = projectProperties.getCriticalActivityType() == CriticalActivityType.LONGEST_PATH;
        for (Row row : tasks) {
            Task task22;
            Integer parentTaskID = row.getInteger("wbs_id");
            Task parentTask = this.m_project.getTaskByUniqueID(parentTaskID);
            if (parentTask == null) {
                Task task3 = this.m_project.addTask();
            } else {
                task22 = parentTask.addTask();
            }
            task22.setProject(projectName);
            this.processFields(this.m_taskFields, row, task22);
            task22.setActualWork(WorkHelper.addWork(task22.getActualWorkLabor(), task22.getActualWorkNonlabor()));
            task22.setPlannedWork(WorkHelper.addWork(task22.getPlannedWorkLabor(), task22.getPlannedWorkNonlabor()));
            task22.setRemainingWork(WorkHelper.addWork(task22.getRemainingWorkLabor(), task22.getRemainingWorkNonlabor()));
            task22.setWork(WorkHelper.addWork(task22.getActualWork(), task22.getRemainingWork()));
            task22.setMilestone(BooleanHelper.getBoolean(MILESTONE_MAP.get(row.getString("task_type"))));
            task22.setActivityStatus(ActivityStatusHelper.getInstanceFromXer(row.getString("status_code")));
            task22.setActivityType(ActivityTypeHelper.getInstanceFromXer(row.getString("task_type")));
            task22.setIgnoreResourceCalendar(!"TT_Rsrc".equals(row.getString("task_type")));
            task22.setPercentCompleteType(PercentCompleteTypeHelper.getInstanceFromXer(row.getString("complete_pct_type")));
            task22.setPercentageWorkComplete(this.calculateUnitsPercentComplete(row));
            task22.setPercentageComplete(this.calculateDurationPercentComplete(row));
            task22.setPhysicalPercentComplete(this.calculatePhysicalPercentComplete(row));
            if (this.m_matchPrimaveraWBS && parentTask != null) {
                task22.setWBS(parentTask.getWBS());
            }
            Integer originalUniqueID = row.getInteger("task_id");
            this.populateUserDefinedFieldValues("TASK", FieldTypeClass.TASK, task22, originalUniqueID);
            this.populateActivityCodes(task22, originalUniqueID);
            task22.setNotesObject(taskNotes.get(originalUniqueID));
            task22.setUniqueID(this.m_activityClashMap.addID(originalUniqueID));
            Integer calId = row.getInteger("clndr_id");
            ProjectCalendar cal = this.m_project.getCalendarByUniqueID(calId);
            task22.setCalendar(cal);
            this.populateField(task22, TaskField.START, TaskField.ACTUAL_START, TaskField.REMAINING_EARLY_START, TaskField.PLANNED_START, TaskField.EARLY_START);
            this.populateField(task22, TaskField.FINISH, TaskField.ACTUAL_FINISH, TaskField.REMAINING_EARLY_FINISH, TaskField.PLANNED_FINISH, TaskField.EARLY_FINISH);
            LocalDateTime actualStart = task22.getActualStart();
            if (actualStart != null) {
                LocalDateTime finish = task22.getActualFinish();
                if (finish == null && (finish = this.m_project.getProjectProperties().getStatusDate()) != null && finish.isBefore(actualStart)) {
                    finish = actualStart;
                }
                if (finish != null) {
                    Duration actualDuration;
                    cal = task22.getEffectiveCalendar();
                    if (task22.getSuspendDate() == null || finish.isBefore(task22.getSuspendDate())) {
                        actualDuration = cal.getWork(actualStart, finish, TimeUnit.HOURS);
                    } else {
                        double actualHours = cal.getWork(actualStart, task22.getSuspendDate(), TimeUnit.HOURS).getDuration();
                        if (task22.getResume() != null && finish.isAfter(task22.getResume())) {
                            actualHours += cal.getWork(task22.getResume(), finish, TimeUnit.HOURS).getDuration();
                        }
                        actualDuration = Duration.getInstance(actualHours, TimeUnit.HOURS);
                    }
                    task22.setActualDuration(actualDuration);
                }
            }
            Duration durationAtCompletion = task22.getActualDuration() != null && task22.getActualDuration().getDuration() != 0.0 && task22.getRemainingDuration() != null && task22.getRemainingDuration().getDuration() != 0.0 ? task22.getEffectiveCalendar().getWork(task22.getStart(), task22.getFinish(), TimeUnit.HOURS) : (task22.getActualDuration() != null && task22.getActualDuration().getDuration() != 0.0 ? task22.getActualDuration() : task22.getRemainingDuration());
            task22.setDuration(durationAtCompletion);
            if (forceCriticalToFalse) {
                task22.setCritical(false);
            } else {
                task22.getCritical();
            }
            if (baselineFromCurrentProject) {
                this.populateBaselineFromCurrentProject(task22);
            }
            SlackHelper.inferSlack(task22);
            this.m_eventManager.fireTaskReadEvent(task22);
        }
        new ActivitySorter(wbsTasks).sort(this.m_project);
        this.updateStructure();
        if (this.m_project.getChildTasks().size() == 1 && (task = this.m_project.getChildTasks().get(0)).getSummary()) {
            projectProperties.setName(task.getName());
        }
    }

    private void populateWBS(Task parent, Task task) {
        if (parent != null) {
            task.setWBS(parent.getWBS() + this.m_project.getProjectProperties().getWbsCodeSeparator() + task.getWBS());
            task.setActivityID(task.getWBS());
        }
        task.getChildTasks().forEach(t -> this.populateWBS(task, (Task)t));
    }

    private void populateBaselineFromCurrentProject(Task task) {
        task.setBaselineCost(task.getPlannedCost());
        task.setBaselineDuration(task.getPlannedDuration());
        task.setBaselineFinish(task.getPlannedFinish());
        task.setBaselineStart(task.getPlannedStart());
        task.setBaselineWork(task.getPlannedWork());
    }

    private void populateActivityCodes(Task task, Integer uniqueID) {
        List<Row> list = this.m_activityCodeAssignments.get(uniqueID);
        if (list == null) {
            return;
        }
        for (Row row : list) {
            ActivityCodeValue value;
            ActivityCode code = (ActivityCode)this.m_project.getActivityCodes().getByUniqueID(row.getInteger("actv_code_type_id"));
            if (code == null || (value = code.getValueByUniqueID(row.getInteger("actv_code_id"))) == null) continue;
            task.addActivityCodeValue(value);
        }
    }

    private void populateResourceCodeValues(Resource resource) {
        List<Row> list = this.m_resourceCodeAssignments.get(resource.getUniqueID());
        if (list == null) {
            return;
        }
        for (Row row : list) {
            ResourceCodeValue value;
            ResourceCode code = (ResourceCode)this.m_project.getResourceCodes().getByUniqueID(row.getInteger("rsrc_catg_type_id"));
            if (code == null || (value = code.getValueByUniqueID(row.getInteger("rsrc_catg_id"))) == null) continue;
            resource.addResourceCodeValue(value);
        }
    }

    private void populateRoleCodeValues(Resource role) {
        List<Row> list = this.m_roleCodeAssignments.get(role.getUniqueID());
        if (list == null) {
            return;
        }
        for (Row row : list) {
            RoleCodeValue value;
            RoleCode code = (RoleCode)this.m_project.getRoleCodes().getByUniqueID(row.getInteger("role_catg_type_id"));
            if (code == null || (value = code.getValueByUniqueID(row.getInteger("role_catg_id"))) == null) continue;
            role.addRoleCodeValue(value);
        }
    }

    private void populateResourceAssignmentCodeValues(ResourceAssignment resourceAssignment) {
        List<Row> list = this.m_resourceAssignmentCodeAssignments.get(resourceAssignment.getUniqueID());
        if (list == null) {
            return;
        }
        for (Row row : list) {
            ResourceAssignmentCodeValue value;
            ResourceAssignmentCode code = (ResourceAssignmentCode)this.m_project.getResourceAssignmentCodes().getByUniqueID(row.getInteger("asgnmnt_catg_type_id"));
            if (code == null || (value = code.getValueByUniqueID(row.getInteger("asgnmnt_catg_id"))) == null) continue;
            resourceAssignment.addResourceAssignmentCodeValue(value);
        }
    }

    private void addUDFValue(FieldTypeClass fieldType, FieldContainer container, Row row) {
        Object value;
        Integer fieldId = row.getInteger("udf_type_id");
        UserDefinedField field = this.m_project.getUserDefinedFields().getByUniqueID(fieldId);
        if (field == null) {
            return;
        }
        DataType fieldDataType = field.getDataType();
        switch (fieldDataType) {
            case DATE: {
                value = row.getDate("udf_date");
                break;
            }
            case CURRENCY: 
            case NUMERIC: {
                value = row.getDouble("udf_number");
                break;
            }
            case INTEGER: {
                value = row.getInteger("udf_number");
                break;
            }
            default: {
                value = row.getString("udf_text");
            }
        }
        container.set(field, value);
    }

    private void populateUserDefinedFieldValues(String tableName, FieldTypeClass type, FieldContainer container, Integer uniqueID) {
        List<Row> udf;
        Map<Integer, List<Row>> tableData = this.m_udfValues.get(tableName);
        if (tableData != null && (udf = tableData.get(uniqueID)) != null) {
            for (Row r : udf) {
                this.addUDFValue(type, container, r);
            }
        }
    }

    public void processNotebookTopics(List<Row> rows) {
        rows.forEach(this::processNotebookTopic);
    }

    private void processNotebookTopic(Row row) {
        NotesTopic topic = new NotesTopic.Builder(this.m_project).uniqueID(row.getInteger("memo_type_id")).sequenceNumber(row.getInteger("seq_num")).availableForEPS(row.getBoolean("eps_flag")).availableForProject(row.getBoolean("proj_flag")).availableForWBS(row.getBoolean("wbs_flag")).availableForActivity(row.getBoolean("task_flag")).name(row.getString("memo_type")).build();
        this.m_project.getNotesTopics().add(topic);
    }

    public Map<Integer, Notes> getNotes(List<Row> rows, String uniqueIDColumn, String entityIdColumn, String textColumn) {
        Map map = rows.stream().sorted(Comparator.comparing(r -> r.getInteger(uniqueIDColumn))).collect(Collectors.groupingBy(r -> r.getInteger(entityIdColumn), Collectors.mapping(r -> r, Collectors.toList())));
        NotesTopicContainer topics = this.m_project.getNotesTopics();
        HashMap<Integer, Notes> result = new HashMap<Integer, Notes>();
        for (Map.Entry entry : map.entrySet()) {
            ArrayList<Notes> list = new ArrayList<Notes>();
            for (Row row : entry.getValue()) {
                HtmlNotes notes = this.getHtmlNote(row.getString(textColumn));
                if (notes == null || notes.isEmpty()) continue;
                NotesTopic topic = (NotesTopic)topics.getByUniqueID(row.getInteger("memo_type_id"));
                if (topic == null) {
                    topic = topics.getDefaultTopic();
                }
                list.add(new StructuredNotes(this.m_project, row.getInteger(uniqueIDColumn), topic, notes));
            }
            result.put(entry.getKey(), new ParentNotes(list));
        }
        return result;
    }

    private HtmlNotes getHtmlNote(String text) {
        if (text == null) {
            return null;
        }
        String html = text.replaceAll("[\\uFEFF\\uFFFE\\x00]", "");
        HtmlNotes result = new HtmlNotes(html = html.replaceAll("\\x7F\\x7F", "\n"));
        return result.isEmpty() ? null : result;
    }

    private void populateField(FieldContainer container, FieldType target, FieldType ... types) {
        for (FieldType type : types) {
            Object value = container.getCachedValue(type);
            if (value == null) continue;
            container.set(target, value);
            break;
        }
    }

    private void updateStructure() {
        int id = 1;
        Integer outlineLevel = 1;
        for (Task task : this.m_project.getChildTasks()) {
            id = this.updateStructure(id, task, outlineLevel);
        }
    }

    private int updateStructure(int id, Task task, Integer outlineLevel) {
        task.setID(id++);
        task.setOutlineLevel(outlineLevel);
        outlineLevel = outlineLevel + 1;
        for (Task childTask : task.getChildTasks()) {
            id = this.updateStructure(id, childTask, outlineLevel);
        }
        return id;
    }

    private ProjectCalendar rollupCalendars(Task task) {
        ProjectCalendar result = null;
        if (task.hasChildTasks()) {
            ProjectCalendar firstCalendar;
            List calendars = task.getChildTasks().stream().map(this::rollupCalendars).distinct().collect(Collectors.toList());
            if (calendars.size() == 1 && (firstCalendar = (ProjectCalendar)calendars.get(0)) != null && firstCalendar != this.m_project.getDefaultCalendar()) {
                result = firstCalendar;
                task.setCalendar(result);
            }
        } else {
            result = task.getCalendar();
        }
        return result;
    }

    private void rollupDates(Task parentTask) {
        if (parentTask.hasChildTasks()) {
            int finished = 0;
            LocalDateTime startDate = parentTask.getStart();
            LocalDateTime finishDate = parentTask.getFinish();
            LocalDateTime plannedStartDate = parentTask.getPlannedStart();
            LocalDateTime plannedFinishDate = parentTask.getPlannedFinish();
            LocalDateTime actualStartDate = parentTask.getActualStart();
            LocalDateTime actualFinishDate = parentTask.getActualFinish();
            LocalDateTime earlyStartDate = parentTask.getEarlyStart();
            LocalDateTime earlyFinishDate = parentTask.getEarlyFinish();
            LocalDateTime lateStartDate = parentTask.getLateStart();
            LocalDateTime lateFinishDate = parentTask.getLateFinish();
            LocalDateTime baselineStartDate = parentTask.getBaselineStart();
            LocalDateTime baselineFinishDate = parentTask.getBaselineFinish();
            LocalDateTime remainingEarlyStartDate = parentTask.getRemainingEarlyStart();
            LocalDateTime remainingEarlyFinishDate = parentTask.getRemainingEarlyFinish();
            LocalDateTime remainingLateStartDate = parentTask.getRemainingLateStart();
            LocalDateTime remainingLateFinishDate = parentTask.getRemainingLateFinish();
            boolean critical = false;
            for (Task task : parentTask.getChildTasks()) {
                this.rollupDates(task);
                startDate = LocalDateTimeHelper.min(startDate, task.getStart());
                finishDate = LocalDateTimeHelper.max(finishDate, task.getFinish());
                plannedStartDate = LocalDateTimeHelper.min(plannedStartDate, task.getPlannedStart());
                plannedFinishDate = LocalDateTimeHelper.max(plannedFinishDate, task.getPlannedFinish());
                actualStartDate = LocalDateTimeHelper.min(actualStartDate, task.getActualStart());
                actualFinishDate = LocalDateTimeHelper.max(actualFinishDate, task.getActualFinish());
                earlyStartDate = LocalDateTimeHelper.min(earlyStartDate, task.getEarlyStart());
                earlyFinishDate = LocalDateTimeHelper.max(earlyFinishDate, task.getEarlyFinish());
                remainingEarlyStartDate = LocalDateTimeHelper.min(remainingEarlyStartDate, task.getRemainingEarlyStart());
                remainingEarlyFinishDate = LocalDateTimeHelper.max(remainingEarlyFinishDate, task.getRemainingEarlyFinish());
                lateStartDate = LocalDateTimeHelper.min(lateStartDate, task.getLateStart());
                lateFinishDate = LocalDateTimeHelper.max(lateFinishDate, task.getLateFinish());
                remainingLateStartDate = LocalDateTimeHelper.min(remainingLateStartDate, task.getRemainingLateStart());
                remainingLateFinishDate = LocalDateTimeHelper.max(remainingLateFinishDate, task.getRemainingLateFinish());
                baselineStartDate = LocalDateTimeHelper.min(baselineStartDate, task.getBaselineStart());
                baselineFinishDate = LocalDateTimeHelper.max(baselineFinishDate, task.getBaselineFinish());
                if (task.getActualFinish() != null) {
                    ++finished;
                }
                critical = critical || task.getCritical();
            }
            parentTask.setStart(startDate);
            parentTask.setFinish(finishDate);
            parentTask.setPlannedStart(plannedStartDate);
            parentTask.setPlannedFinish(plannedFinishDate);
            parentTask.setActualStart(actualStartDate);
            parentTask.setEarlyStart(earlyStartDate);
            parentTask.setEarlyFinish(earlyFinishDate);
            parentTask.setRemainingEarlyStart(remainingEarlyStartDate);
            parentTask.setRemainingEarlyFinish(remainingEarlyFinishDate);
            parentTask.setLateStart(lateStartDate);
            parentTask.setLateFinish(lateFinishDate);
            parentTask.setRemainingLateStart(remainingLateStartDate);
            parentTask.setRemainingLateFinish(remainingLateFinishDate);
            parentTask.setBaselineStart(baselineStartDate);
            parentTask.setBaselineFinish(baselineFinishDate);
            if (finished == parentTask.getChildTasks().size()) {
                parentTask.setActualFinish(actualFinishDate);
            }
            Duration plannedDuration = null;
            if (plannedStartDate != null && plannedFinishDate != null) {
                plannedDuration = parentTask.getEffectiveCalendar().getWork(plannedStartDate, plannedFinishDate, TimeUnit.HOURS);
                parentTask.setPlannedDuration(plannedDuration);
            }
            Duration actualDuration = null;
            Duration remainingDuration = null;
            if (parentTask.getActualFinish() == null) {
                LocalDateTime taskFinishDate;
                LocalDateTime taskStartDate = parentTask.getRemainingEarlyStart();
                if (taskStartDate == null && (taskStartDate = parentTask.getEarlyStart()) == null) {
                    taskStartDate = plannedStartDate;
                }
                if ((taskFinishDate = parentTask.getRemainingEarlyFinish()) == null && (taskFinishDate = parentTask.getEarlyFinish()) == null) {
                    taskFinishDate = plannedFinishDate;
                }
                if (taskStartDate != null) {
                    if (parentTask.getActualStart() != null) {
                        actualDuration = parentTask.getEffectiveCalendar().getWork(parentTask.getActualStart(), taskStartDate, TimeUnit.HOURS);
                    }
                    if (taskFinishDate != null) {
                        remainingDuration = parentTask.getEffectiveCalendar().getWork(taskStartDate, taskFinishDate, TimeUnit.HOURS);
                    }
                }
            } else {
                actualDuration = parentTask.getEffectiveCalendar().getWork(parentTask.getActualStart(), parentTask.getActualFinish(), TimeUnit.HOURS);
                remainingDuration = Duration.getInstance(0, TimeUnit.HOURS);
            }
            if (actualDuration != null && actualDuration.getDuration() < 0.0) {
                actualDuration = null;
            }
            if (remainingDuration != null && remainingDuration.getDuration() < 0.0) {
                remainingDuration = null;
            }
            parentTask.setActualDuration(actualDuration);
            parentTask.setRemainingDuration(remainingDuration);
            parentTask.setDuration(Duration.add(actualDuration, remainingDuration, parentTask.getEffectiveCalendar()));
            if (plannedDuration != null && remainingDuration != null && plannedDuration.getDuration() != 0.0) {
                double durationPercentComplete = (plannedDuration.getDuration() - remainingDuration.getDuration()) / plannedDuration.getDuration() * 100.0;
                if (durationPercentComplete < 0.0) {
                    durationPercentComplete = 0.0;
                } else if (durationPercentComplete > 100.0) {
                    durationPercentComplete = 100.0;
                }
                parentTask.setPercentageComplete(durationPercentComplete);
                parentTask.setPercentCompleteType(PercentCompleteType.DURATION);
            }
            parentTask.getTotalSlack();
            parentTask.setCritical(critical);
        }
    }

    private void rollupWork(Task parentTask) {
        if (parentTask.hasChildTasks()) {
            ProjectCalendar calendar = parentTask.getEffectiveCalendar();
            Duration actualWork = null;
            Duration plannedWork = null;
            Duration remainingWork = null;
            Duration work = null;
            for (Task task : parentTask.getChildTasks()) {
                this.rollupWork(task);
                actualWork = Duration.add(actualWork, task.getActualWork(), calendar);
                plannedWork = Duration.add(plannedWork, task.getPlannedWork(), calendar);
                remainingWork = Duration.add(remainingWork, task.getRemainingWork(), calendar);
                work = Duration.add(work, task.getWork(), calendar);
            }
            parentTask.setActualWork(actualWork);
            parentTask.setPlannedWork(plannedWork);
            parentTask.setRemainingWork(remainingWork);
            parentTask.setWork(work);
        }
    }

    public void processPredecessors(List<Row> rows) {
        for (Row row : rows) {
            Object relation;
            Integer uniqueID = row.getInteger("task_pred_id");
            if (uniqueID == null) {
                uniqueID = this.m_relationObjectID.getNext();
            }
            Integer successorID = this.m_activityClashMap.getID(row.getInteger("task_id"));
            Integer predecessorID = this.m_activityClashMap.getID(row.getInteger("pred_task_id"));
            Task successorTask = this.m_project.getTaskByUniqueID(successorID);
            Task predecessorTask = this.m_project.getTaskByUniqueID(predecessorID);
            RelationType type = RelationTypeHelper.getInstanceFromXer(row.getString("pred_type"));
            Duration lag = row.getDuration("lag_hr_cnt");
            String comments = this.nullIfEmpty(row.getString("comments"));
            if (successorTask != null && predecessorTask != null) {
                relation = successorTask.addPredecessor(new Relation.Builder().predecessorTask(predecessorTask).type(type).lag(lag).uniqueID(uniqueID).notes(comments));
                this.m_eventManager.fireRelationReadEvent((Relation)relation);
                continue;
            }
            if (successorTask != null && predecessorTask == null) {
                relation = new ExternalRelation(uniqueID, predecessorID, successorTask, type, lag, true, comments);
                this.m_externalRelations.add((ExternalRelation)relation);
                continue;
            }
            if (successorTask != null || predecessorTask == null) continue;
            relation = new ExternalRelation(uniqueID, successorID, predecessorTask, type, lag, false, comments);
            this.m_externalRelations.add((ExternalRelation)relation);
        }
    }

    public void processAssignments(List<Row> rows) {
        for (Row row : rows) {
            Task task = this.m_project.getTaskByUniqueID(this.m_activityClashMap.getID(row.getInteger("task_id")));
            Integer roleID = this.m_roleClashMap.getID(row.getInteger("role_id"));
            Integer resourceID = row.getInteger("rsrc_id");
            if (resourceID == null && roleID != null) {
                resourceID = roleID;
                roleID = null;
            }
            Resource resource = this.m_project.getResourceByUniqueID(resourceID);
            if (task == null || resource == null) continue;
            ProjectCalendar effectiveCalendar = task.getEffectiveCalendar();
            ResourceAssignment assignment = task.addResourceAssignment(resource);
            this.processFields(this.m_assignmentFields, row, assignment);
            assignment.setWorkContour(CurveHelper.getWorkContour(this.m_project, row.getInteger("curv_id")));
            assignment.setRateIndex(RateTypeHelper.getInstanceFromXer(row.getString("rate_type")));
            assignment.setRole(this.m_project.getResourceByUniqueID(roleID));
            assignment.setOverrideRate(this.readRate(row.getDouble("cost_per_qty")));
            assignment.setRateSource(RateSourceHelper.getInstanceFromXer(row.getString("cost_per_qty_source_type")));
            this.populateField(assignment, AssignmentField.START, AssignmentField.ACTUAL_START, AssignmentField.REMAINING_EARLY_START, AssignmentField.PLANNED_START);
            this.populateField(assignment, AssignmentField.FINISH, AssignmentField.ACTUAL_FINISH, AssignmentField.REMAINING_EARLY_FINISH, AssignmentField.PLANNED_FINISH);
            Duration remainingWork = assignment.getRemainingWork();
            Duration actualRegularWork = row.getDuration("act_reg_qty");
            Duration actualOvertimeWork = assignment.getActualOvertimeWork();
            Duration actualWork = Duration.add(actualRegularWork, actualOvertimeWork, effectiveCalendar);
            assignment.setActualWork(actualWork);
            Duration totalWork = Duration.add(actualWork, remainingWork, effectiveCalendar);
            assignment.setWork(totalWork);
            Number remainingCost = assignment.getRemainingCost();
            Double actualRegularCost = row.getDouble("act_reg_cost");
            Number actualOvertimeCost = assignment.getActualOvertimeCost();
            Double actualCost = NumberHelper.sumAsDouble(actualRegularCost, actualOvertimeCost);
            assignment.setActualCost(actualCost);
            Double totalCost = NumberHelper.sumAsDouble(actualCost, remainingCost);
            assignment.setCost(totalCost);
            task.setPlannedCost(NumberHelper.sumAsDouble(task.getPlannedCost(), assignment.getPlannedCost()));
            task.setActualCost(NumberHelper.sumAsDouble(task.getActualCost(), assignment.getActualCost()));
            task.setRemainingCost(NumberHelper.sumAsDouble(task.getRemainingCost(), assignment.getRemainingCost()));
            task.setCost(NumberHelper.sumAsDouble(task.getCost(), assignment.getCost()));
            assignment.setUnits(NumberHelper.getDouble(row.getDouble("target_qty_per_hr")) * 100.0);
            assignment.setRemainingUnits(NumberHelper.getDouble(row.getDouble("remain_qty_per_hr")) * 100.0);
            this.populateUserDefinedFieldValues("TASKRSRC", FieldTypeClass.ASSIGNMENT, assignment, assignment.getUniqueID());
            assignment.setTimephasedPlannedWork(TimephasedHelper.read(effectiveCalendar, assignment.getPlannedStart(), row.getString("target_crv")));
            assignment.setTimephasedActualWork(TimephasedHelper.read(effectiveCalendar, assignment.getActualStart(), row.getString("actual_crv")));
            assignment.setTimephasedWork(TimephasedHelper.read(effectiveCalendar, assignment.getRemainingEarlyStart(), row.getString("remain_crv")));
            this.populateResourceAssignmentCodeValues(assignment);
            this.m_eventManager.fireAssignmentReadEvent(assignment);
        }
    }

    public void rollupValues() {
        this.m_project.getChildTasks().forEach(this::rollupCalendars);
        this.m_project.getChildTasks().forEach(this::rollupDates);
        this.m_project.getChildTasks().forEach(this::rollupWork);
        this.m_project.getChildTasks().forEach(this::rollupCosts);
        if (this.m_project.getProjectProperties().getBaselineProjectUniqueID() == null) {
            this.m_project.getTasks().stream().filter(Task::getSummary).forEach(this::populateBaselineFromCurrentProject);
        }
    }

    private void rollupCosts(Task parentTask) {
        if (parentTask.hasChildTasks()) {
            double plannedCost = 0.0;
            double actualCost = 0.0;
            double remainingCost = 0.0;
            double cost = 0.0;
            double fixedCost = 0.0;
            for (Task child : parentTask.getChildTasks()) {
                this.rollupCosts(child);
                plannedCost += NumberHelper.getDouble(child.getPlannedCost());
                actualCost += NumberHelper.getDouble(child.getActualCost());
                remainingCost += NumberHelper.getDouble(child.getRemainingCost());
                cost += NumberHelper.getDouble(child.getCost());
                fixedCost += NumberHelper.getDouble(child.getFixedCost());
            }
            parentTask.setPlannedCost(NumberHelper.getDouble(plannedCost));
            parentTask.setActualCost(NumberHelper.getDouble(actualCost));
            parentTask.setRemainingCost(NumberHelper.getDouble(remainingCost));
            parentTask.setCost(NumberHelper.getDouble(cost));
            parentTask.setFixedCost(NumberHelper.getDouble(fixedCost));
        }
    }

    public void processDefaultCurrency(Row row) {
        ProjectProperties properties = this.m_project.getProjectProperties();
        properties.setCurrencySymbol(row.getString("curr_symbol"));
        properties.setSymbolPosition(CURRENCY_SYMBOL_POSITION_MAP.get(row.getString("pos_curr_fmt_type")));
        properties.setCurrencyDigits(row.getInteger("decimal_digit_cnt"));
        properties.setThousandsSeparator(row.getString("digit_group_symbol").charAt(0));
        properties.setDecimalSeparator(row.getString("decimal_symbol").charAt(0));
    }

    public void processExpenseItems(List<Row> rows) {
        for (Row row : rows) {
            Task task = this.m_project.getTaskByUniqueID(this.m_activityClashMap.getID(row.getInteger("task_id")));
            if (task == null) continue;
            Double actualCost = row.getDouble("act_cost");
            Double remainingCost = row.getDouble("remain_cost");
            Double pricePerUnit = row.getDouble("cost_per_qty");
            ExpenseItem.Builder builder = new ExpenseItem.Builder(task).account((CostAccount)this.m_project.getCostAccounts().getByUniqueID(row.getInteger("acct_id"))).accrueType(AccrueTypeHelper.getInstanceFromXer(row.getString("cost_load_type"))).actualCost(actualCost).autoComputeActuals(row.getBoolean("auto_compute_act_flag")).category((ExpenseCategory)this.m_project.getExpenseCategories().getByUniqueID(row.getInteger("cost_type_id"))).description(row.getString("cost_descr")).documentNumber(row.getString("po_number")).name(row.getString("cost_name")).plannedCost(row.getDouble("target_cost")).plannedUnits(row.getDouble("target_qty")).pricePerUnit(pricePerUnit).remainingCost(remainingCost).uniqueID(row.getInteger("cost_item_id")).unitOfMeasure(row.getString("qty_name")).vendor(row.getString("vendor_name")).atCompletionCost(NumberHelper.sumAsDouble(actualCost, remainingCost));
            double pricePerUnitValue = NumberHelper.getDouble(pricePerUnit);
            if (pricePerUnitValue != 0.0) {
                Double actualUnits = NumberHelper.getDouble(actualCost) / pricePerUnitValue;
                Double remainingUnits = NumberHelper.getDouble(remainingCost) / pricePerUnitValue;
                builder.actualUnits(actualUnits).remainingUnits(remainingUnits).atCompletionUnits(NumberHelper.sumAsDouble(actualUnits, remainingUnits));
            }
            ExpenseItem ei = builder.build();
            task.getExpenseItems().add(ei);
            task.setPlannedCost(NumberHelper.sumAsDouble(task.getPlannedCost(), ei.getPlannedCost()));
            task.setActualCost(NumberHelper.sumAsDouble(task.getActualCost(), ei.getActualCost()));
            task.setRemainingCost(NumberHelper.sumAsDouble(task.getRemainingCost(), ei.getRemainingCost()));
            task.setCost(NumberHelper.sumAsDouble(task.getCost(), ei.getAtCompletionCost()));
            task.setFixedCost(NumberHelper.sumAsDouble(task.getFixedCost(), ei.getAtCompletionCost()));
        }
    }

    public void processActivitySteps(List<Row> rows) {
        for (Row row : rows) {
            Task task = this.m_project.getTaskByUniqueID(this.m_activityClashMap.getID(row.getInteger("task_id")));
            if (task == null) continue;
            Step step = new Step.Builder(task).uniqueID(row.getInteger("proc_id")).name(row.getString("proc_name")).percentComplete(row.getDouble("complete_pct")).sequenceNumber(row.getInteger("seq_num")).weight(row.getDouble("proc_wt")).description(this.getNotes(row.getString("proc_descr"))).build();
            task.getSteps().add(step);
        }
    }

    public void processScheduleOptions(Row row) {
        ProjectProperties projectProperties = this.m_project.getProjectProperties();
        projectProperties.setConsiderAssignmentsInOtherProjects(row.getBoolean("level_outer_assign_flag"));
        projectProperties.setConsiderAssignmentsInOtherProjectsWithPriorityEqualHigherThan(NumberHelper.getInteger(row.getString("level_outer_assign_priority")));
        projectProperties.setPreserveScheduledEarlyAndLateDates(row.getBoolean("level_keep_sched_date_flag"));
        projectProperties.setLevelAllResources(row.getBoolean("level_all_rsrc_flag"));
        projectProperties.setLevelResourcesOnlyWithinActivityTotalFloat(row.getBoolean("level_within_float_flag"));
        projectProperties.setPreserveMinimumFloatWhenLeveling(Duration.getInstance(NumberHelper.getInt(row.getString("level_float_thrs_cnt")), TimeUnit.HOURS));
        projectProperties.setMaxPercentToOverallocateResources(NumberHelper.getDoubleObject(row.getString("level_over_alloc_pct")));
        projectProperties.setLevelingPriorities(row.getString("levelprioritylist"));
        projectProperties.setDataDateAndPlannedStartSetToProjectForecastStart(row.getBoolean("sched_setplantoforecast"));
        projectProperties.setIgnoreRelationshipsToAndFromOtherProjects("SD_None".equals(row.getString("sched_outer_depend_type")));
        projectProperties.setMakeOpenEndedActivitiesCritical(row.getBoolean("sched_open_critical_flag"));
        projectProperties.setUseExpectedFinishDates(row.getBoolean("sched_use_expect_end_flag"));
        projectProperties.setSchedulingProgressedActivities(row.getBoolean("sched_retained_logic") ? SchedulingProgressedActivities.RETAINED_LOGIC : (row.getBoolean("sched_progress_override") ? SchedulingProgressedActivities.PROGRESS_OVERRIDE : SchedulingProgressedActivities.ACTUAL_DATES));
        projectProperties.setComputeStartToStartLagFromEarlyStart(row.getBoolean("sched_lag_early_start_flag"));
        projectProperties.setCalculateFloatBasedOnFinishDateOfEachProject(row.getBoolean("sched_use_project_end_date_for_float"));
        projectProperties.setTotalSlackCalculationType(TotalSlackCalculationTypeHelper.getInstanceFromXer(row.getString("sched_float_type")));
        projectProperties.setRelationshipLagCalendar(RelationshipLagCalendarHelper.getInstanceFromXer(row.getString("sched_calendar_on_relationship_lag")));
        projectProperties.setCalculateMultipleFloatPaths(row.getBoolean("enable_multiple_longest_path_calc"));
        projectProperties.setCalculateMultipleFloatPathsUsingTotalFloat(row.getBoolean("use_total_float_multiple_longest_paths"));
        projectProperties.setDisplayMultipleFloatPathsEndingWithActivityUniqueID(NumberHelper.getInteger(row.getString("key_activity_for_multiple_longest_paths")));
        projectProperties.setLimitNumberOfFloatPathsToCalculate(row.getBoolean("limit_multiple_longest_path_calc"));
        projectProperties.setMaximumNumberOfFloatPathsToCalculate(NumberHelper.getInteger(row.getString("max_multiple_longest_path")));
    }

    public void processRoleAssignments(List<Row> rows) {
        for (Row row : rows) {
            Resource role;
            Resource resource;
            Integer skillLevel;
            Integer roleID;
            Integer resourceID = row.getInteger("rsrc_id");
            if (resourceID == null || (roleID = row.getInteger("role_id")) == null || (skillLevel = row.getInteger("skill_level")) == null || (resource = this.m_project.getResourceByUniqueID(resourceID)) == null || (role = this.m_project.getResourceByUniqueID(roleID)) == null) continue;
            resource.addRoleAssignment(role, SkillLevelHelper.getInstanceFromXer(skillLevel));
        }
    }

    private void processFields(Map<FieldType, String> map, Row row, FieldContainer container) {
        for (Map.Entry<FieldType, String> entry : map.entrySet()) {
            Object value;
            FieldType field = entry.getKey();
            String name = entry.getValue();
            switch (field.getDataType()) {
                case INTEGER: {
                    value = row.getInteger(name);
                    break;
                }
                case BOOLEAN: {
                    value = row.getBooleanObject(name);
                    break;
                }
                case DATE: {
                    value = row.getDate(name);
                    break;
                }
                case CURRENCY: 
                case NUMERIC: 
                case PERCENTAGE: {
                    value = row.getDouble(name);
                    break;
                }
                case DELAY: 
                case WORK: 
                case DURATION: {
                    value = row.getDuration(name);
                    break;
                }
                case RESOURCE_TYPE: {
                    value = ResourceTypeHelper.getInstanceFromXer(row.getString(name));
                    break;
                }
                case TASK_TYPE: {
                    value = TaskTypeHelper.getInstanceFromXer(row.getString(name));
                    break;
                }
                case CONSTRAINT: {
                    value = ConstraintTypeHelper.getInstanceFromXer(row.getString(name));
                    break;
                }
                case PRIORITY: {
                    value = PriorityHelper.getInstanceFromXer(row.getString(name));
                    break;
                }
                case GUID: {
                    value = row.getUUID(name);
                    break;
                }
                default: {
                    value = row.getString(name);
                }
            }
            container.set(field, value);
        }
    }

    private Number calculatePhysicalPercentComplete(Row row) {
        return row.getDouble("phys_complete_pct");
    }

    private Number calculateUnitsPercentComplete(Row row) {
        double actualEquipmentQuantity;
        double result = 0.0;
        double actualWorkQuantity = NumberHelper.getDouble(row.getDouble("act_work_qty"));
        double numerator = actualWorkQuantity + (actualEquipmentQuantity = NumberHelper.getDouble(row.getDouble("act_equip_qty")));
        if (numerator != 0.0) {
            double remainingEquipmentQuantity;
            double remainingWorkQuantity = NumberHelper.getDouble(row.getDouble("remain_work_qty"));
            double denominator = remainingWorkQuantity + actualWorkQuantity + (remainingEquipmentQuantity = NumberHelper.getDouble(row.getDouble("remain_equip_qty"))) + actualEquipmentQuantity;
            result = denominator == 0.0 ? 0.0 : numerator * 100.0 / denominator;
        }
        return NumberHelper.getDouble(result);
    }

    private Number calculateDurationPercentComplete(Row row) {
        double result = 0.0;
        double targetDuration = NumberHelper.getDouble(row.getDouble("target_drtn_hr_cnt"));
        double remainingDuration = NumberHelper.getDouble(row.getDouble("remain_drtn_hr_cnt"));
        if (targetDuration == 0.0) {
            if (remainingDuration == 0.0 && "TK_Complete".equals(row.getString("status_code"))) {
                result = 100.0;
            }
        } else if (remainingDuration < targetDuration) {
            result = (targetDuration - remainingDuration) * 100.0 / targetDuration;
        }
        return NumberHelper.getDouble(result);
    }

    public static Map<FieldType, String> getDefaultResourceFieldMap() {
        LinkedHashMap<FieldType, String> map = new LinkedHashMap<FieldType, String>();
        map.put(ResourceField.UNIQUE_ID, "rsrc_id");
        map.put(ResourceField.GUID, "guid");
        map.put(ResourceField.NAME, "rsrc_name");
        map.put(ResourceField.CODE, "employee_code");
        map.put(ResourceField.EMAIL_ADDRESS, "email_addr");
        map.put(ResourceField.NOTES, "rsrc_notes");
        map.put(ResourceField.CREATED, "create_date");
        map.put(ResourceField.TYPE, "rsrc_type");
        map.put(ResourceField.PARENT_ID, "parent_rsrc_id");
        map.put(ResourceField.RESOURCE_ID, "rsrc_short_name");
        map.put(ResourceField.CALCULATE_COSTS_FROM_UNITS, "def_cost_qty_link_flag");
        map.put(ResourceField.SEQUENCE_NUMBER, "rsrc_seq_num");
        map.put(ResourceField.ACTIVE, "active_flag");
        map.put(ResourceField.LOCATION_UNIQUE_ID, "location_id");
        map.put(ResourceField.UNIT_OF_MEASURE_UNIQUE_ID, "unit_id");
        map.put(ResourceField.SHIFT_UNIQUE_ID, "shift_id");
        map.put(ResourceField.PRIMARY_ROLE_UNIQUE_ID, "role_id");
        map.put(ResourceField.CURRENCY_UNIQUE_ID, "curr_id");
        return map;
    }

    public static Map<FieldType, String> getDefaultRoleFieldMap() {
        LinkedHashMap<FieldType, String> map = new LinkedHashMap<FieldType, String>();
        map.put(ResourceField.UNIQUE_ID, "role_id");
        map.put(ResourceField.NAME, "role_name");
        map.put(ResourceField.RESOURCE_ID, "role_short_name");
        map.put(ResourceField.NOTES, "role_descr");
        map.put(ResourceField.PARENT_ID, "parent_role_id");
        map.put(ResourceField.CALCULATE_COSTS_FROM_UNITS, "def_cost_qty_link_flag");
        map.put(ResourceField.SEQUENCE_NUMBER, "seq_num");
        return map;
    }

    public static Map<FieldType, String> getDefaultWbsFieldMap() {
        LinkedHashMap<FieldType, String> map = new LinkedHashMap<FieldType, String>();
        map.put(TaskField.UNIQUE_ID, "wbs_id");
        map.put(TaskField.GUID, "guid");
        map.put(TaskField.NAME, "wbs_name");
        map.put(TaskField.REMAINING_COST, "indep_remain_total_cost");
        map.put(TaskField.REMAINING_WORK, "indep_remain_work_qty");
        map.put(TaskField.DEADLINE, "anticip_end_date");
        map.put(TaskField.WBS, "wbs_short_name");
        map.put(TaskField.SEQUENCE_NUMBER, "seq_num");
        map.put(TaskField.METHODOLOGY_GUID, "tmpl_guid");
        return map;
    }

    public static Map<FieldType, String> getDefaultTaskFieldMap() {
        LinkedHashMap<FieldType, String> map = new LinkedHashMap<FieldType, String>();
        map.put(TaskField.GUID, "guid");
        map.put(TaskField.NAME, "task_name");
        map.put(TaskField.REMAINING_DURATION, "remain_drtn_hr_cnt");
        map.put(TaskField.ACTUAL_WORK_LABOR, "act_work_qty");
        map.put(TaskField.ACTUAL_WORK_NONLABOR, "act_equip_qty");
        map.put(TaskField.REMAINING_WORK_LABOR, "remain_work_qty");
        map.put(TaskField.REMAINING_WORK_NONLABOR, "remain_equip_qty");
        map.put(TaskField.PLANNED_WORK_LABOR, "target_work_qty");
        map.put(TaskField.PLANNED_WORK_NONLABOR, "target_equip_qty");
        map.put(TaskField.PLANNED_DURATION, "target_drtn_hr_cnt");
        map.put(TaskField.CONSTRAINT_DATE, "cstr_date");
        map.put(TaskField.ACTUAL_START, "act_start_date");
        map.put(TaskField.ACTUAL_FINISH, "act_end_date");
        map.put(TaskField.LATE_START, "late_start_date");
        map.put(TaskField.LATE_FINISH, "late_end_date");
        map.put(TaskField.EARLY_START, "early_start_date");
        map.put(TaskField.EARLY_FINISH, "early_end_date");
        map.put(TaskField.REMAINING_EARLY_START, "restart_date");
        map.put(TaskField.REMAINING_EARLY_FINISH, "reend_date");
        map.put(TaskField.REMAINING_LATE_START, "rem_late_start_date");
        map.put(TaskField.REMAINING_LATE_FINISH, "rem_late_end_date");
        map.put(TaskField.PLANNED_START, "target_start_date");
        map.put(TaskField.PLANNED_FINISH, "target_end_date");
        map.put(TaskField.CONSTRAINT_TYPE, "cstr_type");
        map.put(TaskField.SECONDARY_CONSTRAINT_DATE, "cstr_date2");
        map.put(TaskField.SECONDARY_CONSTRAINT_TYPE, "cstr_type2");
        map.put(TaskField.PRIORITY, "priority_type");
        map.put(TaskField.CREATED, "create_date");
        map.put(TaskField.TYPE, "duration_type");
        map.put(TaskField.FREE_SLACK, "free_float_hr_cnt");
        map.put(TaskField.TOTAL_SLACK, "total_float_hr_cnt");
        map.put(TaskField.ACTIVITY_ID, "task_code");
        map.put(TaskField.PRIMARY_RESOURCE_UNIQUE_ID, "rsrc_id");
        map.put(TaskField.SUSPEND_DATE, "suspend_date");
        map.put(TaskField.RESUME, "resume_date");
        map.put(TaskField.EXTERNAL_EARLY_START, "external_early_start_date");
        map.put(TaskField.EXTERNAL_LATE_FINISH, "external_late_end_date");
        map.put(TaskField.LONGEST_PATH, "driving_path_flag");
        map.put(TaskField.LOCATION_UNIQUE_ID, "location_id");
        map.put(TaskField.EXPECTED_FINISH, "expect_end_date");
        map.put(TaskField.METHODOLOGY_GUID, "tmpl_guid");
        map.put(TaskField.FLOAT_PATH, "float_path");
        map.put(TaskField.FLOAT_PATH_ORDER, "float_path_order");
        return map;
    }

    public static Map<FieldType, String> getDefaultAssignmentFieldMap() {
        LinkedHashMap<FieldType, String> map = new LinkedHashMap<FieldType, String>();
        map.put(AssignmentField.UNIQUE_ID, "taskrsrc_id");
        map.put(AssignmentField.GUID, "guid");
        map.put(AssignmentField.REMAINING_WORK, "remain_qty");
        map.put(AssignmentField.PLANNED_WORK, "target_qty");
        map.put(AssignmentField.ACTUAL_OVERTIME_WORK, "act_ot_qty");
        map.put(AssignmentField.PLANNED_COST, "target_cost");
        map.put(AssignmentField.ACTUAL_OVERTIME_COST, "act_ot_cost");
        map.put(AssignmentField.REMAINING_COST, "remain_cost");
        map.put(AssignmentField.ACTUAL_START, "act_start_date");
        map.put(AssignmentField.ACTUAL_FINISH, "act_end_date");
        map.put(AssignmentField.PLANNED_START, "target_start_date");
        map.put(AssignmentField.PLANNED_FINISH, "target_end_date");
        map.put(AssignmentField.ASSIGNMENT_DELAY, "target_lag_drtn_hr_cnt");
        map.put(AssignmentField.CALCULATE_COSTS_FROM_UNITS, "cost_qty_link_flag");
        map.put(AssignmentField.COST_ACCOUNT_UNIQUE_ID, "acct_id");
        map.put(AssignmentField.REMAINING_EARLY_START, "restart_date");
        map.put(AssignmentField.REMAINING_EARLY_FINISH, "reend_date");
        map.put(AssignmentField.REMAINING_LATE_START, "rem_late_start_date");
        map.put(AssignmentField.REMAINING_LATE_FINISH, "rem_late_end_date");
        return map;
    }

    static {
        MILESTONE_MAP.put("TT_Task", Boolean.FALSE);
        MILESTONE_MAP.put("TT_Rsrc", Boolean.FALSE);
        MILESTONE_MAP.put("TT_LOE", Boolean.FALSE);
        MILESTONE_MAP.put("TT_Mile", Boolean.TRUE);
        MILESTONE_MAP.put("TT_FinMile", Boolean.TRUE);
        MILESTONE_MAP.put("TT_WBS", Boolean.FALSE);
        CURRENCY_SYMBOL_POSITION_MAP = new HashMap<String, CurrencySymbolPosition>();
        CURRENCY_SYMBOL_POSITION_MAP.put("#1.1", CurrencySymbolPosition.BEFORE);
        CURRENCY_SYMBOL_POSITION_MAP.put("1.1#", CurrencySymbolPosition.AFTER);
        CURRENCY_SYMBOL_POSITION_MAP.put("# 1.1", CurrencySymbolPosition.BEFORE_WITH_SPACE);
        CURRENCY_SYMBOL_POSITION_MAP.put("1.1 #", CurrencySymbolPosition.AFTER_WITH_SPACE);
        EXCEPTION_EPOCH = LocalDate.of(1899, 12, 30);
    }
}

