/*
 * Decompiled with CFR 0.152.
 */
package org.mpxj.primavera;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.ParseException;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.mpxj.DataType;
import org.mpxj.FieldType;
import org.mpxj.HasCharset;
import org.mpxj.MPXJException;
import org.mpxj.Notes;
import org.mpxj.ProjectFile;
import org.mpxj.ProjectFileSharedData;
import org.mpxj.Relation;
import org.mpxj.Task;
import org.mpxj.WorkContour;
import org.mpxj.WorkContourContainer;
import org.mpxj.common.CharsetHelper;
import org.mpxj.common.LocalDateTimeHelper;
import org.mpxj.common.NumberHelper;
import org.mpxj.common.ReaderTokenizer;
import org.mpxj.common.Tokenizer;
import org.mpxj.primavera.ArrayRow;
import org.mpxj.primavera.ExternalRelation;
import org.mpxj.primavera.PrimaveraReader;
import org.mpxj.primavera.Row;
import org.mpxj.primavera.WbsRowComparatorXER;
import org.mpxj.reader.AbstractProjectStreamReader;

public final class PrimaveraXERFileReader
extends AbstractProjectStreamReader
implements HasCharset {
    private Charset m_charset = CharsetHelper.CP1252;
    private PrimaveraReader m_reader;
    private Integer m_projectID;
    boolean m_skipTable;
    private Map<String, List<Row>> m_tables;
    private String m_currentTableName;
    private List<Row> m_currentTable;
    private String[] m_currentFieldNames;
    private Map<String, Integer> m_currentFieldIndex;
    private String m_defaultCurrencyName;
    private DecimalFormat m_numberFormat;
    private Row m_defaultCurrencyData;
    private final DateTimeFormatter m_df = DateTimeFormatter.ofPattern("yyyy-M-dd[ HH[:][.]mm[[:][.]ss]]");
    private final Map<FieldType, String> m_resourceFields = PrimaveraReader.getDefaultResourceFieldMap();
    private final Map<FieldType, String> m_roleFields = PrimaveraReader.getDefaultRoleFieldMap();
    private final Map<FieldType, String> m_wbsFields = PrimaveraReader.getDefaultWbsFieldMap();
    private final Map<FieldType, String> m_taskFields = PrimaveraReader.getDefaultTaskFieldMap();
    private final Map<FieldType, String> m_assignmentFields = PrimaveraReader.getDefaultAssignmentFieldMap();
    private final Map<String, DataType> m_fieldTypes = this.getDefaultFieldTypes();
    private boolean m_matchPrimaveraWBS = true;
    private boolean m_wbsIsFullPath = true;
    private boolean m_linkCrossProjectRelations;
    private boolean m_ignoreErrors = true;
    private boolean m_readSharedData;
    private Set<String> m_requiredTables;
    private static final Map<String, XerRecordType> RECORD_TYPE_MAP = new HashMap<String, XerRecordType>();
    private static final Map<String, DataType> FIELD_TYPE_MAP;
    private static final Set<String> LIST_REQUIRED_TABLES;
    private static final Set<String> READ_REQUIRED_TABLES;
    private static final WbsRowComparatorXER WBS_ROW_COMPARATOR;

    public void setProjectID(int projectID) {
        this.m_projectID = projectID;
    }

    @Override
    public void setCharset(Charset charset) {
        this.m_charset = charset;
    }

    @Override
    public Charset getCharset() {
        return this.m_charset;
    }

    public boolean getLinkCrossProjectRelations() {
        return this.m_linkCrossProjectRelations;
    }

    public void setLinkCrossProjectRelations(boolean linkCrossProjectRelations) {
        this.m_linkCrossProjectRelations = linkCrossProjectRelations;
    }

    @Override
    public ProjectFile read(InputStream is) throws MPXJException {
        ProjectFile project = null;
        Integer targetProjectID = this.m_projectID;
        List<ProjectFile> projects = this.readAll(is);
        if (!projects.isEmpty()) {
            project = targetProjectID == null ? projects.get(0) : (ProjectFile)projects.stream().filter(p -> targetProjectID.equals(p.getProjectProperties().getUniqueID())).findFirst().orElse(null);
        }
        return project;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ProjectFile> readAll(InputStream is) throws MPXJException {
        try {
            this.m_tables = new HashMap<String, List<Row>>();
            this.m_numberFormat = new DecimalFormat();
            this.m_readSharedData = true;
            this.processFile(READ_REQUIRED_TABLES, is);
            List<Row> rows = this.getRows("project", null, null);
            ArrayList<ProjectFile> result = new ArrayList<ProjectFile>(rows.size());
            ArrayList<ExternalRelation> externalRelations = new ArrayList<ExternalRelation>();
            ProjectFileSharedData shared = new ProjectFileSharedData();
            for (Row row : rows) {
                this.setProjectID(row.getInt("proj_id"));
                this.m_reader = new PrimaveraReader(shared, this.m_resourceFields, this.m_roleFields, this.m_wbsFields, this.m_taskFields, this.m_assignmentFields, this.m_matchPrimaveraWBS, this.m_wbsIsFullPath, this.m_ignoreErrors);
                ProjectFile project = this.readProject();
                externalRelations.addAll(this.m_reader.getExternalRelations());
                result.add(project);
            }
            result.sort((o1, o2) -> Boolean.compare(o2.getProjectProperties().getExportFlag(), o1.getProjectProperties().getExportFlag()));
            if (this.m_linkCrossProjectRelations) {
                block4: for (ExternalRelation externalRelation : externalRelations) {
                    for (ProjectFile proj : result) {
                        Task predecessorTask = proj.getTaskByUniqueID(externalRelation.externalTaskUniqueID());
                        if (predecessorTask == null) continue;
                        Task successorTask = externalRelation.getTargetTask();
                        ProjectFile successorProject = successorTask.getParentFile();
                        successorProject.getRelations().addPredecessor(new Relation.Builder().predecessorTask(predecessorTask).successorTask(successorTask).type(externalRelation.getType()).lag(externalRelation.getLag()).uniqueID(externalRelation.getUniqueID()).notes(externalRelation.getNotes()));
                        ProjectFile predecessorProject = predecessorTask.getParentFile();
                        predecessorProject.getRelations().addPredecessor(new Relation.Builder().predecessorTask(predecessorTask).successorTask(successorTask).type(externalRelation.getType()).lag(externalRelation.getLag()).uniqueID(externalRelation.getUniqueID()).notes(externalRelation.getNotes()));
                        continue block4;
                    }
                }
            }
            Iterator iterator = result;
            return iterator;
        }
        finally {
            this.m_tables = null;
            this.m_numberFormat = null;
            this.m_reader = null;
        }
    }

    private ProjectFile readProject() {
        try {
            ProjectFile project = this.m_reader.getProject();
            project.getProjectProperties().setFileApplication("Primavera");
            project.getProjectProperties().setFileType("XER");
            this.addListenersToProject(project);
            this.processProjectID();
            if (this.m_readSharedData) {
                this.m_readSharedData = false;
                this.processCurrencies();
                this.processLocations();
                this.processShifts();
                this.processUnitsOfMeasure();
                this.processExpenseCategories();
                this.processCostAccounts();
                this.processWorkContours();
                this.processNotebookTopics();
                this.processUdfDefinitions();
                this.processProjectCodeDefinitions();
                this.processResourceCodeDefinitions();
                this.processRoleCodeDefinitions();
                this.processResourceAssignmentCodeDefinitions();
                this.processActivityCodeDefinitions();
            }
            this.processActivityCodeAssignments();
            this.processResourceCodeAssignments();
            this.processRoleCodeAssignments();
            this.processResourceAssignmentCodeAssignments();
            this.processUdfValues();
            this.processCalendars();
            this.processResources();
            this.processRoles();
            this.processRoleAssignments();
            this.processResourceRates();
            this.processRoleRates();
            this.processProjectProperties();
            this.processTasks();
            this.processPredecessors();
            this.processAssignments();
            this.processExpenseItems();
            this.processActivitySteps();
            this.m_reader.rollupValues();
            project.updateStructure();
            project.readComplete();
            ProjectFile projectFile = project;
            return projectFile;
        }
        finally {
            this.m_currentTableName = null;
            this.m_currentTable = null;
            this.m_currentFieldNames = null;
            this.m_defaultCurrencyName = null;
            this.m_numberFormat = null;
            this.m_defaultCurrencyData = null;
        }
    }

    private void processFile(Set<String> requiredTables, InputStream is) throws MPXJException {
        int line = 1;
        this.m_requiredTables = requiredTables;
        try {
            InputStreamReader reader = new InputStreamReader(is, this.getCharset());
            ReaderTokenizer tk = new ReaderTokenizer(reader);
            tk.setDelimiter('\t');
            ArrayList<String> record = new ArrayList<String>();
            if (tk.getType() == -1) {
                throw new MPXJException("Invalid file format");
            }
            this.readRecord(tk, record);
            if (record.isEmpty() || !"ERMHDR".equals(record.get(0))) {
                throw new MPXJException("Invalid file format");
            }
            this.processRecord(record);
            while (tk.getType() != -1) {
                this.readRecord(tk, record);
                if (record.isEmpty() || !this.processRecord(record)) {
                    ++line;
                    continue;
                }
                break;
            }
        }
        catch (Exception ex) {
            throw new MPXJException("Error reading file (failed at line " + line + ")", ex);
        }
    }

    private void processProjectID() {
        List<Row> rows;
        if (this.m_projectID == null && !(rows = this.getRows("project", null, null)).isEmpty()) {
            Row row = rows.get(0);
            this.m_projectID = row.getInteger("proj_id");
        }
    }

    private void processCurrency(Row row) {
        String currencyName = row.getString("curr_short_name");
        if (currencyName.equalsIgnoreCase(this.m_defaultCurrencyName)) {
            DecimalFormatSymbols symbols = new DecimalFormatSymbols();
            symbols.setDecimalSeparator(row.getString("decimal_symbol").charAt(0));
            symbols.setGroupingSeparator(row.getString("digit_group_symbol").charAt(0));
            DecimalFormat nf = new DecimalFormat();
            nf.setDecimalFormatSymbols(symbols);
            nf.applyPattern("#.#");
            this.m_numberFormat = nf;
            this.m_defaultCurrencyData = row;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<Integer, String> listProjects(InputStream is) throws MPXJException {
        try {
            this.m_tables = new HashMap<String, List<Row>>();
            this.m_numberFormat = new DecimalFormat();
            this.processFile(LIST_REQUIRED_TABLES, is);
            HashMap<Integer, String> result = new HashMap<Integer, String>();
            List<Row> rows = this.getRows("project", null, null);
            for (Row row : rows) {
                Integer id = row.getInteger("proj_id");
                String name = row.getString("proj_short_name");
                result.put(id, name);
            }
            HashMap<Integer, String> hashMap = result;
            return hashMap;
        }
        finally {
            this.m_tables = null;
            this.m_currentTable = null;
            this.m_currentFieldNames = null;
            this.m_numberFormat = null;
        }
    }

    private void processProjectProperties() {
        List<Row> rows = this.getRows("project", "proj_id", this.m_projectID);
        this.m_reader.processProjectProperties(this.m_projectID, rows);
        rows = this.getRows("projpcat", "proj_id", this.m_projectID);
        this.m_reader.processProjectCodeAssignments(rows);
        if (this.m_defaultCurrencyData != null) {
            this.m_reader.processDefaultCurrency(this.m_defaultCurrencyData);
        }
        this.processScheduleOptions();
    }

    private void processCurrencies() {
        this.m_reader.processCurrencies(this.getRows("currtype", null, null));
    }

    private void processLocations() {
        this.m_reader.processLocations(this.getRows("location", null, null));
    }

    private void processShifts() {
        this.m_reader.processShifts(this.getRows("shift", null, null), this.getRows("shiftper", null, null));
    }

    private void processExpenseCategories() {
        this.m_reader.processExpenseCategories(this.getRows("costtype", null, null));
    }

    private void processExpenseItems() {
        this.m_reader.processExpenseItems(this.getRows("projcost", "proj_id", this.m_projectID));
    }

    private void processActivitySteps() {
        this.m_reader.processActivitySteps(this.getRows("taskproc", "proj_id", this.m_projectID));
    }

    private void processCostAccounts() {
        this.m_reader.processCostAccounts(this.getRows("account", null, null));
    }

    private void processUnitsOfMeasure() {
        this.m_reader.processUnitsOfMeasure(this.getRows("umeasure", null, null));
    }

    private void processNotebookTopics() {
        this.m_reader.processNotebookTopics(this.getRows("memotype", null, null));
    }

    private void processActivityCodeDefinitions() {
        List<Row> types = this.getRows("actvtype", null, null);
        List<Row> typeValues = this.getRows("actvcode", null, null);
        this.m_reader.processActivityCodeDefinitions(types, typeValues);
    }

    private void processProjectCodeDefinitions() {
        List<Row> types = this.getRows("pcattype", null, null);
        List<Row> typeValues = this.getRows("pcatval", null, null);
        this.m_reader.processProjectCodeDefinitions(types, typeValues);
    }

    private void processResourceCodeDefinitions() {
        List<Row> types = this.getRows("rcattype", null, null);
        List<Row> typeValues = this.getRows("rcatval", null, null);
        this.m_reader.processResourceCodeDefinitions(types, typeValues);
    }

    private void processRoleCodeDefinitions() {
        List<Row> types = this.getRows("rolecattype", null, null);
        List<Row> typeValues = this.getRows("rolecatval", null, null);
        this.m_reader.processRoleCodeDefinitions(types, typeValues);
    }

    private void processResourceAssignmentCodeDefinitions() {
        List<Row> types = this.getRows("asgnmntcattype", null, null);
        List<Row> typeValues = this.getRows("asgnmntcatval", null, null);
        this.m_reader.processResourceAssignmentCodeDefinitions(types, typeValues);
    }

    private void processActivityCodeAssignments() {
        List<Row> assignments = this.getRows("taskactv", null, null);
        this.m_reader.processActivityCodeAssignments(assignments);
    }

    private void processResourceCodeAssignments() {
        List<Row> assignments = this.getRows("rsrcrcat", null, null);
        this.m_reader.processResourceCodeAssignments(assignments);
    }

    private void processRoleCodeAssignments() {
        List<Row> assignments = this.getRows("rolercat", null, null);
        this.m_reader.processRoleCodeAssignments(assignments);
    }

    private void processResourceAssignmentCodeAssignments() {
        List<Row> assignments = this.getRows("asgnmntacat", null, null);
        this.m_reader.processResourceAssignmentCodeAssignments(assignments);
    }

    private void processScheduleOptions() {
        List<Row> rows = this.getRows("schedoptions", "proj_id", this.m_projectID);
        if (!rows.isEmpty()) {
            this.m_reader.processScheduleOptions(rows.get(0));
        }
    }

    private void processUdfDefinitions() {
        List<Row> fields = this.getRows("udftype", null, null);
        this.m_reader.processUdfDefinitions(fields);
    }

    private void processUdfValues() {
        List<Row> values = this.getRows("udfvalue", null, null);
        this.m_reader.processUdfValues(values);
    }

    private void processCalendars() {
        List<Row> rows = this.getRows("calendar", null, null);
        this.m_reader.processCalendars(rows);
    }

    private void processResources() {
        List<Row> rows = this.getRows("rsrc", null, null);
        this.m_reader.processResources(rows);
    }

    private void processRoles() {
        List<Row> rows = this.getRows("roles", null, null);
        this.m_reader.processRoles(rows);
    }

    private void processRoleAssignments() {
        List<Row> rows = this.getRows("rsrcrole", null, null);
        this.m_reader.processRoleAssignments(rows);
    }

    private void processResourceRates() {
        List<Row> rows = this.getRows("rsrcrate", null, null);
        this.m_reader.processResourceRates(rows);
    }

    private void processRoleRates() {
        List<Row> rows = this.getRows("rolerate", null, null);
        this.m_reader.processRoleRates(rows);
        this.m_reader.processRoleAvailability(rows);
    }

    private void processTasks() {
        List<Row> wbs = this.getRows("projwbs", "proj_id", this.m_projectID);
        List<Row> tasks = this.getRows("task", "proj_id", this.m_projectID);
        Map<Integer, Notes> wbsNotes = this.m_reader.getNotes(this.getRows("wbsmemo", "proj_id", this.m_projectID), "wbs_memo_id", "wbs_id", "wbs_memo");
        Map<Integer, Notes> taskNotes = this.m_reader.getNotes(this.getRows("taskmemo", "proj_id", this.m_projectID), "memo_id", "task_id", "task_memo");
        wbs.sort(WBS_ROW_COMPARATOR);
        this.m_reader.processTasks(wbs, tasks, wbsNotes, taskNotes);
    }

    private void processPredecessors() {
        List<Row> rows = this.getRows("taskpred", "proj_id", this.m_projectID);
        this.m_reader.processPredecessors(rows);
    }

    private void processAssignments() {
        List<Row> rows = this.getRows("taskrsrc", "proj_id", this.m_projectID);
        this.m_reader.processAssignments(rows);
    }

    private void processWorkContours() {
        WorkContourContainer contours = this.m_reader.getProject().getWorkContours();
        List<Row> rows = this.getRows("rsrccurvdata", null, null);
        for (Row row : rows) {
            Integer id = row.getInteger("curv_id");
            if (contours.getByUniqueID(id) != null) continue;
            double[] values = new double[]{NumberHelper.getDouble(row.getDouble("pct_usage_0")), NumberHelper.getDouble(row.getDouble("pct_usage_1")), NumberHelper.getDouble(row.getDouble("pct_usage_2")), NumberHelper.getDouble(row.getDouble("pct_usage_3")), NumberHelper.getDouble(row.getDouble("pct_usage_4")), NumberHelper.getDouble(row.getDouble("pct_usage_5")), NumberHelper.getDouble(row.getDouble("pct_usage_6")), NumberHelper.getDouble(row.getDouble("pct_usage_7")), NumberHelper.getDouble(row.getDouble("pct_usage_8")), NumberHelper.getDouble(row.getDouble("pct_usage_9")), NumberHelper.getDouble(row.getDouble("pct_usage_10")), NumberHelper.getDouble(row.getDouble("pct_usage_11")), NumberHelper.getDouble(row.getDouble("pct_usage_12")), NumberHelper.getDouble(row.getDouble("pct_usage_13")), NumberHelper.getDouble(row.getDouble("pct_usage_14")), NumberHelper.getDouble(row.getDouble("pct_usage_15")), NumberHelper.getDouble(row.getDouble("pct_usage_16")), NumberHelper.getDouble(row.getDouble("pct_usage_17")), NumberHelper.getDouble(row.getDouble("pct_usage_18")), NumberHelper.getDouble(row.getDouble("pct_usage_19")), NumberHelper.getDouble(row.getDouble("pct_usage_20"))};
            contours.add(new WorkContour(id, row.getString("curv_name"), row.getBoolean("default_flag"), values));
        }
    }

    private void readRecord(Tokenizer tk, List<String> record) throws IOException {
        record.clear();
        while (tk.nextToken() == -3) {
            record.add(tk.getToken());
        }
    }

    private boolean processRecord(List<String> record) {
        XerRecordType type = RECORD_TYPE_MAP.get(record.get(0));
        return type != null && this.processRecord(type, record);
    }

    private boolean processRecord(XerRecordType type, List<String> record) {
        boolean done = false;
        switch (type) {
            case HEADER: {
                this.processHeader(record);
                break;
            }
            case TABLE: {
                this.m_currentTableName = record.size() > 1 ? record.get(1).toLowerCase() : null;
                boolean bl = this.m_skipTable = !this.m_requiredTables.contains(this.m_currentTableName);
                if (this.m_skipTable) {
                    this.m_currentTable = null;
                    break;
                }
                this.m_currentTable = new ArrayList<Row>();
                this.m_tables.put(this.m_currentTableName, this.m_currentTable);
                break;
            }
            case FIELDS: {
                if (this.m_skipTable) {
                    this.m_currentFieldNames = null;
                    this.m_currentFieldIndex = null;
                    break;
                }
                this.m_currentFieldNames = record.toArray(new String[0]);
                this.m_currentFieldIndex = new HashMap<String, Integer>();
                for (int loop = 0; loop < this.m_currentFieldNames.length; ++loop) {
                    this.m_currentFieldNames[loop] = this.m_currentFieldNames[loop].toLowerCase();
                    this.m_currentFieldIndex.put(this.m_currentFieldNames[loop], loop);
                }
                break;
            }
            case DATA: {
                if (this.m_skipTable) break;
                this.processData(record);
                break;
            }
            case END: {
                done = true;
                break;
            }
        }
        return done;
    }

    private void processData(List<String> record) {
        Object[] array = new Object[this.m_currentFieldIndex.size()];
        for (int loop = 1; loop < record.size() && loop != this.m_currentFieldNames.length; ++loop) {
            Object objectValue;
            String fieldName = this.m_currentFieldNames[loop];
            String fieldValue = record.get(loop);
            DataType fieldType = this.getFieldType(fieldName);
            if (fieldValue.isEmpty()) {
                objectValue = null;
            } else {
                switch (fieldType) {
                    case DATE: {
                        try {
                            objectValue = LocalDateTimeHelper.parseBest(this.m_df, fieldValue);
                        }
                        catch (DateTimeParseException ex) {
                            objectValue = fieldValue;
                        }
                        break;
                    }
                    case CURRENCY: 
                    case NUMERIC: 
                    case DURATION: {
                        try {
                            objectValue = this.m_numberFormat.parse(fieldValue.trim()).doubleValue();
                        }
                        catch (ParseException ex) {
                            objectValue = fieldValue;
                        }
                        break;
                    }
                    case INTEGER: {
                        try {
                            objectValue = Integer.valueOf(fieldValue.trim());
                        }
                        catch (NumberFormatException ex) {
                            objectValue = fieldValue;
                        }
                        break;
                    }
                    default: {
                        objectValue = this.unescapeQuotes(fieldValue);
                    }
                }
            }
            array[loop] = objectValue;
        }
        ArrayRow currentRow = new ArrayRow(this.m_currentFieldIndex, array, this.m_ignoreErrors);
        this.m_currentTable.add(currentRow);
        if (this.m_currentTableName.equals("currtype")) {
            this.processCurrency(currentRow);
        }
    }

    private String unescapeQuotes(String value) {
        if (value == null || value.isEmpty()) {
            return value;
        }
        if (!value.contains("\"\"")) {
            return value;
        }
        return value.replace("\"\"", "\"");
    }

    private DataType getFieldType(String fieldName) {
        DataType fieldType = this.m_currentTableName.equals("projcost") && fieldName.equals("target_qty") ? DataType.CURRENCY : this.m_fieldTypes.getOrDefault(fieldName, DataType.STRING);
        return fieldType;
    }

    private void processHeader(List<String> record) {
        this.m_defaultCurrencyName = record.size() > 8 ? record.get(8) : "USD";
    }

    public Map<String, DataType> getFieldTypeMap() {
        return this.m_fieldTypes;
    }

    public Map<FieldType, String> getResourceFieldMap() {
        return this.m_resourceFields;
    }

    public Map<FieldType, String> getRoleFieldMap() {
        return this.m_roleFields;
    }

    public Map<FieldType, String> getWbsFieldMap() {
        return this.m_wbsFields;
    }

    public Map<FieldType, String> getActivityFieldMap() {
        return this.m_taskFields;
    }

    public Map<FieldType, String> getAssignmentFieldMap() {
        return this.m_assignmentFields;
    }

    private List<Row> getRows(String tableName, String columnName, Integer id) {
        List<Row> result;
        List<Row> table = this.m_tables.get(tableName);
        if (table == null) {
            result = Collections.emptyList();
        } else if (columnName == null) {
            result = table;
        } else {
            result = new ArrayList<Row>();
            for (Row row : table) {
                if (!NumberHelper.equals(id, row.getInteger(columnName))) continue;
                result.add(row);
            }
        }
        return result;
    }

    public boolean getMatchPrimaveraWBS() {
        return this.m_matchPrimaveraWBS;
    }

    public void setMatchPrimaveraWBS(boolean matchPrimaveraWBS) {
        this.m_matchPrimaveraWBS = matchPrimaveraWBS;
    }

    public boolean getWbsIsFullPath() {
        return this.m_wbsIsFullPath;
    }

    public void setWbsIsFullPath(boolean wbsIsFullPath) {
        this.m_wbsIsFullPath = wbsIsFullPath;
    }

    public void setIgnoreErrors(boolean ignoreErrors) {
        this.m_ignoreErrors = ignoreErrors;
    }

    public boolean getIgnoreErrors() {
        return this.m_ignoreErrors;
    }

    private Map<String, DataType> getDefaultFieldTypes() {
        return new HashMap<String, DataType>(FIELD_TYPE_MAP);
    }

    static {
        RECORD_TYPE_MAP.put("ERMHDR", XerRecordType.HEADER);
        RECORD_TYPE_MAP.put("%T", XerRecordType.TABLE);
        RECORD_TYPE_MAP.put("%F", XerRecordType.FIELDS);
        RECORD_TYPE_MAP.put("%R", XerRecordType.DATA);
        RECORD_TYPE_MAP.put("", XerRecordType.DATA);
        RECORD_TYPE_MAP.put("%E", XerRecordType.END);
        FIELD_TYPE_MAP = new HashMap<String, DataType>();
        FIELD_TYPE_MAP.put("acct_id", DataType.INTEGER);
        FIELD_TYPE_MAP.put("acct_seq_num", DataType.INTEGER);
        FIELD_TYPE_MAP.put("act_cost", DataType.NUMERIC);
        FIELD_TYPE_MAP.put("act_end_date", DataType.DATE);
        FIELD_TYPE_MAP.put("act_equip_qty", DataType.DURATION);
        FIELD_TYPE_MAP.put("act_ot_cost", DataType.CURRENCY);
        FIELD_TYPE_MAP.put("act_ot_qty", DataType.DURATION);
        FIELD_TYPE_MAP.put("act_reg_cost", DataType.CURRENCY);
        FIELD_TYPE_MAP.put("act_reg_qty", DataType.DURATION);
        FIELD_TYPE_MAP.put("act_start_date", DataType.DATE);
        FIELD_TYPE_MAP.put("act_work_qty", DataType.DURATION);
        FIELD_TYPE_MAP.put("actv_code_id", DataType.INTEGER);
        FIELD_TYPE_MAP.put("actv_code_type_id", DataType.INTEGER);
        FIELD_TYPE_MAP.put("actv_short_len", DataType.INTEGER);
        FIELD_TYPE_MAP.put("anticip_end_date", DataType.DATE);
        FIELD_TYPE_MAP.put("anticip_start_date", DataType.DATE);
        FIELD_TYPE_MAP.put("asgnmnt_catg_id", DataType.NUMERIC);
        FIELD_TYPE_MAP.put("asgnmnt_catg_short_len", DataType.NUMERIC);
        FIELD_TYPE_MAP.put("asgnmnt_catg_type_id", DataType.NUMERIC);
        FIELD_TYPE_MAP.put("base_clndr_id", DataType.INTEGER);
        FIELD_TYPE_MAP.put("base_exch_rate", DataType.NUMERIC);
        FIELD_TYPE_MAP.put("clndr_data", DataType.STRING);
        FIELD_TYPE_MAP.put("clndr_id", DataType.INTEGER);
        FIELD_TYPE_MAP.put("clndr_name", DataType.STRING);
        FIELD_TYPE_MAP.put("clndr_type", DataType.STRING);
        FIELD_TYPE_MAP.put("complete_pct", DataType.NUMERIC);
        FIELD_TYPE_MAP.put("cost_item_id", DataType.INTEGER);
        FIELD_TYPE_MAP.put("cost_per_qty", DataType.NUMERIC);
        FIELD_TYPE_MAP.put("cost_per_qty2", DataType.NUMERIC);
        FIELD_TYPE_MAP.put("cost_per_qty3", DataType.NUMERIC);
        FIELD_TYPE_MAP.put("cost_per_qty4", DataType.NUMERIC);
        FIELD_TYPE_MAP.put("cost_per_qty5", DataType.NUMERIC);
        FIELD_TYPE_MAP.put("cost_type_id", DataType.INTEGER);
        FIELD_TYPE_MAP.put("create_date", DataType.DATE);
        FIELD_TYPE_MAP.put("critical_drtn_hr_cnt", DataType.NUMERIC);
        FIELD_TYPE_MAP.put("cstr_date", DataType.DATE);
        FIELD_TYPE_MAP.put("cstr_date2", DataType.DATE);
        FIELD_TYPE_MAP.put("curr_id", DataType.INTEGER);
        FIELD_TYPE_MAP.put("curv_id", DataType.NUMERIC);
        FIELD_TYPE_MAP.put("day_hr_cnt", DataType.NUMERIC);
        FIELD_TYPE_MAP.put("decimal_digit_cnt", DataType.INTEGER);
        FIELD_TYPE_MAP.put("default_flag", DataType.STRING);
        FIELD_TYPE_MAP.put("def_qty_per_hr", DataType.NUMERIC);
        FIELD_TYPE_MAP.put("driving_path_flag", DataType.STRING);
        FIELD_TYPE_MAP.put("early_end_date", DataType.DATE);
        FIELD_TYPE_MAP.put("early_start_date", DataType.DATE);
        FIELD_TYPE_MAP.put("expect_end_date", DataType.DATE);
        FIELD_TYPE_MAP.put("external_early_start_date", DataType.DATE);
        FIELD_TYPE_MAP.put("external_late_end_date", DataType.DATE);
        FIELD_TYPE_MAP.put("fk_id", DataType.INTEGER);
        FIELD_TYPE_MAP.put("float_path", DataType.INTEGER);
        FIELD_TYPE_MAP.put("float_path_order", DataType.INTEGER);
        FIELD_TYPE_MAP.put("free_float_hr_cnt", DataType.DURATION);
        FIELD_TYPE_MAP.put("fy_start_month_num", DataType.INTEGER);
        FIELD_TYPE_MAP.put("group_digit_cnt", DataType.INTEGER);
        FIELD_TYPE_MAP.put("indep_remain_total_cost", DataType.CURRENCY);
        FIELD_TYPE_MAP.put("indep_remain_work_qty", DataType.DURATION);
        FIELD_TYPE_MAP.put("lag_hr_cnt", DataType.DURATION);
        FIELD_TYPE_MAP.put("last_chng_date", DataType.STRING);
        FIELD_TYPE_MAP.put("last_recalc_date", DataType.DATE);
        FIELD_TYPE_MAP.put("late_end_date", DataType.DATE);
        FIELD_TYPE_MAP.put("late_start_date", DataType.DATE);
        FIELD_TYPE_MAP.put("latitude", DataType.NUMERIC);
        FIELD_TYPE_MAP.put("location_id", DataType.INTEGER);
        FIELD_TYPE_MAP.put("loginal_data_type", DataType.STRING);
        FIELD_TYPE_MAP.put("longitude", DataType.NUMERIC);
        FIELD_TYPE_MAP.put("max_qty_per_hr", DataType.NUMERIC);
        FIELD_TYPE_MAP.put("memo_type_id", DataType.INTEGER);
        FIELD_TYPE_MAP.put("memo_id", DataType.INTEGER);
        FIELD_TYPE_MAP.put("month_hr_cnt", DataType.NUMERIC);
        FIELD_TYPE_MAP.put("orig_cost", DataType.CURRENCY);
        FIELD_TYPE_MAP.put("parent_acct_id", DataType.INTEGER);
        FIELD_TYPE_MAP.put("parent_actv_code_id", DataType.INTEGER);
        FIELD_TYPE_MAP.put("parent_asgnmnt_catg_id", DataType.NUMERIC);
        FIELD_TYPE_MAP.put("parent_proj_catg_id", DataType.INTEGER);
        FIELD_TYPE_MAP.put("parent_role_id", DataType.INTEGER);
        FIELD_TYPE_MAP.put("parent_role_catg_id", DataType.INTEGER);
        FIELD_TYPE_MAP.put("parent_rsrc_catg_id", DataType.INTEGER);
        FIELD_TYPE_MAP.put("parent_rsrc_id", DataType.INTEGER);
        FIELD_TYPE_MAP.put("parent_wbs_id", DataType.INTEGER);
        FIELD_TYPE_MAP.put("pct_usage_0", DataType.NUMERIC);
        FIELD_TYPE_MAP.put("pct_usage_1", DataType.NUMERIC);
        FIELD_TYPE_MAP.put("pct_usage_2", DataType.NUMERIC);
        FIELD_TYPE_MAP.put("pct_usage_3", DataType.NUMERIC);
        FIELD_TYPE_MAP.put("pct_usage_4", DataType.NUMERIC);
        FIELD_TYPE_MAP.put("pct_usage_5", DataType.NUMERIC);
        FIELD_TYPE_MAP.put("pct_usage_6", DataType.NUMERIC);
        FIELD_TYPE_MAP.put("pct_usage_7", DataType.NUMERIC);
        FIELD_TYPE_MAP.put("pct_usage_8", DataType.NUMERIC);
        FIELD_TYPE_MAP.put("pct_usage_9", DataType.NUMERIC);
        FIELD_TYPE_MAP.put("pct_usage_10", DataType.NUMERIC);
        FIELD_TYPE_MAP.put("pct_usage_11", DataType.NUMERIC);
        FIELD_TYPE_MAP.put("pct_usage_12", DataType.NUMERIC);
        FIELD_TYPE_MAP.put("pct_usage_13", DataType.NUMERIC);
        FIELD_TYPE_MAP.put("pct_usage_14", DataType.NUMERIC);
        FIELD_TYPE_MAP.put("pct_usage_15", DataType.NUMERIC);
        FIELD_TYPE_MAP.put("pct_usage_16", DataType.NUMERIC);
        FIELD_TYPE_MAP.put("pct_usage_17", DataType.NUMERIC);
        FIELD_TYPE_MAP.put("pct_usage_18", DataType.NUMERIC);
        FIELD_TYPE_MAP.put("pct_usage_19", DataType.NUMERIC);
        FIELD_TYPE_MAP.put("pct_usage_20", DataType.NUMERIC);
        FIELD_TYPE_MAP.put("phys_complete_pct", DataType.NUMERIC);
        FIELD_TYPE_MAP.put("plan_end_date", DataType.DATE);
        FIELD_TYPE_MAP.put("plan_start_date", DataType.DATE);
        FIELD_TYPE_MAP.put("pred_task_id", DataType.INTEGER);
        FIELD_TYPE_MAP.put("proc_id", DataType.INTEGER);
        FIELD_TYPE_MAP.put("proc_wt", DataType.NUMERIC);
        FIELD_TYPE_MAP.put("proj_catg_id", DataType.INTEGER);
        FIELD_TYPE_MAP.put("proj_catg_type_id", DataType.INTEGER);
        FIELD_TYPE_MAP.put("proj_catg_short_len", DataType.INTEGER);
        FIELD_TYPE_MAP.put("proj_id", DataType.INTEGER);
        FIELD_TYPE_MAP.put("reend_date", DataType.DATE);
        FIELD_TYPE_MAP.put("rem_late_start_date", DataType.DATE);
        FIELD_TYPE_MAP.put("rem_late_end_date", DataType.DATE);
        FIELD_TYPE_MAP.put("remain_cost", DataType.NUMERIC);
        FIELD_TYPE_MAP.put("remain_drtn_hr_cnt", DataType.DURATION);
        FIELD_TYPE_MAP.put("remain_equip_qty", DataType.DURATION);
        FIELD_TYPE_MAP.put("remain_qty", DataType.DURATION);
        FIELD_TYPE_MAP.put("remain_qty_per_hr", DataType.NUMERIC);
        FIELD_TYPE_MAP.put("remain_work_qty", DataType.DURATION);
        FIELD_TYPE_MAP.put("restart_date", DataType.DATE);
        FIELD_TYPE_MAP.put("resume_date", DataType.DATE);
        FIELD_TYPE_MAP.put("role_id", DataType.INTEGER);
        FIELD_TYPE_MAP.put("role_catg_id", DataType.INTEGER);
        FIELD_TYPE_MAP.put("role_catg_short_len", DataType.INTEGER);
        FIELD_TYPE_MAP.put("role_catg_type_id", DataType.INTEGER);
        FIELD_TYPE_MAP.put("rsrc_id", DataType.INTEGER);
        FIELD_TYPE_MAP.put("rsrc_catg_id", DataType.INTEGER);
        FIELD_TYPE_MAP.put("rsrc_catg_type_id", DataType.INTEGER);
        FIELD_TYPE_MAP.put("rsrc_catg_short_len", DataType.INTEGER);
        FIELD_TYPE_MAP.put("rsrc_role_id", DataType.INTEGER);
        FIELD_TYPE_MAP.put("rsrc_seq_num", DataType.INTEGER);
        FIELD_TYPE_MAP.put("scd_end_date", DataType.DATE);
        FIELD_TYPE_MAP.put("sched_calendar_on_relationship_lag", DataType.STRING);
        FIELD_TYPE_MAP.put("seq_num", DataType.INTEGER);
        FIELD_TYPE_MAP.put("shift_id", DataType.INTEGER);
        FIELD_TYPE_MAP.put("shift_period_id", DataType.INTEGER);
        FIELD_TYPE_MAP.put("shift_start_hr_num", DataType.INTEGER);
        FIELD_TYPE_MAP.put("skill_level", DataType.INTEGER);
        FIELD_TYPE_MAP.put("start_date", DataType.DATE);
        FIELD_TYPE_MAP.put("sum_base_proj_id", DataType.INTEGER);
        FIELD_TYPE_MAP.put("super_flag", DataType.STRING);
        FIELD_TYPE_MAP.put("suspend_date", DataType.DATE);
        FIELD_TYPE_MAP.put("table_name", DataType.STRING);
        FIELD_TYPE_MAP.put("target_cost", DataType.CURRENCY);
        FIELD_TYPE_MAP.put("target_drtn_hr_cnt", DataType.DURATION);
        FIELD_TYPE_MAP.put("target_end_date", DataType.DATE);
        FIELD_TYPE_MAP.put("target_equip_qty", DataType.DURATION);
        FIELD_TYPE_MAP.put("target_lag_drtn_hr_cnt", DataType.DURATION);
        FIELD_TYPE_MAP.put("target_qty", DataType.DURATION);
        FIELD_TYPE_MAP.put("target_qty_per_hr", DataType.NUMERIC);
        FIELD_TYPE_MAP.put("target_start_date", DataType.DATE);
        FIELD_TYPE_MAP.put("target_work_qty", DataType.DURATION);
        FIELD_TYPE_MAP.put("task_code_base", DataType.INTEGER);
        FIELD_TYPE_MAP.put("task_code_step", DataType.INTEGER);
        FIELD_TYPE_MAP.put("task_id", DataType.INTEGER);
        FIELD_TYPE_MAP.put("task_pred_id", DataType.INTEGER);
        FIELD_TYPE_MAP.put("taskrsrc_id", DataType.INTEGER);
        FIELD_TYPE_MAP.put("tmpl_guid", DataType.GUID);
        FIELD_TYPE_MAP.put("total_float_hr_cnt", DataType.DURATION);
        FIELD_TYPE_MAP.put("udf_code_id", DataType.INTEGER);
        FIELD_TYPE_MAP.put("udf_date", DataType.DATE);
        FIELD_TYPE_MAP.put("udf_number", DataType.NUMERIC);
        FIELD_TYPE_MAP.put("udf_text", DataType.STRING);
        FIELD_TYPE_MAP.put("udf_type", DataType.INTEGER);
        FIELD_TYPE_MAP.put("udf_type_id", DataType.INTEGER);
        FIELD_TYPE_MAP.put("udf_type_label", DataType.STRING);
        FIELD_TYPE_MAP.put("udf_type_name", DataType.STRING);
        FIELD_TYPE_MAP.put("unit_id", DataType.INTEGER);
        FIELD_TYPE_MAP.put("wbs_id", DataType.INTEGER);
        FIELD_TYPE_MAP.put("wbs_memo_id", DataType.INTEGER);
        FIELD_TYPE_MAP.put("week_hr_cnt", DataType.NUMERIC);
        FIELD_TYPE_MAP.put("year_hr_cnt", DataType.NUMERIC);
        LIST_REQUIRED_TABLES = new HashSet<String>();
        LIST_REQUIRED_TABLES.add("project");
        READ_REQUIRED_TABLES = new HashSet<String>();
        READ_REQUIRED_TABLES.add("project");
        READ_REQUIRED_TABLES.add("calendar");
        READ_REQUIRED_TABLES.add("rsrc");
        READ_REQUIRED_TABLES.add("rsrcrate");
        READ_REQUIRED_TABLES.add("projwbs");
        READ_REQUIRED_TABLES.add("task");
        READ_REQUIRED_TABLES.add("taskpred");
        READ_REQUIRED_TABLES.add("taskrsrc");
        READ_REQUIRED_TABLES.add("currtype");
        READ_REQUIRED_TABLES.add("udftype");
        READ_REQUIRED_TABLES.add("udfvalue");
        READ_REQUIRED_TABLES.add("schedoptions");
        READ_REQUIRED_TABLES.add("actvtype");
        READ_REQUIRED_TABLES.add("actvcode");
        READ_REQUIRED_TABLES.add("taskactv");
        READ_REQUIRED_TABLES.add("costtype");
        READ_REQUIRED_TABLES.add("account");
        READ_REQUIRED_TABLES.add("projcost");
        READ_REQUIRED_TABLES.add("memotype");
        READ_REQUIRED_TABLES.add("wbsmemo");
        READ_REQUIRED_TABLES.add("taskmemo");
        READ_REQUIRED_TABLES.add("roles");
        READ_REQUIRED_TABLES.add("rolerate");
        READ_REQUIRED_TABLES.add("rsrccurvdata");
        READ_REQUIRED_TABLES.add("taskproc");
        READ_REQUIRED_TABLES.add("location");
        READ_REQUIRED_TABLES.add("umeasure");
        READ_REQUIRED_TABLES.add("shift");
        READ_REQUIRED_TABLES.add("shiftper");
        READ_REQUIRED_TABLES.add("rsrcrole");
        READ_REQUIRED_TABLES.add("pcattype");
        READ_REQUIRED_TABLES.add("pcatval");
        READ_REQUIRED_TABLES.add("projpcat");
        READ_REQUIRED_TABLES.add("rcattype");
        READ_REQUIRED_TABLES.add("rcatval");
        READ_REQUIRED_TABLES.add("rsrcrcat");
        READ_REQUIRED_TABLES.add("rolecattype");
        READ_REQUIRED_TABLES.add("rolecatval");
        READ_REQUIRED_TABLES.add("rolercat");
        READ_REQUIRED_TABLES.add("asgnmntcattype");
        READ_REQUIRED_TABLES.add("asgnmntcatval");
        READ_REQUIRED_TABLES.add("asgnmntacat");
        WBS_ROW_COMPARATOR = new WbsRowComparatorXER();
    }

    private static enum XerRecordType {
        HEADER,
        TABLE,
        FIELDS,
        DATA,
        END;

    }
}

