/*
 * Decompiled with CFR 0.152.
 */
package org.mpxj.primavera;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.mpxj.ActivityCode;
import org.mpxj.ActivityCodeValue;
import org.mpxj.ActivityStatus;
import org.mpxj.ActivityType;
import org.mpxj.Availability;
import org.mpxj.CalendarType;
import org.mpxj.CostAccount;
import org.mpxj.CostRateTableEntry;
import org.mpxj.Currency;
import org.mpxj.CustomField;
import org.mpxj.Duration;
import org.mpxj.ExpenseCategory;
import org.mpxj.ExpenseItem;
import org.mpxj.FieldContainer;
import org.mpxj.FieldType;
import org.mpxj.Location;
import org.mpxj.Notes;
import org.mpxj.NotesTopic;
import org.mpxj.ParentNotes;
import org.mpxj.PercentCompleteType;
import org.mpxj.ProjectCalendar;
import org.mpxj.ProjectCode;
import org.mpxj.ProjectCodeValue;
import org.mpxj.ProjectFile;
import org.mpxj.ProjectProperties;
import org.mpxj.Relation;
import org.mpxj.Resource;
import org.mpxj.ResourceAssignment;
import org.mpxj.ResourceAssignmentCode;
import org.mpxj.ResourceAssignmentCodeValue;
import org.mpxj.ResourceCode;
import org.mpxj.ResourceCodeValue;
import org.mpxj.ResourceType;
import org.mpxj.RoleCode;
import org.mpxj.RoleCodeValue;
import org.mpxj.SchedulingProgressedActivities;
import org.mpxj.Shift;
import org.mpxj.ShiftPeriod;
import org.mpxj.Step;
import org.mpxj.StructuredNotes;
import org.mpxj.Task;
import org.mpxj.TaskContainer;
import org.mpxj.TimeUnit;
import org.mpxj.TimeUnitDefaultsContainer;
import org.mpxj.UnitOfMeasure;
import org.mpxj.UserDefinedField;
import org.mpxj.WorkContour;
import org.mpxj.common.BooleanHelper;
import org.mpxj.common.CharsetHelper;
import org.mpxj.common.FieldTypeHelper;
import org.mpxj.common.NumberHelper;
import org.mpxj.common.ObjectSequence;
import org.mpxj.common.Pair;
import org.mpxj.common.StringHelper;
import org.mpxj.primavera.ActivityStatusHelper;
import org.mpxj.primavera.ActivityTypeHelper;
import org.mpxj.primavera.CurrencyValue;
import org.mpxj.primavera.CurveHelper;
import org.mpxj.primavera.DateOnly;
import org.mpxj.primavera.FieldTypeClassHelper;
import org.mpxj.primavera.MaxUnits;
import org.mpxj.primavera.ProjectCalendarHelper;
import org.mpxj.primavera.ProjectCalendarStructuredTextWriter;
import org.mpxj.primavera.RateTypeHelper;
import org.mpxj.primavera.RelationshipLagCalendarHelper;
import org.mpxj.primavera.TaskHelper;
import org.mpxj.primavera.TimephasedHelper;
import org.mpxj.primavera.TotalSlackCalculationTypeHelper;
import org.mpxj.primavera.UdfHelper;
import org.mpxj.primavera.WorkHelper;
import org.mpxj.primavera.WriterHelper;
import org.mpxj.primavera.XerUnitsHelper;
import org.mpxj.primavera.XerWriter;
import org.mpxj.writer.AbstractProjectWriter;

public class PrimaveraXERFileWriter
extends AbstractProjectWriter {
    private Charset m_charset = CharsetHelper.CP1252;
    private ProjectFile m_file;
    private XerWriter m_writer;
    private ObjectSequence m_rateObjectID;
    private List<Map<String, Object>> m_wbsNotes;
    private List<Map<String, Object>> m_activityNotes;
    private Set<FieldType> m_userDefinedFields;
    private Task m_temporaryRootWbs;
    private Integer m_originalOutlineLevel;
    private boolean m_projectFromPrimavera;
    private static final Integer DEFAULT_PROJECT_ID = 1;
    private static final Currency DEFAULT_CURRENCY = new Currency.Builder(null).uniqueID(1).numberOfDecimalPlaces(2).symbol("$").decimalSymbol(".").digitGroupingSymbol(",").positiveCurrencyFormat("#1.1").negativeCurrencyFormat("(#1.1)").name("US Dollar").currencyID("USD").exchangeRate(1.0).build();
    private static final Map<String, ExportFunction<Currency>> CURRENCY_COLUMNS = new LinkedHashMap<String, ExportFunction<Currency>>();
    private static final Map<String, ExportFunction<Resource>> ROLE_COLUMNS;
    private static final Map<String, ExportFunction<Map<String, Object>>> ROLE_RATE_COLUMNS;
    private static final Map<String, ExportFunction<Map<String, Object>>> RESOURCE_RATE_COLUMNS;
    private static final Map<String, ExportFunction<Resource>> RESOURCE_COLUMNS;
    private static final Map<String, ExportFunction<ProjectProperties>> PROJECT_COLUMNS;
    private static final Map<String, ExportFunction<ProjectCalendar>> CALENDAR_COLUMNS;
    private static final Map<String, ExportFunction<Task>> WBS_COLUMNS;
    private static final Map<String, ExportFunction<Task>> ACTIVITY_COLUMNS;
    private static final Map<String, ExportFunction<Relation>> PREDECESSOR_COLUMNS;
    private static final Map<String, ExportFunction<ResourceAssignment>> RESOURCE_ASSIGNMENT_COLUMNS;
    private static final Map<String, ExportFunction<CostAccount>> COST_ACCOUNT_COLUMNS;
    private static final Map<String, ExportFunction<ExpenseCategory>> EXPENSE_CATEGORY_COLUMNS;
    private static final Map<String, ExportFunction<Location>> LOCATION_COLUMNS;
    private static final Map<String, ExportFunction<ExpenseItem>> EXPENSE_ITEM_COLUMNS;
    private static final Map<String, ExportFunction<WorkContour>> RESOURCE_CURVE_COLUMNS;
    private static final Map<String, ExportFunction<Step>> ACTIVITY_STEP_COLUMNS;
    private static final Map<String, ExportFunction<ActivityCode>> ACTIVITY_CODE_COLUMNS;
    private static final Map<String, ExportFunction<ActivityCodeValue>> ACTIVITY_CODE_VALUE_COLUMNS;
    private static final Map<String, ExportFunction<Pair<Task, ActivityCodeValue>>> ACTIVITY_CODE_ASSIGNMENT_COLUMNS;
    private static final Map<String, ExportFunction<Pair<FieldType, CustomField>>> UDF_TYPE_COLUMNS;
    private static final Map<String, ExportFunction<Map<String, Object>>> UDF_ASSIGNMENT_COLUMNS;
    private static final Map<String, ExportFunction<NotesTopic>> NOTE_TYPE_COLUMNS;
    private static final Map<String, ExportFunction<Map<String, Object>>> WBS_NOTE_COLUMNS;
    private static final Map<String, ExportFunction<Map<String, Object>>> ACTIVITY_NOTE_COLUMNS;
    private static final Map<String, ExportFunction<ProjectProperties>> SCHEDULE_OPTIONS_COLUMNS;
    private static final Map<String, ExportFunction<UnitOfMeasure>> UNIT_OF_MEASURE_COLUMNS;
    private static final Map<String, ExportFunction<Shift>> SHIFT_COLUMNS;
    private static final Map<String, ExportFunction<ShiftPeriod>> SHIFT_PERIOD_COLUMNS;
    private static final Map<String, ExportFunction<Map<String, Object>>> ROLE_ASSIGNMENT_COLUMNS;
    private static final Map<String, ExportFunction<ProjectCode>> PROJECT_CODE_COLUMNS;
    private static final Map<String, ExportFunction<ProjectCodeValue>> PROJECT_CODE_VALUE_COLUMNS;
    private static final Map<String, ExportFunction<Map<String, Object>>> PROJECT_CODE_ASSIGNMENT_COLUMNS;
    private static final Map<String, ExportFunction<ResourceCode>> RESOURCE_CODE_COLUMNS;
    private static final Map<String, ExportFunction<ResourceCodeValue>> RESOURCE_CODE_VALUE_COLUMNS;
    private static final Map<String, ExportFunction<Map<String, Object>>> RESOURCE_CODE_ASSIGNMENT_COLUMNS;
    private static final Map<String, ExportFunction<RoleCode>> ROLE_CODE_COLUMNS;
    private static final Map<String, ExportFunction<RoleCodeValue>> ROLE_CODE_VALUE_COLUMNS;
    private static final Map<String, ExportFunction<Map<String, Object>>> ROLE_CODE_ASSIGNMENT_COLUMNS;
    private static final Map<String, ExportFunction<ResourceAssignmentCode>> RESOURCE_ASSIGNMENT_CODE_COLUMNS;
    private static final Map<String, ExportFunction<ResourceAssignmentCodeValue>> RESOURCE_ASSIGNMENT_CODE_VALUE_COLUMNS;
    private static final Map<String, ExportFunction<Map<String, Object>>> RESOURCE_ASSIGNMENT_CODE_ASSIGNMENT_COLUMNS;

    public void setCharset(Charset charset) {
        this.m_charset = charset;
    }

    public Charset getCharset() {
        return this.m_charset;
    }

    @Override
    public void write(ProjectFile projectFile, OutputStream outputStream) throws IOException {
        this.m_file = projectFile;
        this.m_writer = new XerWriter(projectFile, new OutputStreamWriter(outputStream, this.getCharset()));
        this.m_rateObjectID = new ObjectSequence(1);
        this.m_userDefinedFields = UdfHelper.getUserDefinedFieldsSet(projectFile);
        this.m_projectFromPrimavera = "Primavera".equals(this.m_file.getProjectProperties().getFileApplication());
        this.populateWbsNotes();
        this.populateActivityNotes();
        this.createValidWbsHierarchy();
        try {
            this.writeHeader();
            this.writeResourceAssignmentCodes();
            this.writeExpenseCategories();
            this.writeCurrencies();
            this.writeShifts();
            this.writeShiftPeriods();
            this.writeLocations();
            this.writeNoteTypes();
            this.writeProjectCodes();
            this.writeResourceCodes();
            this.writeRoleCodes();
            this.writeResourceCurves();
            this.writeUdfDefinitions();
            this.writeUnitsOfMeasure();
            this.writeCostAccounts();
            this.writeResourceAssignmentCodeValues();
            this.writeProjectCodeValues();
            this.writeResourceCodeValues();
            this.writeRoleCodeValues();
            this.writeRoles();
            this.writeProject();
            this.writeRoleRates();
            this.writeRoleCodeAssignments();
            this.writeCalendars();
            this.writeProjectCodeAssignments();
            this.writeScheduleOptions();
            this.writeWBS();
            this.writeResources();
            this.writeActivityCodes();
            this.writeResourceRates();
            this.writeResourceCodeAssignments();
            this.writeRoleAssignments();
            this.writeActivities();
            this.writeWbsNotes();
            this.writeActivityCodeValues();
            this.writeActivitySteps();
            this.writeExpenseItems();
            this.writeActivityNotes();
            this.writePredecessors();
            this.writeResourceAssignments();
            this.writeResourceAssignmentCodeAssignments();
            this.writeActivityCodeAssignments();
            this.writeUdfValues();
            this.m_writer.writeTrailer();
            this.m_writer.flush();
        }
        finally {
            this.revertWbsHierarchyChange();
            this.m_writer = null;
        }
    }

    private void writeHeader() {
        Object[] data = new Object[]{"ERMHDR", "20.12", new DateOnly(this.m_file.getProjectProperties().getCurrentDate()), "Project", "admin", "admin", "dbxDatabaseNoName", "Project Management", this.getDefaultCurrency().getCurrencyID()};
        this.m_writer.writeHeader(data);
    }

    private void writeCurrencies() {
        this.m_writer.writeTable("CURRTYPE", CURRENCY_COLUMNS);
        if (this.m_file.getCurrencies().isEmpty()) {
            this.m_writer.writeRecord(CURRENCY_COLUMNS, DEFAULT_CURRENCY);
        } else {
            this.m_file.getCurrencies().forEach(c -> this.m_writer.writeRecord(CURRENCY_COLUMNS, c));
        }
    }

    private void writeRoles() {
        this.m_writer.writeTable("ROLES", ROLE_COLUMNS);
        this.getSortedRoleStream().forEach(r -> this.m_writer.writeRecord(ROLE_COLUMNS, r));
    }

    private void writeRoleRates() {
        this.m_writer.writeTable("ROLERATE", ROLE_RATE_COLUMNS);
        this.getSortedRoleStream().forEach(r -> this.writeCostRateTableEntries(ROLE_RATE_COLUMNS, (Resource)r));
    }

    private void writeResourceRates() {
        this.m_writer.writeTable("RSRCRATE", RESOURCE_RATE_COLUMNS);
        this.getSortedResourceStream().forEach(r -> this.writeCostRateTableEntries(RESOURCE_RATE_COLUMNS, (Resource)r));
    }

    private void writeCostRateTableEntries(Map<String, ExportFunction<Map<String, Object>>> columns, Resource resource) {
        resource.getCostRateTable(0).stream().filter(e -> e != CostRateTableEntry.DEFAULT_ENTRY).forEach(e -> this.writeCostRateTableEntry(columns, resource, (CostRateTableEntry)e));
    }

    private void writeCostRateTableEntry(Map<String, ExportFunction<Map<String, Object>>> columns, Resource resource, CostRateTableEntry entry) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("object_id", this.m_rateObjectID.getNext());
        map.put("entity_id", resource.getUniqueID());
        map.put("cost_per_qty", entry.getRate(0));
        map.put("cost_per_qty2", entry.getRate(1));
        map.put("cost_per_qty3", entry.getRate(2));
        map.put("cost_per_qty4", entry.getRate(3));
        map.put("cost_per_qty5", entry.getRate(4));
        map.put("start_date", entry.getStartDate());
        map.put("max_qty_per_hr", this.getMaxQuantityPerHour(resource, entry));
        map.put("shift_period_id", entry.getShiftPeriod() == null ? null : entry.getShiftPeriod().getUniqueID());
        this.m_writer.writeRecord(columns, map);
    }

    private void writeResources() {
        this.m_writer.writeTable("RSRC", RESOURCE_COLUMNS);
        this.getSortedResourceStream().forEach(r -> this.m_writer.writeRecord(RESOURCE_COLUMNS, r));
    }

    private void writeProject() {
        this.m_writer.writeTable("PROJECT", PROJECT_COLUMNS);
        this.m_writer.writeRecord(PROJECT_COLUMNS, this.m_file.getProjectProperties());
    }

    private void writeCalendars() {
        this.m_writer.writeTable("CALENDAR", CALENDAR_COLUMNS);
        this.m_file.getCalendars().stream().sorted(Comparator.comparing(ProjectCalendar::getUniqueID)).map(ProjectCalendarHelper::normalizeCalendar).forEach(c -> this.m_writer.writeRecord(CALENDAR_COLUMNS, c));
    }

    private void writeScheduleOptions() {
        this.m_writer.writeTable("SCHEDOPTIONS", SCHEDULE_OPTIONS_COLUMNS);
        this.m_writer.writeRecord(SCHEDULE_OPTIONS_COLUMNS, this.m_file.getProjectProperties());
    }

    private void writeWBS() {
        this.m_writer.writeTable("PROJWBS", WBS_COLUMNS);
        this.getWbsStream().sorted(Comparator.comparing(Task::getUniqueID)).forEach(t -> this.m_writer.writeRecord(WBS_COLUMNS, t));
    }

    private void writeActivities() {
        this.m_writer.writeTable("TASK", ACTIVITY_COLUMNS);
        this.getActivityStream().sorted(Comparator.comparing(Task::getUniqueID)).forEach(t -> this.m_writer.writeRecord(ACTIVITY_COLUMNS, t));
    }

    private void writePredecessors() {
        this.m_writer.writeTable("TASKPRED", PREDECESSOR_COLUMNS);
        this.getActivityStream().map(Task::getPredecessors).flatMap(Collection::stream).sorted(Comparator.comparing(Relation::getUniqueID)).forEach(r -> this.m_writer.writeRecord(PREDECESSOR_COLUMNS, r));
    }

    private void writeResourceAssignments() {
        Map<String, ExportFunction<ResourceAssignment>> columns;
        if (this.m_projectFromPrimavera) {
            columns = RESOURCE_ASSIGNMENT_COLUMNS;
        } else {
            columns = new LinkedHashMap<String, ExportFunction<ResourceAssignment>>(RESOURCE_ASSIGNMENT_COLUMNS);
            columns.put("target_crv", r -> null);
            columns.put("remain_crv", r -> null);
            columns.put("actual_crv", r -> null);
        }
        this.m_writer.writeTable("TASKRSRC", RESOURCE_ASSIGNMENT_COLUMNS);
        this.getSortedResourceAssignmentStream().forEach(t -> this.m_writer.writeRecord(columns, t));
    }

    private void writeCostAccounts() {
        this.m_writer.writeTable("ACCOUNT", COST_ACCOUNT_COLUMNS);
        this.m_file.getCostAccounts().stream().sorted(Comparator.comparing(CostAccount::getUniqueID)).forEach(a -> this.m_writer.writeRecord(COST_ACCOUNT_COLUMNS, a));
    }

    private void writeExpenseCategories() {
        this.m_writer.writeTable("COSTTYPE", EXPENSE_CATEGORY_COLUMNS);
        this.m_file.getExpenseCategories().stream().sorted(Comparator.comparing(ExpenseCategory::getUniqueID)).forEach(a -> this.m_writer.writeRecord(EXPENSE_CATEGORY_COLUMNS, a));
    }

    private void writeUnitsOfMeasure() {
        this.m_writer.writeTable("UMEASURE", UNIT_OF_MEASURE_COLUMNS);
        this.m_file.getUnitsOfMeasure().stream().sorted(Comparator.comparing(UnitOfMeasure::getUniqueID)).forEach(a -> this.m_writer.writeRecord(UNIT_OF_MEASURE_COLUMNS, a));
    }

    private void writeShifts() {
        if (this.m_file.getShifts().isEmpty()) {
            return;
        }
        this.m_writer.writeTable("SHIFT", SHIFT_COLUMNS);
        this.m_file.getShifts().stream().sorted(Comparator.comparing(Shift::getUniqueID)).forEach(l -> this.m_writer.writeRecord(SHIFT_COLUMNS, l));
    }

    private void writeShiftPeriods() {
        if (this.m_file.getShiftPeriods().isEmpty()) {
            return;
        }
        this.m_writer.writeTable("SHIFTPER", SHIFT_PERIOD_COLUMNS);
        this.m_file.getShiftPeriods().stream().sorted(Comparator.comparing(ShiftPeriod::getUniqueID)).forEach(l -> this.m_writer.writeRecord(SHIFT_PERIOD_COLUMNS, l));
    }

    private void writeLocations() {
        if (this.m_file.getLocations().isEmpty()) {
            return;
        }
        this.m_writer.writeTable("LOCATION", LOCATION_COLUMNS);
        this.m_file.getLocations().stream().sorted(Comparator.comparing(Location::getUniqueID)).forEach(l -> this.m_writer.writeRecord(LOCATION_COLUMNS, l));
    }

    private void writeExpenseItems() {
        this.m_writer.writeTable("PROJCOST", EXPENSE_ITEM_COLUMNS);
        this.getActivityStream().map(Task::getExpenseItems).flatMap(Collection::stream).sorted(Comparator.comparing(ExpenseItem::getUniqueID)).forEach(i -> this.m_writer.writeRecord(EXPENSE_ITEM_COLUMNS, i));
    }

    private void writeResourceCurves() {
        this.m_writer.writeTable("RSRCCURVDATA", RESOURCE_CURVE_COLUMNS);
        this.m_file.getWorkContours().stream().filter(w -> !w.isContourManual() && !w.isContourFlat()).sorted(Comparator.comparing(WorkContour::getUniqueID)).forEach(r -> this.m_writer.writeRecord(RESOURCE_CURVE_COLUMNS, r));
    }

    private void writeActivitySteps() {
        this.m_writer.writeTable("TASKPROC", ACTIVITY_STEP_COLUMNS);
        this.getActivityStream().map(Task::getSteps).flatMap(Collection::stream).sorted(Comparator.comparing(Step::getUniqueID)).forEach(s -> this.m_writer.writeRecord(ACTIVITY_STEP_COLUMNS, s));
    }

    private void writeActivityCodes() {
        this.m_writer.writeTable("ACTVTYPE", ACTIVITY_CODE_COLUMNS);
        this.m_file.getActivityCodes().stream().sorted(Comparator.comparing(ActivityCode::getUniqueID)).forEach(c -> this.m_writer.writeRecord(ACTIVITY_CODE_COLUMNS, c));
    }

    private void writeActivityCodeValues() {
        this.m_writer.writeTable("ACTVCODE", ACTIVITY_CODE_VALUE_COLUMNS);
        this.m_file.getActivityCodes().stream().map(ActivityCode::getValues).flatMap(Collection::stream).sorted(Comparator.comparing(ActivityCodeValue::getUniqueID)).forEach(v -> this.m_writer.writeRecord(ACTIVITY_CODE_VALUE_COLUMNS, v));
    }

    private void writeActivityCodeAssignments() {
        this.m_writer.writeTable("TASKACTV", ACTIVITY_CODE_ASSIGNMENT_COLUMNS);
        this.getActivityStream().collect(Collectors.toMap(t -> t, Task::getActivityCodeValues, (u, v) -> u, TreeMap::new)).forEach(this::writeActivityCodeAssignments);
    }

    private void writeActivityCodeAssignments(Task task, Map<ActivityCode, ActivityCodeValue> map) {
        map.values().stream().sorted(Comparator.comparing(ActivityCodeValue::getUniqueID)).forEach(v -> this.m_writer.writeRecord(ACTIVITY_CODE_ASSIGNMENT_COLUMNS, new Pair<Task, ActivityCodeValue>(task, (ActivityCodeValue)v)));
    }

    private void writeUdfDefinitions() {
        this.m_writer.writeTable("UDFTYPE", UDF_TYPE_COLUMNS);
        this.m_userDefinedFields.stream().map(f -> new Pair<FieldType, CustomField>((FieldType)f, this.m_file.getCustomFields().get((FieldType)f))).sorted(Comparator.comparing(p -> p.getSecond() == null ? Integer.valueOf(FieldTypeHelper.getFieldID((FieldType)p.getFirst())) : ((CustomField)p.getSecond()).getUniqueID())).forEach(p -> this.m_writer.writeRecord(UDF_TYPE_COLUMNS, p));
    }

    private void writeUdfValues() {
        ArrayList<Map> records = new ArrayList<Map>();
        records.addAll(this.writeActivityUdfValues());
        records.addAll(this.writeWbsUdfValues());
        records.addAll(this.writeResourceUdfValues());
        records.addAll(this.writeResourceAssignmentUdfValues());
        records.addAll(this.writeProjectUdfValues());
        records.removeIf(Objects::isNull);
        records.sort((r1, r2) -> {
            Integer id2;
            Integer id1 = (Integer)r1.get("udf_type_id");
            int result = id1.compareTo(id2 = (Integer)r2.get("udf_type_id"));
            if (result == 0) {
                id1 = (Integer)r1.get("fk_id");
                id2 = (Integer)r2.get("fk_id");
                result = id1.compareTo(id2);
            }
            return result;
        });
        this.m_writer.writeTable("UDFVALUE", UDF_ASSIGNMENT_COLUMNS);
        records.forEach(r -> this.m_writer.writeRecord(UDF_ASSIGNMENT_COLUMNS, r));
    }

    private List<Map<String, Object>> writeActivityUdfValues() {
        Set fields = this.m_userDefinedFields.stream().filter(f -> "TASK".equals(FieldTypeClassHelper.getXerFromInstance(f))).collect(Collectors.toSet());
        Integer projectID = PrimaveraXERFileWriter.getProjectID(this.m_file.getProjectProperties().getUniqueID());
        return this.getActivityStream().map(t -> this.writeUdfAssignments(fields, projectID, t.getUniqueID(), (FieldContainer)t)).flatMap(Collection::stream).collect(Collectors.toList());
    }

    private List<Map<String, Object>> writeWbsUdfValues() {
        Set fields = this.m_userDefinedFields.stream().filter(f -> "PROJWBS".equals(FieldTypeClassHelper.getXerFromInstance(f))).collect(Collectors.toSet());
        Integer projectID = PrimaveraXERFileWriter.getProjectID(this.m_file.getProjectProperties().getUniqueID());
        return this.getWbsStream().map(t -> this.writeUdfAssignments(fields, projectID, t.getUniqueID(), (FieldContainer)t)).flatMap(Collection::stream).collect(Collectors.toList());
    }

    private List<Map<String, Object>> writeResourceUdfValues() {
        Set fields = this.m_userDefinedFields.stream().filter(f -> "RSRC".equals(FieldTypeClassHelper.getXerFromInstance(f))).collect(Collectors.toSet());
        return this.getSortedResourceStream().map(r -> this.writeUdfAssignments(fields, null, r.getUniqueID(), (FieldContainer)r)).flatMap(Collection::stream).collect(Collectors.toList());
    }

    private List<Map<String, Object>> writeResourceAssignmentUdfValues() {
        Set fields = this.m_userDefinedFields.stream().filter(f -> "TASKRSRC".equals(FieldTypeClassHelper.getXerFromInstance(f))).collect(Collectors.toSet());
        Integer projectID = PrimaveraXERFileWriter.getProjectID(this.m_file.getProjectProperties().getUniqueID());
        return this.getSortedResourceAssignmentStream().map(a -> this.writeUdfAssignments(fields, projectID, a.getUniqueID(), (FieldContainer)a)).flatMap(Collection::stream).collect(Collectors.toList());
    }

    private List<Map<String, Object>> writeProjectUdfValues() {
        Set<FieldType> fields = this.m_userDefinedFields.stream().filter(f -> "PROJECT".equals(FieldTypeClassHelper.getXerFromInstance(f))).collect(Collectors.toSet());
        Integer projectID = PrimaveraXERFileWriter.getProjectID(this.m_file.getProjectProperties().getUniqueID());
        return this.writeUdfAssignments(fields, projectID, projectID, this.m_file.getProjectProperties());
    }

    private List<Map<String, Object>> writeUdfAssignments(Set<FieldType> fields, Integer projectID, Integer entityID, FieldContainer container) {
        return fields.stream().map(f -> this.writeUdfAssignment((FieldType)f, projectID, entityID, container.get((FieldType)f))).collect(Collectors.toList());
    }

    private Map<String, Object> writeUdfAssignment(FieldType type, Integer projectID, Integer entityID, Object value) {
        if (value == null) {
            return null;
        }
        HashMap<String, Object> record = new HashMap<String, Object>();
        record.put("udf_type_id", PrimaveraXERFileWriter.getUdfTypeID(type));
        record.put("fk_id", entityID);
        record.put("proj_id", projectID);
        switch (type.getDataType()) {
            case DURATION: 
            case STRING: {
                record.put("udf_text", value.toString());
                break;
            }
            case CURRENCY: 
            case INTEGER: 
            case SHORT: 
            case NUMERIC: {
                record.put("udf_number", value);
                break;
            }
            case BINARY: {
                break;
            }
            case DATE: {
                record.put("udf_date", value);
                break;
            }
            case BOOLEAN: {
                record.put("udf_number", BooleanHelper.getBoolean((Boolean)value) ? Integer.valueOf(1) : Integer.valueOf(0));
                break;
            }
            default: {
                throw new RuntimeException("Unconvertible data type: " + type.getDataType());
            }
        }
        return record;
    }

    private void writeNoteTypes() {
        this.m_writer.writeTable("MEMOTYPE", NOTE_TYPE_COLUMNS);
        this.m_file.getNotesTopics().stream().sorted(Comparator.comparing(NotesTopic::getUniqueID)).forEach(n -> this.m_writer.writeRecord(NOTE_TYPE_COLUMNS, n));
    }

    private void writeWbsNotes() {
        this.m_writer.writeTable("WBSMEMO", WBS_NOTE_COLUMNS);
        this.m_wbsNotes.forEach(n -> this.m_writer.writeRecord(WBS_NOTE_COLUMNS, n));
    }

    private void writeActivityNotes() {
        this.m_writer.writeTable("TASKMEMO", ACTIVITY_NOTE_COLUMNS);
        this.m_activityNotes.forEach(n -> this.m_writer.writeRecord(ACTIVITY_NOTE_COLUMNS, n));
    }

    private void writeRoleAssignments() {
        List<Map> assignments = this.getSortedResourceStream().flatMap(r -> this.getRoleAssignments((Resource)r).stream()).collect(Collectors.toList());
        if (assignments.isEmpty()) {
            return;
        }
        this.m_writer.writeTable("RSRCROLE", ROLE_ASSIGNMENT_COLUMNS);
        assignments.forEach(a -> this.m_writer.writeRecord(ROLE_ASSIGNMENT_COLUMNS, a));
    }

    private List<Map<String, Object>> getRoleAssignments(Resource resource) {
        if (resource.getRoleAssignments().isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        Integer resourceUniqueID = resource.getUniqueID();
        String resourceShortName = WriterHelper.getResourceID(resource);
        String resourceName = StringHelper.stripControlCharacters(resource.getName());
        ResourceType resourceType = resource.getType();
        Integer resourcePrimaryRoleID = resource.getPrimaryRoleUniqueID();
        for (Map.Entry entry : resource.getRoleAssignments().entrySet().stream().sorted(Comparator.comparing(e -> ((Resource)e.getKey()).getUniqueID())).collect(Collectors.toList())) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            Resource role = (Resource)entry.getKey();
            map.put("rsrc_id", resourceUniqueID);
            map.put("role_id", role.getUniqueID());
            map.put("skill_level", entry.getValue());
            map.put("role_short_name", WriterHelper.getRoleID(role));
            map.put("role_name", StringHelper.stripControlCharacters(role.getName()));
            map.put("rsrc_short_name", resourceShortName);
            map.put("rsrc_name", resourceName);
            map.put("rsrc_type", resourceType);
            map.put("rsrc_role_id", resourcePrimaryRoleID);
            result.add(map);
        }
        return result;
    }

    private void writeProjectCodes() {
        if (this.m_file.getProjectCodes().isEmpty()) {
            return;
        }
        this.m_writer.writeTable("PCATTYPE", PROJECT_CODE_COLUMNS);
        this.m_file.getProjectCodes().stream().sorted(Comparator.comparing(ProjectCode::getUniqueID)).forEach(c -> this.m_writer.writeRecord(PROJECT_CODE_COLUMNS, c));
    }

    private void writeProjectCodeValues() {
        if (this.m_file.getProjectCodes().isEmpty()) {
            return;
        }
        this.m_writer.writeTable("PCATVAL", PROJECT_CODE_VALUE_COLUMNS);
        this.m_file.getProjectCodes().stream().map(ProjectCode::getValues).flatMap(Collection::stream).sorted(Comparator.comparing(ProjectCodeValue::getUniqueID)).forEach(v -> this.m_writer.writeRecord(PROJECT_CODE_VALUE_COLUMNS, v));
    }

    private void writeProjectCodeAssignments() {
        Map<ProjectCode, ProjectCodeValue> assignments = this.m_file.getProjectProperties().getProjectCodeValues();
        if (assignments.isEmpty()) {
            return;
        }
        this.m_writer.writeTable("PROJPCAT", PROJECT_CODE_ASSIGNMENT_COLUMNS);
        Integer projectID = PrimaveraXERFileWriter.getProjectID(this.m_file.getProjectProperties().getUniqueID());
        assignments.values().stream().sorted(Comparator.comparing(ProjectCodeValue::getParentCodeUniqueID)).map(v -> this.populateProjectCodeAssignment(projectID, (ProjectCodeValue)v)).forEach(a -> this.m_writer.writeRecord(PROJECT_CODE_ASSIGNMENT_COLUMNS, a));
    }

    private Map<String, Object> populateProjectCodeAssignment(Integer projectID, ProjectCodeValue value) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("proj_id", projectID);
        map.put("proj_catg_type_id", value.getParentCodeUniqueID());
        map.put("proj_catg_id", value.getUniqueID());
        return map;
    }

    private void writeResourceCodes() {
        if (this.m_file.getResourceCodes().isEmpty()) {
            return;
        }
        this.m_writer.writeTable("RCATTYPE", RESOURCE_CODE_COLUMNS);
        this.m_file.getResourceCodes().stream().sorted(Comparator.comparing(ResourceCode::getUniqueID)).forEach(c -> this.m_writer.writeRecord(RESOURCE_CODE_COLUMNS, c));
    }

    private void writeResourceCodeValues() {
        if (this.m_file.getResourceCodes().isEmpty()) {
            return;
        }
        this.m_writer.writeTable("RCATVAL", RESOURCE_CODE_VALUE_COLUMNS);
        this.m_file.getResourceCodes().stream().map(ResourceCode::getValues).flatMap(Collection::stream).sorted(Comparator.comparing(ResourceCodeValue::getUniqueID)).forEach(v -> this.m_writer.writeRecord(RESOURCE_CODE_VALUE_COLUMNS, v));
    }

    private void writeResourceCodeAssignments() {
        List<Map> assignments = this.getSortedResourceStream().map(r -> r.getResourceCodeValues().values().stream().sorted(Comparator.comparing(ResourceCodeValue::getParentCodeUniqueID)).map(v -> this.populateResourceCodeAssignment(r.getUniqueID(), (ResourceCodeValue)v)).collect(Collectors.toList())).flatMap(Collection::stream).collect(Collectors.toList());
        if (assignments.isEmpty()) {
            return;
        }
        this.m_writer.writeTable("RSRCRCAT", RESOURCE_CODE_ASSIGNMENT_COLUMNS);
        assignments.forEach(a -> this.m_writer.writeRecord(RESOURCE_CODE_ASSIGNMENT_COLUMNS, a));
    }

    private void writeRoleCodes() {
        if (this.m_file.getRoleCodes().isEmpty()) {
            return;
        }
        this.m_writer.writeTable("ROLECATTYPE", ROLE_CODE_COLUMNS);
        this.m_file.getRoleCodes().stream().sorted(Comparator.comparing(RoleCode::getUniqueID)).forEach(c -> this.m_writer.writeRecord(ROLE_CODE_COLUMNS, c));
    }

    private void writeRoleCodeValues() {
        if (this.m_file.getRoleCodes().isEmpty()) {
            return;
        }
        this.m_writer.writeTable("ROLECATVAL", ROLE_CODE_VALUE_COLUMNS);
        this.m_file.getRoleCodes().stream().map(RoleCode::getValues).flatMap(Collection::stream).sorted(Comparator.comparing(RoleCodeValue::getUniqueID)).forEach(v -> this.m_writer.writeRecord(ROLE_CODE_VALUE_COLUMNS, v));
    }

    private void writeRoleCodeAssignments() {
        List<Map> assignments = this.getSortedRoleStream().map(r -> r.getRoleCodeValues().values().stream().sorted(Comparator.comparing(RoleCodeValue::getParentCodeUniqueID)).map(v -> this.populateRoleCodeAssignment(r.getUniqueID(), (RoleCodeValue)v)).collect(Collectors.toList())).flatMap(Collection::stream).collect(Collectors.toList());
        if (assignments.isEmpty()) {
            return;
        }
        this.m_writer.writeTable("ROLERCAT", ROLE_CODE_ASSIGNMENT_COLUMNS);
        assignments.forEach(a -> this.m_writer.writeRecord(ROLE_CODE_ASSIGNMENT_COLUMNS, a));
    }

    private void writeResourceAssignmentCodes() {
        if (this.m_file.getResourceAssignmentCodes().isEmpty()) {
            return;
        }
        this.m_writer.writeTable("ASGNMNTCATTYPE", RESOURCE_ASSIGNMENT_CODE_COLUMNS);
        this.m_file.getResourceAssignmentCodes().stream().sorted(Comparator.comparing(ResourceAssignmentCode::getUniqueID)).forEach(c -> this.m_writer.writeRecord(RESOURCE_ASSIGNMENT_CODE_COLUMNS, c));
    }

    private void writeResourceAssignmentCodeValues() {
        if (this.m_file.getResourceAssignmentCodes().isEmpty()) {
            return;
        }
        this.m_writer.writeTable("ASGNMNTCATVAL", RESOURCE_ASSIGNMENT_CODE_VALUE_COLUMNS);
        this.m_file.getResourceAssignmentCodes().stream().map(ResourceAssignmentCode::getValues).flatMap(Collection::stream).sorted(Comparator.comparing(ResourceAssignmentCodeValue::getUniqueID)).forEach(v -> this.m_writer.writeRecord(RESOURCE_ASSIGNMENT_CODE_VALUE_COLUMNS, v));
    }

    private void writeResourceAssignmentCodeAssignments() {
        List<Map> assignments = this.getSortedResourceAssignmentStream().map(r -> r.getResourceAssignmentCodeValues().values().stream().sorted(Comparator.comparing(ResourceAssignmentCodeValue::getParentCodeUniqueID)).map(v -> this.populateResourceAssignmentCodeAssignment(r.getUniqueID(), (ResourceAssignmentCodeValue)v)).collect(Collectors.toList())).flatMap(Collection::stream).collect(Collectors.toList());
        if (assignments.isEmpty()) {
            return;
        }
        this.m_writer.writeTable("ASGNMNTACAT", RESOURCE_ASSIGNMENT_CODE_ASSIGNMENT_COLUMNS);
        assignments.forEach(a -> this.m_writer.writeRecord(RESOURCE_ASSIGNMENT_CODE_ASSIGNMENT_COLUMNS, a));
    }

    private Map<String, Object> populateResourceCodeAssignment(Integer resourceID, ResourceCodeValue value) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("rsrc_id", resourceID);
        map.put("rsrc_catg_type_id", value.getParentCodeUniqueID());
        map.put("rsrc_catg_id", value.getUniqueID());
        return map;
    }

    private Map<String, Object> populateRoleCodeAssignment(Integer roleID, RoleCodeValue value) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("role_id", roleID);
        map.put("role_catg_type_id", value.getParentCodeUniqueID());
        map.put("role_catg_id", value.getUniqueID());
        return map;
    }

    private Map<String, Object> populateResourceAssignmentCodeAssignment(Integer resourceAssignmentID, ResourceAssignmentCodeValue value) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("taskrsrc_id", resourceAssignmentID);
        map.put("asgnmnt_catg_type_id", value.getParentCodeUniqueID());
        map.put("asgnmnt_catg_id", value.getUniqueID());
        map.put("proj_id", PrimaveraXERFileWriter.getProjectID(this.m_file.getProjectProperties().getUniqueID()));
        return map;
    }

    private void populateWbsNotes() {
        this.m_wbsNotes = this.populateNotes(this.getWbsStream());
    }

    private void populateActivityNotes() {
        this.m_activityNotes = this.populateNotes(this.getActivityStream());
    }

    private List<Map<String, Object>> populateNotes(Stream<Task> stream) {
        Map nestedList = stream.collect(Collectors.groupingBy(t -> t, LinkedHashMap::new, Collectors.mapping(t -> this.expandParentNotes(t.getNotesObject()), Collectors.toList())));
        Map<Task, List> flatList = nestedList.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((List)e.getValue()).stream().flatMap(Collection::stream).map(this::createStructuredNotes).collect(Collectors.toList())));
        return flatList.entrySet().stream().map(e -> ((List)e.getValue()).stream().map(n -> this.createNotesMap((Task)e.getKey(), (StructuredNotes)n)).collect(Collectors.toList())).flatMap(Collection::stream).sorted(Comparator.comparing(n -> (Integer)n.get("entity_memo_id"))).collect(Collectors.toList());
    }

    private List<Notes> expandParentNotes(Notes notes) {
        if (notes == null) {
            return Collections.emptyList();
        }
        if (notes instanceof ParentNotes) {
            return ((ParentNotes)notes).getChildNotes();
        }
        return Collections.singletonList(notes);
    }

    private StructuredNotes createStructuredNotes(Notes notes) {
        if (notes instanceof StructuredNotes) {
            return (StructuredNotes)notes;
        }
        return new StructuredNotes(this.m_file, null, this.m_file.getNotesTopics().getDefaultTopic(), notes);
    }

    private Map<String, Object> createNotesMap(Task task, StructuredNotes notes) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("entity_memo_id", notes.getUniqueID());
        map.put("proj_id", PrimaveraXERFileWriter.getProjectID(task.getParentFile().getProjectProperties().getUniqueID()));
        map.put("memo_type_id", notes.getTopicID());
        map.put("entity_id", task.getUniqueID());
        map.put("entity_memo", notes.getNotes());
        return map;
    }

    private MaxUnits getMaxQuantityPerHour(Resource resource, CostRateTableEntry entry) {
        Availability availability = resource.getAvailability().getEntryByDate(entry.getStartDate());
        return availability == null ? MaxUnits.ZERO : new MaxUnits(availability.getUnits());
    }

    private void createValidWbsHierarchy() {
        List wbsWithoutParent = this.getWbsStream().filter(t -> t.getParentTask() == null).collect(Collectors.toList());
        if (wbsWithoutParent.size() < 2) {
            return;
        }
        TaskContainer tasks = this.m_file.getTasks();
        ProjectProperties projectProperties = this.m_file.getProjectProperties();
        Integer uniqueID = tasks.stream().map(Task::getUniqueID).min(Comparator.naturalOrder()).orElse(null);
        uniqueID = uniqueID == null || uniqueID <= 1 ? this.m_file.getUniqueIdObjectSequence(Task.class).getNext() : Integer.valueOf(uniqueID - 1);
        String name = projectProperties.getName();
        if (name == null || name.isEmpty()) {
            name = projectProperties.getProjectTitle();
        }
        this.m_originalOutlineLevel = ((Task)wbsWithoutParent.get(0)).getOutlineLevel();
        this.m_temporaryRootWbs = this.m_file.addTask();
        this.m_temporaryRootWbs.setUniqueID(uniqueID);
        this.m_temporaryRootWbs.setName(StringHelper.stripControlCharacters(name));
        this.m_temporaryRootWbs.setSequenceNumber(0);
        this.m_temporaryRootWbs.setWBS(PrimaveraXERFileWriter.getProjectShortName(projectProperties));
        this.m_file.getTasks().stream().filter(t -> t != this.m_temporaryRootWbs && t.getParentTask() == null).forEach(t -> this.m_temporaryRootWbs.addChildTask((Task)t));
    }

    private void revertWbsHierarchyChange() {
        if (this.m_temporaryRootWbs == null) {
            return;
        }
        ArrayList<Task> childTasks = new ArrayList<Task>(this.m_temporaryRootWbs.getChildTasks());
        for (Task task : childTasks) {
            this.m_temporaryRootWbs.removeChildTask(task);
            task.setOutlineLevel(this.m_originalOutlineLevel);
        }
        this.m_file.removeTask(this.m_temporaryRootWbs);
    }

    private Stream<Task> getActivityStream() {
        return this.m_file.getTasks().stream().filter(t -> !t.getSummary() && !t.getNull());
    }

    private Stream<Task> getWbsStream() {
        return this.m_file.getTasks().stream().filter(Task::getSummary);
    }

    private Stream<Resource> getSortedResourceStream() {
        return this.m_file.getResources().stream().filter(r -> !r.getRole() && r.getUniqueID() != 0).sorted(Comparator.comparing(Resource::getUniqueID));
    }

    private Stream<Resource> getSortedRoleStream() {
        return this.m_file.getResources().stream().filter(r -> r.getRole() && r.getUniqueID() != 0).sorted(Comparator.comparing(Resource::getUniqueID));
    }

    private Stream<ResourceAssignment> getSortedResourceAssignmentStream() {
        return this.m_file.getResourceAssignments().stream().filter(WriterHelper::isValidAssignment).sorted(Comparator.comparing(ResourceAssignment::getUniqueID));
    }

    private Currency getDefaultCurrency() {
        Currency currency = (Currency)this.m_file.getCurrencies().getByUniqueID(1);
        if (currency == null) {
            return DEFAULT_CURRENCY;
        }
        return currency;
    }

    private static Duration getActualRegularWork(ResourceAssignment assignment) {
        ProjectProperties properties = assignment.getParentFile().getProjectProperties();
        Duration actualWork = assignment.getActualWork() == null ? Duration.getInstance(0, TimeUnit.HOURS) : assignment.getActualWork().convertUnits(TimeUnit.HOURS, properties);
        Duration actualOvertimeWork = assignment.getActualOvertimeWork() == null ? Duration.getInstance(0, TimeUnit.HOURS) : assignment.getActualOvertimeWork().convertUnits(TimeUnit.HOURS, properties);
        return Duration.getInstance(actualWork.getDuration() - actualOvertimeWork.getDuration(), TimeUnit.HOURS);
    }

    private static Double getActualRegularCost(ResourceAssignment assignment) {
        double actualCost = NumberHelper.getDouble(assignment.getActualCost());
        double actualOvertimeCost = NumberHelper.getDouble(assignment.getActualOvertimeCost());
        return actualCost - actualOvertimeCost;
    }

    private static Integer getUdfTypeID(FieldType type) {
        return type instanceof UserDefinedField ? ((UserDefinedField)type).getUniqueID() : Integer.valueOf(FieldTypeHelper.getFieldID(type));
    }

    private static String getUdfTypeName(FieldType type) {
        if (type instanceof UserDefinedField) {
            return type.name();
        }
        return "user_field_" + PrimaveraXERFileWriter.getUdfTypeID(type);
    }

    private static String getUdfTypeLabel(FieldType type, CustomField field) {
        return field != null && field.getAlias() != null && !field.getAlias().isEmpty() ? field.getAlias() : type.getName();
    }

    private static boolean locationIsCity(Location location) {
        return location.getCity() != null && !location.getCity().isEmpty() && location.getState() != null && !location.getState().isEmpty() && location.getStateCode() != null && !location.getStateCode().isEmpty() && location.getCountry() != null && !location.getCountry().isEmpty() && location.getCountryCode() != null && !location.getCountryCode().isEmpty();
    }

    private static Integer getProjectID(Integer id) {
        return id == null ? DEFAULT_PROJECT_ID : id;
    }

    private static ActivityType getActivityType(Task task) {
        ActivityType type = task.getActivityType();
        return type == null ? ActivityTypeHelper.EXISTING_ACTIVITY_DEFAULT_TYPE : type;
    }

    private static String getProjectShortName(ProjectProperties props) {
        String shortName = props.getProjectID();
        if (shortName == null || shortName.isEmpty()) {
            shortName = "PROJECT";
        }
        return shortName;
    }

    private static Integer getSequenceNumber(Task task) {
        Integer sequenceNumber = task.getSequenceNumber();
        return sequenceNumber == null ? task.getID() : sequenceNumber;
    }

    private static Integer getSequenceNumber(Resource resource) {
        Integer sequenceNumber = resource.getSequenceNumber();
        return sequenceNumber == null ? resource.getID() : sequenceNumber;
    }

    private static PercentCompleteType getPercentCompleteType(Task task) {
        PercentCompleteType type = task.getPercentCompleteType();
        return type == null ? PercentCompleteType.DURATION : type;
    }

    static {
        CURRENCY_COLUMNS.put("curr_id", Currency::getUniqueID);
        CURRENCY_COLUMNS.put("decimal_digit_cnt", Currency::getNumberOfDecimalPlaces);
        CURRENCY_COLUMNS.put("curr_symbol", Currency::getSymbol);
        CURRENCY_COLUMNS.put("decimal_symbol", Currency::getDecimalSymbol);
        CURRENCY_COLUMNS.put("digit_group_symbol", Currency::getDigitGroupingSymbol);
        CURRENCY_COLUMNS.put("pos_curr_fmt_type", Currency::getPositiveCurrencyFormat);
        CURRENCY_COLUMNS.put("neg_curr_fmt_type", Currency::getNegativeCurrencyFormat);
        CURRENCY_COLUMNS.put("curr_type", Currency::getName);
        CURRENCY_COLUMNS.put("curr_short_name", Currency::getCurrencyID);
        CURRENCY_COLUMNS.put("group_digit_cnt", c -> "3");
        CURRENCY_COLUMNS.put("base_exch_rate", Currency::getExchangeRate);
        ROLE_COLUMNS = new LinkedHashMap<String, ExportFunction<Resource>>();
        ROLE_COLUMNS.put("role_id", Resource::getUniqueID);
        ROLE_COLUMNS.put("parent_role_id", Resource::getParentResourceUniqueID);
        ROLE_COLUMNS.put("seq_num", Resource::getSequenceNumber);
        ROLE_COLUMNS.put("role_name", r -> StringHelper.stripControlCharacters(r.getName()));
        ROLE_COLUMNS.put("role_short_name", WriterHelper::getRoleID);
        ROLE_COLUMNS.put("pobs_id", r -> "");
        ROLE_COLUMNS.put("def_cost_qty_link_flag", r -> r.getCalculateCostsFromUnits());
        ROLE_COLUMNS.put("cost_qty_type", r -> "QT_Hour");
        ROLE_COLUMNS.put("role_descr", Resource::getNotesObject);
        ROLE_COLUMNS.put("last_checksum", r -> "");
        ROLE_RATE_COLUMNS = new LinkedHashMap<String, ExportFunction<Map<String, Object>>>();
        ROLE_RATE_COLUMNS.put("role_rate_id", m -> m.get("object_id"));
        ROLE_RATE_COLUMNS.put("role_id", m -> m.get("entity_id"));
        ROLE_RATE_COLUMNS.put("cost_per_qty", m -> m.get("cost_per_qty"));
        ROLE_RATE_COLUMNS.put("cost_per_qty2", m -> m.get("cost_per_qty2"));
        ROLE_RATE_COLUMNS.put("cost_per_qty3", m -> m.get("cost_per_qty3"));
        ROLE_RATE_COLUMNS.put("cost_per_qty4", m -> m.get("cost_per_qty4"));
        ROLE_RATE_COLUMNS.put("cost_per_qty5", m -> m.get("cost_per_qty5"));
        ROLE_RATE_COLUMNS.put("start_date", m -> m.get("start_date"));
        ROLE_RATE_COLUMNS.put("max_qty_per_hr", m -> m.get("max_qty_per_hr"));
        RESOURCE_RATE_COLUMNS = new LinkedHashMap<String, ExportFunction<Map<String, Object>>>();
        RESOURCE_RATE_COLUMNS.put("rsrc_rate_id", m -> m.get("object_id"));
        RESOURCE_RATE_COLUMNS.put("rsrc_id", m -> m.get("entity_id"));
        RESOURCE_RATE_COLUMNS.put("max_qty_per_hr", m -> m.get("max_qty_per_hr"));
        RESOURCE_RATE_COLUMNS.put("cost_per_qty", m -> m.get("cost_per_qty"));
        RESOURCE_RATE_COLUMNS.put("start_date", m -> m.get("start_date"));
        RESOURCE_RATE_COLUMNS.put("shift_period_id", m -> m.get("shift_period_id"));
        RESOURCE_RATE_COLUMNS.put("cost_per_qty2", m -> m.get("cost_per_qty2"));
        RESOURCE_RATE_COLUMNS.put("cost_per_qty3", m -> m.get("cost_per_qty3"));
        RESOURCE_RATE_COLUMNS.put("cost_per_qty4", m -> m.get("cost_per_qty4"));
        RESOURCE_RATE_COLUMNS.put("cost_per_qty5", m -> m.get("cost_per_qty5"));
        RESOURCE_COLUMNS = new LinkedHashMap<String, ExportFunction<Resource>>();
        RESOURCE_COLUMNS.put("rsrc_id", Resource::getUniqueID);
        RESOURCE_COLUMNS.put("parent_rsrc_id", Resource::getParentResourceUniqueID);
        RESOURCE_COLUMNS.put("clndr_id", Resource::getCalendarUniqueID);
        RESOURCE_COLUMNS.put("role_id", Resource::getPrimaryRoleUniqueID);
        RESOURCE_COLUMNS.put("shift_id", Resource::getShiftUniqueID);
        RESOURCE_COLUMNS.put("user_id", r -> "");
        RESOURCE_COLUMNS.put("pobs_id", r -> "");
        RESOURCE_COLUMNS.put("guid", Resource::getGUID);
        RESOURCE_COLUMNS.put("rsrc_seq_num", PrimaveraXERFileWriter::getSequenceNumber);
        RESOURCE_COLUMNS.put("email_addr", Resource::getEmailAddress);
        RESOURCE_COLUMNS.put("employee_code", Resource::getCode);
        RESOURCE_COLUMNS.put("office_phone", r -> "");
        RESOURCE_COLUMNS.put("other_phone", r -> "");
        RESOURCE_COLUMNS.put("rsrc_name", r -> StringHelper.stripControlCharacters(r.getName()));
        RESOURCE_COLUMNS.put("rsrc_short_name", WriterHelper::getResourceID);
        RESOURCE_COLUMNS.put("rsrc_title_name", r -> "");
        RESOURCE_COLUMNS.put("def_qty_per_hr", r -> r.getDefaultUnits() == null || r.getDefaultUnits().doubleValue() == 0.0 ? null : Double.valueOf(r.getDefaultUnits().doubleValue() / 100.0));
        RESOURCE_COLUMNS.put("cost_qty_type", r -> "QT_Hour");
        RESOURCE_COLUMNS.put("ot_factor", r -> "");
        RESOURCE_COLUMNS.put("active_flag", r -> r.getActive());
        RESOURCE_COLUMNS.put("auto_compute_act_flag", r -> Boolean.TRUE);
        RESOURCE_COLUMNS.put("def_cost_qty_link_flag", r -> r.getCalculateCostsFromUnits());
        RESOURCE_COLUMNS.put("ot_flag", r -> Boolean.FALSE);
        RESOURCE_COLUMNS.put("curr_id", r -> r.getCurrencyUniqueID() == null ? DEFAULT_CURRENCY.getUniqueID() : r.getCurrencyUniqueID());
        RESOURCE_COLUMNS.put("unit_id", Resource::getUnitOfMeasureUniqueID);
        RESOURCE_COLUMNS.put("rsrc_type", Resource::getType);
        RESOURCE_COLUMNS.put("location_id", Resource::getLocationUniqueID);
        RESOURCE_COLUMNS.put("rsrc_notes", Resource::getNotesObject);
        RESOURCE_COLUMNS.put("load_tasks_flag", r -> "");
        RESOURCE_COLUMNS.put("level_flag", r -> "");
        RESOURCE_COLUMNS.put("last_checksum", r -> "");
        PROJECT_COLUMNS = new LinkedHashMap<String, ExportFunction<ProjectProperties>>();
        PROJECT_COLUMNS.put("proj_id", p -> PrimaveraXERFileWriter.getProjectID(p.getUniqueID()));
        PROJECT_COLUMNS.put("fy_start_month_num", ProjectProperties::getFiscalYearStartMonth);
        PROJECT_COLUMNS.put("rsrc_self_add_flag", p -> Boolean.TRUE);
        PROJECT_COLUMNS.put("allow_complete_flag", p -> Boolean.TRUE);
        PROJECT_COLUMNS.put("rsrc_multi_assign_flag", p -> Boolean.TRUE);
        PROJECT_COLUMNS.put("checkout_flag", p -> Boolean.FALSE);
        PROJECT_COLUMNS.put("project_flag", p -> Boolean.TRUE);
        PROJECT_COLUMNS.put("step_complete_flag", p -> Boolean.TRUE);
        PROJECT_COLUMNS.put("cost_qty_recalc_flag", p -> Boolean.TRUE);
        PROJECT_COLUMNS.put("batch_sum_flag", p -> Boolean.TRUE);
        PROJECT_COLUMNS.put("name_sep_char", ProjectProperties::getWbsCodeSeparator);
        PROJECT_COLUMNS.put("def_complete_pct_type", p -> PercentCompleteType.DURATION);
        PROJECT_COLUMNS.put("proj_short_name", PrimaveraXERFileWriter::getProjectShortName);
        PROJECT_COLUMNS.put("acct_id", p -> "");
        PROJECT_COLUMNS.put("orig_proj_id", p -> "");
        PROJECT_COLUMNS.put("source_proj_id", p -> "");
        PROJECT_COLUMNS.put("base_type_id", p -> "");
        PROJECT_COLUMNS.put("clndr_id", ProjectProperties::getDefaultCalendarUniqueID);
        PROJECT_COLUMNS.put("sum_base_proj_id", ProjectProperties::getBaselineProjectUniqueID);
        PROJECT_COLUMNS.put("task_code_base", ProjectProperties::getActivityIdSuffix);
        PROJECT_COLUMNS.put("task_code_step", ProjectProperties::getActivityIdIncrement);
        PROJECT_COLUMNS.put("priority_num", p -> 10);
        PROJECT_COLUMNS.put("wbs_max_sum_level", p -> 0);
        PROJECT_COLUMNS.put("strgy_priority_num", p -> 100);
        PROJECT_COLUMNS.put("last_checksum", p -> "");
        PROJECT_COLUMNS.put("critical_drtn_hr_cnt", p -> p.getCriticalSlackLimit().convertUnits(TimeUnit.HOURS, (TimeUnitDefaultsContainer)p).getDuration());
        PROJECT_COLUMNS.put("def_cost_per_qty", p -> new CurrencyValue(100.0));
        PROJECT_COLUMNS.put("last_recalc_date", ProjectProperties::getStatusDate);
        PROJECT_COLUMNS.put("plan_start_date", WriterHelper::getProjectPlannedStart);
        PROJECT_COLUMNS.put("plan_end_date", ProjectProperties::getMustFinishBy);
        PROJECT_COLUMNS.put("scd_end_date", ProjectProperties::getScheduledFinish);
        PROJECT_COLUMNS.put("add_date", ProjectProperties::getCreationDate);
        PROJECT_COLUMNS.put("last_tasksum_date", p -> "");
        PROJECT_COLUMNS.put("fcst_start_date", p -> "");
        PROJECT_COLUMNS.put("def_duration_type", ProjectProperties::getDefaultTaskType);
        PROJECT_COLUMNS.put("task_code_prefix", ProjectProperties::getActivityIdPrefix);
        PROJECT_COLUMNS.put("guid", ProjectProperties::getGUID);
        PROJECT_COLUMNS.put("def_qty_type", p -> "QT_Hour");
        PROJECT_COLUMNS.put("add_by_name", p -> "admin");
        PROJECT_COLUMNS.put("web_local_root_path", p -> "");
        PROJECT_COLUMNS.put("proj_url", ProjectProperties::getProjectWebsiteUrl);
        PROJECT_COLUMNS.put("def_rate_type", p -> RateTypeHelper.getXerFromInstance(0));
        PROJECT_COLUMNS.put("add_act_remain_flag", p -> Boolean.FALSE);
        PROJECT_COLUMNS.put("act_this_per_link_flag", p -> Boolean.TRUE);
        PROJECT_COLUMNS.put("def_task_type", p -> ActivityTypeHelper.NEW_ACTIVITY_DEFAULT_TYPE);
        PROJECT_COLUMNS.put("act_pct_link_flag", p -> Boolean.FALSE);
        PROJECT_COLUMNS.put("critical_path_type", ProjectProperties::getCriticalActivityType);
        PROJECT_COLUMNS.put("task_code_prefix_flag", p -> p.getActivityIdIncrementBasedOnSelectedActivity());
        PROJECT_COLUMNS.put("def_rollup_dates_flag", p -> Boolean.TRUE);
        PROJECT_COLUMNS.put("use_project_baseline_flag", p -> Boolean.TRUE);
        PROJECT_COLUMNS.put("rem_target_link_flag", p -> Boolean.TRUE);
        PROJECT_COLUMNS.put("reset_planned_flag", p -> Boolean.FALSE);
        PROJECT_COLUMNS.put("allow_neg_act_flag", p -> Boolean.FALSE);
        PROJECT_COLUMNS.put("sum_assign_level", p -> "SL_Taskrsrc");
        PROJECT_COLUMNS.put("last_fin_dates_id", p -> "");
        PROJECT_COLUMNS.put("fintmpl_id", p -> "");
        PROJECT_COLUMNS.put("last_baseline_update_date", p -> "");
        PROJECT_COLUMNS.put("cr_external_key", p -> "");
        PROJECT_COLUMNS.put("apply_actuals_date", p -> "");
        PROJECT_COLUMNS.put("location_id", ProjectProperties::getLocationUniqueID);
        PROJECT_COLUMNS.put("loaded_scope_level", p -> 7);
        PROJECT_COLUMNS.put("export_flag", p -> p.getExportFlag());
        PROJECT_COLUMNS.put("new_fin_dates_id", p -> "");
        PROJECT_COLUMNS.put("baselines_to_export", p -> "");
        PROJECT_COLUMNS.put("baseline_names_to_export", p -> "");
        PROJECT_COLUMNS.put("next_data_date", p -> "");
        PROJECT_COLUMNS.put("close_period_flag", p -> "");
        PROJECT_COLUMNS.put("sum_refresh_date", p -> "");
        PROJECT_COLUMNS.put("trsrcsum_loaded", p -> "");
        PROJECT_COLUMNS.put("sumtask_loaded", p -> "");
        CALENDAR_COLUMNS = new LinkedHashMap<String, ExportFunction<ProjectCalendar>>();
        CALENDAR_COLUMNS.put("clndr_id", ProjectCalendar::getUniqueID);
        CALENDAR_COLUMNS.put("default_flag", c -> c.getParentFile().getProjectProperties().getDefaultCalendar() == c);
        CALENDAR_COLUMNS.put("clndr_name", c -> StringHelper.stripControlCharacters(c.getName()));
        CALENDAR_COLUMNS.put("proj_id", c -> c.getType() == CalendarType.PROJECT ? PrimaveraXERFileWriter.getProjectID(c.getParentFile().getProjectProperties().getUniqueID()) : null);
        CALENDAR_COLUMNS.put("base_clndr_id", ProjectCalendar::getParentUniqueID);
        CALENDAR_COLUMNS.put("last_chng_date", c -> null);
        CALENDAR_COLUMNS.put("clndr_type", ProjectCalendar::getType);
        CALENDAR_COLUMNS.put("day_hr_cnt", c -> NumberHelper.getInt(c.getMinutesPerDay()) / 60);
        CALENDAR_COLUMNS.put("week_hr_cnt", c -> NumberHelper.getInt(c.getMinutesPerWeek()) / 60);
        CALENDAR_COLUMNS.put("month_hr_cnt", c -> NumberHelper.getInt(c.getMinutesPerMonth()) / 60);
        CALENDAR_COLUMNS.put("year_hr_cnt", c -> NumberHelper.getInt(c.getMinutesPerYear()) / 60);
        CALENDAR_COLUMNS.put("rsrc_private", c -> c.getPersonal());
        CALENDAR_COLUMNS.put("clndr_data", c -> new ProjectCalendarStructuredTextWriter().getCalendarData((ProjectCalendar)c));
        WBS_COLUMNS = new LinkedHashMap<String, ExportFunction<Task>>();
        WBS_COLUMNS.put("wbs_id", Task::getUniqueID);
        WBS_COLUMNS.put("proj_id", t -> PrimaveraXERFileWriter.getProjectID(t.getParentFile().getProjectProperties().getUniqueID()));
        WBS_COLUMNS.put("obs_id", t -> "");
        WBS_COLUMNS.put("seq_num", PrimaveraXERFileWriter::getSequenceNumber);
        WBS_COLUMNS.put("est_wt", t -> 1);
        WBS_COLUMNS.put("proj_node_flag", t -> t.getParentTask() == null);
        WBS_COLUMNS.put("sum_data_flag", t -> Boolean.TRUE);
        WBS_COLUMNS.put("status_code", t -> "WS_Open");
        WBS_COLUMNS.put("wbs_short_name", TaskHelper::getWbsCode);
        WBS_COLUMNS.put("wbs_name", t -> StringHelper.stripControlCharacters(t.getName()));
        WBS_COLUMNS.put("phase_id", t -> "");
        WBS_COLUMNS.put("parent_wbs_id", Task::getParentTaskUniqueID);
        WBS_COLUMNS.put("ev_user_pct", t -> 6);
        WBS_COLUMNS.put("ev_etc_user_value", t -> 0.88);
        WBS_COLUMNS.put("orig_cost", t -> CurrencyValue.ZERO);
        WBS_COLUMNS.put("indep_remain_total_cost", t -> CurrencyValue.ZERO);
        WBS_COLUMNS.put("ann_dscnt_rate_pct", t -> "");
        WBS_COLUMNS.put("dscnt_period_type", t -> "");
        WBS_COLUMNS.put("indep_remain_work_qty", t -> 0);
        WBS_COLUMNS.put("anticip_start_date", t -> "");
        WBS_COLUMNS.put("anticip_end_date", t -> "");
        WBS_COLUMNS.put("ev_compute_type", t -> "EC_Cmp_pct");
        WBS_COLUMNS.put("ev_etc_compute_type", t -> "EE_PF_cpi");
        WBS_COLUMNS.put("guid", Task::getGUID);
        WBS_COLUMNS.put("tmpl_guid", Task::getMethodologyGUID);
        WBS_COLUMNS.put("plan_open_state", t -> "");
        ACTIVITY_COLUMNS = new LinkedHashMap<String, ExportFunction<Task>>();
        ACTIVITY_COLUMNS.put("task_id", Task::getUniqueID);
        ACTIVITY_COLUMNS.put("proj_id", t -> PrimaveraXERFileWriter.getProjectID(t.getParentFile().getProjectProperties().getUniqueID()));
        ACTIVITY_COLUMNS.put("wbs_id", Task::getParentTaskUniqueID);
        ACTIVITY_COLUMNS.put("clndr_id", Task::getCalendarUniqueID);
        ACTIVITY_COLUMNS.put("phys_complete_pct", Task::getPhysicalPercentComplete);
        ACTIVITY_COLUMNS.put("rev_fdbk_flag", t -> Boolean.FALSE);
        ACTIVITY_COLUMNS.put("est_wt", t -> 1);
        ACTIVITY_COLUMNS.put("lock_plan_flag", t -> Boolean.FALSE);
        ACTIVITY_COLUMNS.put("auto_compute_act_flag", t -> Boolean.TRUE);
        ACTIVITY_COLUMNS.put("complete_pct_type", PrimaveraXERFileWriter::getPercentCompleteType);
        ACTIVITY_COLUMNS.put("task_type", PrimaveraXERFileWriter::getActivityType);
        ACTIVITY_COLUMNS.put("duration_type", Task::getType);
        ACTIVITY_COLUMNS.put("status_code", ActivityStatusHelper::getActivityStatus);
        ACTIVITY_COLUMNS.put("task_code", WriterHelper::getActivityID);
        ACTIVITY_COLUMNS.put("task_name", t -> StringHelper.stripControlCharacters(t.getName()));
        ACTIVITY_COLUMNS.put("rsrc_id", Task::getPrimaryResourceUniqueID);
        ACTIVITY_COLUMNS.put("total_float_hr_cnt", t -> t.getActivityStatus() == ActivityStatus.COMPLETED ? null : t.getTotalSlack());
        ACTIVITY_COLUMNS.put("free_float_hr_cnt", t -> t.getActivityStatus() == ActivityStatus.COMPLETED ? null : t.getFreeSlack());
        ACTIVITY_COLUMNS.put("remain_drtn_hr_cnt", Task::getRemainingDuration);
        ACTIVITY_COLUMNS.put("act_work_qty", WorkHelper::getActualWorkLabor);
        ACTIVITY_COLUMNS.put("remain_work_qty", WorkHelper::getRemainingWorkLabor);
        ACTIVITY_COLUMNS.put("target_work_qty", WorkHelper::getPlannedWorkLabor);
        ACTIVITY_COLUMNS.put("target_drtn_hr_cnt", WriterHelper::getActivityPlannedDuration);
        ACTIVITY_COLUMNS.put("target_equip_qty", t -> WorkHelper.zeroIfNull(t.getPlannedWorkNonlabor()));
        ACTIVITY_COLUMNS.put("act_equip_qty", t -> WorkHelper.zeroIfNull(t.getActualWorkNonlabor()));
        ACTIVITY_COLUMNS.put("remain_equip_qty", t -> WorkHelper.zeroIfNull(t.getRemainingWorkNonlabor()));
        ACTIVITY_COLUMNS.put("cstr_date", Task::getConstraintDate);
        ACTIVITY_COLUMNS.put("act_start_date", Task::getActualStart);
        ACTIVITY_COLUMNS.put("act_end_date", Task::getActualFinish);
        ACTIVITY_COLUMNS.put("late_start_date", Task::getLateStart);
        ACTIVITY_COLUMNS.put("late_end_date", Task::getLateFinish);
        ACTIVITY_COLUMNS.put("expect_end_date", Task::getExpectedFinish);
        ACTIVITY_COLUMNS.put("early_start_date", Task::getEarlyStart);
        ACTIVITY_COLUMNS.put("early_end_date", Task::getEarlyFinish);
        ACTIVITY_COLUMNS.put("restart_date", Task::getRemainingEarlyStart);
        ACTIVITY_COLUMNS.put("reend_date", Task::getRemainingEarlyFinish);
        ACTIVITY_COLUMNS.put("target_start_date", Task::getPlannedStart);
        ACTIVITY_COLUMNS.put("target_end_date", Task::getPlannedFinish);
        ACTIVITY_COLUMNS.put("rem_late_start_date", Task::getRemainingLateStart);
        ACTIVITY_COLUMNS.put("rem_late_end_date", Task::getRemainingLateFinish);
        ACTIVITY_COLUMNS.put("cstr_type", Task::getConstraintType);
        ACTIVITY_COLUMNS.put("priority_type", Task::getPriority);
        ACTIVITY_COLUMNS.put("suspend_date", Task::getSuspendDate);
        ACTIVITY_COLUMNS.put("resume_date", Task::getResume);
        ACTIVITY_COLUMNS.put("float_path", Task::getFloatPath);
        ACTIVITY_COLUMNS.put("float_path_order", Task::getFloatPathOrder);
        ACTIVITY_COLUMNS.put("guid", Task::getGUID);
        ACTIVITY_COLUMNS.put("tmpl_guid", Task::getMethodologyGUID);
        ACTIVITY_COLUMNS.put("cstr_date2", Task::getSecondaryConstraintDate);
        ACTIVITY_COLUMNS.put("cstr_type2", Task::getSecondaryConstraintType);
        ACTIVITY_COLUMNS.put("driving_path_flag", t -> Boolean.FALSE);
        ACTIVITY_COLUMNS.put("act_this_per_work_qty", t -> 0);
        ACTIVITY_COLUMNS.put("act_this_per_equip_qty", t -> 0);
        ACTIVITY_COLUMNS.put("external_early_start_date", Task::getExternalEarlyStart);
        ACTIVITY_COLUMNS.put("external_late_end_date", Task::getExternalLateFinish);
        ACTIVITY_COLUMNS.put("create_date", Task::getCreateDate);
        ACTIVITY_COLUMNS.put("update_date", t -> null);
        ACTIVITY_COLUMNS.put("create_user", t -> null);
        ACTIVITY_COLUMNS.put("update_user", t -> null);
        ACTIVITY_COLUMNS.put("location_id", Task::getLocationUniqueID);
        PREDECESSOR_COLUMNS = new LinkedHashMap<String, ExportFunction<Relation>>();
        PREDECESSOR_COLUMNS.put("task_pred_id", Relation::getUniqueID);
        PREDECESSOR_COLUMNS.put("task_id", r -> r.getSuccessorTask().getUniqueID());
        PREDECESSOR_COLUMNS.put("pred_task_id", r -> r.getPredecessorTask().getUniqueID());
        PREDECESSOR_COLUMNS.put("proj_id", r -> PrimaveraXERFileWriter.getProjectID(r.getSuccessorTask().getParentFile().getProjectProperties().getUniqueID()));
        PREDECESSOR_COLUMNS.put("pred_proj_id", r -> PrimaveraXERFileWriter.getProjectID(r.getPredecessorTask().getParentFile().getProjectProperties().getUniqueID()));
        PREDECESSOR_COLUMNS.put("pred_type", Relation::getType);
        PREDECESSOR_COLUMNS.put("lag_hr_cnt", Relation::getLag);
        PREDECESSOR_COLUMNS.put("comments", Relation::getNotes);
        PREDECESSOR_COLUMNS.put("float_path", r -> null);
        PREDECESSOR_COLUMNS.put("aref", r -> null);
        PREDECESSOR_COLUMNS.put("arls", r -> null);
        RESOURCE_ASSIGNMENT_COLUMNS = new LinkedHashMap<String, ExportFunction<ResourceAssignment>>();
        RESOURCE_ASSIGNMENT_COLUMNS.put("taskrsrc_id", ResourceAssignment::getUniqueID);
        RESOURCE_ASSIGNMENT_COLUMNS.put("task_id", ResourceAssignment::getTaskUniqueID);
        RESOURCE_ASSIGNMENT_COLUMNS.put("proj_id", r -> PrimaveraXERFileWriter.getProjectID(r.getParentFile().getProjectProperties().getUniqueID()));
        RESOURCE_ASSIGNMENT_COLUMNS.put("cost_qty_link_flag", r -> r.getCalculateCostsFromUnits());
        RESOURCE_ASSIGNMENT_COLUMNS.put("role_id", ResourceAssignment::getRoleUniqueID);
        RESOURCE_ASSIGNMENT_COLUMNS.put("acct_id", ResourceAssignment::getCostAccountUniqueID);
        RESOURCE_ASSIGNMENT_COLUMNS.put("rsrc_id", ResourceAssignment::getResourceUniqueID);
        RESOURCE_ASSIGNMENT_COLUMNS.put("pobs_id", r -> null);
        RESOURCE_ASSIGNMENT_COLUMNS.put("skill_level", r -> null);
        RESOURCE_ASSIGNMENT_COLUMNS.put("remain_qty", r -> new XerUnitsHelper((ResourceAssignment)r).getRemainingUnits());
        RESOURCE_ASSIGNMENT_COLUMNS.put("target_qty", r -> new XerUnitsHelper((ResourceAssignment)r).getPlannedUnits());
        RESOURCE_ASSIGNMENT_COLUMNS.put("remain_qty_per_hr", r -> new XerUnitsHelper((ResourceAssignment)r).getRemainingUnitsPerTime());
        RESOURCE_ASSIGNMENT_COLUMNS.put("target_lag_drtn_hr_cnt", ResourceAssignment::getDelay);
        RESOURCE_ASSIGNMENT_COLUMNS.put("target_qty_per_hr", r -> new XerUnitsHelper((ResourceAssignment)r).getPlannedUnitsPerTime());
        RESOURCE_ASSIGNMENT_COLUMNS.put("act_ot_qty", ResourceAssignment::getActualOvertimeWork);
        RESOURCE_ASSIGNMENT_COLUMNS.put("act_reg_qty", PrimaveraXERFileWriter::getActualRegularWork);
        RESOURCE_ASSIGNMENT_COLUMNS.put("relag_drtn_hr_cnt", r -> null);
        RESOURCE_ASSIGNMENT_COLUMNS.put("ot_factor", r -> null);
        RESOURCE_ASSIGNMENT_COLUMNS.put("cost_per_qty", ResourceAssignment::getOverrideRate);
        RESOURCE_ASSIGNMENT_COLUMNS.put("target_cost", r -> CurrencyValue.getInstance(r.getPlannedCost()));
        RESOURCE_ASSIGNMENT_COLUMNS.put("act_reg_cost", r -> CurrencyValue.getInstance(PrimaveraXERFileWriter.getActualRegularCost(r)));
        RESOURCE_ASSIGNMENT_COLUMNS.put("act_ot_cost", r -> CurrencyValue.getInstance(r.getActualOvertimeCost()));
        RESOURCE_ASSIGNMENT_COLUMNS.put("remain_cost", r -> CurrencyValue.getInstance(r.getRemainingCost()));
        RESOURCE_ASSIGNMENT_COLUMNS.put("act_start_date", ResourceAssignment::getActualStart);
        RESOURCE_ASSIGNMENT_COLUMNS.put("act_end_date", ResourceAssignment::getActualFinish);
        RESOURCE_ASSIGNMENT_COLUMNS.put("restart_date", ResourceAssignment::getRemainingEarlyStart);
        RESOURCE_ASSIGNMENT_COLUMNS.put("reend_date", ResourceAssignment::getRemainingEarlyFinish);
        RESOURCE_ASSIGNMENT_COLUMNS.put("target_start_date", ResourceAssignment::getPlannedStart);
        RESOURCE_ASSIGNMENT_COLUMNS.put("target_end_date", ResourceAssignment::getPlannedFinish);
        RESOURCE_ASSIGNMENT_COLUMNS.put("rem_late_start_date", ResourceAssignment::getRemainingLateStart);
        RESOURCE_ASSIGNMENT_COLUMNS.put("rem_late_end_date", ResourceAssignment::getRemainingLateFinish);
        RESOURCE_ASSIGNMENT_COLUMNS.put("rollup_dates_flag", r -> Boolean.TRUE);
        RESOURCE_ASSIGNMENT_COLUMNS.put("target_crv", r -> TimephasedHelper.write(r.getTask().getEffectiveCalendar(), r.getTimephasedPlannedWork()));
        RESOURCE_ASSIGNMENT_COLUMNS.put("remain_crv", r -> TimephasedHelper.write(r.getTask().getEffectiveCalendar(), r.getTimephasedWork()));
        RESOURCE_ASSIGNMENT_COLUMNS.put("actual_crv", r -> TimephasedHelper.write(r.getTask().getEffectiveCalendar(), r.getTimephasedActualWork()));
        RESOURCE_ASSIGNMENT_COLUMNS.put("ts_pend_act_end_flag", r -> Boolean.FALSE);
        RESOURCE_ASSIGNMENT_COLUMNS.put("guid", ResourceAssignment::getGUID);
        RESOURCE_ASSIGNMENT_COLUMNS.put("rate_type", r -> RateTypeHelper.getXerFromInstance(r.getRateIndex()));
        RESOURCE_ASSIGNMENT_COLUMNS.put("act_this_per_cost", r -> CurrencyValue.ZERO);
        RESOURCE_ASSIGNMENT_COLUMNS.put("act_this_per_qty", r -> 0);
        RESOURCE_ASSIGNMENT_COLUMNS.put("curv_id", r -> CurveHelper.getCurveID(r.getWorkContour()));
        RESOURCE_ASSIGNMENT_COLUMNS.put("rsrc_type", r -> r.getResource() == null ? ResourceType.WORK : r.getResource().getType());
        RESOURCE_ASSIGNMENT_COLUMNS.put("cost_per_qty_source_type", ResourceAssignment::getRateSource);
        RESOURCE_ASSIGNMENT_COLUMNS.put("create_user", r -> null);
        RESOURCE_ASSIGNMENT_COLUMNS.put("create_date", ResourceAssignment::getCreateDate);
        RESOURCE_ASSIGNMENT_COLUMNS.put("has_rsrchours", r -> null);
        RESOURCE_ASSIGNMENT_COLUMNS.put("taskrsrc_sum_id", r -> null);
        COST_ACCOUNT_COLUMNS = new LinkedHashMap<String, ExportFunction<CostAccount>>();
        COST_ACCOUNT_COLUMNS.put("acct_id", CostAccount::getUniqueID);
        COST_ACCOUNT_COLUMNS.put("parent_acct_id", CostAccount::getParentUniqueID);
        COST_ACCOUNT_COLUMNS.put("acct_seq_num", CostAccount::getSequenceNumber);
        COST_ACCOUNT_COLUMNS.put("acct_name", CostAccount::getID);
        COST_ACCOUNT_COLUMNS.put("acct_short_name", c -> StringHelper.stripControlCharacters(c.getName()));
        COST_ACCOUNT_COLUMNS.put("acct_descr", CostAccount::getNotesObject);
        EXPENSE_CATEGORY_COLUMNS = new LinkedHashMap<String, ExportFunction<ExpenseCategory>>();
        EXPENSE_CATEGORY_COLUMNS.put("cost_type_id", ExpenseCategory::getUniqueID);
        EXPENSE_CATEGORY_COLUMNS.put("seq_num", ExpenseCategory::getSequenceNumber);
        EXPENSE_CATEGORY_COLUMNS.put("cost_type", e -> StringHelper.stripControlCharacters(e.getName()));
        LOCATION_COLUMNS = new LinkedHashMap<String, ExportFunction<Location>>();
        LOCATION_COLUMNS.put("location_id", Location::getUniqueID);
        LOCATION_COLUMNS.put("location_name", l -> StringHelper.stripControlCharacters(l.getName()));
        LOCATION_COLUMNS.put("location_type", l -> PrimaveraXERFileWriter.locationIsCity(l) ? "City" : "LT_Point");
        LOCATION_COLUMNS.put("address_line1", Location::getAddressLine1);
        LOCATION_COLUMNS.put("address_line2", Location::getAddressLine2);
        LOCATION_COLUMNS.put("address_line3", Location::getAddressLine3);
        LOCATION_COLUMNS.put("city_name", Location::getCity);
        LOCATION_COLUMNS.put("municipality_name", Location::getMunicipality);
        LOCATION_COLUMNS.put("state_name", Location::getState);
        LOCATION_COLUMNS.put("state_code", Location::getStateCode);
        LOCATION_COLUMNS.put("country_name", Location::getCountry);
        LOCATION_COLUMNS.put("country_code", Location::getCountryCode);
        LOCATION_COLUMNS.put("postal_code", Location::getPostalCode);
        LOCATION_COLUMNS.put("longitude", Location::getLongitude);
        LOCATION_COLUMNS.put("latitude", Location::getLatitude);
        EXPENSE_ITEM_COLUMNS = new LinkedHashMap<String, ExportFunction<ExpenseItem>>();
        EXPENSE_ITEM_COLUMNS.put("cost_item_id", ExpenseItem::getUniqueID);
        EXPENSE_ITEM_COLUMNS.put("acct_id", ExpenseItem::getAccountUniqueID);
        EXPENSE_ITEM_COLUMNS.put("pobs_id", i -> null);
        EXPENSE_ITEM_COLUMNS.put("cost_type_id", ExpenseItem::getCategoryUniqueID);
        EXPENSE_ITEM_COLUMNS.put("proj_id", i -> PrimaveraXERFileWriter.getProjectID(i.getTask().getParentFile().getProjectProperties().getUniqueID()));
        EXPENSE_ITEM_COLUMNS.put("task_id", i -> i.getTask().getUniqueID());
        EXPENSE_ITEM_COLUMNS.put("cost_name", i -> StringHelper.stripControlCharacters(i.getName()));
        EXPENSE_ITEM_COLUMNS.put("po_number", ExpenseItem::getDocumentNumber);
        EXPENSE_ITEM_COLUMNS.put("vendor_name", ExpenseItem::getVendor);
        EXPENSE_ITEM_COLUMNS.put("act_cost", i -> CurrencyValue.getInstance(i.getActualCost()));
        EXPENSE_ITEM_COLUMNS.put("cost_per_qty", i -> CurrencyValue.getInstance(i.getPricePerUnit()));
        EXPENSE_ITEM_COLUMNS.put("remain_cost", i -> CurrencyValue.getInstance(i.getRemainingCost()));
        EXPENSE_ITEM_COLUMNS.put("target_cost", i -> CurrencyValue.getInstance(i.getPlannedCost()));
        EXPENSE_ITEM_COLUMNS.put("cost_load_type", ExpenseItem::getAccrueType);
        EXPENSE_ITEM_COLUMNS.put("auto_compute_act_flag", i -> i.getAutoComputeActuals());
        EXPENSE_ITEM_COLUMNS.put("target_qty", ExpenseItem::getPlannedUnits);
        EXPENSE_ITEM_COLUMNS.put("qty_name", ExpenseItem::getUnitOfMeasure);
        EXPENSE_ITEM_COLUMNS.put("cost_descr", ExpenseItem::getDescription);
        EXPENSE_ITEM_COLUMNS.put("contract_manager_import", i -> null);
        RESOURCE_CURVE_COLUMNS = new LinkedHashMap<String, ExportFunction<WorkContour>>();
        RESOURCE_CURVE_COLUMNS.put("curv_id", WorkContour::getUniqueID);
        RESOURCE_CURVE_COLUMNS.put("curv_name", r -> StringHelper.stripControlCharacters(r.getName()));
        RESOURCE_CURVE_COLUMNS.put("default_flag", r -> r.isContourDefault());
        RESOURCE_CURVE_COLUMNS.put("pct_usage_0", r -> r.getCurveValues()[0]);
        RESOURCE_CURVE_COLUMNS.put("pct_usage_1", r -> r.getCurveValues()[1]);
        RESOURCE_CURVE_COLUMNS.put("pct_usage_2", r -> r.getCurveValues()[2]);
        RESOURCE_CURVE_COLUMNS.put("pct_usage_3", r -> r.getCurveValues()[3]);
        RESOURCE_CURVE_COLUMNS.put("pct_usage_4", r -> r.getCurveValues()[4]);
        RESOURCE_CURVE_COLUMNS.put("pct_usage_5", r -> r.getCurveValues()[5]);
        RESOURCE_CURVE_COLUMNS.put("pct_usage_6", r -> r.getCurveValues()[6]);
        RESOURCE_CURVE_COLUMNS.put("pct_usage_7", r -> r.getCurveValues()[7]);
        RESOURCE_CURVE_COLUMNS.put("pct_usage_8", r -> r.getCurveValues()[8]);
        RESOURCE_CURVE_COLUMNS.put("pct_usage_9", r -> r.getCurveValues()[9]);
        RESOURCE_CURVE_COLUMNS.put("pct_usage_10", r -> r.getCurveValues()[10]);
        RESOURCE_CURVE_COLUMNS.put("pct_usage_11", r -> r.getCurveValues()[11]);
        RESOURCE_CURVE_COLUMNS.put("pct_usage_12", r -> r.getCurveValues()[12]);
        RESOURCE_CURVE_COLUMNS.put("pct_usage_13", r -> r.getCurveValues()[13]);
        RESOURCE_CURVE_COLUMNS.put("pct_usage_14", r -> r.getCurveValues()[14]);
        RESOURCE_CURVE_COLUMNS.put("pct_usage_15", r -> r.getCurveValues()[15]);
        RESOURCE_CURVE_COLUMNS.put("pct_usage_16", r -> r.getCurveValues()[16]);
        RESOURCE_CURVE_COLUMNS.put("pct_usage_17", r -> r.getCurveValues()[17]);
        RESOURCE_CURVE_COLUMNS.put("pct_usage_18", r -> r.getCurveValues()[18]);
        RESOURCE_CURVE_COLUMNS.put("pct_usage_19", r -> r.getCurveValues()[19]);
        RESOURCE_CURVE_COLUMNS.put("pct_usage_20", r -> r.getCurveValues()[20]);
        ACTIVITY_STEP_COLUMNS = new LinkedHashMap<String, ExportFunction<Step>>();
        ACTIVITY_STEP_COLUMNS.put("proc_id", Step::getUniqueID);
        ACTIVITY_STEP_COLUMNS.put("task_id", s -> s.getTask().getUniqueID());
        ACTIVITY_STEP_COLUMNS.put("proj_id", s -> PrimaveraXERFileWriter.getProjectID(s.getTask().getParentFile().getProjectProperties().getUniqueID()));
        ACTIVITY_STEP_COLUMNS.put("seq_num", Step::getSequenceNumber);
        ACTIVITY_STEP_COLUMNS.put("proc_name", s -> StringHelper.stripControlCharacters(s.getName()));
        ACTIVITY_STEP_COLUMNS.put("complete_flag", s -> s.getComplete());
        ACTIVITY_STEP_COLUMNS.put("proc_wt", Step::getWeight);
        ACTIVITY_STEP_COLUMNS.put("complete_pct", Step::getPercentComplete);
        ACTIVITY_STEP_COLUMNS.put("proc_descr", Step::getDescriptionObject);
        ACTIVITY_CODE_COLUMNS = new LinkedHashMap<String, ExportFunction<ActivityCode>>();
        ACTIVITY_CODE_COLUMNS.put("actv_code_type_id", ActivityCode::getUniqueID);
        ACTIVITY_CODE_COLUMNS.put("actv_short_len", ActivityCode::getMaxLength);
        ACTIVITY_CODE_COLUMNS.put("seq_num", ActivityCode::getSequenceNumber);
        ACTIVITY_CODE_COLUMNS.put("actv_code_type", a -> StringHelper.stripControlCharacters(a.getName()));
        ACTIVITY_CODE_COLUMNS.put("proj_id", ActivityCode::getScopeProjectUniqueID);
        ACTIVITY_CODE_COLUMNS.put("wbs_id", ActivityCode::getScopeEpsUniqueID);
        ACTIVITY_CODE_COLUMNS.put("actv_code_type_scope", ActivityCode::getScope);
        ACTIVITY_CODE_VALUE_COLUMNS = new LinkedHashMap<String, ExportFunction<ActivityCodeValue>>();
        ACTIVITY_CODE_VALUE_COLUMNS.put("actv_code_id", ActivityCodeValue::getUniqueID);
        ACTIVITY_CODE_VALUE_COLUMNS.put("parent_actv_code_id", ActivityCodeValue::getParentValueUniqueID);
        ACTIVITY_CODE_VALUE_COLUMNS.put("actv_code_type_id", ActivityCodeValue::getParentCodeUniqueID);
        ACTIVITY_CODE_VALUE_COLUMNS.put("actv_code_name", a -> StringHelper.stripControlCharacters(a.getDescription()));
        ACTIVITY_CODE_VALUE_COLUMNS.put("short_name", a -> StringHelper.stripControlCharacters(a.getName()));
        ACTIVITY_CODE_VALUE_COLUMNS.put("seq_num", ActivityCodeValue::getSequenceNumber);
        ACTIVITY_CODE_VALUE_COLUMNS.put("color", ActivityCodeValue::getColor);
        ACTIVITY_CODE_VALUE_COLUMNS.put("total_assignments", a -> null);
        ACTIVITY_CODE_ASSIGNMENT_COLUMNS = new LinkedHashMap<String, ExportFunction<Pair<Task, ActivityCodeValue>>>();
        ACTIVITY_CODE_ASSIGNMENT_COLUMNS.put("task_id", p -> ((Task)p.getFirst()).getUniqueID());
        ACTIVITY_CODE_ASSIGNMENT_COLUMNS.put("actv_code_type_id", p -> ((ActivityCodeValue)p.getSecond()).getParentCodeUniqueID());
        ACTIVITY_CODE_ASSIGNMENT_COLUMNS.put("actv_code_id", p -> ((ActivityCodeValue)p.getSecond()).getUniqueID());
        ACTIVITY_CODE_ASSIGNMENT_COLUMNS.put("proj_id", p -> PrimaveraXERFileWriter.getProjectID(((Task)p.getFirst()).getParentFile().getProjectProperties().getUniqueID()));
        UDF_TYPE_COLUMNS = new LinkedHashMap<String, ExportFunction<Pair<FieldType, CustomField>>>();
        UDF_TYPE_COLUMNS.put("udf_type_id", p -> PrimaveraXERFileWriter.getUdfTypeID((FieldType)p.getFirst()));
        UDF_TYPE_COLUMNS.put("table_name", p -> FieldTypeClassHelper.getXerFromInstance((FieldType)p.getFirst()));
        UDF_TYPE_COLUMNS.put("udf_type_name", p -> PrimaveraXERFileWriter.getUdfTypeName((FieldType)p.getFirst()));
        UDF_TYPE_COLUMNS.put("udf_type_label", p -> PrimaveraXERFileWriter.getUdfTypeLabel((FieldType)p.getFirst(), (CustomField)p.getSecond()));
        UDF_TYPE_COLUMNS.put("logical_data_type", p -> ((FieldType)p.getFirst()).getDataType());
        UDF_TYPE_COLUMNS.put("super_flag", p -> Boolean.FALSE);
        UDF_TYPE_COLUMNS.put("indicator_expression", p -> null);
        UDF_TYPE_COLUMNS.put("summary_indicator_expression", p -> null);
        UDF_ASSIGNMENT_COLUMNS = new LinkedHashMap<String, ExportFunction<Map<String, Object>>>();
        UDF_ASSIGNMENT_COLUMNS.put("udf_type_id", u -> u.get("udf_type_id"));
        UDF_ASSIGNMENT_COLUMNS.put("fk_id", u -> u.get("fk_id"));
        UDF_ASSIGNMENT_COLUMNS.put("proj_id", u -> u.get("proj_id"));
        UDF_ASSIGNMENT_COLUMNS.put("udf_date", u -> u.get("udf_date"));
        UDF_ASSIGNMENT_COLUMNS.put("udf_number", u -> u.get("udf_number"));
        UDF_ASSIGNMENT_COLUMNS.put("udf_text", u -> u.get("udf_text"));
        UDF_ASSIGNMENT_COLUMNS.put("udf_code_id", u -> u.get("udf_code_id"));
        NOTE_TYPE_COLUMNS = new LinkedHashMap<String, ExportFunction<NotesTopic>>();
        NOTE_TYPE_COLUMNS.put("memo_type_id", NotesTopic::getUniqueID);
        NOTE_TYPE_COLUMNS.put("seq_num", NotesTopic::getSequenceNumber);
        NOTE_TYPE_COLUMNS.put("eps_flag", n -> n.getAvailableForEPS());
        NOTE_TYPE_COLUMNS.put("proj_flag", n -> n.getAvailableForProject());
        NOTE_TYPE_COLUMNS.put("wbs_flag", n -> n.getAvailableForWBS());
        NOTE_TYPE_COLUMNS.put("task_flag", n -> n.getAvailableForActivity());
        NOTE_TYPE_COLUMNS.put("memo_type", n -> StringHelper.stripControlCharacters(n.getName()));
        WBS_NOTE_COLUMNS = new LinkedHashMap<String, ExportFunction<Map<String, Object>>>();
        WBS_NOTE_COLUMNS.put("wbs_memo_id", n -> n.get("entity_memo_id"));
        WBS_NOTE_COLUMNS.put("proj_id", n -> n.get("proj_id"));
        WBS_NOTE_COLUMNS.put("memo_type_id", n -> n.get("memo_type_id"));
        WBS_NOTE_COLUMNS.put("wbs_id", n -> n.get("entity_id"));
        WBS_NOTE_COLUMNS.put("wbs_memo", n -> n.get("entity_memo"));
        ACTIVITY_NOTE_COLUMNS = new LinkedHashMap<String, ExportFunction<Map<String, Object>>>();
        ACTIVITY_NOTE_COLUMNS.put("memo_id", n -> n.get("entity_memo_id"));
        ACTIVITY_NOTE_COLUMNS.put("task_id", n -> n.get("entity_id"));
        ACTIVITY_NOTE_COLUMNS.put("memo_type_id", n -> n.get("memo_type_id"));
        ACTIVITY_NOTE_COLUMNS.put("proj_id", n -> n.get("proj_id"));
        ACTIVITY_NOTE_COLUMNS.put("task_memo", n -> n.get("entity_memo"));
        SCHEDULE_OPTIONS_COLUMNS = new LinkedHashMap<String, ExportFunction<ProjectProperties>>();
        SCHEDULE_OPTIONS_COLUMNS.put("schedoptions_id", o -> 1);
        SCHEDULE_OPTIONS_COLUMNS.put("proj_id", o -> PrimaveraXERFileWriter.getProjectID(o.getUniqueID()));
        SCHEDULE_OPTIONS_COLUMNS.put("sched_outer_depend_type", o -> o.getIgnoreRelationshipsToAndFromOtherProjects() ? "SD_None" : "SD_Both");
        SCHEDULE_OPTIONS_COLUMNS.put("sched_open_critical_flag", o -> o.getMakeOpenEndedActivitiesCritical());
        SCHEDULE_OPTIONS_COLUMNS.put("sched_lag_early_start_flag", o -> o.getComputeStartToStartLagFromEarlyStart());
        SCHEDULE_OPTIONS_COLUMNS.put("sched_retained_logic", o -> o.getSchedulingProgressedActivities() == SchedulingProgressedActivities.RETAINED_LOGIC);
        SCHEDULE_OPTIONS_COLUMNS.put("sched_setplantoforecast", o -> o.getDataDateAndPlannedStartSetToProjectForecastStart());
        SCHEDULE_OPTIONS_COLUMNS.put("sched_float_type", o -> TotalSlackCalculationTypeHelper.getXerFromInstance(o.getTotalSlackCalculationType()));
        SCHEDULE_OPTIONS_COLUMNS.put("sched_calendar_on_relationship_lag", o -> RelationshipLagCalendarHelper.getXerFromInstance(o.getRelationshipLagCalendar()));
        SCHEDULE_OPTIONS_COLUMNS.put("sched_use_expect_end_flag", o -> o.getUseExpectedFinishDates());
        SCHEDULE_OPTIONS_COLUMNS.put("sched_progress_override", o -> o.getSchedulingProgressedActivities() == SchedulingProgressedActivities.PROGRESS_OVERRIDE);
        SCHEDULE_OPTIONS_COLUMNS.put("level_float_thrs_cnt", ProjectProperties::getPreserveMinimumFloatWhenLeveling);
        SCHEDULE_OPTIONS_COLUMNS.put("level_outer_assign_flag", o -> o.getConsiderAssignmentsInOtherProjects());
        SCHEDULE_OPTIONS_COLUMNS.put("level_outer_assign_priority", ProjectProperties::getConsiderAssignmentsInOtherProjectsWithPriorityEqualHigherThan);
        SCHEDULE_OPTIONS_COLUMNS.put("level_over_alloc_pct", ProjectProperties::getMaxPercentToOverallocateResources);
        SCHEDULE_OPTIONS_COLUMNS.put("level_within_float_flag", o -> o.getLevelResourcesOnlyWithinActivityTotalFloat());
        SCHEDULE_OPTIONS_COLUMNS.put("level_keep_sched_date_flag", o -> o.getPreserveScheduledEarlyAndLateDates());
        SCHEDULE_OPTIONS_COLUMNS.put("level_all_rsrc_flag", o -> o.getLevelAllResources());
        SCHEDULE_OPTIONS_COLUMNS.put("sched_use_project_end_date_for_float", o -> o.getCalculateFloatBasedOnFinishDateOfEachProject());
        SCHEDULE_OPTIONS_COLUMNS.put("enable_multiple_longest_path_calc", o -> o.getCalculateMultipleFloatPaths());
        SCHEDULE_OPTIONS_COLUMNS.put("limit_multiple_longest_path_calc", o -> o.getLimitNumberOfFloatPathsToCalculate());
        SCHEDULE_OPTIONS_COLUMNS.put("max_multiple_longest_path", ProjectProperties::getMaximumNumberOfFloatPathsToCalculate);
        SCHEDULE_OPTIONS_COLUMNS.put("use_total_float_multiple_longest_paths", o -> o.getCalculateMultipleFloatPathsUsingTotalFloat());
        SCHEDULE_OPTIONS_COLUMNS.put("key_activity_for_multiple_longest_paths", ProjectProperties::getDisplayMultipleFloatPathsEndingWithActivityUniqueID);
        SCHEDULE_OPTIONS_COLUMNS.put("LevelPriorityList", o -> "priority_type,ASC_BY_FIELD/ASC");
        UNIT_OF_MEASURE_COLUMNS = new LinkedHashMap<String, ExportFunction<UnitOfMeasure>>();
        UNIT_OF_MEASURE_COLUMNS.put("unit_id", UnitOfMeasure::getUniqueID);
        UNIT_OF_MEASURE_COLUMNS.put("seq_num", UnitOfMeasure::getSequenceNumber);
        UNIT_OF_MEASURE_COLUMNS.put("unit_abbrev", UnitOfMeasure::getAbbreviation);
        UNIT_OF_MEASURE_COLUMNS.put("unit_name", u -> StringHelper.stripControlCharacters(u.getName()));
        SHIFT_COLUMNS = new LinkedHashMap<String, ExportFunction<Shift>>();
        SHIFT_COLUMNS.put("shift_id", Shift::getUniqueID);
        SHIFT_COLUMNS.put("shift_name", s -> StringHelper.stripControlCharacters(s.getName()));
        SHIFT_PERIOD_COLUMNS = new LinkedHashMap<String, ExportFunction<ShiftPeriod>>();
        SHIFT_PERIOD_COLUMNS.put("shift_period_id", ShiftPeriod::getUniqueID);
        SHIFT_PERIOD_COLUMNS.put("shift_id", s -> s.getParentShift().getUniqueID());
        SHIFT_PERIOD_COLUMNS.put("shift_start_hr_num", s -> s.getStart().getHour());
        ROLE_ASSIGNMENT_COLUMNS = new LinkedHashMap<String, ExportFunction<Map<String, Object>>>();
        ROLE_ASSIGNMENT_COLUMNS.put("rsrc_id", v -> v.get("rsrc_id"));
        ROLE_ASSIGNMENT_COLUMNS.put("role_id", v -> v.get("role_id"));
        ROLE_ASSIGNMENT_COLUMNS.put("skill_level", v -> v.get("skill_level"));
        ROLE_ASSIGNMENT_COLUMNS.put("role_short_name", v -> v.get("role_short_name"));
        ROLE_ASSIGNMENT_COLUMNS.put("role_name", v -> v.get("role_name"));
        ROLE_ASSIGNMENT_COLUMNS.put("rsrc_short_name", v -> v.get("rsrc_short_name"));
        ROLE_ASSIGNMENT_COLUMNS.put("rsrc_name", v -> v.get("rsrc_name"));
        ROLE_ASSIGNMENT_COLUMNS.put("rsrc_type", v -> v.get("rsrc_type"));
        ROLE_ASSIGNMENT_COLUMNS.put("rsrc_role_id", v -> v.get("rsrc_role_id"));
        PROJECT_CODE_COLUMNS = new LinkedHashMap<String, ExportFunction<ProjectCode>>();
        PROJECT_CODE_COLUMNS.put("proj_catg_type_id", ProjectCode::getUniqueID);
        PROJECT_CODE_COLUMNS.put("seq_num", ProjectCode::getSequenceNumber);
        PROJECT_CODE_COLUMNS.put("proj_catg_short_len", ProjectCode::getMaxLength);
        PROJECT_CODE_COLUMNS.put("proj_catg_type", ProjectCode::getName);
        PROJECT_CODE_VALUE_COLUMNS = new LinkedHashMap<String, ExportFunction<ProjectCodeValue>>();
        PROJECT_CODE_VALUE_COLUMNS.put("proj_catg_id", ProjectCodeValue::getUniqueID);
        PROJECT_CODE_VALUE_COLUMNS.put("proj_catg_type_id", ProjectCodeValue::getParentCodeUniqueID);
        PROJECT_CODE_VALUE_COLUMNS.put("seq_num", ProjectCodeValue::getSequenceNumber);
        PROJECT_CODE_VALUE_COLUMNS.put("proj_catg_short_name", ProjectCodeValue::getName);
        PROJECT_CODE_VALUE_COLUMNS.put("parent_proj_catg_id", ProjectCodeValue::getParentValueUniqueID);
        PROJECT_CODE_VALUE_COLUMNS.put("proj_catg_name", ProjectCodeValue::getDescription);
        PROJECT_CODE_ASSIGNMENT_COLUMNS = new LinkedHashMap<String, ExportFunction<Map<String, Object>>>();
        PROJECT_CODE_ASSIGNMENT_COLUMNS.put("proj_id", v -> v.get("proj_id"));
        PROJECT_CODE_ASSIGNMENT_COLUMNS.put("proj_catg_type_id", v -> v.get("proj_catg_type_id"));
        PROJECT_CODE_ASSIGNMENT_COLUMNS.put("proj_catg_id", v -> v.get("proj_catg_id"));
        RESOURCE_CODE_COLUMNS = new LinkedHashMap<String, ExportFunction<ResourceCode>>();
        RESOURCE_CODE_COLUMNS.put("rsrc_catg_type_id", ResourceCode::getUniqueID);
        RESOURCE_CODE_COLUMNS.put("seq_num", ResourceCode::getSequenceNumber);
        RESOURCE_CODE_COLUMNS.put("rsrc_catg_short_len", ResourceCode::getMaxLength);
        RESOURCE_CODE_COLUMNS.put("rsrc_catg_type", ResourceCode::getName);
        RESOURCE_CODE_VALUE_COLUMNS = new LinkedHashMap<String, ExportFunction<ResourceCodeValue>>();
        RESOURCE_CODE_VALUE_COLUMNS.put("rsrc_catg_id", ResourceCodeValue::getUniqueID);
        RESOURCE_CODE_VALUE_COLUMNS.put("rsrc_catg_type_id", ResourceCodeValue::getParentCodeUniqueID);
        RESOURCE_CODE_VALUE_COLUMNS.put("seq_num", ResourceCodeValue::getSequenceNumber);
        RESOURCE_CODE_VALUE_COLUMNS.put("rsrc_catg_short_name", ResourceCodeValue::getName);
        RESOURCE_CODE_VALUE_COLUMNS.put("rsrc_catg_name", ResourceCodeValue::getDescription);
        RESOURCE_CODE_VALUE_COLUMNS.put("parent_rsrc_catg_id", ResourceCodeValue::getParentValueUniqueID);
        RESOURCE_CODE_ASSIGNMENT_COLUMNS = new LinkedHashMap<String, ExportFunction<Map<String, Object>>>();
        RESOURCE_CODE_ASSIGNMENT_COLUMNS.put("rsrc_id", v -> v.get("rsrc_id"));
        RESOURCE_CODE_ASSIGNMENT_COLUMNS.put("rsrc_catg_type_id", v -> v.get("rsrc_catg_type_id"));
        RESOURCE_CODE_ASSIGNMENT_COLUMNS.put("rsrc_catg_id", v -> v.get("rsrc_catg_id"));
        ROLE_CODE_COLUMNS = new LinkedHashMap<String, ExportFunction<RoleCode>>();
        ROLE_CODE_COLUMNS.put("role_catg_type_id", RoleCode::getUniqueID);
        ROLE_CODE_COLUMNS.put("seq_num", RoleCode::getSequenceNumber);
        ROLE_CODE_COLUMNS.put("role_catg_short_len", RoleCode::getMaxLength);
        ROLE_CODE_COLUMNS.put("role_catg_type", RoleCode::getName);
        ROLE_CODE_VALUE_COLUMNS = new LinkedHashMap<String, ExportFunction<RoleCodeValue>>();
        ROLE_CODE_VALUE_COLUMNS.put("role_catg_id", RoleCodeValue::getUniqueID);
        ROLE_CODE_VALUE_COLUMNS.put("role_catg_type_id", RoleCodeValue::getParentCodeUniqueID);
        ROLE_CODE_VALUE_COLUMNS.put("seq_num", RoleCodeValue::getSequenceNumber);
        ROLE_CODE_VALUE_COLUMNS.put("role_catg_short_name", RoleCodeValue::getName);
        ROLE_CODE_VALUE_COLUMNS.put("role_catg_name", RoleCodeValue::getDescription);
        ROLE_CODE_VALUE_COLUMNS.put("parent_role_catg_id", RoleCodeValue::getParentValueUniqueID);
        ROLE_CODE_ASSIGNMENT_COLUMNS = new LinkedHashMap<String, ExportFunction<Map<String, Object>>>();
        ROLE_CODE_ASSIGNMENT_COLUMNS.put("role_id", v -> v.get("role_id"));
        ROLE_CODE_ASSIGNMENT_COLUMNS.put("role_catg_type_id", v -> v.get("role_catg_type_id"));
        ROLE_CODE_ASSIGNMENT_COLUMNS.put("role_catg_id", v -> v.get("role_catg_id"));
        RESOURCE_ASSIGNMENT_CODE_COLUMNS = new LinkedHashMap<String, ExportFunction<ResourceAssignmentCode>>();
        RESOURCE_ASSIGNMENT_CODE_COLUMNS.put("asgnmnt_catg_type_id", ResourceAssignmentCode::getUniqueID);
        RESOURCE_ASSIGNMENT_CODE_COLUMNS.put("seq_num", ResourceAssignmentCode::getSequenceNumber);
        RESOURCE_ASSIGNMENT_CODE_COLUMNS.put("asgnmnt_catg_short_len", ResourceAssignmentCode::getMaxLength);
        RESOURCE_ASSIGNMENT_CODE_COLUMNS.put("asgnmnt_catg_type", ResourceAssignmentCode::getName);
        RESOURCE_ASSIGNMENT_CODE_VALUE_COLUMNS = new LinkedHashMap<String, ExportFunction<ResourceAssignmentCodeValue>>();
        RESOURCE_ASSIGNMENT_CODE_VALUE_COLUMNS.put("asgnmnt_catg_id", ResourceAssignmentCodeValue::getUniqueID);
        RESOURCE_ASSIGNMENT_CODE_VALUE_COLUMNS.put("asgnmnt_catg_type_id", ResourceAssignmentCodeValue::getParentCodeUniqueID);
        RESOURCE_ASSIGNMENT_CODE_VALUE_COLUMNS.put("seq_num", ResourceAssignmentCodeValue::getSequenceNumber);
        RESOURCE_ASSIGNMENT_CODE_VALUE_COLUMNS.put("asgnmnt_catg_short_name", ResourceAssignmentCodeValue::getName);
        RESOURCE_ASSIGNMENT_CODE_VALUE_COLUMNS.put("asgnmnt_catg_name", ResourceAssignmentCodeValue::getDescription);
        RESOURCE_ASSIGNMENT_CODE_VALUE_COLUMNS.put("parent_asgnmnt_catg_id", ResourceAssignmentCodeValue::getParentValueUniqueID);
        RESOURCE_ASSIGNMENT_CODE_ASSIGNMENT_COLUMNS = new LinkedHashMap<String, ExportFunction<Map<String, Object>>>();
        RESOURCE_ASSIGNMENT_CODE_ASSIGNMENT_COLUMNS.put("taskrsrc_id", v -> v.get("taskrsrc_id"));
        RESOURCE_ASSIGNMENT_CODE_ASSIGNMENT_COLUMNS.put("asgnmnt_catg_type_id", v -> v.get("asgnmnt_catg_type_id"));
        RESOURCE_ASSIGNMENT_CODE_ASSIGNMENT_COLUMNS.put("asgnmnt_catg_id", v -> v.get("asgnmnt_catg_id"));
        RESOURCE_ASSIGNMENT_CODE_ASSIGNMENT_COLUMNS.put("proj_id", v -> v.get("proj_id"));
    }

    static interface ExportFunction<T> {
        public Object apply(T var1);
    }
}

