/*
 * Decompiled with CFR 0.152.
 */
package org.mpxj.primavera;

import java.time.DayOfWeek;
import java.time.LocalTime;
import org.mpxj.CalendarType;
import org.mpxj.LocalTimeRange;
import org.mpxj.ProjectCalendar;
import org.mpxj.ProjectCalendarHours;

final class ProjectCalendarHelper {
    ProjectCalendarHelper() {
    }

    public static ProjectCalendar normalizeCalendar(ProjectCalendar calendar) {
        ProjectCalendar result = calendar;
        if (calendar.getType() == CalendarType.GLOBAL && calendar.isDerived()) {
            result = org.mpxj.common.ProjectCalendarHelper.createTemporaryFlattenedCalendar(calendar);
        }
        return result;
    }

    public static void ensureWorkingTime(ProjectCalendar calendar) {
        boolean hasWorkingTime = false;
        for (DayOfWeek day : DayOfWeek.values()) {
            ProjectCalendarHours hours = calendar.getCalendarHours(day);
            boolean bl = hasWorkingTime = hours != null && !hours.isEmpty();
            if (hasWorkingTime) break;
        }
        if (!hasWorkingTime) {
            LocalTimeRange defaultHourRange = ProjectCalendarHelper.getDefaultCalendarHours();
            for (DayOfWeek day : DayOfWeek.values()) {
                ProjectCalendarHours hours = calendar.addCalendarHours(day);
                if (day != DayOfWeek.SATURDAY && day != DayOfWeek.SUNDAY) {
                    calendar.setWorkingDay(day, true);
                    hours.add(defaultHourRange);
                    continue;
                }
                calendar.setWorkingDay(day, false);
            }
        }
    }

    public static LocalTimeRange getDefaultCalendarHours() {
        return new LocalTimeRange(LocalTime.of(8, 0), LocalTime.of(16, 0));
    }
}

