/*
 * Decompiled with CFR 0.152.
 */
package org.mpxj.primavera;

import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.HashSet;
import java.util.List;
import org.mpxj.LocalTimeRange;
import org.mpxj.ProjectCalendar;
import org.mpxj.ProjectCalendarException;
import org.mpxj.ProjectCalendarHours;
import org.mpxj.common.DayOfWeekHelper;
import org.mpxj.primavera.PrimaveraReader;
import org.mpxj.primavera.StructuredTextRecord;
import org.mpxj.primavera.StructuredTextWriter;

class ProjectCalendarStructuredTextWriter {
    private final DateTimeFormatter m_timeFormat = DateTimeFormatter.ofPattern("HH:mm");

    ProjectCalendarStructuredTextWriter() {
    }

    public String getCalendarData(ProjectCalendar calendar) {
        StructuredTextRecord root = new StructuredTextRecord();
        root.addAttribute("_record_number", "0");
        root.addAttribute("_record_name", "CalendarData");
        root.addChild(this.getDaysOfWeek(calendar));
        root.addChild(this.getExceptions(calendar));
        return new StructuredTextWriter().write(root);
    }

    private StructuredTextRecord getDaysOfWeek(ProjectCalendar calendar) {
        StructuredTextRecord daysOfWeekRecord = new StructuredTextRecord();
        daysOfWeekRecord.addAttribute("_record_number", "0");
        daysOfWeekRecord.addAttribute("_record_name", "DaysOfWeek");
        for (DayOfWeek day : DayOfWeekHelper.ORDERED_DAYS) {
            StructuredTextRecord dayRecord = new StructuredTextRecord();
            daysOfWeekRecord.addChild(dayRecord);
            dayRecord.addAttribute("_record_number", "0");
            dayRecord.addAttribute("_record_name", Integer.toString(DayOfWeekHelper.getValue(day)));
            this.writeHours(dayRecord, calendar.getHours(day));
        }
        return daysOfWeekRecord;
    }

    private StructuredTextRecord getExceptions(ProjectCalendar calendar) {
        StructuredTextRecord exceptionsRecord = new StructuredTextRecord();
        exceptionsRecord.addAttribute("_record_number", "0");
        exceptionsRecord.addAttribute("_record_name", "Exceptions");
        int exceptionIndex = 0;
        HashSet<LocalDate> exceptionDates = new HashSet<LocalDate>();
        List<ProjectCalendarException> exceptions = calendar.getExpandedCalendarExceptionsWithWorkWeeks();
        for (ProjectCalendarException exception : exceptions) {
            LocalDate currentDate = exception.getFromDate();
            while (!currentDate.isAfter(exception.getToDate())) {
                LocalDate exceptionDate = currentDate;
                currentDate = currentDate.plusDays(1L);
                if (!exceptionDates.add(exceptionDate)) continue;
                long dateValue = PrimaveraReader.EXCEPTION_EPOCH.until(exceptionDate, ChronoUnit.DAYS);
                StructuredTextRecord exceptionRecord = new StructuredTextRecord();
                exceptionsRecord.addChild(exceptionRecord);
                exceptionRecord.addAttribute("_record_number", "0");
                exceptionRecord.addAttribute("_record_name", Integer.toString(exceptionIndex++));
                exceptionRecord.addAttribute("d", Long.toString(dateValue));
                this.writeHours(exceptionRecord, exception);
            }
        }
        return exceptionsRecord;
    }

    private void writeHours(StructuredTextRecord parentRecord, ProjectCalendarHours hours) {
        int hoursIndex = 0;
        for (LocalTimeRange range : hours) {
            StructuredTextRecord hoursRecord = new StructuredTextRecord();
            parentRecord.addChild(hoursRecord);
            hoursRecord.addAttribute("_record_number", "0");
            hoursRecord.addAttribute("_record_name", Integer.toString(hoursIndex++));
            hoursRecord.addAttribute("f", this.m_timeFormat.format(range.getEnd()));
            hoursRecord.addAttribute("s", this.m_timeFormat.format(range.getStart()));
        }
    }
}

