/*
 * Decompiled with CFR 0.152.
 */
package org.mpxj.primavera;

import java.util.HashMap;
import java.util.Map;
import org.mpxj.RelationType;

final class RelationTypeHelper {
    private static final Map<String, RelationType> XML_TYPE_MAP = new HashMap<String, RelationType>();
    private static final Map<RelationType, String> TYPE_XML_MAP;
    private static final Map<String, RelationType> XER_TYPE_MAP;
    private static final Map<RelationType, String> TYPE_XER_MAP;

    RelationTypeHelper() {
    }

    public static RelationType getInstanceFromXml(String value) {
        return XML_TYPE_MAP.get(value);
    }

    public static RelationType getInstanceFromXer(String value) {
        RelationType result = null;
        if (value != null) {
            if (value.length() > 5) {
                value = value.substring(0, 5);
            }
            result = XER_TYPE_MAP.get(value);
        }
        return result == null ? RelationType.FINISH_START : result;
    }

    public static String getXmlFromInstance(RelationType value) {
        return TYPE_XML_MAP.get(value);
    }

    public static String getXerFromInstance(RelationType value) {
        return TYPE_XER_MAP.get(value);
    }

    static {
        XML_TYPE_MAP.put("Finish to Start", RelationType.FINISH_START);
        XML_TYPE_MAP.put("Finish to Finish", RelationType.FINISH_FINISH);
        XML_TYPE_MAP.put("Start to Start", RelationType.START_START);
        XML_TYPE_MAP.put("Start to Finish", RelationType.START_FINISH);
        TYPE_XML_MAP = new HashMap<RelationType, String>();
        TYPE_XML_MAP.put(RelationType.FINISH_START, "Finish to Start");
        TYPE_XML_MAP.put(RelationType.FINISH_FINISH, "Finish to Finish");
        TYPE_XML_MAP.put(RelationType.START_START, "Start to Start");
        TYPE_XML_MAP.put(RelationType.START_FINISH, "Start to Finish");
        XER_TYPE_MAP = new HashMap<String, RelationType>();
        XER_TYPE_MAP.put("PR_FS", RelationType.FINISH_START);
        XER_TYPE_MAP.put("PR_FF", RelationType.FINISH_FINISH);
        XER_TYPE_MAP.put("PR_SS", RelationType.START_START);
        XER_TYPE_MAP.put("PR_SF", RelationType.START_FINISH);
        TYPE_XER_MAP = new HashMap<RelationType, String>();
        TYPE_XER_MAP.put(RelationType.FINISH_START, "PR_FS");
        TYPE_XER_MAP.put(RelationType.FINISH_FINISH, "PR_FF");
        TYPE_XER_MAP.put(RelationType.START_START, "PR_SS");
        TYPE_XER_MAP.put(RelationType.START_FINISH, "PR_SF");
    }
}

