/*
 * Decompiled with CFR 0.152.
 */
package org.mpxj.primavera;

import java.util.HashMap;
import java.util.Map;
import org.mpxj.ResourceType;

final class ResourceTypeHelper {
    private static final Map<String, ResourceType> XML_TYPE_MAP = new HashMap<String, ResourceType>();
    private static final Map<ResourceType, String> TYPE_XML_MAP;
    private static final Map<String, ResourceType> XER_TYPE_MAP;
    private static final Map<ResourceType, String> TYPE_XER_MAP;

    ResourceTypeHelper() {
    }

    public static ResourceType getInstanceFromXml(String value) {
        return XML_TYPE_MAP.get(value);
    }

    public static ResourceType getInstanceFromXer(String value) {
        return XER_TYPE_MAP.get(value);
    }

    public static String getXmlFromInstance(ResourceType value) {
        return TYPE_XML_MAP.get(value);
    }

    public static String getXerFromInstance(ResourceType value) {
        return TYPE_XER_MAP.get(value);
    }

    static {
        XML_TYPE_MAP.put(null, ResourceType.WORK);
        XML_TYPE_MAP.put("Labor", ResourceType.WORK);
        XML_TYPE_MAP.put("Material", ResourceType.MATERIAL);
        XML_TYPE_MAP.put("Nonlabor", ResourceType.COST);
        TYPE_XML_MAP = new HashMap<ResourceType, String>();
        TYPE_XML_MAP.put(ResourceType.WORK, "Labor");
        TYPE_XML_MAP.put(ResourceType.MATERIAL, "Material");
        TYPE_XML_MAP.put(ResourceType.COST, "Nonlabor");
        XER_TYPE_MAP = new HashMap<String, ResourceType>();
        XER_TYPE_MAP.put(null, ResourceType.WORK);
        XER_TYPE_MAP.put("RT_Labor", ResourceType.WORK);
        XER_TYPE_MAP.put("RT_Mat", ResourceType.MATERIAL);
        XER_TYPE_MAP.put("RT_Equip", ResourceType.COST);
        TYPE_XER_MAP = new HashMap<ResourceType, String>();
        TYPE_XER_MAP.put(ResourceType.WORK, "RT_Labor");
        TYPE_XER_MAP.put(ResourceType.MATERIAL, "RT_Mat");
        TYPE_XER_MAP.put(ResourceType.COST, "RT_Equip");
    }
}

