/*
 * Decompiled with CFR 0.152.
 */
package org.mpxj.primavera;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Map;
import org.mpxj.common.NumberHelper;
import org.mpxj.primavera.ArrayRow;

final class ResultSetRow
extends ArrayRow {
    private static final int SQL_SERVER_TIMESTAMP = -151;

    public ResultSetRow(ResultSet rs, Map<String, Integer> meta, Map<String, Integer> index) throws SQLException {
        super(index, ResultSetRow.populateArray(rs, meta, index), false);
    }

    private static Object[] populateArray(ResultSet rs, Map<String, Integer> meta, Map<String, Integer> index) throws SQLException {
        Object[] array = new Object[meta.size()];
        for (Map.Entry<String, Integer> entry : meta.entrySet()) {
            Object value;
            String name = entry.getKey().toLowerCase();
            int type = entry.getValue();
            switch (type) {
                case -7: 
                case 16: {
                    value = rs.getBoolean(name);
                    break;
                }
                case -16: 
                case -9: 
                case -1: 
                case 1: 
                case 12: 
                case 2005: {
                    value = ResultSetRow.stripTrailingNul(rs.getString(name));
                    break;
                }
                case -151: 
                case 91: 
                case 93: {
                    Timestamp ts = rs.getTimestamp(name);
                    if (ts != null) {
                        value = ts.toLocalDateTime();
                        break;
                    }
                    value = null;
                    break;
                }
                case 2: 
                case 3: 
                case 7: 
                case 8: {
                    value = NumberHelper.getDouble(rs.getDouble(name));
                    break;
                }
                case 4: 
                case 5: {
                    value = rs.getInt(name);
                    break;
                }
                case -5: {
                    value = rs.getLong(name);
                    break;
                }
                case -4: 
                case -3: 
                case 2004: {
                    value = rs.getBytes(name);
                    break;
                }
                case 1111: {
                    value = rs.getObject(name);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported SQL type: " + type + " for column " + name);
                }
            }
            if (rs.wasNull()) {
                value = null;
            }
            array[index.get((Object)name).intValue()] = value;
        }
        return array;
    }

    private static String stripTrailingNul(String value) {
        String result;
        for (result = value; result != null && !result.isEmpty() && result.charAt(result.length() - 1) == '\u0000'; result = result.substring(0, result.length() - 1)) {
        }
        return result;
    }
}

