/*
 * Decompiled with CFR 0.152.
 */
package org.mpxj.primavera;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PushbackReader;
import java.io.StringReader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import org.mpxj.common.CharsetHelper;
import org.mpxj.primavera.StructuredTextParseException;
import org.mpxj.primavera.StructuredTextRecord;

public class StructuredTextParser {
    private boolean m_raiseExceptionOnParseError = true;
    private PushbackReader m_reader;
    private final StringBuilder m_buffer = new StringBuilder();
    public static final Charset DEFAULT_CHARSET = CharsetHelper.CP1252;

    public void setRaiseExceptionOnParseError(boolean raiseExceptionOnParseError) {
        this.m_raiseExceptionOnParseError = raiseExceptionOnParseError;
    }

    public StructuredTextRecord parse(InputStream is) {
        return this.parse(is, DEFAULT_CHARSET);
    }

    public StructuredTextRecord parse(InputStream is, Charset charset) {
        try {
            return this.parse(new PushbackReader(new InputStreamReader(is, charset)));
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public StructuredTextRecord parse(String text) {
        try {
            return this.parse(new PushbackReader(new StringReader(text)));
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    private StructuredTextRecord parse(PushbackReader reader) throws IOException {
        this.m_reader = reader;
        return this.parse();
    }

    private StructuredTextRecord parse() throws IOException {
        ArrayList<StructuredTextRecord> children;
        HashMap<String, String> attributes;
        block16: {
            attributes = new HashMap<String, String>();
            children = new ArrayList<StructuredTextRecord>();
            try {
                char c;
                while ((c = this.skipWhitespaceAndRead()) != ')') {
                    if (c != '(') {
                        throw new StructuredTextParseException("Unexpected character: '" + c + "' expecting record start '('");
                    }
                    this.m_buffer.setLength(0);
                    while (Character.isDigit(c = this.read())) {
                        this.m_buffer.append(c);
                    }
                    if (this.m_buffer.length() == 0) {
                        throw new StructuredTextParseException("Missing record number");
                    }
                    attributes.put("_record_number", this.m_buffer.toString());
                    this.m_buffer.setLength(0);
                    c = this.skipWhitespaceAndRead(c);
                    while (c == '|') {
                        this.m_buffer.append(c);
                        c = this.read();
                    }
                    if (!this.m_buffer.toString().equals("||")) {
                        throw new StructuredTextParseException("Missing record separator '||'");
                    }
                    this.m_buffer.setLength(0);
                    c = this.skipWhitespaceAndRead(c);
                    while (c != '(') {
                        this.m_buffer.append(c);
                        c = this.read();
                    }
                    if (this.m_buffer.length() > 0) {
                        attributes.put("_record_name", this.m_buffer.toString());
                    }
                    c = this.read();
                    while (c != ')') {
                        this.m_buffer.setLength(0);
                        while (c != '|') {
                            this.m_buffer.append(c);
                            c = this.read();
                        }
                        String fieldName = this.m_buffer.toString();
                        this.m_buffer.setLength(0);
                        c = this.read();
                        while (c != '|' && c != ')') {
                            this.m_buffer.append(c);
                            c = this.read();
                        }
                        if (c == '|') {
                            c = this.read();
                        }
                        attributes.put(fieldName, this.m_buffer.toString());
                    }
                    c = this.skipWhitespaceAndRead();
                    if (c != '(') {
                        throw new StructuredTextParseException("Unexpected character: '" + c + "' expecting child records start '('");
                    }
                    while (true) {
                        c = this.skipWhitespaceAndRead();
                        this.m_reader.unread(c);
                        if (c != '(') break;
                        children.add(this.parse());
                    }
                    c = this.skipWhitespaceAndRead();
                    if (c == ')') continue;
                    throw new StructuredTextParseException("Unexpected character: '" + c + "' expecting child records end ')'");
                }
            }
            catch (StructuredTextParseException ex) {
                if (!this.m_raiseExceptionOnParseError) break block16;
                throw ex;
            }
        }
        return new StructuredTextRecord(attributes, children);
    }

    private char skipWhitespaceAndRead() throws IOException {
        return this.skipWhitespaceAndRead(this.read());
    }

    private char skipWhitespaceAndRead(char c) throws IOException {
        while (Character.isWhitespace(c) || Character.isISOControl(c)) {
            c = this.read();
        }
        return c;
    }

    private char read() throws IOException {
        int c = this.m_reader.read();
        if (c == -1) {
            throw new StructuredTextParseException("End of stream reached");
        }
        return (char)c;
    }
}

