/*
 * Decompiled with CFR 0.152.
 */
package org.mpxj.primavera;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.mpxj.primavera.StructuredTextRecord;

public class StructuredTextWriter {
    private StringBuilder m_buffer;
    private static final Set<String> IGNORED_KEYS = new HashSet<String>(Arrays.asList("_record_name", "_record_number"));

    public String write(StructuredTextRecord record) {
        this.m_buffer = new StringBuilder();
        this.writeRecord(record);
        String result = this.m_buffer.toString();
        this.m_buffer = null;
        return result;
    }

    private void writeRecord(StructuredTextRecord record) {
        this.m_buffer.append("(");
        this.m_buffer.append(record.getRecordNumber());
        this.m_buffer.append("||");
        this.m_buffer.append(record.getRecordName());
        this.m_buffer.append("(");
        this.m_buffer.append(record.getAttributes().entrySet().stream().filter(e -> !IGNORED_KEYS.contains(e.getKey())).map(e -> (String)e.getKey() + "|" + (String)e.getValue()).collect(Collectors.joining("|")));
        this.m_buffer.append(")");
        this.m_buffer.append("(");
        for (StructuredTextRecord child : record.getChildren()) {
            this.writeRecord(child);
        }
        this.m_buffer.append(")");
        this.m_buffer.append(")");
    }
}

