/*
 * Decompiled with CFR 0.152.
 */
package org.mpxj.primavera;

import java.text.DecimalFormat;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import org.mpxj.Duration;
import org.mpxj.ProjectCalendar;
import org.mpxj.TimeUnit;
import org.mpxj.TimephasedWork;

final class TimephasedHelper {
    private static final DecimalFormat FORMAT = new DecimalFormat("#.#");

    TimephasedHelper() {
    }

    public static List<TimephasedWork> read(ProjectCalendar calendar, LocalDateTime start, String values) {
        if (start == null || values == null || values.isEmpty()) {
            return null;
        }
        if (values.indexOf(58) == -1) {
            return null;
        }
        ArrayList<TimephasedWork> list = new ArrayList<TimephasedWork>();
        LocalDateTime currentStart = calendar.getNextWorkStart(start);
        for (String value : values.split(";")) {
            String[] item = value.split(":");
            if (item.length != 2) {
                return null;
            }
            Duration workHours = Duration.getInstance(Double.parseDouble(item[0]), TimeUnit.HOURS);
            Duration periodHours = Duration.getInstance(Double.parseDouble(item[1]), TimeUnit.HOURS);
            LocalDateTime currentFinish = calendar.getDate(currentStart, periodHours);
            double days = calendar.getDuration(currentStart, currentFinish).getDuration();
            TimephasedWork timephasedItem = new TimephasedWork();
            timephasedItem.setStart(currentStart);
            timephasedItem.setFinish(currentFinish);
            timephasedItem.setTotalAmount(workHours);
            timephasedItem.setAmountPerDay(Duration.getInstance(workHours.getDuration() / days, TimeUnit.HOURS));
            list.add(timephasedItem);
            currentStart = calendar.getNextWorkStart(currentFinish);
        }
        return list;
    }

    public static String write(ProjectCalendar calendar, List<TimephasedWork> items) {
        if (items == null || items.isEmpty()) {
            return null;
        }
        StringBuilder result = new StringBuilder();
        LocalDateTime previousFinish = null;
        for (TimephasedWork item : items) {
            Duration workToNextItem;
            if (previousFinish != null && (workToNextItem = calendar.getWork(previousFinish, item.getStart(), TimeUnit.HOURS)).getDuration() != 0.0) {
                if (result.length() != 0) {
                    result.append(";");
                }
                result.append("0:");
                result.append((int)workToNextItem.getDuration());
            }
            Duration workHours = ((Duration)item.getTotalAmount()).convertUnits(TimeUnit.HOURS, calendar);
            Duration periodHours = calendar.getWork(item.getStart(), item.getFinish(), TimeUnit.HOURS);
            if (result.length() != 0) {
                result.append(";");
            }
            result.append(FORMAT.format(workHours.getDuration()));
            result.append(':');
            result.append(FORMAT.format(periodHours.getDuration()));
            previousFinish = item.getFinish();
        }
        return result.toString();
    }
}

