/*
 * Decompiled with CFR 0.152.
 */
package org.mpxj.primavera;

import java.time.LocalDateTime;
import java.util.Optional;
import org.mpxj.Duration;
import org.mpxj.ProjectProperties;
import org.mpxj.Resource;
import org.mpxj.ResourceAssignment;
import org.mpxj.Task;
import org.mpxj.TimeUnit;

class WriterHelper {
    private static final String RESOURCE_ID_PREFIX = "RESOURCE-";
    private static final String ROLE_ID_PREFIX = "ROLE-";

    WriterHelper() {
    }

    public static LocalDateTime getProjectPlannedStart(ProjectProperties props) {
        return Optional.ofNullable(Optional.ofNullable(props.getPlannedStart()).orElseGet(props::getStartDate)).orElseGet(props::getCurrentDate);
    }

    public static Duration getActivityPlannedDuration(Task task) {
        return Optional.ofNullable(Optional.ofNullable(task.getPlannedDuration()).orElseGet(task::getDuration)).orElseGet(() -> Duration.getInstance(0, TimeUnit.HOURS));
    }

    public static String getActivityID(Task task) {
        return task.getActivityID() == null ? task.getWBS() : task.getActivityID();
    }

    public static String getResourceID(Resource resource) {
        String id = resource.getResourceID();
        return id == null || id.isEmpty() ? RESOURCE_ID_PREFIX + resource.getUniqueID() : id;
    }

    public static String getRoleID(Resource role) {
        String id = role.getResourceID();
        return id == null || id.isEmpty() ? ROLE_ID_PREFIX + role.getResourceID() : id;
    }

    public static boolean isValidAssignment(ResourceAssignment assignment) {
        Task task = assignment.getTask();
        return assignment.getResource() != null && task != null && task.getUniqueID() != 0 && !task.getSummary();
    }
}

