/*
 * Decompiled with CFR 0.152.
 */
package org.mpxj.primavera.p3;

import java.time.LocalDateTime;
import org.mpxj.primavera.common.AbstractColumn;
import org.mpxj.primavera.p3.DatabaseReader;

class DateColumn
extends AbstractColumn {
    public DateColumn(String name, int offset) {
        super(name, offset);
    }

    @Override
    public LocalDateTime read(int offset, byte[] data) {
        String stringValue;
        LocalDateTime result = null;
        int intValue = 0;
        int i = offset + this.m_offset;
        for (int shiftBy = 0; shiftBy < 32; shiftBy += 8) {
            intValue |= (data[i] & 0xFF) << shiftBy;
            ++i;
        }
        if (intValue != 0 && (stringValue = Integer.toString(intValue)).length() == 10) {
            int year = Integer.parseInt(stringValue.substring(0, 4));
            int month = Integer.parseInt(stringValue.substring(4, 6));
            int day = Integer.parseInt(stringValue.substring(6, 8));
            if (year > 0 && month > 0 && month <= 12 && day > 0 && day <= 31 && (result = LocalDateTime.of(year, month, day, 0, 0)).isBefore(DatabaseReader.EPOCH)) {
                result = null;
            }
        }
        return result;
    }
}

