/*
 * Decompiled with CFR 0.152.
 */
package org.mpxj.primavera.suretrak;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import org.mpxj.MPXJException;
import org.mpxj.ProjectFile;
import org.mpxj.common.ByteArrayHelper;
import org.mpxj.common.FileHelper;
import org.mpxj.common.FixedLengthInputStream;
import org.mpxj.common.InputStreamHelper;
import org.mpxj.primavera.common.Blast;
import org.mpxj.primavera.suretrak.SureTrakDatabaseReader;
import org.mpxj.reader.AbstractProjectStreamReader;

public final class SureTrakSTXFileReader
extends AbstractProjectStreamReader {
    @Override
    public ProjectFile read(InputStream stream) throws MPXJException {
        ProjectFile projectFile;
        File tempDir = null;
        try {
            InputStreamHelper.skip(stream, 32772L);
            tempDir = FileHelper.createTempDir();
            while (stream.available() > 0) {
                this.extractFile(stream, tempDir);
            }
            projectFile = SureTrakDatabaseReader.setProjectNameAndRead(tempDir);
        }
        catch (IOException ex) {
            try {
                throw new MPXJException("Failed to parse file", ex);
            }
            catch (Throwable throwable) {
                FileHelper.deleteQuietly(tempDir);
                throw throwable;
            }
        }
        FileHelper.deleteQuietly(tempDir);
        return projectFile;
    }

    private void extractFile(InputStream stream, File dir) throws IOException {
        byte[] dataSize = InputStreamHelper.read(stream, 4);
        InputStreamHelper.skip(stream, 4L);
        byte[] fileName = InputStreamHelper.read(stream, 260);
        int dataSizeValue = this.getInt(dataSize, 0);
        String fileNameValue = this.getString(fileName, 0);
        File file = new File(dir, fileNameValue);
        if (dataSizeValue == 0) {
            FileHelper.createNewFile(file);
        } else {
            OutputStream os = Files.newOutputStream(file.toPath(), new OpenOption[0]);
            FixedLengthInputStream inputStream = new FixedLengthInputStream(stream, dataSizeValue);
            Blast blast = new Blast();
            blast.blast(inputStream, os);
            os.close();
        }
    }

    private int getInt(byte[] data, int offset) {
        return ByteArrayHelper.getInt(data, offset);
    }

    private String getString(byte[] data, int offset) {
        char c;
        StringBuilder buffer = new StringBuilder();
        int loop = 0;
        while (offset + loop < data.length && (c = (char)data[offset + loop]) != '\u0000') {
            buffer.append(c);
            ++loop;
        }
        return buffer.toString();
    }
}

