/*
 * Decompiled with CFR 0.152.
 */
package org.mpxj.primavera.suretrak;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.HashMap;
import org.mpxj.common.AutoCloseableHelper;
import org.mpxj.common.ByteArrayHelper;
import org.mpxj.common.InputStreamHelper;
import org.mpxj.primavera.common.ColumnDefinition;
import org.mpxj.primavera.common.Table;
import org.mpxj.primavera.common.TableDefinition;

class TableReader {
    private final TableDefinition m_definition;

    public TableReader(TableDefinition definition) {
        this.m_definition = definition;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void read(File file, Table table) throws IOException {
        InputStream is = null;
        try {
            is = Files.newInputStream(file.toPath(), new OpenOption[0]);
            this.read(is, table);
        }
        catch (Throwable throwable) {
            AutoCloseableHelper.closeQuietly(is);
            throw throwable;
        }
        AutoCloseableHelper.closeQuietly(is);
    }

    private void read(InputStream is, Table table) throws IOException {
        int bytesRead;
        InputStreamHelper.skip(is, 6L);
        InputStreamHelper.skip(is, 2L);
        byte[] buffer = new byte[this.m_definition.getRecordSize()];
        while ((bytesRead = is.read(buffer)) != -1) {
            if (bytesRead != buffer.length) {
                throw new IOException("Unexpected end of file");
            }
            if (buffer[0] != 0) continue;
            this.readRecord(buffer, table);
        }
    }

    private void readRecord(byte[] buffer, Table table) {
        int deletedFlag = this.getShort(buffer, 0);
        if (deletedFlag != 0) {
            HashMap<String, Object> row = new HashMap<String, Object>();
            for (ColumnDefinition column : this.m_definition.getColumns()) {
                Object value = column.read(0, buffer);
                row.put(column.getName(), value);
            }
            table.addRow(this.m_definition.getPrimaryKeyColumnName(), row);
        }
    }

    private int getShort(byte[] data, int offset) {
        return ByteArrayHelper.getShort(data, offset);
    }
}

