/*
 * Decompiled with CFR 0.152.
 */
package org.mpxj.reader;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.mpxj.MPXJException;
import org.mpxj.asta.AstaFileReader;
import org.mpxj.fasttrack.FastTrackReader;
import org.mpxj.ganttproject.GanttProjectReader;
import org.mpxj.mpd.MPDFileReader;
import org.mpxj.mpp.MPPReader;
import org.mpxj.mpx.MPXReader;
import org.mpxj.mspdi.MSPDIReader;
import org.mpxj.phoenix.PhoenixReader;
import org.mpxj.planner.PlannerReader;
import org.mpxj.primavera.PrimaveraPMFileReader;
import org.mpxj.primavera.PrimaveraXERFileReader;
import org.mpxj.projectlibre.ProjectLibreReader;
import org.mpxj.reader.ProjectReader;

public final class ProjectReaderUtility {
    private static final Map<String, Class<? extends ProjectReader>> READER_MAP = new HashMap<String, Class<? extends ProjectReader>>();

    private ProjectReaderUtility() {
    }

    public static ProjectReader getProjectReader(String name) throws MPXJException {
        int index = name.lastIndexOf(46);
        if (index == -1) {
            throw new IllegalArgumentException("Filename has no extension: " + name);
        }
        String extension = name.substring(index + 1).toUpperCase();
        Class<? extends ProjectReader> fileClass = READER_MAP.get(extension);
        if (fileClass == null) {
            throw new IllegalArgumentException("Cannot read files of type: " + extension);
        }
        try {
            return fileClass.newInstance();
        }
        catch (Exception ex) {
            throw new MPXJException("Failed to load project reader", ex);
        }
    }

    public static Set<String> getSupportedFileExtensions() {
        return READER_MAP.keySet();
    }

    static {
        READER_MAP.put("MPP", MPPReader.class);
        READER_MAP.put("MPT", MPPReader.class);
        READER_MAP.put("MPX", MPXReader.class);
        READER_MAP.put("XML", MSPDIReader.class);
        READER_MAP.put("MPD", MPDFileReader.class);
        READER_MAP.put("PLANNER", PlannerReader.class);
        READER_MAP.put("XER", PrimaveraXERFileReader.class);
        READER_MAP.put("PMXML", PrimaveraPMFileReader.class);
        READER_MAP.put("PP", AstaFileReader.class);
        READER_MAP.put("PPX", PhoenixReader.class);
        READER_MAP.put("FTS", FastTrackReader.class);
        READER_MAP.put("POD", ProjectLibreReader.class);
        READER_MAP.put("GAN", GanttProjectReader.class);
    }
}

