/*
 * Decompiled with CFR 0.152.
 */
package org.mpxj.reader;

import com.healthmarketscience.jackcess.Database;
import com.healthmarketscience.jackcess.DatabaseBuilder;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.Stack;
import java.util.regex.Pattern;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.mpxj.HasCharset;
import org.mpxj.MPXJException;
import org.mpxj.ProjectFile;
import org.mpxj.asta.AstaMdbReader;
import org.mpxj.asta.AstaSqliteReader;
import org.mpxj.asta.AstaTextFileReader;
import org.mpxj.common.AutoCloseableHelper;
import org.mpxj.common.CharsetHelper;
import org.mpxj.common.ConnectionHelper;
import org.mpxj.common.FileHelper;
import org.mpxj.common.InputStreamHelper;
import org.mpxj.common.SQLite;
import org.mpxj.conceptdraw.ConceptDrawProjectReader;
import org.mpxj.edrawproject.EdrawProjectReader;
import org.mpxj.fasttrack.FastTrackReader;
import org.mpxj.ganttdesigner.GanttDesignerReader;
import org.mpxj.ganttproject.GanttProjectReader;
import org.mpxj.merlin.MerlinReader;
import org.mpxj.mpd.MPDFileReader;
import org.mpxj.mpp.MPPReader;
import org.mpxj.mpx.MPXReader;
import org.mpxj.mspdi.MSPDIReader;
import org.mpxj.openplan.OpenPlanReader;
import org.mpxj.phoenix.PhoenixInputStream;
import org.mpxj.phoenix.PhoenixReader;
import org.mpxj.planner.PlannerReader;
import org.mpxj.primavera.PrimaveraDatabaseFileReader;
import org.mpxj.primavera.PrimaveraPMFileReader;
import org.mpxj.primavera.PrimaveraXERFileReader;
import org.mpxj.primavera.p3.P3DatabaseReader;
import org.mpxj.primavera.p3.P3PRXFileReader;
import org.mpxj.primavera.suretrak.SureTrakDatabaseReader;
import org.mpxj.primavera.suretrak.SureTrakSTXFileReader;
import org.mpxj.projectcommander.ProjectCommanderReader;
import org.mpxj.projectlibre.ProjectLibreReader;
import org.mpxj.reader.AbstractProjectReader;
import org.mpxj.reader.ProjectReader;
import org.mpxj.sage.SageReader;
import org.mpxj.sdef.SDEFReader;
import org.mpxj.synchro.SynchroReader;
import org.mpxj.turboproject.TurboProjectReader;

public final class UniversalProjectReader
extends AbstractProjectReader {
    private Properties m_properties;
    private int m_skipBytes;
    private Charset m_charset;
    private final Stack<Runnable> m_cleanup = new Stack();
    private static final int BUFFER_SIZE = 512;
    private static final byte[] OLE_COMPOUND_DOC_FINGERPRINT = new byte[]{-48, -49, 17, -32, -95, -79, 26, -31};
    private static final byte[] PP_FINGERPRINT = new byte[]{0, 0, 48, 48, 48, 48, 48, 48};
    private static final byte[] MPX_FINGERPRINT = new byte[]{77, 80, 88};
    private static final byte[] MDB_FINGERPRINT = new byte[]{0, 1, 0, 0, 83, 116, 97, 110, 100, 97, 114, 100, 32, 74, 101, 116, 32, 68, 66};
    private static final byte[] SQLITE_FINGERPRINT = new byte[]{83, 81, 76, 105, 116, 101, 32, 102, 111, 114, 109, 97, 116};
    private static final byte[] ZIP_FINGERPRINT = new byte[]{80, 75};
    private static final byte[] PHOENIX_FINGERPRINT = new byte[]{80, 80, 88, 33, 33, 33, 33};
    private static final byte[] BINARY_PLIST = new byte[]{98, 112, 108, 105, 115, 116};
    private static final byte[] FASTTRACK_FINGERPRINT = new byte[]{28, 0, 0, 0};
    private static final byte[] PROJECTLIBRE_FINGERPRINT = new byte[]{-84, -19, 0, 5};
    private static final byte[] BTRIEVE_FINGERPRINT = new byte[]{70, 67, 0, 0};
    private static final byte[] STW_FINGERPRINT = new byte[]{83, 84, 87};
    private static final byte[] DOS_EXE_FINGERPRINT = new byte[]{77, 90};
    private static final byte[] WINDOWS_NE_EXE_FINGERPRINT = new byte[]{78, 69};
    private static final byte[] STX_FINGERPRINT = new byte[]{85, -117};
    private static final byte[] SYNCHRO_FINGERPRINT = new byte[]{-74, 23};
    private static final byte[] SDEF_FINGERPRINT = new byte[]{86, 79, 76, 77};
    private static final byte[] SCHEDULE_GRID_FINGERPRINT = new byte[]{42, 42, 42, 42, 32, 83, 99, 104, 101, 100, 117, 108, 101, 32, 71, 114, 105, 100};
    private static final byte[] UTF8_BOM_FINGERPRINT = new byte[]{-17, -69, -65};
    private static final byte[] UTF16_BOM_FINGERPRINT = new byte[]{-2, -1};
    private static final byte[] UTF16LE_BOM_FINGERPRINT = new byte[]{-1, -2};
    private static final byte[] PROJECT_COMMANDER_FINGERPRINT_1 = new byte[]{0, -128, 1, 0};
    private static final byte[] PROJECT_COMMANDER_FINGERPRINT_2 = new byte[]{2, -128, 1, 0};
    private static final Pattern XER_FINGERPRINT = Pattern.compile("ERMHDR.*", 32);
    private static final Pattern PLANNER_FINGERPRINT = Pattern.compile(".*<project.*mrproject-version.*", 32);
    private static final Pattern PMXML_FINGERPRINT = Pattern.compile(".*(<BusinessObjects|APIBusinessObjects).*", 32);
    private static final Pattern MSPDI_FINGERPRINT_1 = Pattern.compile(".*xmlns=\"http://schemas\\.microsoft\\.com/project.*", 32);
    private static final Pattern MSPDI_FINGERPRINT_2 = Pattern.compile(".*<Project.*<SaveVersion>.*", 32);
    private static final Pattern MSPDI_FINGERPRINT_3 = Pattern.compile(".*<Project.*<Title>.*", 32);
    private static final Pattern PHOENIX_XML_FINGERPRINT1 = Pattern.compile(".*<project.*version=\"(\\d+|\\d+\\.\\d+)\".*update_mode=\"(true|false)\".*>.*", 32);
    private static final Pattern PHOENIX_XML_FINGERPRINT2 = Pattern.compile(".*<project.*version=\"(\\d+|\\d+\\.\\d+)\".*application=\"Phoenix.*", 32);
    private static final Pattern GANTTPROJECT_FINGERPRINT = Pattern.compile(".*<project.*webLink.*", 32);
    private static final Pattern TURBOPROJECT_FINGERPRINT = Pattern.compile(".*dWBSTAB.*", 32);
    private static final Pattern PRX_FINGERPRINT = Pattern.compile("!Self-Extracting Primavera Project", 32);
    private static final Pattern PRX3_FINGERPRINT = Pattern.compile("PRX3", 32);
    private static final Pattern CONCEPT_DRAW_FINGERPRINT = Pattern.compile(".*Application=\"CDProject\".*", 32);
    private static final Pattern GANTT_DESIGNER_FINGERPRINT = Pattern.compile(".*<Gantt Version=.*", 32);
    private static final Pattern EDRAW_PROJECT_FINGERPRINT = Pattern.compile(".*<Document.*DocGuid=.*", 32);

    @Override
    public ProjectFile read(String fileName) throws MPXJException {
        return this.read(new File(fileName));
    }

    @Override
    public List<ProjectFile> readAll(String fileName) throws MPXJException {
        return this.readAll(new File(fileName));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public ProjectFile read(File file) throws MPXJException {
        try (ProjectReaderProxy reader = this.getProjectReaderProxy(file);){
            ProjectFile projectFile = reader == null ? null : reader.read();
            return projectFile;
        }
        catch (MPXJException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<ProjectFile> readAll(File file) throws MPXJException {
        try (ProjectReaderProxy reader = this.getProjectReaderProxy(file);){
            List<ProjectFile> list = reader == null ? Collections.emptyList() : reader.readAll();
            return list;
        }
        catch (MPXJException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public ProjectFile read(InputStream inputStream) throws MPXJException {
        try (ProjectReaderProxy reader = this.getProjectReaderProxy(inputStream);){
            ProjectFile projectFile = reader == null ? null : reader.read();
            return projectFile;
        }
        catch (MPXJException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<ProjectFile> readAll(InputStream inputStream) throws MPXJException {
        try (ProjectReaderProxy reader = this.getProjectReaderProxy(inputStream);){
            List<ProjectFile> list = reader == null ? Collections.emptyList() : reader.readAll();
            return list;
        }
        catch (MPXJException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public ProjectReaderProxy getProjectReaderProxy(String fileName) throws MPXJException {
        return this.getProjectReaderProxy(new File(fileName));
    }

    public ProjectReaderProxy getProjectReaderProxy(File file) throws MPXJException {
        try {
            return file.isDirectory() ? this.handleDirectory(file) : this.handleFile(file);
        }
        catch (Exception ex) {
            throw new MPXJException("Invalid file format", ex);
        }
    }

    public ProjectReaderProxy getProjectReaderProxy(InputStream inputStream) throws MPXJException {
        try {
            BufferedInputStream bis = new BufferedInputStream(inputStream);
            InputStreamHelper.skip(bis, this.m_skipBytes);
            bis.mark(512);
            byte[] buffer = new byte[512];
            int bytesRead = bis.read(buffer);
            bis.reset();
            if (bytesRead != 512) {
                return null;
            }
            if (this.matchesFingerprint(buffer, UTF8_BOM_FINGERPRINT)) {
                return this.handleByteOrderMark(bis, UTF8_BOM_FINGERPRINT.length, CharsetHelper.UTF8);
            }
            if (this.matchesFingerprint(buffer, UTF16_BOM_FINGERPRINT)) {
                return this.handleByteOrderMark(bis, UTF16_BOM_FINGERPRINT.length, CharsetHelper.UTF16);
            }
            if (this.matchesFingerprint(buffer, UTF16LE_BOM_FINGERPRINT)) {
                return this.handleByteOrderMark(bis, UTF16LE_BOM_FINGERPRINT.length, CharsetHelper.UTF16LE);
            }
            if (this.matchesFingerprint(buffer, BINARY_PLIST)) {
                return this.handleBinaryPropertyList(bis);
            }
            if (this.matchesFingerprint(buffer, OLE_COMPOUND_DOC_FINGERPRINT)) {
                return this.handleOleCompoundDocument(bis);
            }
            if (this.matchesFingerprint(buffer, MSPDI_FINGERPRINT_1) || this.matchesFingerprint(buffer, MSPDI_FINGERPRINT_2) || this.matchesFingerprint(buffer, MSPDI_FINGERPRINT_3)) {
                return new StreamReaderProxy(this.configure(new MSPDIReader()), bis);
            }
            if (this.matchesFingerprint(buffer, PP_FINGERPRINT)) {
                return new StreamReaderProxy(this.configure(new AstaTextFileReader()), bis);
            }
            if (this.matchesFingerprint(buffer, MPX_FINGERPRINT)) {
                return new StreamReaderProxy(this.configure(new MPXReader()), bis);
            }
            if (this.matchesFingerprint(buffer, XER_FINGERPRINT)) {
                return new StreamReaderProxy(this.configure(new PrimaveraXERFileReader()), bis);
            }
            if (this.matchesFingerprint(buffer, PLANNER_FINGERPRINT)) {
                return new StreamReaderProxy(this.configure(new PlannerReader()), bis);
            }
            if (this.matchesFingerprint(buffer, PMXML_FINGERPRINT)) {
                return new StreamReaderProxy(this.configure(new PrimaveraPMFileReader()), bis);
            }
            if (this.matchesFingerprint(buffer, MDB_FINGERPRINT)) {
                return this.handleMDBFile(bis);
            }
            if (this.matchesFingerprint(buffer, SQLITE_FINGERPRINT)) {
                return this.handleSQLiteFile(bis);
            }
            if (this.matchesFingerprint(buffer, ZIP_FINGERPRINT)) {
                return this.handleZipFile(bis);
            }
            if (this.matchesFingerprint(buffer, PHOENIX_FINGERPRINT)) {
                return new StreamReaderProxy(this.configure(new PhoenixReader()), new PhoenixInputStream(bis));
            }
            if (this.matchesFingerprint(buffer, PHOENIX_XML_FINGERPRINT1) || this.matchesFingerprint(buffer, PHOENIX_XML_FINGERPRINT2)) {
                return new StreamReaderProxy(this.configure(new PhoenixReader()), bis);
            }
            if (this.matchesFingerprint(buffer, FASTTRACK_FINGERPRINT)) {
                return new StreamReaderProxy(this.configure(new FastTrackReader()), bis);
            }
            if (this.matchesFingerprint(buffer, PROJECTLIBRE_FINGERPRINT)) {
                return new StreamReaderProxy(this.configure(new ProjectLibreReader()), bis);
            }
            if (this.matchesFingerprint(buffer, GANTTPROJECT_FINGERPRINT)) {
                return new StreamReaderProxy(this.configure(new GanttProjectReader()), bis);
            }
            if (this.matchesFingerprint(buffer, TURBOPROJECT_FINGERPRINT)) {
                return new StreamReaderProxy(this.configure(new TurboProjectReader()), bis);
            }
            if (this.matchesFingerprint(buffer, DOS_EXE_FINGERPRINT)) {
                return this.handleDosExeFile(bis);
            }
            if (this.matchesFingerprint(buffer, CONCEPT_DRAW_FINGERPRINT)) {
                return new StreamReaderProxy(this.configure(new ConceptDrawProjectReader()), bis);
            }
            if (this.matchesFingerprint(buffer, SYNCHRO_FINGERPRINT)) {
                return new StreamReaderProxy(this.configure(new SynchroReader()), bis);
            }
            if (this.matchesFingerprint(buffer, GANTT_DESIGNER_FINGERPRINT)) {
                return new StreamReaderProxy(this.configure(new GanttDesignerReader()), bis);
            }
            if (this.matchesFingerprint(buffer, SDEF_FINGERPRINT)) {
                return new StreamReaderProxy(this.configure(new SDEFReader()), bis);
            }
            if (this.matchesFingerprint(buffer, SCHEDULE_GRID_FINGERPRINT)) {
                return new StreamReaderProxy(this.configure(new SageReader()), bis);
            }
            if (this.matchesFingerprint(buffer, PROJECT_COMMANDER_FINGERPRINT_1) || this.matchesFingerprint(buffer, PROJECT_COMMANDER_FINGERPRINT_2)) {
                return new StreamReaderProxy(this.configure(new ProjectCommanderReader()), bis);
            }
            if (this.matchesFingerprint(buffer, EDRAW_PROJECT_FINGERPRINT)) {
                return new StreamReaderProxy(this.configure(new EdrawProjectReader()), bis);
            }
            return null;
        }
        catch (Exception ex) {
            throw new MPXJException("Invalid file format", ex);
        }
    }

    private boolean matchesFingerprint(byte[] buffer, byte[] fingerprint) {
        return Arrays.equals(fingerprint, Arrays.copyOf(buffer, fingerprint.length));
    }

    private boolean matchesFingerprint(byte[] buffer, Pattern fingerprint) {
        return fingerprint.matcher(this.m_charset == null ? new String(buffer) : new String(buffer, this.m_charset)).matches();
    }

    private ProjectReaderProxy handleOleCompoundDocument(InputStream stream) throws Exception {
        POIFSFileSystem fs;
        try {
            File file = InputStreamHelper.writeStreamToTempFile(stream, ".dat");
            this.m_cleanup.push(() -> FileHelper.deleteQuietly(file));
            fs = new POIFSFileSystem(file);
            this.m_cleanup.push(() -> AutoCloseableHelper.closeQuietly((AutoCloseable)fs));
        }
        catch (Exception ex) {
            return null;
        }
        if (fs.getRoot().getEntryNames().contains("SourceInfo")) {
            return new GenericReaderProxy<OpenPlanReader, POIFSFileSystem>(this.configure(new OpenPlanReader()), fs){

                @Override
                public ProjectFile read() throws MPXJException {
                    return ((OpenPlanReader)this.m_reader).read((POIFSFileSystem)this.m_source);
                }

                @Override
                public List<ProjectFile> readAll() throws MPXJException {
                    return Collections.singletonList(((OpenPlanReader)this.m_reader).read((POIFSFileSystem)this.m_source));
                }
            };
        }
        String fileFormat = MPPReader.getFileFormat(fs);
        if (fileFormat == null || !fileFormat.startsWith("MSProject")) {
            return null;
        }
        return new GenericReaderProxy<MPPReader, POIFSFileSystem>(this.configure(new MPPReader()), fs){

            @Override
            public ProjectFile read() throws MPXJException {
                return ((MPPReader)this.m_reader).read((POIFSFileSystem)this.m_source);
            }

            @Override
            public List<ProjectFile> readAll() throws MPXJException {
                return Collections.singletonList(((MPPReader)this.m_reader).read((POIFSFileSystem)this.m_source));
            }
        };
    }

    private ProjectReaderProxy handleBinaryPropertyList(InputStream stream) {
        return null;
    }

    private ProjectReaderProxy handleMDBFile(InputStream stream) throws Exception {
        File file = InputStreamHelper.writeStreamToTempFile(stream, ".mdb");
        this.m_cleanup.push(() -> FileHelper.deleteQuietly(file));
        Set<String> tableNames = this.populateMdbTableNames(file);
        if (tableNames.contains("MSP_PROJECTS")) {
            return new FileReaderProxy(this.configure(new MPDFileReader()), file);
        }
        if (tableNames.contains("EXCEPTIONN")) {
            return new FileReaderProxy(this.configure(new AstaMdbReader()), file);
        }
        return null;
    }

    private ProjectReaderProxy handleSQLiteFile(InputStream stream) throws Exception {
        File file = InputStreamHelper.writeStreamToTempFile(stream, ".sqlite");
        this.m_cleanup.push(() -> FileHelper.deleteQuietly(file));
        Set<String> tableNames = this.populateSqliteTableNames(file);
        if (tableNames.contains("EXCEPTIONN")) {
            return new FileReaderProxy(this.configure(new AstaSqliteReader()), file);
        }
        if (tableNames.contains("PROJWBS")) {
            return new FileReaderProxy(this.configure(new PrimaveraDatabaseFileReader()), file);
        }
        if (tableNames.contains("ZSCHEDULEITEM")) {
            return new FileReaderProxy(this.configure(new MerlinReader()), file);
        }
        return null;
    }

    private ProjectReaderProxy handleZipFile(InputStream stream) throws Exception {
        File dir = InputStreamHelper.writeZipStreamToTempDir(stream);
        this.m_cleanup.push(() -> FileHelper.deleteQuietly(dir));
        return this.handleDirectory(dir);
    }

    private ProjectReaderProxy handleFile(File file) throws Exception {
        FileInputStream fis = new FileInputStream(file);
        this.m_cleanup.push(() -> AutoCloseableHelper.closeQuietly(fis));
        return this.getProjectReaderProxy(fis);
    }

    private ProjectReaderProxy handleDirectory(File directory) throws Exception {
        ProjectReaderProxy result = this.handleDatabaseInDirectory(directory);
        if (result != null) {
            return result;
        }
        return this.handleFileInDirectory(directory);
    }

    private ProjectReaderProxy handleDatabaseInDirectory(File directory) throws Exception {
        byte[] buffer = new byte[512];
        File[] files = directory.listFiles();
        if (files != null) {
            for (File file : files) {
                if (file.isDirectory()) continue;
                FileInputStream fis = new FileInputStream(file);
                int bytesRead = fis.read(buffer);
                fis.close();
                if (bytesRead != 512) continue;
                if (this.matchesFingerprint(buffer, BTRIEVE_FINGERPRINT)) {
                    return this.handleP3BtrieveDatabase(directory);
                }
                if (!this.matchesFingerprint(buffer, STW_FINGERPRINT)) continue;
                return this.handleSureTrakDatabase(directory);
            }
        }
        return null;
    }

    private ProjectReaderProxy handleFileInDirectory(File directory) throws Exception {
        ArrayList<File> directories = new ArrayList<File>();
        File[] files = directory.listFiles();
        if (files != null) {
            for (File file : files) {
                if (file.isDirectory()) {
                    directories.add(file);
                    continue;
                }
                UniversalProjectReader reader = new UniversalProjectReader();
                this.m_cleanup.push(reader::cleanup);
                reader.m_properties = this.m_properties;
                ProjectReaderProxy result = reader.getProjectReaderProxy(file);
                if (result == null) continue;
                return result;
            }
            for (File file : directories) {
                ProjectReaderProxy result = this.handleDirectory(file);
                if (result == null) continue;
                return result;
            }
        }
        return null;
    }

    private ProjectReaderProxy handleP3BtrieveDatabase(final File directory) {
        return new GenericReaderProxy<P3DatabaseReader, File>(this.configure(new P3DatabaseReader()), directory){

            @Override
            public ProjectFile read() throws MPXJException {
                List<String> projects = P3DatabaseReader.listProjectNames(directory);
                if (projects.isEmpty()) {
                    return null;
                }
                ((P3DatabaseReader)this.m_reader).setProjectName(projects.get(0));
                return ((P3DatabaseReader)this.m_reader).read((File)this.m_source);
            }

            @Override
            public List<ProjectFile> readAll() throws MPXJException {
                return ((P3DatabaseReader)this.m_reader).readAll((File)this.m_source);
            }
        };
    }

    private ProjectReaderProxy handleSureTrakDatabase(final File directory) {
        return new GenericReaderProxy<SureTrakDatabaseReader, File>(this.configure(new SureTrakDatabaseReader()), directory){

            @Override
            public ProjectFile read() throws MPXJException {
                List<String> projects = SureTrakDatabaseReader.listProjectNames(directory);
                if (projects.isEmpty()) {
                    return null;
                }
                ((SureTrakDatabaseReader)this.m_reader).setProjectName(projects.get(0));
                return ((SureTrakDatabaseReader)this.m_reader).read((File)this.m_source);
            }

            @Override
            public List<ProjectFile> readAll() throws MPXJException {
                return ((SureTrakDatabaseReader)this.m_reader).readAll((File)this.m_source);
            }
        };
    }

    private ProjectReaderProxy handleByteOrderMark(InputStream stream, int length, Charset charset) throws Exception {
        UniversalProjectReader reader = new UniversalProjectReader();
        this.m_cleanup.push(reader::cleanup);
        reader.m_properties = this.m_properties;
        reader.m_skipBytes = length;
        reader.m_charset = charset;
        return reader.getProjectReaderProxy(stream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ProjectReaderProxy handleDosExeFile(InputStream stream) throws Exception {
        InputStream is;
        block4: {
            byte[] data;
            File file;
            block5: {
                FileReaderProxy fileReaderProxy;
                file = InputStreamHelper.writeStreamToTempFile(stream, ".tmp");
                this.m_cleanup.push(() -> FileHelper.deleteQuietly(file));
                is = null;
                try {
                    is = Files.newInputStream(file.toPath(), new OpenOption[0]);
                    if (is.available() <= 1350) break block4;
                    InputStreamHelper.skip(is, 1024L);
                    data = InputStreamHelper.read(is, 2);
                    if (!this.matchesFingerprint(data, WINDOWS_NE_EXE_FINGERPRINT)) break block5;
                    InputStreamHelper.skip(is, 286L);
                    data = InputStreamHelper.read(is, 34);
                    if (!this.matchesFingerprint(data, PRX_FINGERPRINT)) break block5;
                    is.close();
                    is = null;
                    fileReaderProxy = new FileReaderProxy(this.configure(new P3PRXFileReader()), file);
                }
                catch (Throwable throwable) {
                    AutoCloseableHelper.closeQuietly(is);
                    throw throwable;
                }
                AutoCloseableHelper.closeQuietly(is);
                return fileReaderProxy;
            }
            if (!this.matchesFingerprint(data, STX_FINGERPRINT)) break block4;
            InputStreamHelper.skip(is, 31742L);
            data = InputStreamHelper.read(is, 4);
            if (!this.matchesFingerprint(data, PRX3_FINGERPRINT)) break block4;
            is.close();
            is = null;
            FileReaderProxy fileReaderProxy = new FileReaderProxy(this.configure(new SureTrakSTXFileReader()), file);
            AutoCloseableHelper.closeQuietly(is);
            return fileReaderProxy;
        }
        ProjectReaderProxy projectReaderProxy = null;
        AutoCloseableHelper.closeQuietly(is);
        return projectReaderProxy;
    }

    private Set<String> populateMdbTableNames(File file) throws Exception {
        try (Database database = DatabaseBuilder.open((File)file);){
            Set set = database.getTableNames();
            return set;
        }
    }

    private Set<String> populateSqliteTableNames(File file) throws Exception {
        try (Connection connection = SQLite.createConnection(file);){
            Set<String> set = ConnectionHelper.getTableNames(connection);
            return set;
        }
    }

    private <T extends ProjectReader> T configure(T reader) {
        if (reader instanceof HasCharset && this.m_charset != null) {
            ((HasCharset)((Object)reader)).setCharset(this.m_charset);
        }
        this.addListenersToReader(reader);
        return reader;
    }

    private void cleanup() {
        while (!this.m_cleanup.isEmpty()) {
            this.m_cleanup.pop().run();
        }
    }

    private static abstract class GenericReaderProxy<R extends ProjectReader, T>
    implements ProjectReaderProxy {
        protected final R m_reader;
        protected final T m_source;
        final /* synthetic */ UniversalProjectReader this$0;

        public GenericReaderProxy(R reader, T source) {
            this.this$0 = var1_1;
            this.m_reader = reader;
            this.m_source = source;
        }

        public R getProjectReader() {
            return this.m_reader;
        }

        @Override
        public void close() {
            this.this$0.cleanup();
        }
    }

    private class FileReaderProxy
    implements ProjectReaderProxy {
        private final ProjectReader m_reader;
        private final File m_file;

        public FileReaderProxy(ProjectReader reader, File file) {
            this.m_reader = reader;
            this.m_file = file;
        }

        @Override
        public ProjectReader getProjectReader() {
            return this.m_reader;
        }

        @Override
        public ProjectFile read() throws MPXJException {
            return this.m_reader.read(this.m_file);
        }

        @Override
        public List<ProjectFile> readAll() throws MPXJException {
            return this.m_reader.readAll(this.m_file);
        }

        @Override
        public void close() {
            UniversalProjectReader.this.cleanup();
        }
    }

    private class StreamReaderProxy
    implements ProjectReaderProxy {
        private final ProjectReader m_reader;
        private final InputStream m_stream;

        public StreamReaderProxy(ProjectReader reader, InputStream stream) {
            this.m_reader = reader;
            this.m_stream = stream;
        }

        @Override
        public ProjectReader getProjectReader() {
            return this.m_reader;
        }

        @Override
        public ProjectFile read() throws MPXJException {
            return this.m_reader.read(this.m_stream);
        }

        @Override
        public List<ProjectFile> readAll() throws MPXJException {
            return this.m_reader.readAll(this.m_stream);
        }

        @Override
        public void close() {
            UniversalProjectReader.this.cleanup();
        }
    }

    public static interface ProjectReaderProxy
    extends AutoCloseable {
        public ProjectReader getProjectReader();

        public ProjectFile read() throws MPXJException;

        public List<ProjectFile> readAll() throws MPXJException;
    }
}

