/*
 * Decompiled with CFR 0.152.
 */
package org.mpxj.sample;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.stream.Collectors;
import org.mpxj.Availability;
import org.mpxj.CustomField;
import org.mpxj.CustomFieldContainer;
import org.mpxj.Duration;
import org.mpxj.ProjectCalendar;
import org.mpxj.ProjectFile;
import org.mpxj.ProjectProperties;
import org.mpxj.Relation;
import org.mpxj.RelationType;
import org.mpxj.Resource;
import org.mpxj.ResourceAssignment;
import org.mpxj.Task;
import org.mpxj.TaskField;
import org.mpxj.TimeUnit;
import org.mpxj.common.LocalDateTimeHelper;
import org.mpxj.common.NumberHelper;
import org.mpxj.writer.FileFormat;
import org.mpxj.writer.UniversalProjectWriter;

public class MpxjCreate {
    public static void main(String[] args) {
        try {
            if (args.length != 2) {
                System.out.println("Usage: MpxCreate <output file format> <output file name>");
                System.out.println("(valid output file format values: " + Arrays.stream(FileFormat.values()).map(Enum::name).collect(Collectors.joining(", ")) + ")");
            } else {
                MpxjCreate.create(FileFormat.valueOf(args[0]), args[1]);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace(System.out);
        }
    }

    private static void create(FileFormat format, String filename) throws Exception {
        ProjectFile file = new ProjectFile();
        ProjectCalendar calendar = file.addDefaultBaseCalendar();
        file.setDefaultCalendar(calendar);
        calendar.addCalendarException(LocalDate.of(2006, 3, 13));
        ProjectProperties properties = file.getProjectProperties();
        properties.setStartDate(LocalDateTime.of(2003, 1, 1, 0, 0));
        properties.setProjectTitle("Created by MPXJ");
        properties.setAuthor("Jon Iles");
        CustomFieldContainer customFields = file.getCustomFields();
        CustomField field = customFields.add(TaskField.TEXT1);
        field.setAlias("My Custom Field");
        Resource resource1 = file.addResource();
        resource1.setName("Resource1");
        Resource resource2 = file.addResource();
        resource2.setName("Resource2");
        resource2.getAvailability().add(new Availability(LocalDateTimeHelper.START_DATE_NA, LocalDateTimeHelper.END_DATE_NA, 50.0));
        Task task1 = file.addTask();
        task1.setName("Summary Task");
        Task task2 = task1.addTask();
        task2.setName("First Sub Task");
        task2.setDuration(Duration.getInstance(10.5, TimeUnit.DAYS));
        task2.setStart(LocalDateTime.of(2003, 1, 1, 0, 0));
        task2.setText(1, "My Custom Value 1");
        task2.setPercentageComplete(NumberHelper.getDouble(50.0));
        task2.setActualStart(LocalDateTime.of(2003, 1, 1, 0, 0));
        Task task3 = task1.addTask();
        task3.setName("Second Sub Task");
        task3.setStart(LocalDateTime.of(2003, 1, 11, 0, 0));
        task3.setDuration(Duration.getInstance(10, TimeUnit.DAYS));
        task3.setText(1, "My Custom Value 2");
        task3.addPredecessor(new Relation.Builder().predecessorTask(task2).type(RelationType.FINISH_START));
        Task milestone1 = task1.addTask();
        milestone1.setName("Milestone");
        milestone1.setStart(LocalDateTime.of(2003, 1, 21, 0, 0));
        milestone1.setDuration(Duration.getInstance(0, TimeUnit.DAYS));
        milestone1.addPredecessor(new Relation.Builder().predecessorTask(task3).type(RelationType.FINISH_START));
        Task task4 = file.addTask();
        task4.setName("Next Task");
        task4.setDuration(Duration.getInstance(8, TimeUnit.DAYS));
        task4.setStart(LocalDateTime.of(2003, 1, 1, 0, 0));
        task4.setPercentageComplete(NumberHelper.getDouble(70.0));
        task4.setActualStart(LocalDateTime.of(2003, 1, 1, 0, 0));
        ResourceAssignment assignment1 = task2.addResourceAssignment(resource1);
        ResourceAssignment assignment2 = task3.addResourceAssignment(resource2);
        assignment1.setWork(Duration.getInstance(80, TimeUnit.HOURS));
        assignment1.setActualWork(Duration.getInstance(40, TimeUnit.HOURS));
        assignment1.setRemainingWork(Duration.getInstance(40, TimeUnit.HOURS));
        assignment2.setRemainingWork(Duration.getInstance(80, TimeUnit.HOURS));
        assignment1.setStart(LocalDateTime.of(2003, 1, 1, 0, 0));
        assignment2.setStart(LocalDateTime.of(2003, 1, 11, 0, 0));
        Task task5 = file.addTask();
        task5.setName("Last Task");
        task5.setDuration(Duration.getInstance(3, TimeUnit.DAYS));
        task5.setStart(LocalDateTime.of(2003, 1, 1, 0, 0));
        task5.setPercentageComplete(NumberHelper.getDouble(100.0));
        task5.setActualStart(LocalDateTime.of(2003, 1, 1, 0, 0));
        Task task6 = file.addTask();
        task6.setName("Last Milestone");
        task6.setDuration(Duration.getInstance(0, TimeUnit.DAYS));
        task6.setStart(LocalDateTime.of(2003, 1, 1, 0, 0));
        task6.setPercentageComplete(NumberHelper.getDouble(100.0));
        task6.setActualStart(LocalDateTime.of(2003, 1, 1, 0, 0));
        new UniversalProjectWriter(format).write(file, filename);
    }
}

