/*
 * Decompiled with CFR 0.152.
 */
package org.mpxj.sample;

import java.time.LocalDateTime;
import java.util.Arrays;
import org.mpxj.Duration;
import org.mpxj.ProjectCalendar;
import org.mpxj.ProjectFile;
import org.mpxj.ProjectProperties;
import org.mpxj.Resource;
import org.mpxj.ResourceAssignment;
import org.mpxj.Task;
import org.mpxj.TimeUnit;
import org.mpxj.TimephasedWork;
import org.mpxj.mspdi.MSPDIWriter;

public class MpxjCreateTimephased {
    public static void main(String[] args) {
        try {
            if (args.length != 1) {
                System.out.println("Usage: MpxjCreateTimephased <output file name>");
            } else {
                MpxjCreateTimephased.create(args[0]);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace(System.out);
        }
    }

    private static void create(String filename) throws Exception {
        ProjectFile file = new ProjectFile();
        ProjectCalendar calendar = file.addDefaultBaseCalendar();
        file.setDefaultCalendar(calendar);
        ProjectProperties properties = file.getProjectProperties();
        properties.setStartDate(LocalDateTime.of(2003, 1, 1, 3, 0));
        Resource resource1 = file.addResource();
        resource1.setName("Timephased Resource");
        Task task1 = file.addTask();
        task1.setName("Timephased Task");
        task1.setDuration(Duration.getInstance(3, TimeUnit.DAYS));
        task1.setStart(LocalDateTime.of(2003, 1, 1, 3, 0));
        task1.setFinish(LocalDateTime.of(2003, 1, 3, 10, 0));
        ResourceAssignment assignment3 = task1.addResourceAssignment(resource1);
        TimephasedWork day1 = new TimephasedWork();
        day1.setAmountPerDay(Duration.getInstance(20, TimeUnit.HOURS));
        day1.setStart(LocalDateTime.of(2003, 1, 1, 3, 0));
        day1.setFinish(LocalDateTime.of(2003, 1, 1, 23, 0));
        day1.setModified(true);
        day1.setTotalAmount(Duration.getInstance(20, TimeUnit.HOURS));
        TimephasedWork day2 = new TimephasedWork();
        day2.setAmountPerDay(Duration.getInstance(2, TimeUnit.HOURS));
        day2.setStart(LocalDateTime.of(2003, 1, 2, 8, 0));
        day2.setFinish(LocalDateTime.of(2003, 1, 1, 10, 0));
        day2.setModified(true);
        day2.setTotalAmount(Duration.getInstance(2, TimeUnit.HOURS));
        TimephasedWork day3 = new TimephasedWork();
        day3.setAmountPerDay(Duration.getInstance(2, TimeUnit.HOURS));
        day3.setStart(LocalDateTime.of(2003, 1, 3, 8, 0));
        day3.setFinish(LocalDateTime.of(2003, 1, 1, 10, 0));
        day3.setModified(true);
        day3.setTotalAmount(Duration.getInstance(2, TimeUnit.HOURS));
        assignment3.setTimephasedWork(Arrays.asList(day1, day2, day3));
        MSPDIWriter writer = new MSPDIWriter();
        writer.setWriteTimephasedData(true);
        writer.setSplitTimephasedAsDays(false);
        writer.write(file, filename);
    }
}

