/*
 * Decompiled with CFR 0.152.
 */
package org.mpxj.sdef;

import java.time.LocalDateTime;
import org.mpxj.ConstraintType;
import org.mpxj.Duration;
import org.mpxj.ProjectFile;
import org.mpxj.RelationType;
import org.mpxj.sdef.SDEFField;
import org.mpxj.sdef.SDEFRecord;

abstract class AbstractSDEFRecord
implements SDEFRecord {
    private final Object[] m_fields = new Object[this.getFieldDefinitions().length];

    AbstractSDEFRecord() {
    }

    @Override
    public void read(ProjectFile file, String line, boolean ignoreErrors) {
        int index = 0;
        int offset = 5;
        for (SDEFField field : this.getFieldDefinitions()) {
            Object value;
            try {
                value = field.read(line, offset);
            }
            catch (Exception ex) {
                if (ignoreErrors) {
                    file.addIgnoredError(ex);
                    value = null;
                }
                throw ex;
            }
            this.m_fields[index++] = value;
            offset += field.getLength() + 1;
        }
    }

    protected abstract SDEFField[] getFieldDefinitions();

    protected String getString(int index) {
        return (String)this.m_fields[index];
    }

    protected Integer getInteger(int index) {
        return (Integer)this.m_fields[index];
    }

    protected Double getDouble(int index) {
        return (Double)this.m_fields[index];
    }

    protected LocalDateTime getDate(int index) {
        return (LocalDateTime)this.m_fields[index];
    }

    protected Duration getDuration(int index) {
        return (Duration)this.m_fields[index];
    }

    protected ConstraintType getConstraintType(int index) {
        return (ConstraintType)this.m_fields[index];
    }

    protected RelationType getRelationType(int index) {
        return (RelationType)this.m_fields[index];
    }
}

