/*
 * Decompiled with CFR 0.152.
 */
package org.mpxj.sdef;

import java.time.DayOfWeek;
import org.mpxj.ProjectCalendar;
import org.mpxj.ProjectCalendarDays;
import org.mpxj.ProjectCalendarHours;
import org.mpxj.common.DayOfWeekHelper;
import org.mpxj.sdef.AbstractSDEFRecord;
import org.mpxj.sdef.Context;
import org.mpxj.sdef.SDEFField;
import org.mpxj.sdef.StringField;

class CalendarRecord
extends AbstractSDEFRecord {
    private static final SDEFField[] FIELDS = new SDEFField[]{new StringField("Calendar Code", 1), new StringField("Workdays", 7), new StringField("Calendar Description", 30)};

    CalendarRecord() {
    }

    @Override
    protected SDEFField[] getFieldDefinitions() {
        return FIELDS;
    }

    @Override
    public void process(Context context) {
        ProjectCalendar calendar = context.addCalendar(this.getString(0));
        calendar.setName(this.getString(2));
        String flags = this.getString(1);
        for (DayOfWeek day : DayOfWeekHelper.ORDERED_DAYS) {
            boolean workingDay = flags.charAt(DayOfWeekHelper.getValue(day) - 1) == 'Y';
            calendar.setWorkingDay(day, workingDay);
            ProjectCalendarHours hours = calendar.addCalendarHours(day);
            if (!workingDay) continue;
            hours.add(ProjectCalendarDays.DEFAULT_WORKING_MORNING);
            hours.add(ProjectCalendarDays.DEFAULT_WORKING_AFTERNOON);
        }
        context.getEventManager().fireCalendarReadEvent(calendar);
    }
}

