/*
 * Decompiled with CFR 0.152.
 */
package org.mpxj.synchro;

import java.io.IOException;
import java.util.Map;
import org.mpxj.Duration;
import org.mpxj.RelationType;
import org.mpxj.synchro.StreamReader;
import org.mpxj.synchro.Synchro;
import org.mpxj.synchro.TableReader;

class PredecessorReader
extends TableReader {
    private static final RelationType[] RELATION_TYPES = new RelationType[]{null, RelationType.FINISH_START, RelationType.START_FINISH, RelationType.START_START, RelationType.FINISH_FINISH};

    public PredecessorReader(StreamReader stream) {
        super(stream);
    }

    @Override
    protected void readRow(StreamReader stream, Map<String, Object> map) throws IOException {
        map.put("PREDECESSOR_UUID", stream.readUUID());
        map.put("RELATION_TYPE", this.getRelationType(stream.readInt()));
        if (stream.getVersion().atLeast(Synchro.VERSION_6_2_0)) {
            map.put("LAG", stream.readDurationFromLong());
            map.put("CALENDAR_UUID", stream.readUUID());
            map.put("UNKNOWN1", stream.readBytes(8));
        } else {
            boolean lagIsNegative;
            map.put("UNKNOWN1", stream.readBytes(4));
            map.put("LAG", stream.readDuration());
            map.put("UNKNOWN2", stream.readBytes(4));
            if (stream.getVersion().before(Synchro.VERSION_6_1_0)) {
                lagIsNegative = stream.readInt() == 2;
                map.put("LAG_IS_NEGATIVE", lagIsNegative);
                map.put("CALENDAR_UUID", stream.readUUID());
                map.put("UNKNOWN3", stream.readBytes(8));
            } else {
                map.put("CALENDAR_UUID", stream.readUUID());
                lagIsNegative = stream.readInt() == 2;
                map.put("LAG_IS_NEGATIVE", lagIsNegative);
            }
            if (lagIsNegative) {
                map.put("LAG", ((Duration)map.get("LAG")).negate());
            }
        }
    }

    @Override
    protected int rowMagicNumber() {
        return 82306001;
    }

    private RelationType getRelationType(int type) {
        RelationType result = type > 0 && type < RELATION_TYPES.length ? RELATION_TYPES[type] : RelationType.FINISH_START;
        return result;
    }
}

