/*
 * Decompiled with CFR 0.152.
 */
package org.mpxj.synchro;

import java.io.IOException;
import java.util.Map;
import org.mpxj.synchro.CommentaryReader;
import org.mpxj.synchro.ResourceCostContainerReader;
import org.mpxj.synchro.StreamReader;
import org.mpxj.synchro.TableReader;
import org.mpxj.synchro.UserFieldReader;

class ResourceReader
extends TableReader {
    public ResourceReader(StreamReader stream) {
        super(stream);
    }

    @Override
    protected void readRow(StreamReader stream, Map<String, Object> map) throws IOException {
        map.put("NAME", stream.readString());
        map.put("DESCRIPTION", stream.readString());
        Integer supplyReferenceFlag = stream.readInteger();
        map.put("SUPPLY_REFERENCE_FLAG", supplyReferenceFlag);
        if (supplyReferenceFlag != 0) {
            map.put("SUPPLY_REFERENCE", stream.readString());
        }
        map.put("UNKNOWN1A", stream.readBytes(32));
        int unknown1Count = stream.readInt();
        map.put("UNKNOWN1B", stream.readBytes(unknown1Count * 20));
        map.put("UNKNOWN1C", stream.readBytes(12));
        map.put("RESOURCES", stream.readTable(ResourceReader.class));
        map.put("UNKNOWN2", stream.readBytes(20));
        map.put("URL", stream.readString());
        map.put("USER_FIELDS", stream.readTableConditional(UserFieldReader.class));
        map.put("ID", stream.readString());
        map.put("EMAIL", stream.readString());
        map.put("COST_CONTAINER", stream.readTable(ResourceCostContainerReader.class));
        map.put("UNKNOWN4", stream.readBytes(30));
        map.put("COMMENTARY", stream.readTableConditional(CommentaryReader.class));
        this.skipToRowEnd(4);
        map.put("UNIQUE_ID", stream.readInteger());
    }

    @Override
    protected int rowMagicNumber() {
        return 1470651441;
    }
}

