/*
 * Decompiled with CFR 0.152.
 */
package org.mpxj.synchro;

import java.io.IOException;
import java.io.InputStream;
import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.mpxj.ChildResourceContainer;
import org.mpxj.ChildTaskContainer;
import org.mpxj.ConstraintType;
import org.mpxj.EventManager;
import org.mpxj.LocalTimeRange;
import org.mpxj.MPXJException;
import org.mpxj.ProjectCalendar;
import org.mpxj.ProjectCalendarHours;
import org.mpxj.ProjectFile;
import org.mpxj.Relation;
import org.mpxj.Resource;
import org.mpxj.ResourceAssignment;
import org.mpxj.Task;
import org.mpxj.common.LocalDateHelper;
import org.mpxj.common.LocalDateTimeHelper;
import org.mpxj.reader.AbstractProjectStreamReader;
import org.mpxj.synchro.CalendarReader;
import org.mpxj.synchro.CompanyReader;
import org.mpxj.synchro.MapRow;
import org.mpxj.synchro.ResourceReader;
import org.mpxj.synchro.Synchro;
import org.mpxj.synchro.SynchroData;
import org.mpxj.synchro.SynchroLogger;
import org.mpxj.synchro.TaskReader;

public final class SynchroReader
extends AbstractProjectStreamReader {
    private SynchroData m_data;
    private ProjectFile m_project;
    private EventManager m_eventManager;
    private Map<UUID, ProjectCalendar> m_calendarMap;
    private Map<UUID, Task> m_taskMap;
    private Map<Task, List<MapRow>> m_predecessorMap;
    private Map<UUID, Resource> m_resourceMap;

    @Override
    public ProjectFile read(InputStream inputStream) throws MPXJException {
        try {
            SynchroLogger.openLogFile();
            this.m_calendarMap = new HashMap<UUID, ProjectCalendar>();
            this.m_taskMap = new HashMap<UUID, Task>();
            this.m_predecessorMap = new LinkedHashMap<Task, List<MapRow>>();
            this.m_resourceMap = new HashMap<UUID, Resource>();
            this.m_data = new SynchroData();
            this.m_data.process(inputStream);
            ProjectFile projectFile = this.read();
            return projectFile;
        }
        catch (Exception ex) {
            throw new MPXJException("Invalid file format", ex);
        }
        finally {
            SynchroLogger.closeLogFile();
            this.m_data = null;
            this.m_calendarMap = null;
            this.m_taskMap = null;
            this.m_predecessorMap = null;
            this.m_resourceMap = null;
        }
    }

    private ProjectFile read() throws Exception {
        this.m_project = new ProjectFile();
        this.m_eventManager = this.m_project.getEventManager();
        this.m_project.getProjectProperties().setFileApplication("Synchro");
        this.m_project.getProjectProperties().setFileType("SP");
        this.addListenersToProject(this.m_project);
        this.processCalendars();
        this.processResources();
        this.processTasks();
        this.processPredecessors();
        this.m_project.readComplete();
        return this.m_project;
    }

    private void processCalendars() throws IOException {
        CalendarReader reader = new CalendarReader(this.m_data.getTableData("Calendars"));
        reader.read();
        for (MapRow row : reader.getRows()) {
            this.processCalendar(row);
        }
        ProjectCalendar calendar = this.m_calendarMap.get(reader.getDefaultCalendarUUID());
        if (calendar == null) {
            calendar = this.m_project.getCalendars().findOrCreateDefaultCalendar();
        }
        this.m_project.setDefaultCalendar(calendar);
    }

    private void processCalendar(MapRow row) {
        ProjectCalendar calendar = this.m_project.addCalendar();
        Map<UUID, List<LocalTimeRange>> dayTypeMap = this.processDayTypes(row.getRows("DAY_TYPES"));
        calendar.setName(row.getString("NAME"));
        this.processRanges(dayTypeMap.get(row.getUUID("SUNDAY_DAY_TYPE")), calendar.addCalendarHours(DayOfWeek.SUNDAY));
        this.processRanges(dayTypeMap.get(row.getUUID("MONDAY_DAY_TYPE")), calendar.addCalendarHours(DayOfWeek.MONDAY));
        this.processRanges(dayTypeMap.get(row.getUUID("TUESDAY_DAY_TYPE")), calendar.addCalendarHours(DayOfWeek.TUESDAY));
        this.processRanges(dayTypeMap.get(row.getUUID("WEDNESDAY_DAY_TYPE")), calendar.addCalendarHours(DayOfWeek.WEDNESDAY));
        this.processRanges(dayTypeMap.get(row.getUUID("THURSDAY_DAY_TYPE")), calendar.addCalendarHours(DayOfWeek.THURSDAY));
        this.processRanges(dayTypeMap.get(row.getUUID("FRIDAY_DAY_TYPE")), calendar.addCalendarHours(DayOfWeek.FRIDAY));
        this.processRanges(dayTypeMap.get(row.getUUID("SATURDAY_DAY_TYPE")), calendar.addCalendarHours(DayOfWeek.SATURDAY));
        for (DayOfWeek day : DayOfWeek.values()) {
            calendar.setWorkingDay(day, !calendar.getCalendarHours(day).isEmpty());
        }
        for (MapRow assignment : row.getRows("DAY_TYPE_ASSIGNMENTS")) {
            LocalDate date = LocalDateHelper.getLocalDate(assignment.getDate("DATE"));
            this.processRanges(dayTypeMap.get(assignment.getUUID("DAY_TYPE_UUID")), calendar.addCalendarException(date));
        }
        this.m_calendarMap.put(row.getUUID("UUID"), calendar);
        this.m_eventManager.fireCalendarReadEvent(calendar);
    }

    private void processRanges(List<LocalTimeRange> ranges, ProjectCalendarHours container) {
        if (ranges != null) {
            container.addAll(ranges);
        }
    }

    private Map<UUID, List<LocalTimeRange>> processDayTypes(List<MapRow> types) {
        HashMap<UUID, List<LocalTimeRange>> map = new HashMap<UUID, List<LocalTimeRange>>();
        for (MapRow row : types) {
            ArrayList<LocalTimeRange> ranges = new ArrayList<LocalTimeRange>();
            for (MapRow range : row.getRows("TIME_RANGES")) {
                ranges.add(new LocalTimeRange(range.getTime("START"), range.getTime("END")));
            }
            map.put(row.getUUID("UUID"), ranges);
        }
        return map;
    }

    private void processResources() throws IOException {
        if (this.m_data.getVersion().atLeast(Synchro.VERSION_6_2_0)) {
            this.process62Resources();
        } else {
            this.process50Resources();
        }
    }

    private void process50Resources() throws IOException {
        CompanyReader reader = new CompanyReader(this.m_data.getTableData("Companies"));
        reader.read();
        for (MapRow companyRow : reader.getRows()) {
            for (MapRow resourceRow : this.sort(companyRow.getRows("RESOURCES"), "NAME")) {
                this.processResource(this.m_project, resourceRow);
            }
        }
    }

    private void process62Resources() throws IOException {
        ResourceReader reader = new ResourceReader(this.m_data.getTableData("Resources"));
        reader.read();
        for (MapRow resourceRow : this.sort(reader.getRows(), "NAME")) {
            this.processResource(this.m_project, resourceRow);
        }
    }

    private void processResource(ChildResourceContainer parent, MapRow row) {
        Resource resource = parent.addResource();
        resource.setName(row.getString("NAME"));
        resource.setGUID(row.getUUID("UUID"));
        resource.setEmailAddress(row.getString("EMAIL"));
        resource.setHyperlink(row.getString("URL"));
        resource.setNotes(this.getNotes(row.getRows("COMMENTARY")));
        resource.setDescription(row.getString("DESCRIPTION"));
        resource.setSupplyReference(row.getString("SUPPLY_REFERENCE"));
        resource.setActive(true);
        resource.setResourceID(row.getString("ID"));
        List<MapRow> resources = row.getRows("RESOURCES");
        if (resources != null) {
            for (MapRow childResource : this.sort(resources, "NAME")) {
                this.processResource(resource, childResource);
            }
        }
        this.m_resourceMap.put(resource.getGUID(), resource);
        this.m_eventManager.fireResourceReadEvent(resource);
    }

    private void processTasks() throws IOException {
        TaskReader reader = new TaskReader(this.m_data.getTableData("Tasks"));
        reader.read();
        for (MapRow row : reader.getRows()) {
            this.processTask(this.m_project, row);
        }
        this.updateDates();
    }

    private void processTask(ChildTaskContainer parent, MapRow row) throws IOException {
        List<MapRow> resourceAssignmnets;
        Task task = parent.addTask();
        task.setName(row.getString("NAME"));
        task.setGUID(row.getUUID("UUID"));
        task.setActivityID(row.getString("ID"));
        task.setDuration(row.getDuration("PLANNED_DURATION"));
        task.setRemainingDuration(row.getDuration("REMAINING_DURATION"));
        task.setHyperlink(row.getString("URL"));
        task.setPercentageComplete(row.getDouble("PERCENT_COMPLETE"));
        task.setNotes(this.getNotes(row.getRows("COMMENTARY")));
        task.setMilestone(task.getDuration() != null && task.getDuration().getDuration() == 0.0);
        ProjectCalendar calendar = this.m_calendarMap.get(row.getUUID("CALENDAR_UUID"));
        if (calendar != this.m_project.getDefaultCalendar()) {
            task.setCalendar(calendar);
        }
        switch (row.getInteger("STATUS")) {
            case 1: {
                task.setStart(row.getDate("PLANNED_START"));
                if (task.getStart() == null || task.getDuration() == null) break;
                task.setFinish(task.getEffectiveCalendar().getDate(task.getStart(), task.getDuration()));
                break;
            }
            case 2: {
                task.setActualStart(row.getDate("ACTUAL_START"));
                task.setStart(task.getActualStart());
                task.setFinish(row.getDate("ESTIMATED_FINISH"));
                if (task.getFinish() != null) break;
                task.setFinish(row.getDate("PLANNED_FINISH"));
                break;
            }
            case 3: {
                task.setActualStart(row.getDate("ACTUAL_START"));
                task.setActualFinish(row.getDate("ACTUAL_FINISH"));
                task.setPercentageComplete(100.0);
                task.setStart(task.getActualStart());
                task.setFinish(task.getActualFinish());
            }
        }
        this.setConstraints(task, row);
        this.processChildTasks(task, row);
        this.m_taskMap.put(task.getGUID(), task);
        this.m_eventManager.fireTaskReadEvent(task);
        List<MapRow> predecessors = row.getRows("PREDECESSORS");
        if (predecessors != null && !predecessors.isEmpty()) {
            this.m_predecessorMap.put(task, predecessors);
        }
        if ((resourceAssignmnets = row.getRows("RESOURCE_ASSIGNMENTS")) != null && !resourceAssignmnets.isEmpty()) {
            this.processResourceAssignments(task, resourceAssignmnets);
        }
    }

    private void processChildTasks(Task task, MapRow row) throws IOException {
        List<MapRow> tasks = row.getRows("TASKS");
        if (tasks != null) {
            for (MapRow childTask : tasks) {
                this.processTask(task, childTask);
            }
        }
    }

    private void processPredecessors() {
        for (Map.Entry<Task, List<MapRow>> entry : this.m_predecessorMap.entrySet()) {
            Task task = entry.getKey();
            List<MapRow> predecessors = entry.getValue();
            for (MapRow predecessor : predecessors) {
                this.processPredecessor(task, predecessor);
            }
        }
    }

    private void processPredecessor(Task task, MapRow row) {
        Task predecessor = this.m_taskMap.get(row.getUUID("PREDECESSOR_UUID"));
        if (predecessor != null) {
            Relation relation = task.addPredecessor(new Relation.Builder().predecessorTask(predecessor).type(row.getRelationType("RELATION_TYPE")).lag(row.getDuration("LAG")));
            this.m_eventManager.fireRelationReadEvent(relation);
        }
    }

    private void processResourceAssignments(Task task, List<MapRow> assignments) {
        for (MapRow row : assignments) {
            this.processResourceAssignment(task, row);
        }
    }

    private void processResourceAssignment(Task task, MapRow row) {
        Resource resource = this.m_resourceMap.get(row.getUUID("RESOURCE_UUID"));
        ResourceAssignment assignment = task.addResourceAssignment(resource);
        this.m_eventManager.fireAssignmentReadEvent(assignment);
    }

    private void setConstraints(Task task, MapRow row) {
        ConstraintType constraintType = null;
        LocalDateTime constraintDate = null;
        LocalDateTime lateDate = row.getDate("CONSTRAINT_LATE_DATE");
        LocalDateTime earlyDate = row.getDate("CONSTRAINT_EARLY_DATE");
        switch (row.getInteger("CONSTRAINT_TYPE")) {
            case 2: {
                constraintType = ConstraintType.MUST_START_ON;
                constraintDate = task.getStart();
                break;
            }
            case 12: {
                constraintType = ConstraintType.MUST_FINISH_ON;
                constraintDate = lateDate;
                break;
            }
            case 10: {
                constraintType = ConstraintType.FINISH_NO_EARLIER_THAN;
                constraintDate = earlyDate;
                break;
            }
            case 11: {
                constraintType = ConstraintType.FINISH_NO_LATER_THAN;
                constraintDate = lateDate;
                break;
            }
            case 5: 
            case 9: 
            case 13: {
                constraintType = ConstraintType.MUST_START_ON;
                constraintDate = earlyDate;
                break;
            }
            case 14: {
                constraintType = ConstraintType.MUST_FINISH_ON;
                constraintDate = earlyDate;
                break;
            }
            case 4: {
                constraintType = ConstraintType.AS_LATE_AS_POSSIBLE;
                break;
            }
            case 3: {
                constraintType = ConstraintType.AS_SOON_AS_POSSIBLE;
                break;
            }
            case 8: {
                constraintType = ConstraintType.AS_SOON_AS_POSSIBLE;
                constraintDate = earlyDate;
                break;
            }
            case 6: {
                constraintType = ConstraintType.START_NO_LATER_THAN;
                constraintDate = earlyDate;
                break;
            }
            case 15: {
                constraintType = ConstraintType.START_NO_EARLIER_THAN;
                constraintDate = earlyDate;
            }
        }
        task.setConstraintType(constraintType);
        task.setConstraintDate(constraintDate);
    }

    private String getNotes(List<MapRow> rows) {
        String result = null;
        if (rows != null && !rows.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            for (MapRow row : rows) {
                sb.append(row.getString("TITLE"));
                sb.append('\n');
                sb.append(row.getString("TEXT"));
                sb.append("\n\n");
            }
            result = sb.toString();
        }
        return result;
    }

    private List<MapRow> sort(List<MapRow> rows, String attribute) {
        rows.sort((o1, o2) -> {
            String value1 = o1.getString(attribute);
            String value2 = o2.getString(attribute);
            return value1.compareTo(value2);
        });
        return rows;
    }

    private void updateDates() {
        for (Task task : this.m_project.getChildTasks()) {
            this.updateDates(task);
        }
    }

    private void updateDates(Task parentTask) {
        if (parentTask.hasChildTasks()) {
            LocalDateTime plannedStartDate = null;
            LocalDateTime plannedFinishDate = null;
            for (Task task : parentTask.getChildTasks()) {
                this.updateDates(task);
                plannedStartDate = LocalDateTimeHelper.min(plannedStartDate, task.getStart());
                plannedFinishDate = LocalDateTimeHelper.max(plannedFinishDate, task.getFinish());
            }
            parentTask.setStart(plannedStartDate);
            parentTask.setFinish(plannedFinishDate);
        }
    }
}

