/*
 * Decompiled with CFR 0.152.
 */
package org.mpxj.synchro;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.mpxj.common.ByteArray;
import org.mpxj.synchro.DatatypeConverter;
import org.mpxj.synchro.MapRow;
import org.mpxj.synchro.StreamReader;
import org.mpxj.synchro.Synchro;
import org.mpxj.synchro.SynchroLogger;

abstract class TableReader {
    protected final StreamReader m_stream;
    private final List<MapRow> m_rows = new ArrayList<MapRow>();
    private static final int TABLE_HEADER = 967791738;
    private static final int TABLE_TRAILER = 1872356374;

    public TableReader(StreamReader stream) {
        this.m_stream = stream;
    }

    public List<MapRow> getRows() {
        return this.m_rows;
    }

    public TableReader read() throws IOException {
        int tableHeader = this.m_stream.readInt();
        if (tableHeader != 967791738) {
            throw new IllegalArgumentException("Unexpected file format");
        }
        int recordCount = this.m_stream.readInt();
        for (int loop = 0; loop < recordCount; ++loop) {
            int rowMagicNumber = this.m_stream.readInt();
            if (rowMagicNumber != this.rowMagicNumber()) {
                throw new IllegalArgumentException("Unexpected file format");
            }
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
            if (this.hasUUID()) {
                this.readUUID(this.m_stream, map);
            }
            this.readRow(this.m_stream, map);
            SynchroLogger.log("READER", this.getClass(), map);
            this.m_rows.add(new MapRow(map));
        }
        int tableTrailer = this.m_stream.readInt();
        if (tableTrailer != 1872356374) {
            throw new IllegalArgumentException("Unexpected file format");
        }
        this.postTrailer(this.m_stream);
        return this;
    }

    protected boolean hasUUID() {
        return true;
    }

    protected void readUUID(StreamReader stream, Map<String, Object> map) throws IOException {
        int unknown0Size = stream.getVersion().atLeast(Synchro.VERSION_6_0_0) ? 8 : 16;
        map.put("UNKNOWN0", stream.readBytes(unknown0Size));
        map.put("UUID", stream.readUUID());
    }

    protected ByteArray skipToRowEnd(int preserveBytes) throws IOException {
        InputStream is = this.m_stream.getStream();
        int available = is.available();
        is.mark(available);
        byte[] data = this.m_stream.readBytes(available).getData();
        is.reset();
        int tableDepth = 0;
        int blockSize = data.length - 4;
        for (int index = 0; index < data.length - 4; ++index) {
            int value = DatatypeConverter.getInt(data, index);
            if (value == 967791738) {
                ++tableDepth;
                continue;
            }
            if (value == 1872356374) {
                if (tableDepth == 0) {
                    blockSize = index;
                    break;
                }
                --tableDepth;
                continue;
            }
            if (value != this.rowMagicNumber()) continue;
            blockSize = index;
            break;
        }
        return this.m_stream.readBytes(blockSize - preserveBytes);
    }

    protected void postTrailer(StreamReader stream) throws IOException {
    }

    protected abstract int rowMagicNumber();

    protected abstract void readRow(StreamReader var1, Map<String, Object> var2) throws IOException;
}

