/*
 * Decompiled with CFR 0.152.
 */
package org.mpxj.turboproject;

import java.time.LocalDateTime;
import org.mpxj.common.ByteArrayHelper;

final class PEPUtility {
    private static final LocalDateTime EPOCH = LocalDateTime.of(1999, 12, 31, 0, 0);

    PEPUtility() {
    }

    public static final int getInt(byte[] data, int offset) {
        return ByteArrayHelper.getInt(data, offset);
    }

    public static final int getShort(byte[] data, int offset) {
        return ByteArrayHelper.getShort(data, offset);
    }

    public static final String getString(byte[] data, int offset) {
        return PEPUtility.getString(data, offset, data.length - offset);
    }

    public static final String getString(byte[] data, int offset, int maxLength) {
        char c;
        StringBuilder buffer = new StringBuilder();
        for (int loop = 0; loop < maxLength && (c = (char)data[offset + loop]) != '\u0000'; ++loop) {
            buffer.append(c);
        }
        return buffer.toString();
    }

    public static final LocalDateTime getStartDate(byte[] data, int offset) {
        long days = PEPUtility.getShort(data, offset);
        LocalDateTime result = days == 32768L ? null : EPOCH.plusDays(days);
        return result;
    }

    public static final LocalDateTime getFinishDate(byte[] data, int offset) {
        long days = PEPUtility.getShort(data, offset);
        LocalDateTime result = days == 32768L ? null : EPOCH.plusDays(days - 1L);
        return result;
    }
}

