/*
 * Decompiled with CFR 0.152.
 */
package org.mpxj.turboproject;

import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.mpxj.common.InputStreamHelper;
import org.mpxj.turboproject.MapRow;
import org.mpxj.turboproject.PEPUtility;

class Table
implements Iterable<MapRow> {
    private final Map<Integer, MapRow> m_rows = new TreeMap<Integer, MapRow>();

    Table() {
    }

    @Override
    public Iterator<MapRow> iterator() {
        return this.m_rows.values().iterator();
    }

    public void read(InputStream is) throws IOException {
        byte[] headerBlock = InputStreamHelper.read(is, 20);
        int headerLength = PEPUtility.getShort(headerBlock, 8);
        int recordCount = PEPUtility.getInt(headerBlock, 10);
        int recordLength = PEPUtility.getInt(headerBlock, 16);
        InputStreamHelper.skip(is, headerLength - headerBlock.length);
        byte[] record = new byte[recordLength];
        for (int recordIndex = 1; recordIndex <= recordCount; ++recordIndex) {
            this.readRow(recordIndex, InputStreamHelper.read(is, record));
        }
    }

    public MapRow find(Integer uniqueID) {
        return this.m_rows.get(uniqueID);
    }

    protected void readRow(int uniqueID, byte[] data) {
    }

    protected void addRow(int uniqueID, Map<String, Object> map) {
        this.m_rows.put(uniqueID, new MapRow(map));
    }
}

