/*
 * Decompiled with CFR 0.152.
 */
package org.mpxj.turboproject;

import java.util.HashMap;
import org.mpxj.Duration;
import org.mpxj.RelationType;
import org.mpxj.TimeUnit;
import org.mpxj.turboproject.PEPUtility;
import org.mpxj.turboproject.Table;

class TableCONTAB
extends Table {
    private static final RelationType[] RELATION_TYPES = new RelationType[]{null, RelationType.START_START, null, RelationType.FINISH_START, RelationType.FINISH_FINISH};

    TableCONTAB() {
    }

    @Override
    protected void readRow(int uniqueID, byte[] data) {
        if (data[0] != -1) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("UNIQUE_ID", uniqueID);
            map.put("TASK_ID_1", PEPUtility.getShort(data, 1));
            map.put("TASK_ID_2", PEPUtility.getShort(data, 3));
            map.put("TYPE", this.getRelationType(PEPUtility.getShort(data, 9)));
            map.put("LAG", Duration.getInstance(PEPUtility.getShort(data, 11), TimeUnit.DAYS));
            this.addRow(uniqueID, map);
        }
    }

    private RelationType getRelationType(int value) {
        RelationType result = null;
        if (value >= 0 || value < RELATION_TYPES.length) {
            result = RELATION_TYPES[value];
        }
        if (result == null) {
            result = RelationType.FINISH_START;
        }
        return result;
    }
}

