/*
 * Decompiled with CFR 0.152.
 */
package org.mpxj.utility;

import java.time.DayOfWeek;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import org.mpxj.LocalDateTimeRange;
import org.mpxj.mpp.TimescaleUnits;

public final class TimescaleUtility {
    private DayOfWeek m_weekStartDay = DayOfWeek.MONDAY;

    public final ArrayList<LocalDateTimeRange> createTimescale(LocalDateTime startDate, TimescaleUnits segmentUnit, int segmentCount) {
        int calendarIncrementAmount;
        ChronoUnit calendarIncrementUnit;
        ArrayList<LocalDateTimeRange> result = new ArrayList<LocalDateTimeRange>(segmentCount);
        LocalDateTime cal = LocalDateTime.of(startDate.toLocalDate(), LocalTime.MIDNIGHT);
        switch (segmentUnit) {
            case MINUTES: {
                calendarIncrementUnit = ChronoUnit.MINUTES;
                calendarIncrementAmount = 1;
                break;
            }
            case HOURS: {
                calendarIncrementUnit = ChronoUnit.HOURS;
                calendarIncrementAmount = 1;
                break;
            }
            case WEEKS: {
                cal = cal.plusDays(this.m_weekStartDay.getValue() - cal.getDayOfWeek().getValue());
                calendarIncrementUnit = ChronoUnit.DAYS;
                calendarIncrementAmount = 7;
                break;
            }
            case THIRDS_OF_MONTHS: {
                cal = LocalDateTime.of(cal.getYear(), cal.getMonth(), 1, 0, 0, 0);
                calendarIncrementUnit = ChronoUnit.DAYS;
                calendarIncrementAmount = 10;
                break;
            }
            case MONTHS: {
                cal = LocalDateTime.of(cal.getYear(), cal.getMonth(), 1, 0, 0, 0);
                calendarIncrementUnit = ChronoUnit.MONTHS;
                calendarIncrementAmount = 1;
                break;
            }
            case QUARTERS: {
                int currentMonth = cal.getMonthValue() - 1;
                int currentQuarter = currentMonth / 3;
                int startMonth = currentQuarter * 3 + 1;
                cal = LocalDateTime.of(cal.getYear(), startMonth, 1, 0, 0, 0);
                calendarIncrementUnit = ChronoUnit.MONTHS;
                calendarIncrementAmount = 3;
                break;
            }
            case HALF_YEARS: {
                int currentMonth = cal.getMonthValue() - 1;
                int currentHalf = currentMonth / 6;
                int startMonth = currentHalf * 6 + 1;
                cal = LocalDateTime.of(cal.getYear(), startMonth, 1, 0, 0, 0);
                calendarIncrementUnit = ChronoUnit.MONTHS;
                calendarIncrementAmount = 6;
                break;
            }
            case YEARS: {
                cal = LocalDateTime.of(cal.getYear(), 1, 1, 0, 0, 0);
                calendarIncrementUnit = ChronoUnit.YEARS;
                calendarIncrementAmount = 1;
                break;
            }
            default: {
                calendarIncrementUnit = ChronoUnit.DAYS;
                calendarIncrementAmount = 1;
            }
        }
        for (int loop = 0; loop < segmentCount; ++loop) {
            LocalDateTime rangeStart = cal;
            cal = segmentUnit == TimescaleUnits.THIRDS_OF_MONTHS && (loop + 1) % 3 == 0 ? LocalDateTime.of(cal.getYear(), cal.getMonth(), 1, 0, 0, 0).plusMonths(1L) : cal.plus(calendarIncrementAmount, calendarIncrementUnit);
            LocalDateTime rangeEnd = cal.minus(1L, ChronoUnit.MILLIS);
            result.add(new LocalDateTimeRange(rangeStart, rangeEnd));
        }
        return result;
    }

    public void setWeekStartDay(DayOfWeek weekStartDay) {
        this.m_weekStartDay = weekStartDay;
    }

    public DayOfWeek getWeekStartDay() {
        return this.m_weekStartDay;
    }
}

