/*
 * Decompiled with CFR 0.152.
 */
package org.mpxj.writer;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import org.mpxj.ProjectFile;
import org.mpxj.json.JsonWriter;
import org.mpxj.mpx.MPXWriter;
import org.mpxj.mspdi.MSPDIWriter;
import org.mpxj.planner.PlannerWriter;
import org.mpxj.primavera.PrimaveraPMFileWriter;
import org.mpxj.primavera.PrimaveraXERFileWriter;
import org.mpxj.sdef.SDEFWriter;
import org.mpxj.writer.FileFormat;
import org.mpxj.writer.ProjectWriter;

public final class UniversalProjectWriter
implements ProjectWriter {
    private final FileFormat m_format;
    private static final Map<FileFormat, Supplier<ProjectWriter>> WRITER_MAP = new HashMap<FileFormat, Supplier<ProjectWriter>>();

    public UniversalProjectWriter(FileFormat format) {
        this.m_format = format;
    }

    @Override
    public void write(ProjectFile projectFile, String fileName) throws IOException {
        this.getWriter().write(projectFile, fileName);
    }

    @Override
    public void write(ProjectFile projectFile, File file) throws IOException {
        this.getWriter().write(projectFile, file);
    }

    @Override
    public void write(ProjectFile projectFile, OutputStream outputStream) throws IOException {
        this.getWriter().write(projectFile, outputStream);
    }

    private ProjectWriter getWriter() {
        if (this.m_format == null) {
            throw new IllegalArgumentException("No file format specified");
        }
        Supplier<ProjectWriter> supplier = WRITER_MAP.get((Object)this.m_format);
        if (supplier == null) {
            throw new IllegalArgumentException("No file format found");
        }
        return supplier.get();
    }

    static {
        WRITER_MAP.put(FileFormat.JSON, JsonWriter::new);
        WRITER_MAP.put(FileFormat.MPX, MPXWriter::new);
        WRITER_MAP.put(FileFormat.MSPDI, MSPDIWriter::new);
        WRITER_MAP.put(FileFormat.PLANNER, PlannerWriter::new);
        WRITER_MAP.put(FileFormat.PMXML, PrimaveraPMFileWriter::new);
        WRITER_MAP.put(FileFormat.XER, PrimaveraXERFileWriter::new);
        WRITER_MAP.put(FileFormat.SDEF, SDEFWriter::new);
    }
}

