/*
 * Decompiled with CFR 0.152.
 */
package com.rtfparserkit.converter.text;

import com.rtfparserkit.parser.IRtfSource;
import com.rtfparserkit.parser.RtfListenerAdaptor;
import com.rtfparserkit.parser.standard.StandardRtfParser;
import com.rtfparserkit.rtf.Command;
import com.rtfparserkit.rtf.CommandType;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.Deque;

public abstract class AbstractTextConverter
extends RtfListenerAdaptor {
    private Command currentDestination = Command.rtf;
    private final Deque<Command> destinationStack = new ArrayDeque<Command>();

    public void convert(IRtfSource source) throws IOException {
        StandardRtfParser parser = new StandardRtfParser();
        this.currentDestination = Command.rtf;
        parser.parse(source, this);
    }

    public abstract void processExtractedText(String var1);

    @Override
    public void processGroupStart() {
        this.destinationStack.push(this.currentDestination);
    }

    @Override
    public void processGroupEnd() {
        this.currentDestination = this.destinationStack.pop();
    }

    @Override
    public void processString(String string) {
        switch (this.currentDestination) {
            case rtf: 
            case pntext: 
            case fldrslt: {
                this.processExtractedText(string);
                break;
            }
        }
    }

    @Override
    public void processCommand(Command command, int parameter, boolean hasParameter, boolean optional) {
        if (command.getCommandType() == CommandType.Destination) {
            this.currentDestination = command;
        }
        switch (command) {
            case par: 
            case line: 
            case row: {
                this.processExtractedText("\n");
                break;
            }
            case tab: 
            case cell: {
                this.processExtractedText("\t");
                break;
            }
        }
    }
}

