# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['DatastoreClusterArgs', 'DatastoreCluster']

@pulumi.input_type
class DatastoreClusterArgs:
    def __init__(__self__, *,
                 datacenter_id: pulumi.Input[builtins.str],
                 custom_attributes: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 folder: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 sdrs_advanced_options: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 sdrs_automation_level: Optional[pulumi.Input[builtins.str]] = None,
                 sdrs_default_intra_vm_affinity: Optional[pulumi.Input[builtins.bool]] = None,
                 sdrs_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 sdrs_free_space_threshold: Optional[pulumi.Input[builtins.int]] = None,
                 sdrs_free_space_threshold_mode: Optional[pulumi.Input[builtins.str]] = None,
                 sdrs_free_space_utilization_difference: Optional[pulumi.Input[builtins.int]] = None,
                 sdrs_io_balance_automation_level: Optional[pulumi.Input[builtins.str]] = None,
                 sdrs_io_latency_threshold: Optional[pulumi.Input[builtins.int]] = None,
                 sdrs_io_load_balance_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 sdrs_io_load_imbalance_threshold: Optional[pulumi.Input[builtins.int]] = None,
                 sdrs_io_reservable_iops_threshold: Optional[pulumi.Input[builtins.int]] = None,
                 sdrs_io_reservable_percent_threshold: Optional[pulumi.Input[builtins.int]] = None,
                 sdrs_io_reservable_threshold_mode: Optional[pulumi.Input[builtins.str]] = None,
                 sdrs_load_balance_interval: Optional[pulumi.Input[builtins.int]] = None,
                 sdrs_policy_enforcement_automation_level: Optional[pulumi.Input[builtins.str]] = None,
                 sdrs_rule_enforcement_automation_level: Optional[pulumi.Input[builtins.str]] = None,
                 sdrs_space_balance_automation_level: Optional[pulumi.Input[builtins.str]] = None,
                 sdrs_space_utilization_threshold: Optional[pulumi.Input[builtins.int]] = None,
                 sdrs_vm_evacuation_automation_level: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None):
        """
        The set of arguments for constructing a DatastoreCluster resource.
        :param pulumi.Input[builtins.str] datacenter_id: The managed object ID of
               the datacenter to create the datastore cluster in. Forces a new resource if
               changed.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] custom_attributes: A map of custom attribute ids to attribute
               value strings to set for the datastore cluster. See
               [here][docs-setting-custom-attributes] for a reference on how to set values
               for custom attributes.
               
               [docs-setting-custom-attributes]: /docs/providers/vsphere/r/custom_attribute.html#using-custom-attributes-in-a-supported-resource
               
               > **NOTE:** Custom attributes are unsupported on direct ESXi connections
               and require vCenter.
        :param pulumi.Input[builtins.str] folder: The relative path to a folder to put this datastore
               cluster in.  This is a path relative to the datacenter you are deploying the
               datastore to.  Example: for the `dc1` datacenter, and a provided `folder` of
               `foo/bar`, The provider will place a datastore cluster named
               `datastore-cluster-test` in a datastore folder located at
               `/dc1/datastore/foo/bar`, with the final inventory path being
               `/dc1/datastore/foo/bar/datastore-cluster-test`.
        :param pulumi.Input[builtins.str] name: The name of the datastore cluster.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] sdrs_advanced_options: Advanced configuration options for storage DRS.
        :param pulumi.Input[builtins.str] sdrs_automation_level: The default automation level for all virtual machines in this storage cluster.
        :param pulumi.Input[builtins.bool] sdrs_default_intra_vm_affinity: When true, storage DRS keeps VMDKs for individual VMs on the same datastore by default.
        :param pulumi.Input[builtins.bool] sdrs_enabled: Enable Storage DRS for this datastore cluster.
               Default: `false`.
        :param pulumi.Input[builtins.int] sdrs_free_space_threshold: The threshold, in GB, that storage DRS uses to make decisions to migrate VMs out of a datastore.
        :param pulumi.Input[builtins.str] sdrs_free_space_threshold_mode: The free space threshold to use. When set to utilization, drs_space_utilization_threshold is used, and when set to
               freeSpace, drs_free_space_threshold is used.
        :param pulumi.Input[builtins.int] sdrs_free_space_utilization_difference: The threshold, in percent, of difference between space utilization in datastores before storage DRS makes decisions to
               balance the space.
        :param pulumi.Input[builtins.str] sdrs_io_balance_automation_level: Overrides the default automation settings when correcting I/O load imbalances.
        :param pulumi.Input[builtins.int] sdrs_io_latency_threshold: The I/O latency threshold, in milliseconds, that storage DRS uses to make recommendations to move disks from this
               datastore.
        :param pulumi.Input[builtins.bool] sdrs_io_load_balance_enabled: Enable I/O load balancing for this datastore cluster.
        :param pulumi.Input[builtins.int] sdrs_io_load_imbalance_threshold: The difference between load in datastores in the cluster before storage DRS makes recommendations to balance the load.
        :param pulumi.Input[builtins.int] sdrs_io_reservable_iops_threshold: The threshold of reservable IOPS of all virtual machines on the datastore before storage DRS makes recommendations to
               move VMs off of a datastore.
        :param pulumi.Input[builtins.int] sdrs_io_reservable_percent_threshold: The threshold, in percent, of actual estimated performance of the datastore (in IOPS) that storage DRS uses to make
               recommendations to move VMs off of a datastore when the total reservable IOPS exceeds the threshold.
        :param pulumi.Input[builtins.str] sdrs_io_reservable_threshold_mode: The reservable IOPS threshold to use, percent in the event of automatic, or manual threshold in the event of manual.
        :param pulumi.Input[builtins.int] sdrs_load_balance_interval: The storage DRS poll interval, in minutes.
        :param pulumi.Input[builtins.str] sdrs_policy_enforcement_automation_level: Overrides the default automation settings when correcting storage and VM policy violations.
        :param pulumi.Input[builtins.str] sdrs_rule_enforcement_automation_level: Overrides the default automation settings when correcting affinity rule violations.
        :param pulumi.Input[builtins.str] sdrs_space_balance_automation_level: Overrides the default automation settings when correcting disk space imbalances.
        :param pulumi.Input[builtins.int] sdrs_space_utilization_threshold: The threshold, in percent of used space, that storage DRS uses to make decisions to migrate VMs out of a datastore.
        :param pulumi.Input[builtins.str] sdrs_vm_evacuation_automation_level: Overrides the default automation settings when generating recommendations for datastore evacuation.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] tags: The IDs of any tags to attach to this resource.
        """
        pulumi.set(__self__, "datacenter_id", datacenter_id)
        if custom_attributes is not None:
            pulumi.set(__self__, "custom_attributes", custom_attributes)
        if folder is not None:
            pulumi.set(__self__, "folder", folder)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if sdrs_advanced_options is not None:
            pulumi.set(__self__, "sdrs_advanced_options", sdrs_advanced_options)
        if sdrs_automation_level is not None:
            pulumi.set(__self__, "sdrs_automation_level", sdrs_automation_level)
        if sdrs_default_intra_vm_affinity is not None:
            pulumi.set(__self__, "sdrs_default_intra_vm_affinity", sdrs_default_intra_vm_affinity)
        if sdrs_enabled is not None:
            pulumi.set(__self__, "sdrs_enabled", sdrs_enabled)
        if sdrs_free_space_threshold is not None:
            pulumi.set(__self__, "sdrs_free_space_threshold", sdrs_free_space_threshold)
        if sdrs_free_space_threshold_mode is not None:
            pulumi.set(__self__, "sdrs_free_space_threshold_mode", sdrs_free_space_threshold_mode)
        if sdrs_free_space_utilization_difference is not None:
            pulumi.set(__self__, "sdrs_free_space_utilization_difference", sdrs_free_space_utilization_difference)
        if sdrs_io_balance_automation_level is not None:
            pulumi.set(__self__, "sdrs_io_balance_automation_level", sdrs_io_balance_automation_level)
        if sdrs_io_latency_threshold is not None:
            pulumi.set(__self__, "sdrs_io_latency_threshold", sdrs_io_latency_threshold)
        if sdrs_io_load_balance_enabled is not None:
            pulumi.set(__self__, "sdrs_io_load_balance_enabled", sdrs_io_load_balance_enabled)
        if sdrs_io_load_imbalance_threshold is not None:
            pulumi.set(__self__, "sdrs_io_load_imbalance_threshold", sdrs_io_load_imbalance_threshold)
        if sdrs_io_reservable_iops_threshold is not None:
            pulumi.set(__self__, "sdrs_io_reservable_iops_threshold", sdrs_io_reservable_iops_threshold)
        if sdrs_io_reservable_percent_threshold is not None:
            pulumi.set(__self__, "sdrs_io_reservable_percent_threshold", sdrs_io_reservable_percent_threshold)
        if sdrs_io_reservable_threshold_mode is not None:
            pulumi.set(__self__, "sdrs_io_reservable_threshold_mode", sdrs_io_reservable_threshold_mode)
        if sdrs_load_balance_interval is not None:
            pulumi.set(__self__, "sdrs_load_balance_interval", sdrs_load_balance_interval)
        if sdrs_policy_enforcement_automation_level is not None:
            pulumi.set(__self__, "sdrs_policy_enforcement_automation_level", sdrs_policy_enforcement_automation_level)
        if sdrs_rule_enforcement_automation_level is not None:
            pulumi.set(__self__, "sdrs_rule_enforcement_automation_level", sdrs_rule_enforcement_automation_level)
        if sdrs_space_balance_automation_level is not None:
            pulumi.set(__self__, "sdrs_space_balance_automation_level", sdrs_space_balance_automation_level)
        if sdrs_space_utilization_threshold is not None:
            pulumi.set(__self__, "sdrs_space_utilization_threshold", sdrs_space_utilization_threshold)
        if sdrs_vm_evacuation_automation_level is not None:
            pulumi.set(__self__, "sdrs_vm_evacuation_automation_level", sdrs_vm_evacuation_automation_level)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="datacenterId")
    def datacenter_id(self) -> pulumi.Input[builtins.str]:
        """
        The managed object ID of
        the datacenter to create the datastore cluster in. Forces a new resource if
        changed.
        """
        return pulumi.get(self, "datacenter_id")

    @datacenter_id.setter
    def datacenter_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "datacenter_id", value)

    @property
    @pulumi.getter(name="customAttributes")
    def custom_attributes(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        A map of custom attribute ids to attribute
        value strings to set for the datastore cluster. See
        [here][docs-setting-custom-attributes] for a reference on how to set values
        for custom attributes.

        [docs-setting-custom-attributes]: /docs/providers/vsphere/r/custom_attribute.html#using-custom-attributes-in-a-supported-resource

        > **NOTE:** Custom attributes are unsupported on direct ESXi connections
        and require vCenter.
        """
        return pulumi.get(self, "custom_attributes")

    @custom_attributes.setter
    def custom_attributes(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "custom_attributes", value)

    @property
    @pulumi.getter
    def folder(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The relative path to a folder to put this datastore
        cluster in.  This is a path relative to the datacenter you are deploying the
        datastore to.  Example: for the `dc1` datacenter, and a provided `folder` of
        `foo/bar`, The provider will place a datastore cluster named
        `datastore-cluster-test` in a datastore folder located at
        `/dc1/datastore/foo/bar`, with the final inventory path being
        `/dc1/datastore/foo/bar/datastore-cluster-test`.
        """
        return pulumi.get(self, "folder")

    @folder.setter
    def folder(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "folder", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the datastore cluster.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="sdrsAdvancedOptions")
    def sdrs_advanced_options(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Advanced configuration options for storage DRS.
        """
        return pulumi.get(self, "sdrs_advanced_options")

    @sdrs_advanced_options.setter
    def sdrs_advanced_options(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "sdrs_advanced_options", value)

    @property
    @pulumi.getter(name="sdrsAutomationLevel")
    def sdrs_automation_level(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The default automation level for all virtual machines in this storage cluster.
        """
        return pulumi.get(self, "sdrs_automation_level")

    @sdrs_automation_level.setter
    def sdrs_automation_level(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "sdrs_automation_level", value)

    @property
    @pulumi.getter(name="sdrsDefaultIntraVmAffinity")
    def sdrs_default_intra_vm_affinity(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        When true, storage DRS keeps VMDKs for individual VMs on the same datastore by default.
        """
        return pulumi.get(self, "sdrs_default_intra_vm_affinity")

    @sdrs_default_intra_vm_affinity.setter
    def sdrs_default_intra_vm_affinity(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "sdrs_default_intra_vm_affinity", value)

    @property
    @pulumi.getter(name="sdrsEnabled")
    def sdrs_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Enable Storage DRS for this datastore cluster.
        Default: `false`.
        """
        return pulumi.get(self, "sdrs_enabled")

    @sdrs_enabled.setter
    def sdrs_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "sdrs_enabled", value)

    @property
    @pulumi.getter(name="sdrsFreeSpaceThreshold")
    def sdrs_free_space_threshold(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The threshold, in GB, that storage DRS uses to make decisions to migrate VMs out of a datastore.
        """
        return pulumi.get(self, "sdrs_free_space_threshold")

    @sdrs_free_space_threshold.setter
    def sdrs_free_space_threshold(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "sdrs_free_space_threshold", value)

    @property
    @pulumi.getter(name="sdrsFreeSpaceThresholdMode")
    def sdrs_free_space_threshold_mode(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The free space threshold to use. When set to utilization, drs_space_utilization_threshold is used, and when set to
        freeSpace, drs_free_space_threshold is used.
        """
        return pulumi.get(self, "sdrs_free_space_threshold_mode")

    @sdrs_free_space_threshold_mode.setter
    def sdrs_free_space_threshold_mode(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "sdrs_free_space_threshold_mode", value)

    @property
    @pulumi.getter(name="sdrsFreeSpaceUtilizationDifference")
    def sdrs_free_space_utilization_difference(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The threshold, in percent, of difference between space utilization in datastores before storage DRS makes decisions to
        balance the space.
        """
        return pulumi.get(self, "sdrs_free_space_utilization_difference")

    @sdrs_free_space_utilization_difference.setter
    def sdrs_free_space_utilization_difference(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "sdrs_free_space_utilization_difference", value)

    @property
    @pulumi.getter(name="sdrsIoBalanceAutomationLevel")
    def sdrs_io_balance_automation_level(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Overrides the default automation settings when correcting I/O load imbalances.
        """
        return pulumi.get(self, "sdrs_io_balance_automation_level")

    @sdrs_io_balance_automation_level.setter
    def sdrs_io_balance_automation_level(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "sdrs_io_balance_automation_level", value)

    @property
    @pulumi.getter(name="sdrsIoLatencyThreshold")
    def sdrs_io_latency_threshold(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The I/O latency threshold, in milliseconds, that storage DRS uses to make recommendations to move disks from this
        datastore.
        """
        return pulumi.get(self, "sdrs_io_latency_threshold")

    @sdrs_io_latency_threshold.setter
    def sdrs_io_latency_threshold(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "sdrs_io_latency_threshold", value)

    @property
    @pulumi.getter(name="sdrsIoLoadBalanceEnabled")
    def sdrs_io_load_balance_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Enable I/O load balancing for this datastore cluster.
        """
        return pulumi.get(self, "sdrs_io_load_balance_enabled")

    @sdrs_io_load_balance_enabled.setter
    def sdrs_io_load_balance_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "sdrs_io_load_balance_enabled", value)

    @property
    @pulumi.getter(name="sdrsIoLoadImbalanceThreshold")
    def sdrs_io_load_imbalance_threshold(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The difference between load in datastores in the cluster before storage DRS makes recommendations to balance the load.
        """
        return pulumi.get(self, "sdrs_io_load_imbalance_threshold")

    @sdrs_io_load_imbalance_threshold.setter
    def sdrs_io_load_imbalance_threshold(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "sdrs_io_load_imbalance_threshold", value)

    @property
    @pulumi.getter(name="sdrsIoReservableIopsThreshold")
    def sdrs_io_reservable_iops_threshold(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The threshold of reservable IOPS of all virtual machines on the datastore before storage DRS makes recommendations to
        move VMs off of a datastore.
        """
        return pulumi.get(self, "sdrs_io_reservable_iops_threshold")

    @sdrs_io_reservable_iops_threshold.setter
    def sdrs_io_reservable_iops_threshold(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "sdrs_io_reservable_iops_threshold", value)

    @property
    @pulumi.getter(name="sdrsIoReservablePercentThreshold")
    def sdrs_io_reservable_percent_threshold(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The threshold, in percent, of actual estimated performance of the datastore (in IOPS) that storage DRS uses to make
        recommendations to move VMs off of a datastore when the total reservable IOPS exceeds the threshold.
        """
        return pulumi.get(self, "sdrs_io_reservable_percent_threshold")

    @sdrs_io_reservable_percent_threshold.setter
    def sdrs_io_reservable_percent_threshold(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "sdrs_io_reservable_percent_threshold", value)

    @property
    @pulumi.getter(name="sdrsIoReservableThresholdMode")
    def sdrs_io_reservable_threshold_mode(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The reservable IOPS threshold to use, percent in the event of automatic, or manual threshold in the event of manual.
        """
        return pulumi.get(self, "sdrs_io_reservable_threshold_mode")

    @sdrs_io_reservable_threshold_mode.setter
    def sdrs_io_reservable_threshold_mode(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "sdrs_io_reservable_threshold_mode", value)

    @property
    @pulumi.getter(name="sdrsLoadBalanceInterval")
    def sdrs_load_balance_interval(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The storage DRS poll interval, in minutes.
        """
        return pulumi.get(self, "sdrs_load_balance_interval")

    @sdrs_load_balance_interval.setter
    def sdrs_load_balance_interval(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "sdrs_load_balance_interval", value)

    @property
    @pulumi.getter(name="sdrsPolicyEnforcementAutomationLevel")
    def sdrs_policy_enforcement_automation_level(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Overrides the default automation settings when correcting storage and VM policy violations.
        """
        return pulumi.get(self, "sdrs_policy_enforcement_automation_level")

    @sdrs_policy_enforcement_automation_level.setter
    def sdrs_policy_enforcement_automation_level(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "sdrs_policy_enforcement_automation_level", value)

    @property
    @pulumi.getter(name="sdrsRuleEnforcementAutomationLevel")
    def sdrs_rule_enforcement_automation_level(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Overrides the default automation settings when correcting affinity rule violations.
        """
        return pulumi.get(self, "sdrs_rule_enforcement_automation_level")

    @sdrs_rule_enforcement_automation_level.setter
    def sdrs_rule_enforcement_automation_level(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "sdrs_rule_enforcement_automation_level", value)

    @property
    @pulumi.getter(name="sdrsSpaceBalanceAutomationLevel")
    def sdrs_space_balance_automation_level(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Overrides the default automation settings when correcting disk space imbalances.
        """
        return pulumi.get(self, "sdrs_space_balance_automation_level")

    @sdrs_space_balance_automation_level.setter
    def sdrs_space_balance_automation_level(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "sdrs_space_balance_automation_level", value)

    @property
    @pulumi.getter(name="sdrsSpaceUtilizationThreshold")
    def sdrs_space_utilization_threshold(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The threshold, in percent of used space, that storage DRS uses to make decisions to migrate VMs out of a datastore.
        """
        return pulumi.get(self, "sdrs_space_utilization_threshold")

    @sdrs_space_utilization_threshold.setter
    def sdrs_space_utilization_threshold(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "sdrs_space_utilization_threshold", value)

    @property
    @pulumi.getter(name="sdrsVmEvacuationAutomationLevel")
    def sdrs_vm_evacuation_automation_level(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Overrides the default automation settings when generating recommendations for datastore evacuation.
        """
        return pulumi.get(self, "sdrs_vm_evacuation_automation_level")

    @sdrs_vm_evacuation_automation_level.setter
    def sdrs_vm_evacuation_automation_level(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "sdrs_vm_evacuation_automation_level", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        The IDs of any tags to attach to this resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _DatastoreClusterState:
    def __init__(__self__, *,
                 custom_attributes: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 datacenter_id: Optional[pulumi.Input[builtins.str]] = None,
                 folder: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 sdrs_advanced_options: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 sdrs_automation_level: Optional[pulumi.Input[builtins.str]] = None,
                 sdrs_default_intra_vm_affinity: Optional[pulumi.Input[builtins.bool]] = None,
                 sdrs_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 sdrs_free_space_threshold: Optional[pulumi.Input[builtins.int]] = None,
                 sdrs_free_space_threshold_mode: Optional[pulumi.Input[builtins.str]] = None,
                 sdrs_free_space_utilization_difference: Optional[pulumi.Input[builtins.int]] = None,
                 sdrs_io_balance_automation_level: Optional[pulumi.Input[builtins.str]] = None,
                 sdrs_io_latency_threshold: Optional[pulumi.Input[builtins.int]] = None,
                 sdrs_io_load_balance_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 sdrs_io_load_imbalance_threshold: Optional[pulumi.Input[builtins.int]] = None,
                 sdrs_io_reservable_iops_threshold: Optional[pulumi.Input[builtins.int]] = None,
                 sdrs_io_reservable_percent_threshold: Optional[pulumi.Input[builtins.int]] = None,
                 sdrs_io_reservable_threshold_mode: Optional[pulumi.Input[builtins.str]] = None,
                 sdrs_load_balance_interval: Optional[pulumi.Input[builtins.int]] = None,
                 sdrs_policy_enforcement_automation_level: Optional[pulumi.Input[builtins.str]] = None,
                 sdrs_rule_enforcement_automation_level: Optional[pulumi.Input[builtins.str]] = None,
                 sdrs_space_balance_automation_level: Optional[pulumi.Input[builtins.str]] = None,
                 sdrs_space_utilization_threshold: Optional[pulumi.Input[builtins.int]] = None,
                 sdrs_vm_evacuation_automation_level: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering DatastoreCluster resources.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] custom_attributes: A map of custom attribute ids to attribute
               value strings to set for the datastore cluster. See
               [here][docs-setting-custom-attributes] for a reference on how to set values
               for custom attributes.
               
               [docs-setting-custom-attributes]: /docs/providers/vsphere/r/custom_attribute.html#using-custom-attributes-in-a-supported-resource
               
               > **NOTE:** Custom attributes are unsupported on direct ESXi connections
               and require vCenter.
        :param pulumi.Input[builtins.str] datacenter_id: The managed object ID of
               the datacenter to create the datastore cluster in. Forces a new resource if
               changed.
        :param pulumi.Input[builtins.str] folder: The relative path to a folder to put this datastore
               cluster in.  This is a path relative to the datacenter you are deploying the
               datastore to.  Example: for the `dc1` datacenter, and a provided `folder` of
               `foo/bar`, The provider will place a datastore cluster named
               `datastore-cluster-test` in a datastore folder located at
               `/dc1/datastore/foo/bar`, with the final inventory path being
               `/dc1/datastore/foo/bar/datastore-cluster-test`.
        :param pulumi.Input[builtins.str] name: The name of the datastore cluster.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] sdrs_advanced_options: Advanced configuration options for storage DRS.
        :param pulumi.Input[builtins.str] sdrs_automation_level: The default automation level for all virtual machines in this storage cluster.
        :param pulumi.Input[builtins.bool] sdrs_default_intra_vm_affinity: When true, storage DRS keeps VMDKs for individual VMs on the same datastore by default.
        :param pulumi.Input[builtins.bool] sdrs_enabled: Enable Storage DRS for this datastore cluster.
               Default: `false`.
        :param pulumi.Input[builtins.int] sdrs_free_space_threshold: The threshold, in GB, that storage DRS uses to make decisions to migrate VMs out of a datastore.
        :param pulumi.Input[builtins.str] sdrs_free_space_threshold_mode: The free space threshold to use. When set to utilization, drs_space_utilization_threshold is used, and when set to
               freeSpace, drs_free_space_threshold is used.
        :param pulumi.Input[builtins.int] sdrs_free_space_utilization_difference: The threshold, in percent, of difference between space utilization in datastores before storage DRS makes decisions to
               balance the space.
        :param pulumi.Input[builtins.str] sdrs_io_balance_automation_level: Overrides the default automation settings when correcting I/O load imbalances.
        :param pulumi.Input[builtins.int] sdrs_io_latency_threshold: The I/O latency threshold, in milliseconds, that storage DRS uses to make recommendations to move disks from this
               datastore.
        :param pulumi.Input[builtins.bool] sdrs_io_load_balance_enabled: Enable I/O load balancing for this datastore cluster.
        :param pulumi.Input[builtins.int] sdrs_io_load_imbalance_threshold: The difference between load in datastores in the cluster before storage DRS makes recommendations to balance the load.
        :param pulumi.Input[builtins.int] sdrs_io_reservable_iops_threshold: The threshold of reservable IOPS of all virtual machines on the datastore before storage DRS makes recommendations to
               move VMs off of a datastore.
        :param pulumi.Input[builtins.int] sdrs_io_reservable_percent_threshold: The threshold, in percent, of actual estimated performance of the datastore (in IOPS) that storage DRS uses to make
               recommendations to move VMs off of a datastore when the total reservable IOPS exceeds the threshold.
        :param pulumi.Input[builtins.str] sdrs_io_reservable_threshold_mode: The reservable IOPS threshold to use, percent in the event of automatic, or manual threshold in the event of manual.
        :param pulumi.Input[builtins.int] sdrs_load_balance_interval: The storage DRS poll interval, in minutes.
        :param pulumi.Input[builtins.str] sdrs_policy_enforcement_automation_level: Overrides the default automation settings when correcting storage and VM policy violations.
        :param pulumi.Input[builtins.str] sdrs_rule_enforcement_automation_level: Overrides the default automation settings when correcting affinity rule violations.
        :param pulumi.Input[builtins.str] sdrs_space_balance_automation_level: Overrides the default automation settings when correcting disk space imbalances.
        :param pulumi.Input[builtins.int] sdrs_space_utilization_threshold: The threshold, in percent of used space, that storage DRS uses to make decisions to migrate VMs out of a datastore.
        :param pulumi.Input[builtins.str] sdrs_vm_evacuation_automation_level: Overrides the default automation settings when generating recommendations for datastore evacuation.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] tags: The IDs of any tags to attach to this resource.
        """
        if custom_attributes is not None:
            pulumi.set(__self__, "custom_attributes", custom_attributes)
        if datacenter_id is not None:
            pulumi.set(__self__, "datacenter_id", datacenter_id)
        if folder is not None:
            pulumi.set(__self__, "folder", folder)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if sdrs_advanced_options is not None:
            pulumi.set(__self__, "sdrs_advanced_options", sdrs_advanced_options)
        if sdrs_automation_level is not None:
            pulumi.set(__self__, "sdrs_automation_level", sdrs_automation_level)
        if sdrs_default_intra_vm_affinity is not None:
            pulumi.set(__self__, "sdrs_default_intra_vm_affinity", sdrs_default_intra_vm_affinity)
        if sdrs_enabled is not None:
            pulumi.set(__self__, "sdrs_enabled", sdrs_enabled)
        if sdrs_free_space_threshold is not None:
            pulumi.set(__self__, "sdrs_free_space_threshold", sdrs_free_space_threshold)
        if sdrs_free_space_threshold_mode is not None:
            pulumi.set(__self__, "sdrs_free_space_threshold_mode", sdrs_free_space_threshold_mode)
        if sdrs_free_space_utilization_difference is not None:
            pulumi.set(__self__, "sdrs_free_space_utilization_difference", sdrs_free_space_utilization_difference)
        if sdrs_io_balance_automation_level is not None:
            pulumi.set(__self__, "sdrs_io_balance_automation_level", sdrs_io_balance_automation_level)
        if sdrs_io_latency_threshold is not None:
            pulumi.set(__self__, "sdrs_io_latency_threshold", sdrs_io_latency_threshold)
        if sdrs_io_load_balance_enabled is not None:
            pulumi.set(__self__, "sdrs_io_load_balance_enabled", sdrs_io_load_balance_enabled)
        if sdrs_io_load_imbalance_threshold is not None:
            pulumi.set(__self__, "sdrs_io_load_imbalance_threshold", sdrs_io_load_imbalance_threshold)
        if sdrs_io_reservable_iops_threshold is not None:
            pulumi.set(__self__, "sdrs_io_reservable_iops_threshold", sdrs_io_reservable_iops_threshold)
        if sdrs_io_reservable_percent_threshold is not None:
            pulumi.set(__self__, "sdrs_io_reservable_percent_threshold", sdrs_io_reservable_percent_threshold)
        if sdrs_io_reservable_threshold_mode is not None:
            pulumi.set(__self__, "sdrs_io_reservable_threshold_mode", sdrs_io_reservable_threshold_mode)
        if sdrs_load_balance_interval is not None:
            pulumi.set(__self__, "sdrs_load_balance_interval", sdrs_load_balance_interval)
        if sdrs_policy_enforcement_automation_level is not None:
            pulumi.set(__self__, "sdrs_policy_enforcement_automation_level", sdrs_policy_enforcement_automation_level)
        if sdrs_rule_enforcement_automation_level is not None:
            pulumi.set(__self__, "sdrs_rule_enforcement_automation_level", sdrs_rule_enforcement_automation_level)
        if sdrs_space_balance_automation_level is not None:
            pulumi.set(__self__, "sdrs_space_balance_automation_level", sdrs_space_balance_automation_level)
        if sdrs_space_utilization_threshold is not None:
            pulumi.set(__self__, "sdrs_space_utilization_threshold", sdrs_space_utilization_threshold)
        if sdrs_vm_evacuation_automation_level is not None:
            pulumi.set(__self__, "sdrs_vm_evacuation_automation_level", sdrs_vm_evacuation_automation_level)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="customAttributes")
    def custom_attributes(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        A map of custom attribute ids to attribute
        value strings to set for the datastore cluster. See
        [here][docs-setting-custom-attributes] for a reference on how to set values
        for custom attributes.

        [docs-setting-custom-attributes]: /docs/providers/vsphere/r/custom_attribute.html#using-custom-attributes-in-a-supported-resource

        > **NOTE:** Custom attributes are unsupported on direct ESXi connections
        and require vCenter.
        """
        return pulumi.get(self, "custom_attributes")

    @custom_attributes.setter
    def custom_attributes(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "custom_attributes", value)

    @property
    @pulumi.getter(name="datacenterId")
    def datacenter_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The managed object ID of
        the datacenter to create the datastore cluster in. Forces a new resource if
        changed.
        """
        return pulumi.get(self, "datacenter_id")

    @datacenter_id.setter
    def datacenter_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "datacenter_id", value)

    @property
    @pulumi.getter
    def folder(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The relative path to a folder to put this datastore
        cluster in.  This is a path relative to the datacenter you are deploying the
        datastore to.  Example: for the `dc1` datacenter, and a provided `folder` of
        `foo/bar`, The provider will place a datastore cluster named
        `datastore-cluster-test` in a datastore folder located at
        `/dc1/datastore/foo/bar`, with the final inventory path being
        `/dc1/datastore/foo/bar/datastore-cluster-test`.
        """
        return pulumi.get(self, "folder")

    @folder.setter
    def folder(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "folder", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the datastore cluster.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="sdrsAdvancedOptions")
    def sdrs_advanced_options(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Advanced configuration options for storage DRS.
        """
        return pulumi.get(self, "sdrs_advanced_options")

    @sdrs_advanced_options.setter
    def sdrs_advanced_options(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "sdrs_advanced_options", value)

    @property
    @pulumi.getter(name="sdrsAutomationLevel")
    def sdrs_automation_level(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The default automation level for all virtual machines in this storage cluster.
        """
        return pulumi.get(self, "sdrs_automation_level")

    @sdrs_automation_level.setter
    def sdrs_automation_level(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "sdrs_automation_level", value)

    @property
    @pulumi.getter(name="sdrsDefaultIntraVmAffinity")
    def sdrs_default_intra_vm_affinity(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        When true, storage DRS keeps VMDKs for individual VMs on the same datastore by default.
        """
        return pulumi.get(self, "sdrs_default_intra_vm_affinity")

    @sdrs_default_intra_vm_affinity.setter
    def sdrs_default_intra_vm_affinity(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "sdrs_default_intra_vm_affinity", value)

    @property
    @pulumi.getter(name="sdrsEnabled")
    def sdrs_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Enable Storage DRS for this datastore cluster.
        Default: `false`.
        """
        return pulumi.get(self, "sdrs_enabled")

    @sdrs_enabled.setter
    def sdrs_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "sdrs_enabled", value)

    @property
    @pulumi.getter(name="sdrsFreeSpaceThreshold")
    def sdrs_free_space_threshold(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The threshold, in GB, that storage DRS uses to make decisions to migrate VMs out of a datastore.
        """
        return pulumi.get(self, "sdrs_free_space_threshold")

    @sdrs_free_space_threshold.setter
    def sdrs_free_space_threshold(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "sdrs_free_space_threshold", value)

    @property
    @pulumi.getter(name="sdrsFreeSpaceThresholdMode")
    def sdrs_free_space_threshold_mode(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The free space threshold to use. When set to utilization, drs_space_utilization_threshold is used, and when set to
        freeSpace, drs_free_space_threshold is used.
        """
        return pulumi.get(self, "sdrs_free_space_threshold_mode")

    @sdrs_free_space_threshold_mode.setter
    def sdrs_free_space_threshold_mode(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "sdrs_free_space_threshold_mode", value)

    @property
    @pulumi.getter(name="sdrsFreeSpaceUtilizationDifference")
    def sdrs_free_space_utilization_difference(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The threshold, in percent, of difference between space utilization in datastores before storage DRS makes decisions to
        balance the space.
        """
        return pulumi.get(self, "sdrs_free_space_utilization_difference")

    @sdrs_free_space_utilization_difference.setter
    def sdrs_free_space_utilization_difference(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "sdrs_free_space_utilization_difference", value)

    @property
    @pulumi.getter(name="sdrsIoBalanceAutomationLevel")
    def sdrs_io_balance_automation_level(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Overrides the default automation settings when correcting I/O load imbalances.
        """
        return pulumi.get(self, "sdrs_io_balance_automation_level")

    @sdrs_io_balance_automation_level.setter
    def sdrs_io_balance_automation_level(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "sdrs_io_balance_automation_level", value)

    @property
    @pulumi.getter(name="sdrsIoLatencyThreshold")
    def sdrs_io_latency_threshold(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The I/O latency threshold, in milliseconds, that storage DRS uses to make recommendations to move disks from this
        datastore.
        """
        return pulumi.get(self, "sdrs_io_latency_threshold")

    @sdrs_io_latency_threshold.setter
    def sdrs_io_latency_threshold(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "sdrs_io_latency_threshold", value)

    @property
    @pulumi.getter(name="sdrsIoLoadBalanceEnabled")
    def sdrs_io_load_balance_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Enable I/O load balancing for this datastore cluster.
        """
        return pulumi.get(self, "sdrs_io_load_balance_enabled")

    @sdrs_io_load_balance_enabled.setter
    def sdrs_io_load_balance_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "sdrs_io_load_balance_enabled", value)

    @property
    @pulumi.getter(name="sdrsIoLoadImbalanceThreshold")
    def sdrs_io_load_imbalance_threshold(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The difference between load in datastores in the cluster before storage DRS makes recommendations to balance the load.
        """
        return pulumi.get(self, "sdrs_io_load_imbalance_threshold")

    @sdrs_io_load_imbalance_threshold.setter
    def sdrs_io_load_imbalance_threshold(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "sdrs_io_load_imbalance_threshold", value)

    @property
    @pulumi.getter(name="sdrsIoReservableIopsThreshold")
    def sdrs_io_reservable_iops_threshold(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The threshold of reservable IOPS of all virtual machines on the datastore before storage DRS makes recommendations to
        move VMs off of a datastore.
        """
        return pulumi.get(self, "sdrs_io_reservable_iops_threshold")

    @sdrs_io_reservable_iops_threshold.setter
    def sdrs_io_reservable_iops_threshold(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "sdrs_io_reservable_iops_threshold", value)

    @property
    @pulumi.getter(name="sdrsIoReservablePercentThreshold")
    def sdrs_io_reservable_percent_threshold(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The threshold, in percent, of actual estimated performance of the datastore (in IOPS) that storage DRS uses to make
        recommendations to move VMs off of a datastore when the total reservable IOPS exceeds the threshold.
        """
        return pulumi.get(self, "sdrs_io_reservable_percent_threshold")

    @sdrs_io_reservable_percent_threshold.setter
    def sdrs_io_reservable_percent_threshold(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "sdrs_io_reservable_percent_threshold", value)

    @property
    @pulumi.getter(name="sdrsIoReservableThresholdMode")
    def sdrs_io_reservable_threshold_mode(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The reservable IOPS threshold to use, percent in the event of automatic, or manual threshold in the event of manual.
        """
        return pulumi.get(self, "sdrs_io_reservable_threshold_mode")

    @sdrs_io_reservable_threshold_mode.setter
    def sdrs_io_reservable_threshold_mode(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "sdrs_io_reservable_threshold_mode", value)

    @property
    @pulumi.getter(name="sdrsLoadBalanceInterval")
    def sdrs_load_balance_interval(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The storage DRS poll interval, in minutes.
        """
        return pulumi.get(self, "sdrs_load_balance_interval")

    @sdrs_load_balance_interval.setter
    def sdrs_load_balance_interval(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "sdrs_load_balance_interval", value)

    @property
    @pulumi.getter(name="sdrsPolicyEnforcementAutomationLevel")
    def sdrs_policy_enforcement_automation_level(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Overrides the default automation settings when correcting storage and VM policy violations.
        """
        return pulumi.get(self, "sdrs_policy_enforcement_automation_level")

    @sdrs_policy_enforcement_automation_level.setter
    def sdrs_policy_enforcement_automation_level(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "sdrs_policy_enforcement_automation_level", value)

    @property
    @pulumi.getter(name="sdrsRuleEnforcementAutomationLevel")
    def sdrs_rule_enforcement_automation_level(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Overrides the default automation settings when correcting affinity rule violations.
        """
        return pulumi.get(self, "sdrs_rule_enforcement_automation_level")

    @sdrs_rule_enforcement_automation_level.setter
    def sdrs_rule_enforcement_automation_level(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "sdrs_rule_enforcement_automation_level", value)

    @property
    @pulumi.getter(name="sdrsSpaceBalanceAutomationLevel")
    def sdrs_space_balance_automation_level(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Overrides the default automation settings when correcting disk space imbalances.
        """
        return pulumi.get(self, "sdrs_space_balance_automation_level")

    @sdrs_space_balance_automation_level.setter
    def sdrs_space_balance_automation_level(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "sdrs_space_balance_automation_level", value)

    @property
    @pulumi.getter(name="sdrsSpaceUtilizationThreshold")
    def sdrs_space_utilization_threshold(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The threshold, in percent of used space, that storage DRS uses to make decisions to migrate VMs out of a datastore.
        """
        return pulumi.get(self, "sdrs_space_utilization_threshold")

    @sdrs_space_utilization_threshold.setter
    def sdrs_space_utilization_threshold(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "sdrs_space_utilization_threshold", value)

    @property
    @pulumi.getter(name="sdrsVmEvacuationAutomationLevel")
    def sdrs_vm_evacuation_automation_level(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Overrides the default automation settings when generating recommendations for datastore evacuation.
        """
        return pulumi.get(self, "sdrs_vm_evacuation_automation_level")

    @sdrs_vm_evacuation_automation_level.setter
    def sdrs_vm_evacuation_automation_level(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "sdrs_vm_evacuation_automation_level", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        The IDs of any tags to attach to this resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.type_token("vsphere:index/datastoreCluster:DatastoreCluster")
class DatastoreCluster(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 custom_attributes: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 datacenter_id: Optional[pulumi.Input[builtins.str]] = None,
                 folder: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 sdrs_advanced_options: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 sdrs_automation_level: Optional[pulumi.Input[builtins.str]] = None,
                 sdrs_default_intra_vm_affinity: Optional[pulumi.Input[builtins.bool]] = None,
                 sdrs_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 sdrs_free_space_threshold: Optional[pulumi.Input[builtins.int]] = None,
                 sdrs_free_space_threshold_mode: Optional[pulumi.Input[builtins.str]] = None,
                 sdrs_free_space_utilization_difference: Optional[pulumi.Input[builtins.int]] = None,
                 sdrs_io_balance_automation_level: Optional[pulumi.Input[builtins.str]] = None,
                 sdrs_io_latency_threshold: Optional[pulumi.Input[builtins.int]] = None,
                 sdrs_io_load_balance_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 sdrs_io_load_imbalance_threshold: Optional[pulumi.Input[builtins.int]] = None,
                 sdrs_io_reservable_iops_threshold: Optional[pulumi.Input[builtins.int]] = None,
                 sdrs_io_reservable_percent_threshold: Optional[pulumi.Input[builtins.int]] = None,
                 sdrs_io_reservable_threshold_mode: Optional[pulumi.Input[builtins.str]] = None,
                 sdrs_load_balance_interval: Optional[pulumi.Input[builtins.int]] = None,
                 sdrs_policy_enforcement_automation_level: Optional[pulumi.Input[builtins.str]] = None,
                 sdrs_rule_enforcement_automation_level: Optional[pulumi.Input[builtins.str]] = None,
                 sdrs_space_balance_automation_level: Optional[pulumi.Input[builtins.str]] = None,
                 sdrs_space_utilization_threshold: Optional[pulumi.Input[builtins.int]] = None,
                 sdrs_vm_evacuation_automation_level: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 __props__=None):
        """
        The `DatastoreCluster` resource can be used to create and manage
        datastore clusters. This can be used to create groups of datastores with a
        shared management interface, allowing for resource control and load balancing
        through Storage DRS.

        For more information on vSphere datastore clusters and Storage DRS, see [this
        page][ref-vsphere-datastore-clusters].

        [ref-vsphere-datastore-clusters]: https://techdocs.broadcom.com/us/en/vmware-cis/vsphere/vsphere/8-0/vsphere-resource-management-8-0/creating-a-datastore-cluster.html

        > **NOTE:** This resource requires vCenter and is not available on direct ESXi
        connections.

        > **NOTE:** Storage DRS requires a vSphere Enterprise Plus license.

        ## Example Usage

        The following example sets up a datastore cluster and enables Storage DRS with
        the default settings. It then creates two NAS datastores using the
        `NasDatastore` resource and assigns them to
        the datastore cluster.

        ```python
        import pulumi
        import pulumi_vsphere as vsphere

        config = pulumi.Config()
        hosts = config.get_object("hosts")
        if hosts is None:
            hosts = [
                "esxi-01.example.com",
                "esxi-02.example.com",
                "esxi-03.example.com",
            ]
        datacenter = vsphere.get_datacenter()
        hosts_get_host = [vsphere.get_host(name=hosts[__index],
            datacenter_id=datacenter.id) for __index in range(len(hosts))]
        datastore_cluster = vsphere.DatastoreCluster("datastore_cluster",
            name="datastore-cluster-test",
            datacenter_id=datacenter.id,
            sdrs_enabled=True)
        datastore1 = vsphere.NasDatastore("datastore1",
            name="datastore-test1",
            host_system_ids=[[__item["id"] for __item in esxi_hosts]],
            datastore_cluster_id=datastore_cluster.id,
            type="NFS",
            remote_hosts=["nfs"],
            remote_path="/export/test1")
        datastore2 = vsphere.NasDatastore("datastore2",
            name="datastore-test2",
            host_system_ids=[[__item["id"] for __item in esxi_hosts]],
            datastore_cluster_id=datastore_cluster.id,
            type="NFS",
            remote_hosts=["nfs"],
            remote_path="/export/test2")
        ```

        ## Import

        An existing datastore cluster can be imported into this resource

        via the path to the cluster, via the following command:

        [docs-import]: https://developer.hashicorp.com/terraform/cli/import

        ```sh
        $ pulumi import vsphere:index/datastoreCluster:DatastoreCluster datastore_cluster /dc1/datastore/ds-cluster
        ```

        The above would import the datastore cluster named `ds-cluster` that is located

        in the `dc1` datacenter.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] custom_attributes: A map of custom attribute ids to attribute
               value strings to set for the datastore cluster. See
               [here][docs-setting-custom-attributes] for a reference on how to set values
               for custom attributes.
               
               [docs-setting-custom-attributes]: /docs/providers/vsphere/r/custom_attribute.html#using-custom-attributes-in-a-supported-resource
               
               > **NOTE:** Custom attributes are unsupported on direct ESXi connections
               and require vCenter.
        :param pulumi.Input[builtins.str] datacenter_id: The managed object ID of
               the datacenter to create the datastore cluster in. Forces a new resource if
               changed.
        :param pulumi.Input[builtins.str] folder: The relative path to a folder to put this datastore
               cluster in.  This is a path relative to the datacenter you are deploying the
               datastore to.  Example: for the `dc1` datacenter, and a provided `folder` of
               `foo/bar`, The provider will place a datastore cluster named
               `datastore-cluster-test` in a datastore folder located at
               `/dc1/datastore/foo/bar`, with the final inventory path being
               `/dc1/datastore/foo/bar/datastore-cluster-test`.
        :param pulumi.Input[builtins.str] name: The name of the datastore cluster.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] sdrs_advanced_options: Advanced configuration options for storage DRS.
        :param pulumi.Input[builtins.str] sdrs_automation_level: The default automation level for all virtual machines in this storage cluster.
        :param pulumi.Input[builtins.bool] sdrs_default_intra_vm_affinity: When true, storage DRS keeps VMDKs for individual VMs on the same datastore by default.
        :param pulumi.Input[builtins.bool] sdrs_enabled: Enable Storage DRS for this datastore cluster.
               Default: `false`.
        :param pulumi.Input[builtins.int] sdrs_free_space_threshold: The threshold, in GB, that storage DRS uses to make decisions to migrate VMs out of a datastore.
        :param pulumi.Input[builtins.str] sdrs_free_space_threshold_mode: The free space threshold to use. When set to utilization, drs_space_utilization_threshold is used, and when set to
               freeSpace, drs_free_space_threshold is used.
        :param pulumi.Input[builtins.int] sdrs_free_space_utilization_difference: The threshold, in percent, of difference between space utilization in datastores before storage DRS makes decisions to
               balance the space.
        :param pulumi.Input[builtins.str] sdrs_io_balance_automation_level: Overrides the default automation settings when correcting I/O load imbalances.
        :param pulumi.Input[builtins.int] sdrs_io_latency_threshold: The I/O latency threshold, in milliseconds, that storage DRS uses to make recommendations to move disks from this
               datastore.
        :param pulumi.Input[builtins.bool] sdrs_io_load_balance_enabled: Enable I/O load balancing for this datastore cluster.
        :param pulumi.Input[builtins.int] sdrs_io_load_imbalance_threshold: The difference between load in datastores in the cluster before storage DRS makes recommendations to balance the load.
        :param pulumi.Input[builtins.int] sdrs_io_reservable_iops_threshold: The threshold of reservable IOPS of all virtual machines on the datastore before storage DRS makes recommendations to
               move VMs off of a datastore.
        :param pulumi.Input[builtins.int] sdrs_io_reservable_percent_threshold: The threshold, in percent, of actual estimated performance of the datastore (in IOPS) that storage DRS uses to make
               recommendations to move VMs off of a datastore when the total reservable IOPS exceeds the threshold.
        :param pulumi.Input[builtins.str] sdrs_io_reservable_threshold_mode: The reservable IOPS threshold to use, percent in the event of automatic, or manual threshold in the event of manual.
        :param pulumi.Input[builtins.int] sdrs_load_balance_interval: The storage DRS poll interval, in minutes.
        :param pulumi.Input[builtins.str] sdrs_policy_enforcement_automation_level: Overrides the default automation settings when correcting storage and VM policy violations.
        :param pulumi.Input[builtins.str] sdrs_rule_enforcement_automation_level: Overrides the default automation settings when correcting affinity rule violations.
        :param pulumi.Input[builtins.str] sdrs_space_balance_automation_level: Overrides the default automation settings when correcting disk space imbalances.
        :param pulumi.Input[builtins.int] sdrs_space_utilization_threshold: The threshold, in percent of used space, that storage DRS uses to make decisions to migrate VMs out of a datastore.
        :param pulumi.Input[builtins.str] sdrs_vm_evacuation_automation_level: Overrides the default automation settings when generating recommendations for datastore evacuation.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] tags: The IDs of any tags to attach to this resource.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DatastoreClusterArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        The `DatastoreCluster` resource can be used to create and manage
        datastore clusters. This can be used to create groups of datastores with a
        shared management interface, allowing for resource control and load balancing
        through Storage DRS.

        For more information on vSphere datastore clusters and Storage DRS, see [this
        page][ref-vsphere-datastore-clusters].

        [ref-vsphere-datastore-clusters]: https://techdocs.broadcom.com/us/en/vmware-cis/vsphere/vsphere/8-0/vsphere-resource-management-8-0/creating-a-datastore-cluster.html

        > **NOTE:** This resource requires vCenter and is not available on direct ESXi
        connections.

        > **NOTE:** Storage DRS requires a vSphere Enterprise Plus license.

        ## Example Usage

        The following example sets up a datastore cluster and enables Storage DRS with
        the default settings. It then creates two NAS datastores using the
        `NasDatastore` resource and assigns them to
        the datastore cluster.

        ```python
        import pulumi
        import pulumi_vsphere as vsphere

        config = pulumi.Config()
        hosts = config.get_object("hosts")
        if hosts is None:
            hosts = [
                "esxi-01.example.com",
                "esxi-02.example.com",
                "esxi-03.example.com",
            ]
        datacenter = vsphere.get_datacenter()
        hosts_get_host = [vsphere.get_host(name=hosts[__index],
            datacenter_id=datacenter.id) for __index in range(len(hosts))]
        datastore_cluster = vsphere.DatastoreCluster("datastore_cluster",
            name="datastore-cluster-test",
            datacenter_id=datacenter.id,
            sdrs_enabled=True)
        datastore1 = vsphere.NasDatastore("datastore1",
            name="datastore-test1",
            host_system_ids=[[__item["id"] for __item in esxi_hosts]],
            datastore_cluster_id=datastore_cluster.id,
            type="NFS",
            remote_hosts=["nfs"],
            remote_path="/export/test1")
        datastore2 = vsphere.NasDatastore("datastore2",
            name="datastore-test2",
            host_system_ids=[[__item["id"] for __item in esxi_hosts]],
            datastore_cluster_id=datastore_cluster.id,
            type="NFS",
            remote_hosts=["nfs"],
            remote_path="/export/test2")
        ```

        ## Import

        An existing datastore cluster can be imported into this resource

        via the path to the cluster, via the following command:

        [docs-import]: https://developer.hashicorp.com/terraform/cli/import

        ```sh
        $ pulumi import vsphere:index/datastoreCluster:DatastoreCluster datastore_cluster /dc1/datastore/ds-cluster
        ```

        The above would import the datastore cluster named `ds-cluster` that is located

        in the `dc1` datacenter.

        :param str resource_name: The name of the resource.
        :param DatastoreClusterArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DatastoreClusterArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 custom_attributes: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 datacenter_id: Optional[pulumi.Input[builtins.str]] = None,
                 folder: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 sdrs_advanced_options: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 sdrs_automation_level: Optional[pulumi.Input[builtins.str]] = None,
                 sdrs_default_intra_vm_affinity: Optional[pulumi.Input[builtins.bool]] = None,
                 sdrs_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 sdrs_free_space_threshold: Optional[pulumi.Input[builtins.int]] = None,
                 sdrs_free_space_threshold_mode: Optional[pulumi.Input[builtins.str]] = None,
                 sdrs_free_space_utilization_difference: Optional[pulumi.Input[builtins.int]] = None,
                 sdrs_io_balance_automation_level: Optional[pulumi.Input[builtins.str]] = None,
                 sdrs_io_latency_threshold: Optional[pulumi.Input[builtins.int]] = None,
                 sdrs_io_load_balance_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 sdrs_io_load_imbalance_threshold: Optional[pulumi.Input[builtins.int]] = None,
                 sdrs_io_reservable_iops_threshold: Optional[pulumi.Input[builtins.int]] = None,
                 sdrs_io_reservable_percent_threshold: Optional[pulumi.Input[builtins.int]] = None,
                 sdrs_io_reservable_threshold_mode: Optional[pulumi.Input[builtins.str]] = None,
                 sdrs_load_balance_interval: Optional[pulumi.Input[builtins.int]] = None,
                 sdrs_policy_enforcement_automation_level: Optional[pulumi.Input[builtins.str]] = None,
                 sdrs_rule_enforcement_automation_level: Optional[pulumi.Input[builtins.str]] = None,
                 sdrs_space_balance_automation_level: Optional[pulumi.Input[builtins.str]] = None,
                 sdrs_space_utilization_threshold: Optional[pulumi.Input[builtins.int]] = None,
                 sdrs_vm_evacuation_automation_level: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DatastoreClusterArgs.__new__(DatastoreClusterArgs)

            __props__.__dict__["custom_attributes"] = custom_attributes
            if datacenter_id is None and not opts.urn:
                raise TypeError("Missing required property 'datacenter_id'")
            __props__.__dict__["datacenter_id"] = datacenter_id
            __props__.__dict__["folder"] = folder
            __props__.__dict__["name"] = name
            __props__.__dict__["sdrs_advanced_options"] = sdrs_advanced_options
            __props__.__dict__["sdrs_automation_level"] = sdrs_automation_level
            __props__.__dict__["sdrs_default_intra_vm_affinity"] = sdrs_default_intra_vm_affinity
            __props__.__dict__["sdrs_enabled"] = sdrs_enabled
            __props__.__dict__["sdrs_free_space_threshold"] = sdrs_free_space_threshold
            __props__.__dict__["sdrs_free_space_threshold_mode"] = sdrs_free_space_threshold_mode
            __props__.__dict__["sdrs_free_space_utilization_difference"] = sdrs_free_space_utilization_difference
            __props__.__dict__["sdrs_io_balance_automation_level"] = sdrs_io_balance_automation_level
            __props__.__dict__["sdrs_io_latency_threshold"] = sdrs_io_latency_threshold
            __props__.__dict__["sdrs_io_load_balance_enabled"] = sdrs_io_load_balance_enabled
            __props__.__dict__["sdrs_io_load_imbalance_threshold"] = sdrs_io_load_imbalance_threshold
            __props__.__dict__["sdrs_io_reservable_iops_threshold"] = sdrs_io_reservable_iops_threshold
            __props__.__dict__["sdrs_io_reservable_percent_threshold"] = sdrs_io_reservable_percent_threshold
            __props__.__dict__["sdrs_io_reservable_threshold_mode"] = sdrs_io_reservable_threshold_mode
            __props__.__dict__["sdrs_load_balance_interval"] = sdrs_load_balance_interval
            __props__.__dict__["sdrs_policy_enforcement_automation_level"] = sdrs_policy_enforcement_automation_level
            __props__.__dict__["sdrs_rule_enforcement_automation_level"] = sdrs_rule_enforcement_automation_level
            __props__.__dict__["sdrs_space_balance_automation_level"] = sdrs_space_balance_automation_level
            __props__.__dict__["sdrs_space_utilization_threshold"] = sdrs_space_utilization_threshold
            __props__.__dict__["sdrs_vm_evacuation_automation_level"] = sdrs_vm_evacuation_automation_level
            __props__.__dict__["tags"] = tags
        super(DatastoreCluster, __self__).__init__(
            'vsphere:index/datastoreCluster:DatastoreCluster',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            custom_attributes: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            datacenter_id: Optional[pulumi.Input[builtins.str]] = None,
            folder: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            sdrs_advanced_options: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            sdrs_automation_level: Optional[pulumi.Input[builtins.str]] = None,
            sdrs_default_intra_vm_affinity: Optional[pulumi.Input[builtins.bool]] = None,
            sdrs_enabled: Optional[pulumi.Input[builtins.bool]] = None,
            sdrs_free_space_threshold: Optional[pulumi.Input[builtins.int]] = None,
            sdrs_free_space_threshold_mode: Optional[pulumi.Input[builtins.str]] = None,
            sdrs_free_space_utilization_difference: Optional[pulumi.Input[builtins.int]] = None,
            sdrs_io_balance_automation_level: Optional[pulumi.Input[builtins.str]] = None,
            sdrs_io_latency_threshold: Optional[pulumi.Input[builtins.int]] = None,
            sdrs_io_load_balance_enabled: Optional[pulumi.Input[builtins.bool]] = None,
            sdrs_io_load_imbalance_threshold: Optional[pulumi.Input[builtins.int]] = None,
            sdrs_io_reservable_iops_threshold: Optional[pulumi.Input[builtins.int]] = None,
            sdrs_io_reservable_percent_threshold: Optional[pulumi.Input[builtins.int]] = None,
            sdrs_io_reservable_threshold_mode: Optional[pulumi.Input[builtins.str]] = None,
            sdrs_load_balance_interval: Optional[pulumi.Input[builtins.int]] = None,
            sdrs_policy_enforcement_automation_level: Optional[pulumi.Input[builtins.str]] = None,
            sdrs_rule_enforcement_automation_level: Optional[pulumi.Input[builtins.str]] = None,
            sdrs_space_balance_automation_level: Optional[pulumi.Input[builtins.str]] = None,
            sdrs_space_utilization_threshold: Optional[pulumi.Input[builtins.int]] = None,
            sdrs_vm_evacuation_automation_level: Optional[pulumi.Input[builtins.str]] = None,
            tags: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None) -> 'DatastoreCluster':
        """
        Get an existing DatastoreCluster resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] custom_attributes: A map of custom attribute ids to attribute
               value strings to set for the datastore cluster. See
               [here][docs-setting-custom-attributes] for a reference on how to set values
               for custom attributes.
               
               [docs-setting-custom-attributes]: /docs/providers/vsphere/r/custom_attribute.html#using-custom-attributes-in-a-supported-resource
               
               > **NOTE:** Custom attributes are unsupported on direct ESXi connections
               and require vCenter.
        :param pulumi.Input[builtins.str] datacenter_id: The managed object ID of
               the datacenter to create the datastore cluster in. Forces a new resource if
               changed.
        :param pulumi.Input[builtins.str] folder: The relative path to a folder to put this datastore
               cluster in.  This is a path relative to the datacenter you are deploying the
               datastore to.  Example: for the `dc1` datacenter, and a provided `folder` of
               `foo/bar`, The provider will place a datastore cluster named
               `datastore-cluster-test` in a datastore folder located at
               `/dc1/datastore/foo/bar`, with the final inventory path being
               `/dc1/datastore/foo/bar/datastore-cluster-test`.
        :param pulumi.Input[builtins.str] name: The name of the datastore cluster.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] sdrs_advanced_options: Advanced configuration options for storage DRS.
        :param pulumi.Input[builtins.str] sdrs_automation_level: The default automation level for all virtual machines in this storage cluster.
        :param pulumi.Input[builtins.bool] sdrs_default_intra_vm_affinity: When true, storage DRS keeps VMDKs for individual VMs on the same datastore by default.
        :param pulumi.Input[builtins.bool] sdrs_enabled: Enable Storage DRS for this datastore cluster.
               Default: `false`.
        :param pulumi.Input[builtins.int] sdrs_free_space_threshold: The threshold, in GB, that storage DRS uses to make decisions to migrate VMs out of a datastore.
        :param pulumi.Input[builtins.str] sdrs_free_space_threshold_mode: The free space threshold to use. When set to utilization, drs_space_utilization_threshold is used, and when set to
               freeSpace, drs_free_space_threshold is used.
        :param pulumi.Input[builtins.int] sdrs_free_space_utilization_difference: The threshold, in percent, of difference between space utilization in datastores before storage DRS makes decisions to
               balance the space.
        :param pulumi.Input[builtins.str] sdrs_io_balance_automation_level: Overrides the default automation settings when correcting I/O load imbalances.
        :param pulumi.Input[builtins.int] sdrs_io_latency_threshold: The I/O latency threshold, in milliseconds, that storage DRS uses to make recommendations to move disks from this
               datastore.
        :param pulumi.Input[builtins.bool] sdrs_io_load_balance_enabled: Enable I/O load balancing for this datastore cluster.
        :param pulumi.Input[builtins.int] sdrs_io_load_imbalance_threshold: The difference between load in datastores in the cluster before storage DRS makes recommendations to balance the load.
        :param pulumi.Input[builtins.int] sdrs_io_reservable_iops_threshold: The threshold of reservable IOPS of all virtual machines on the datastore before storage DRS makes recommendations to
               move VMs off of a datastore.
        :param pulumi.Input[builtins.int] sdrs_io_reservable_percent_threshold: The threshold, in percent, of actual estimated performance of the datastore (in IOPS) that storage DRS uses to make
               recommendations to move VMs off of a datastore when the total reservable IOPS exceeds the threshold.
        :param pulumi.Input[builtins.str] sdrs_io_reservable_threshold_mode: The reservable IOPS threshold to use, percent in the event of automatic, or manual threshold in the event of manual.
        :param pulumi.Input[builtins.int] sdrs_load_balance_interval: The storage DRS poll interval, in minutes.
        :param pulumi.Input[builtins.str] sdrs_policy_enforcement_automation_level: Overrides the default automation settings when correcting storage and VM policy violations.
        :param pulumi.Input[builtins.str] sdrs_rule_enforcement_automation_level: Overrides the default automation settings when correcting affinity rule violations.
        :param pulumi.Input[builtins.str] sdrs_space_balance_automation_level: Overrides the default automation settings when correcting disk space imbalances.
        :param pulumi.Input[builtins.int] sdrs_space_utilization_threshold: The threshold, in percent of used space, that storage DRS uses to make decisions to migrate VMs out of a datastore.
        :param pulumi.Input[builtins.str] sdrs_vm_evacuation_automation_level: Overrides the default automation settings when generating recommendations for datastore evacuation.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] tags: The IDs of any tags to attach to this resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DatastoreClusterState.__new__(_DatastoreClusterState)

        __props__.__dict__["custom_attributes"] = custom_attributes
        __props__.__dict__["datacenter_id"] = datacenter_id
        __props__.__dict__["folder"] = folder
        __props__.__dict__["name"] = name
        __props__.__dict__["sdrs_advanced_options"] = sdrs_advanced_options
        __props__.__dict__["sdrs_automation_level"] = sdrs_automation_level
        __props__.__dict__["sdrs_default_intra_vm_affinity"] = sdrs_default_intra_vm_affinity
        __props__.__dict__["sdrs_enabled"] = sdrs_enabled
        __props__.__dict__["sdrs_free_space_threshold"] = sdrs_free_space_threshold
        __props__.__dict__["sdrs_free_space_threshold_mode"] = sdrs_free_space_threshold_mode
        __props__.__dict__["sdrs_free_space_utilization_difference"] = sdrs_free_space_utilization_difference
        __props__.__dict__["sdrs_io_balance_automation_level"] = sdrs_io_balance_automation_level
        __props__.__dict__["sdrs_io_latency_threshold"] = sdrs_io_latency_threshold
        __props__.__dict__["sdrs_io_load_balance_enabled"] = sdrs_io_load_balance_enabled
        __props__.__dict__["sdrs_io_load_imbalance_threshold"] = sdrs_io_load_imbalance_threshold
        __props__.__dict__["sdrs_io_reservable_iops_threshold"] = sdrs_io_reservable_iops_threshold
        __props__.__dict__["sdrs_io_reservable_percent_threshold"] = sdrs_io_reservable_percent_threshold
        __props__.__dict__["sdrs_io_reservable_threshold_mode"] = sdrs_io_reservable_threshold_mode
        __props__.__dict__["sdrs_load_balance_interval"] = sdrs_load_balance_interval
        __props__.__dict__["sdrs_policy_enforcement_automation_level"] = sdrs_policy_enforcement_automation_level
        __props__.__dict__["sdrs_rule_enforcement_automation_level"] = sdrs_rule_enforcement_automation_level
        __props__.__dict__["sdrs_space_balance_automation_level"] = sdrs_space_balance_automation_level
        __props__.__dict__["sdrs_space_utilization_threshold"] = sdrs_space_utilization_threshold
        __props__.__dict__["sdrs_vm_evacuation_automation_level"] = sdrs_vm_evacuation_automation_level
        __props__.__dict__["tags"] = tags
        return DatastoreCluster(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="customAttributes")
    def custom_attributes(self) -> pulumi.Output[Optional[Mapping[str, builtins.str]]]:
        """
        A map of custom attribute ids to attribute
        value strings to set for the datastore cluster. See
        [here][docs-setting-custom-attributes] for a reference on how to set values
        for custom attributes.

        [docs-setting-custom-attributes]: /docs/providers/vsphere/r/custom_attribute.html#using-custom-attributes-in-a-supported-resource

        > **NOTE:** Custom attributes are unsupported on direct ESXi connections
        and require vCenter.
        """
        return pulumi.get(self, "custom_attributes")

    @property
    @pulumi.getter(name="datacenterId")
    def datacenter_id(self) -> pulumi.Output[builtins.str]:
        """
        The managed object ID of
        the datacenter to create the datastore cluster in. Forces a new resource if
        changed.
        """
        return pulumi.get(self, "datacenter_id")

    @property
    @pulumi.getter
    def folder(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The relative path to a folder to put this datastore
        cluster in.  This is a path relative to the datacenter you are deploying the
        datastore to.  Example: for the `dc1` datacenter, and a provided `folder` of
        `foo/bar`, The provider will place a datastore cluster named
        `datastore-cluster-test` in a datastore folder located at
        `/dc1/datastore/foo/bar`, with the final inventory path being
        `/dc1/datastore/foo/bar/datastore-cluster-test`.
        """
        return pulumi.get(self, "folder")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        The name of the datastore cluster.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="sdrsAdvancedOptions")
    def sdrs_advanced_options(self) -> pulumi.Output[Optional[Mapping[str, builtins.str]]]:
        """
        Advanced configuration options for storage DRS.
        """
        return pulumi.get(self, "sdrs_advanced_options")

    @property
    @pulumi.getter(name="sdrsAutomationLevel")
    def sdrs_automation_level(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The default automation level for all virtual machines in this storage cluster.
        """
        return pulumi.get(self, "sdrs_automation_level")

    @property
    @pulumi.getter(name="sdrsDefaultIntraVmAffinity")
    def sdrs_default_intra_vm_affinity(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        When true, storage DRS keeps VMDKs for individual VMs on the same datastore by default.
        """
        return pulumi.get(self, "sdrs_default_intra_vm_affinity")

    @property
    @pulumi.getter(name="sdrsEnabled")
    def sdrs_enabled(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Enable Storage DRS for this datastore cluster.
        Default: `false`.
        """
        return pulumi.get(self, "sdrs_enabled")

    @property
    @pulumi.getter(name="sdrsFreeSpaceThreshold")
    def sdrs_free_space_threshold(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        The threshold, in GB, that storage DRS uses to make decisions to migrate VMs out of a datastore.
        """
        return pulumi.get(self, "sdrs_free_space_threshold")

    @property
    @pulumi.getter(name="sdrsFreeSpaceThresholdMode")
    def sdrs_free_space_threshold_mode(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The free space threshold to use. When set to utilization, drs_space_utilization_threshold is used, and when set to
        freeSpace, drs_free_space_threshold is used.
        """
        return pulumi.get(self, "sdrs_free_space_threshold_mode")

    @property
    @pulumi.getter(name="sdrsFreeSpaceUtilizationDifference")
    def sdrs_free_space_utilization_difference(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        The threshold, in percent, of difference between space utilization in datastores before storage DRS makes decisions to
        balance the space.
        """
        return pulumi.get(self, "sdrs_free_space_utilization_difference")

    @property
    @pulumi.getter(name="sdrsIoBalanceAutomationLevel")
    def sdrs_io_balance_automation_level(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Overrides the default automation settings when correcting I/O load imbalances.
        """
        return pulumi.get(self, "sdrs_io_balance_automation_level")

    @property
    @pulumi.getter(name="sdrsIoLatencyThreshold")
    def sdrs_io_latency_threshold(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        The I/O latency threshold, in milliseconds, that storage DRS uses to make recommendations to move disks from this
        datastore.
        """
        return pulumi.get(self, "sdrs_io_latency_threshold")

    @property
    @pulumi.getter(name="sdrsIoLoadBalanceEnabled")
    def sdrs_io_load_balance_enabled(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Enable I/O load balancing for this datastore cluster.
        """
        return pulumi.get(self, "sdrs_io_load_balance_enabled")

    @property
    @pulumi.getter(name="sdrsIoLoadImbalanceThreshold")
    def sdrs_io_load_imbalance_threshold(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        The difference between load in datastores in the cluster before storage DRS makes recommendations to balance the load.
        """
        return pulumi.get(self, "sdrs_io_load_imbalance_threshold")

    @property
    @pulumi.getter(name="sdrsIoReservableIopsThreshold")
    def sdrs_io_reservable_iops_threshold(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        The threshold of reservable IOPS of all virtual machines on the datastore before storage DRS makes recommendations to
        move VMs off of a datastore.
        """
        return pulumi.get(self, "sdrs_io_reservable_iops_threshold")

    @property
    @pulumi.getter(name="sdrsIoReservablePercentThreshold")
    def sdrs_io_reservable_percent_threshold(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        The threshold, in percent, of actual estimated performance of the datastore (in IOPS) that storage DRS uses to make
        recommendations to move VMs off of a datastore when the total reservable IOPS exceeds the threshold.
        """
        return pulumi.get(self, "sdrs_io_reservable_percent_threshold")

    @property
    @pulumi.getter(name="sdrsIoReservableThresholdMode")
    def sdrs_io_reservable_threshold_mode(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The reservable IOPS threshold to use, percent in the event of automatic, or manual threshold in the event of manual.
        """
        return pulumi.get(self, "sdrs_io_reservable_threshold_mode")

    @property
    @pulumi.getter(name="sdrsLoadBalanceInterval")
    def sdrs_load_balance_interval(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        The storage DRS poll interval, in minutes.
        """
        return pulumi.get(self, "sdrs_load_balance_interval")

    @property
    @pulumi.getter(name="sdrsPolicyEnforcementAutomationLevel")
    def sdrs_policy_enforcement_automation_level(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Overrides the default automation settings when correcting storage and VM policy violations.
        """
        return pulumi.get(self, "sdrs_policy_enforcement_automation_level")

    @property
    @pulumi.getter(name="sdrsRuleEnforcementAutomationLevel")
    def sdrs_rule_enforcement_automation_level(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Overrides the default automation settings when correcting affinity rule violations.
        """
        return pulumi.get(self, "sdrs_rule_enforcement_automation_level")

    @property
    @pulumi.getter(name="sdrsSpaceBalanceAutomationLevel")
    def sdrs_space_balance_automation_level(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Overrides the default automation settings when correcting disk space imbalances.
        """
        return pulumi.get(self, "sdrs_space_balance_automation_level")

    @property
    @pulumi.getter(name="sdrsSpaceUtilizationThreshold")
    def sdrs_space_utilization_threshold(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        The threshold, in percent of used space, that storage DRS uses to make decisions to migrate VMs out of a datastore.
        """
        return pulumi.get(self, "sdrs_space_utilization_threshold")

    @property
    @pulumi.getter(name="sdrsVmEvacuationAutomationLevel")
    def sdrs_vm_evacuation_automation_level(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Overrides the default automation settings when generating recommendations for datastore evacuation.
        """
        return pulumi.get(self, "sdrs_vm_evacuation_automation_level")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence[builtins.str]]]:
        """
        The IDs of any tags to attach to this resource.
        """
        return pulumi.get(self, "tags")

