# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['DatastoreClusterVmAntiAffinityRuleArgs', 'DatastoreClusterVmAntiAffinityRule']

@pulumi.input_type
class DatastoreClusterVmAntiAffinityRuleArgs:
    def __init__(__self__, *,
                 datastore_cluster_id: pulumi.Input[builtins.str],
                 virtual_machine_ids: pulumi.Input[Sequence[pulumi.Input[builtins.str]]],
                 enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 mandatory: Optional[pulumi.Input[builtins.bool]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a DatastoreClusterVmAntiAffinityRule resource.
        :param pulumi.Input[builtins.str] datastore_cluster_id: The managed object reference
               ID of the datastore cluster to put the group in.  Forces
               a new resource if changed.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] virtual_machine_ids: The UUIDs of the virtual machines to run
               on different datastores from each other.
               
               > **NOTE:** The minimum length of `virtual_machine_ids` is 2.
        :param pulumi.Input[builtins.bool] enabled: Enable this rule in the cluster. Default: `true`.
        :param pulumi.Input[builtins.bool] mandatory: When this value is `true`, prevents any virtual
               machine operations that may violate this rule. Default: `false`.
        :param pulumi.Input[builtins.str] name: The name of the rule. This must be unique in the cluster.
        """
        pulumi.set(__self__, "datastore_cluster_id", datastore_cluster_id)
        pulumi.set(__self__, "virtual_machine_ids", virtual_machine_ids)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if mandatory is not None:
            pulumi.set(__self__, "mandatory", mandatory)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="datastoreClusterId")
    def datastore_cluster_id(self) -> pulumi.Input[builtins.str]:
        """
        The managed object reference
        ID of the datastore cluster to put the group in.  Forces
        a new resource if changed.
        """
        return pulumi.get(self, "datastore_cluster_id")

    @datastore_cluster_id.setter
    def datastore_cluster_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "datastore_cluster_id", value)

    @property
    @pulumi.getter(name="virtualMachineIds")
    def virtual_machine_ids(self) -> pulumi.Input[Sequence[pulumi.Input[builtins.str]]]:
        """
        The UUIDs of the virtual machines to run
        on different datastores from each other.

        > **NOTE:** The minimum length of `virtual_machine_ids` is 2.
        """
        return pulumi.get(self, "virtual_machine_ids")

    @virtual_machine_ids.setter
    def virtual_machine_ids(self, value: pulumi.Input[Sequence[pulumi.Input[builtins.str]]]):
        pulumi.set(self, "virtual_machine_ids", value)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Enable this rule in the cluster. Default: `true`.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter
    def mandatory(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        When this value is `true`, prevents any virtual
        machine operations that may violate this rule. Default: `false`.
        """
        return pulumi.get(self, "mandatory")

    @mandatory.setter
    def mandatory(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "mandatory", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the rule. This must be unique in the cluster.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _DatastoreClusterVmAntiAffinityRuleState:
    def __init__(__self__, *,
                 datastore_cluster_id: Optional[pulumi.Input[builtins.str]] = None,
                 enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 mandatory: Optional[pulumi.Input[builtins.bool]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 virtual_machine_ids: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering DatastoreClusterVmAntiAffinityRule resources.
        :param pulumi.Input[builtins.str] datastore_cluster_id: The managed object reference
               ID of the datastore cluster to put the group in.  Forces
               a new resource if changed.
        :param pulumi.Input[builtins.bool] enabled: Enable this rule in the cluster. Default: `true`.
        :param pulumi.Input[builtins.bool] mandatory: When this value is `true`, prevents any virtual
               machine operations that may violate this rule. Default: `false`.
        :param pulumi.Input[builtins.str] name: The name of the rule. This must be unique in the cluster.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] virtual_machine_ids: The UUIDs of the virtual machines to run
               on different datastores from each other.
               
               > **NOTE:** The minimum length of `virtual_machine_ids` is 2.
        """
        if datastore_cluster_id is not None:
            pulumi.set(__self__, "datastore_cluster_id", datastore_cluster_id)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if mandatory is not None:
            pulumi.set(__self__, "mandatory", mandatory)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if virtual_machine_ids is not None:
            pulumi.set(__self__, "virtual_machine_ids", virtual_machine_ids)

    @property
    @pulumi.getter(name="datastoreClusterId")
    def datastore_cluster_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The managed object reference
        ID of the datastore cluster to put the group in.  Forces
        a new resource if changed.
        """
        return pulumi.get(self, "datastore_cluster_id")

    @datastore_cluster_id.setter
    def datastore_cluster_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "datastore_cluster_id", value)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Enable this rule in the cluster. Default: `true`.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter
    def mandatory(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        When this value is `true`, prevents any virtual
        machine operations that may violate this rule. Default: `false`.
        """
        return pulumi.get(self, "mandatory")

    @mandatory.setter
    def mandatory(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "mandatory", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the rule. This must be unique in the cluster.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="virtualMachineIds")
    def virtual_machine_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        The UUIDs of the virtual machines to run
        on different datastores from each other.

        > **NOTE:** The minimum length of `virtual_machine_ids` is 2.
        """
        return pulumi.get(self, "virtual_machine_ids")

    @virtual_machine_ids.setter
    def virtual_machine_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "virtual_machine_ids", value)


@pulumi.type_token("vsphere:index/datastoreClusterVmAntiAffinityRule:DatastoreClusterVmAntiAffinityRule")
class DatastoreClusterVmAntiAffinityRule(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 datastore_cluster_id: Optional[pulumi.Input[builtins.str]] = None,
                 enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 mandatory: Optional[pulumi.Input[builtins.bool]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 virtual_machine_ids: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 __props__=None):
        """
        The `DatastoreClusterVmAntiAffinityRule` resource can be used to
        manage VM anti-affinity rules in a datastore cluster, either created by the
        `DatastoreCluster` resource or looked up
        by the `DatastoreCluster` data source.

        This rule can be used to tell a set to virtual machines to run on different
        datastores within a cluster, useful for preventing single points of failure in
        application cluster scenarios. When configured, Storage DRS will make a best effort to
        ensure that the virtual machines run on different datastores, or prevent any
        operation that would keep that from happening, depending on the value of the
        `mandatory` flag.

        > **NOTE:** This resource requires vCenter and is not available on direct ESXi
        connections.

        > **NOTE:** Storage DRS requires a vSphere Enterprise Plus license.

        ## Example Usage

        The example below creates two virtual machines in a cluster using the
        `VirtualMachine` resource, creating the
        virtual machines in the datastore cluster looked up by the
        `DatastoreCluster` data
        source. It then creates an anti-affinity rule for these two virtual machines,
        ensuring they will run on different datastores whenever possible.

        ```python
        import pulumi
        import pulumi_vsphere as vsphere

        datacenter = vsphere.get_datacenter(name="dc-01")
        datastore_cluster = vsphere.get_datastore_cluster(name="datastore-cluster1",
            datacenter_id=datacenter.id)
        cluster = vsphere.get_compute_cluster(name="cluster-01",
            datacenter_id=datacenter.id)
        network = vsphere.get_network(name="network1",
            datacenter_id=datacenter.id)
        vm = []
        for range in [{"value": i} for i in range(0, 2)]:
            vm.append(vsphere.VirtualMachine(f"vm-{range['value']}",
                name=f"test-{range['value']}",
                resource_pool_id=cluster.resource_pool_id,
                datastore_cluster_id=datastore_cluster.id,
                num_cpus=2,
                memory=2048,
                guest_id="otherLinux64Guest",
                network_interfaces=[{
                    "network_id": network.id,
                }],
                disks=[{
                    "label": "disk0",
                    "size": 20,
                }]))
        cluster_vm_anti_affinity_rule = vsphere.DatastoreClusterVmAntiAffinityRule("cluster_vm_anti_affinity_rule",
            name="test-datastore-cluster-vm-anti-affinity-rule",
            datastore_cluster_id=datastore_cluster.id,
            virtual_machine_ids=[[__item.id for __item in vm]])
        ```

        ## Import

        An existing rule can be imported into this resource by supplying

        both the path to the cluster, and the name the rule. If the name or cluster is

        not found, or if the rule is of a different type, an error will be returned. An

        example is below:

        [docs-import]: https://developer.hashicorp.com/terraform/cli/import

        ```sh
        $ pulumi import vsphere:index/datastoreClusterVmAntiAffinityRule:DatastoreClusterVmAntiAffinityRule cluster_vm_anti_affinity_rule \\
        ```

          '{"compute_cluster_path": "/dc1/datastore/cluster1", \\

          "name": "pulumi-test-datastore-cluster-vm-anti-affinity-rule"}'

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] datastore_cluster_id: The managed object reference
               ID of the datastore cluster to put the group in.  Forces
               a new resource if changed.
        :param pulumi.Input[builtins.bool] enabled: Enable this rule in the cluster. Default: `true`.
        :param pulumi.Input[builtins.bool] mandatory: When this value is `true`, prevents any virtual
               machine operations that may violate this rule. Default: `false`.
        :param pulumi.Input[builtins.str] name: The name of the rule. This must be unique in the cluster.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] virtual_machine_ids: The UUIDs of the virtual machines to run
               on different datastores from each other.
               
               > **NOTE:** The minimum length of `virtual_machine_ids` is 2.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DatastoreClusterVmAntiAffinityRuleArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        The `DatastoreClusterVmAntiAffinityRule` resource can be used to
        manage VM anti-affinity rules in a datastore cluster, either created by the
        `DatastoreCluster` resource or looked up
        by the `DatastoreCluster` data source.

        This rule can be used to tell a set to virtual machines to run on different
        datastores within a cluster, useful for preventing single points of failure in
        application cluster scenarios. When configured, Storage DRS will make a best effort to
        ensure that the virtual machines run on different datastores, or prevent any
        operation that would keep that from happening, depending on the value of the
        `mandatory` flag.

        > **NOTE:** This resource requires vCenter and is not available on direct ESXi
        connections.

        > **NOTE:** Storage DRS requires a vSphere Enterprise Plus license.

        ## Example Usage

        The example below creates two virtual machines in a cluster using the
        `VirtualMachine` resource, creating the
        virtual machines in the datastore cluster looked up by the
        `DatastoreCluster` data
        source. It then creates an anti-affinity rule for these two virtual machines,
        ensuring they will run on different datastores whenever possible.

        ```python
        import pulumi
        import pulumi_vsphere as vsphere

        datacenter = vsphere.get_datacenter(name="dc-01")
        datastore_cluster = vsphere.get_datastore_cluster(name="datastore-cluster1",
            datacenter_id=datacenter.id)
        cluster = vsphere.get_compute_cluster(name="cluster-01",
            datacenter_id=datacenter.id)
        network = vsphere.get_network(name="network1",
            datacenter_id=datacenter.id)
        vm = []
        for range in [{"value": i} for i in range(0, 2)]:
            vm.append(vsphere.VirtualMachine(f"vm-{range['value']}",
                name=f"test-{range['value']}",
                resource_pool_id=cluster.resource_pool_id,
                datastore_cluster_id=datastore_cluster.id,
                num_cpus=2,
                memory=2048,
                guest_id="otherLinux64Guest",
                network_interfaces=[{
                    "network_id": network.id,
                }],
                disks=[{
                    "label": "disk0",
                    "size": 20,
                }]))
        cluster_vm_anti_affinity_rule = vsphere.DatastoreClusterVmAntiAffinityRule("cluster_vm_anti_affinity_rule",
            name="test-datastore-cluster-vm-anti-affinity-rule",
            datastore_cluster_id=datastore_cluster.id,
            virtual_machine_ids=[[__item.id for __item in vm]])
        ```

        ## Import

        An existing rule can be imported into this resource by supplying

        both the path to the cluster, and the name the rule. If the name or cluster is

        not found, or if the rule is of a different type, an error will be returned. An

        example is below:

        [docs-import]: https://developer.hashicorp.com/terraform/cli/import

        ```sh
        $ pulumi import vsphere:index/datastoreClusterVmAntiAffinityRule:DatastoreClusterVmAntiAffinityRule cluster_vm_anti_affinity_rule \\
        ```

          '{"compute_cluster_path": "/dc1/datastore/cluster1", \\

          "name": "pulumi-test-datastore-cluster-vm-anti-affinity-rule"}'

        :param str resource_name: The name of the resource.
        :param DatastoreClusterVmAntiAffinityRuleArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DatastoreClusterVmAntiAffinityRuleArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 datastore_cluster_id: Optional[pulumi.Input[builtins.str]] = None,
                 enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 mandatory: Optional[pulumi.Input[builtins.bool]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 virtual_machine_ids: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DatastoreClusterVmAntiAffinityRuleArgs.__new__(DatastoreClusterVmAntiAffinityRuleArgs)

            if datastore_cluster_id is None and not opts.urn:
                raise TypeError("Missing required property 'datastore_cluster_id'")
            __props__.__dict__["datastore_cluster_id"] = datastore_cluster_id
            __props__.__dict__["enabled"] = enabled
            __props__.__dict__["mandatory"] = mandatory
            __props__.__dict__["name"] = name
            if virtual_machine_ids is None and not opts.urn:
                raise TypeError("Missing required property 'virtual_machine_ids'")
            __props__.__dict__["virtual_machine_ids"] = virtual_machine_ids
        super(DatastoreClusterVmAntiAffinityRule, __self__).__init__(
            'vsphere:index/datastoreClusterVmAntiAffinityRule:DatastoreClusterVmAntiAffinityRule',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            datastore_cluster_id: Optional[pulumi.Input[builtins.str]] = None,
            enabled: Optional[pulumi.Input[builtins.bool]] = None,
            mandatory: Optional[pulumi.Input[builtins.bool]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            virtual_machine_ids: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None) -> 'DatastoreClusterVmAntiAffinityRule':
        """
        Get an existing DatastoreClusterVmAntiAffinityRule resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] datastore_cluster_id: The managed object reference
               ID of the datastore cluster to put the group in.  Forces
               a new resource if changed.
        :param pulumi.Input[builtins.bool] enabled: Enable this rule in the cluster. Default: `true`.
        :param pulumi.Input[builtins.bool] mandatory: When this value is `true`, prevents any virtual
               machine operations that may violate this rule. Default: `false`.
        :param pulumi.Input[builtins.str] name: The name of the rule. This must be unique in the cluster.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] virtual_machine_ids: The UUIDs of the virtual machines to run
               on different datastores from each other.
               
               > **NOTE:** The minimum length of `virtual_machine_ids` is 2.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DatastoreClusterVmAntiAffinityRuleState.__new__(_DatastoreClusterVmAntiAffinityRuleState)

        __props__.__dict__["datastore_cluster_id"] = datastore_cluster_id
        __props__.__dict__["enabled"] = enabled
        __props__.__dict__["mandatory"] = mandatory
        __props__.__dict__["name"] = name
        __props__.__dict__["virtual_machine_ids"] = virtual_machine_ids
        return DatastoreClusterVmAntiAffinityRule(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="datastoreClusterId")
    def datastore_cluster_id(self) -> pulumi.Output[builtins.str]:
        """
        The managed object reference
        ID of the datastore cluster to put the group in.  Forces
        a new resource if changed.
        """
        return pulumi.get(self, "datastore_cluster_id")

    @property
    @pulumi.getter
    def enabled(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Enable this rule in the cluster. Default: `true`.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter
    def mandatory(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        When this value is `true`, prevents any virtual
        machine operations that may violate this rule. Default: `false`.
        """
        return pulumi.get(self, "mandatory")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        The name of the rule. This must be unique in the cluster.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="virtualMachineIds")
    def virtual_machine_ids(self) -> pulumi.Output[Sequence[builtins.str]]:
        """
        The UUIDs of the virtual machines to run
        on different datastores from each other.

        > **NOTE:** The minimum length of `virtual_machine_ids` is 2.
        """
        return pulumi.get(self, "virtual_machine_ids")

