# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['FolderArgs', 'Folder']

@pulumi.input_type
class FolderArgs:
    def __init__(__self__, *,
                 path: pulumi.Input[builtins.str],
                 type: pulumi.Input[builtins.str],
                 custom_attributes: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 datacenter_id: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None):
        """
        The set of arguments for constructing a Folder resource.
        :param pulumi.Input[builtins.str] path: The path of the folder to be created. This is relative to
               the root of the type of folder you are creating, and the supplied datacenter.
               For example, given a default datacenter of `default-dc`, a folder of type
               `vm` (denoting a virtual machine folder), and a supplied folder of
               `test-folder`, the resulting path would be
               `/default-dc/vm/test-folder`.
               
               > **NOTE:** `path` can be modified - the resulting behavior is dependent on
               what section of `path` you are modifying. If you are modifying the parent (so
               any part before the last `/`), your folder will be moved to that new parent. If
               modifying the name (the part after the last `/`), your folder will be renamed.
        :param pulumi.Input[builtins.str] type: The type of folder to create. Allowed options are
               `datacenter` for datacenter folders, `host` for host and cluster folders,
               `vm` for virtual machine folders, `datastore` for datastore folders, and
               `network` for network folders. Forces a new resource if changed.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] custom_attributes: Map of custom attribute ids to attribute
               value strings to set for folder. See [here][docs-setting-custom-attributes]
               for a reference on how to set values for custom attributes.
               
               [docs-setting-custom-attributes]: /docs/providers/vsphere/r/custom_attribute.html#using-custom-attributes-in-a-supported-resource
               
               > **NOTE:** Custom attributes are unsupported on direct ESXi connections
               and require vCenter.
        :param pulumi.Input[builtins.str] datacenter_id: The ID of the datacenter the folder will be created in.
               Required for all folder types except for datacenter folders. Forces a new
               resource if changed.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] tags: The IDs of any tags to attach to this resource.
        """
        pulumi.set(__self__, "path", path)
        pulumi.set(__self__, "type", type)
        if custom_attributes is not None:
            pulumi.set(__self__, "custom_attributes", custom_attributes)
        if datacenter_id is not None:
            pulumi.set(__self__, "datacenter_id", datacenter_id)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def path(self) -> pulumi.Input[builtins.str]:
        """
        The path of the folder to be created. This is relative to
        the root of the type of folder you are creating, and the supplied datacenter.
        For example, given a default datacenter of `default-dc`, a folder of type
        `vm` (denoting a virtual machine folder), and a supplied folder of
        `test-folder`, the resulting path would be
        `/default-dc/vm/test-folder`.

        > **NOTE:** `path` can be modified - the resulting behavior is dependent on
        what section of `path` you are modifying. If you are modifying the parent (so
        any part before the last `/`), your folder will be moved to that new parent. If
        modifying the name (the part after the last `/`), your folder will be renamed.
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "path", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[builtins.str]:
        """
        The type of folder to create. Allowed options are
        `datacenter` for datacenter folders, `host` for host and cluster folders,
        `vm` for virtual machine folders, `datastore` for datastore folders, and
        `network` for network folders. Forces a new resource if changed.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="customAttributes")
    def custom_attributes(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Map of custom attribute ids to attribute
        value strings to set for folder. See [here][docs-setting-custom-attributes]
        for a reference on how to set values for custom attributes.

        [docs-setting-custom-attributes]: /docs/providers/vsphere/r/custom_attribute.html#using-custom-attributes-in-a-supported-resource

        > **NOTE:** Custom attributes are unsupported on direct ESXi connections
        and require vCenter.
        """
        return pulumi.get(self, "custom_attributes")

    @custom_attributes.setter
    def custom_attributes(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "custom_attributes", value)

    @property
    @pulumi.getter(name="datacenterId")
    def datacenter_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the datacenter the folder will be created in.
        Required for all folder types except for datacenter folders. Forces a new
        resource if changed.
        """
        return pulumi.get(self, "datacenter_id")

    @datacenter_id.setter
    def datacenter_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "datacenter_id", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        The IDs of any tags to attach to this resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _FolderState:
    def __init__(__self__, *,
                 custom_attributes: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 datacenter_id: Optional[pulumi.Input[builtins.str]] = None,
                 path: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 type: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering Folder resources.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] custom_attributes: Map of custom attribute ids to attribute
               value strings to set for folder. See [here][docs-setting-custom-attributes]
               for a reference on how to set values for custom attributes.
               
               [docs-setting-custom-attributes]: /docs/providers/vsphere/r/custom_attribute.html#using-custom-attributes-in-a-supported-resource
               
               > **NOTE:** Custom attributes are unsupported on direct ESXi connections
               and require vCenter.
        :param pulumi.Input[builtins.str] datacenter_id: The ID of the datacenter the folder will be created in.
               Required for all folder types except for datacenter folders. Forces a new
               resource if changed.
        :param pulumi.Input[builtins.str] path: The path of the folder to be created. This is relative to
               the root of the type of folder you are creating, and the supplied datacenter.
               For example, given a default datacenter of `default-dc`, a folder of type
               `vm` (denoting a virtual machine folder), and a supplied folder of
               `test-folder`, the resulting path would be
               `/default-dc/vm/test-folder`.
               
               > **NOTE:** `path` can be modified - the resulting behavior is dependent on
               what section of `path` you are modifying. If you are modifying the parent (so
               any part before the last `/`), your folder will be moved to that new parent. If
               modifying the name (the part after the last `/`), your folder will be renamed.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] tags: The IDs of any tags to attach to this resource.
        :param pulumi.Input[builtins.str] type: The type of folder to create. Allowed options are
               `datacenter` for datacenter folders, `host` for host and cluster folders,
               `vm` for virtual machine folders, `datastore` for datastore folders, and
               `network` for network folders. Forces a new resource if changed.
        """
        if custom_attributes is not None:
            pulumi.set(__self__, "custom_attributes", custom_attributes)
        if datacenter_id is not None:
            pulumi.set(__self__, "datacenter_id", datacenter_id)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="customAttributes")
    def custom_attributes(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Map of custom attribute ids to attribute
        value strings to set for folder. See [here][docs-setting-custom-attributes]
        for a reference on how to set values for custom attributes.

        [docs-setting-custom-attributes]: /docs/providers/vsphere/r/custom_attribute.html#using-custom-attributes-in-a-supported-resource

        > **NOTE:** Custom attributes are unsupported on direct ESXi connections
        and require vCenter.
        """
        return pulumi.get(self, "custom_attributes")

    @custom_attributes.setter
    def custom_attributes(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "custom_attributes", value)

    @property
    @pulumi.getter(name="datacenterId")
    def datacenter_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the datacenter the folder will be created in.
        Required for all folder types except for datacenter folders. Forces a new
        resource if changed.
        """
        return pulumi.get(self, "datacenter_id")

    @datacenter_id.setter
    def datacenter_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "datacenter_id", value)

    @property
    @pulumi.getter
    def path(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The path of the folder to be created. This is relative to
        the root of the type of folder you are creating, and the supplied datacenter.
        For example, given a default datacenter of `default-dc`, a folder of type
        `vm` (denoting a virtual machine folder), and a supplied folder of
        `test-folder`, the resulting path would be
        `/default-dc/vm/test-folder`.

        > **NOTE:** `path` can be modified - the resulting behavior is dependent on
        what section of `path` you are modifying. If you are modifying the parent (so
        any part before the last `/`), your folder will be moved to that new parent. If
        modifying the name (the part after the last `/`), your folder will be renamed.
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "path", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        The IDs of any tags to attach to this resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The type of folder to create. Allowed options are
        `datacenter` for datacenter folders, `host` for host and cluster folders,
        `vm` for virtual machine folders, `datastore` for datastore folders, and
        `network` for network folders. Forces a new resource if changed.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "type", value)


@pulumi.type_token("vsphere:index/folder:Folder")
class Folder(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 custom_attributes: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 datacenter_id: Optional[pulumi.Input[builtins.str]] = None,
                 path: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 type: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        The `Folder` resource can be used to manage vSphere inventory folders.
        The resource supports creating folders of the 5 major types - datacenter
        folders, host and cluster folders, virtual machine folders, storage folders,
        and network folders.

        Paths are always relative to the specific type of folder you are creating.
        A subfolder is discovered by parsing the relative path specified in `path`, so
        `foo/bar` will create a folder named `bar` in the parent folder `foo`, as long
        as the folder `foo` exists.

        ## Example Usage

        The basic example below creates a virtual machine folder named
        `test-folder` in the default datacenter's VM hierarchy.

        ```python
        import pulumi
        import pulumi_vsphere as vsphere

        datacenter = vsphere.get_datacenter(name=vsphere_datacenter)
        folder = vsphere.Folder("folder",
            path="test-folder",
            type="vm",
            datacenter_id=datacenter.id)
        ```

        ### Example with Sub-folders

        The below example builds off of the above by first creating a folder named
        `test-parent`, and then locating `test-folder` in that
        folder. To ensure the parent is created first, we create an interpolation
        dependency off the parent's `path` attribute.

        Note that if you change parents (for example, went from the above basic
        configuration to this one), your folder will be moved to be under the correct
        parent.

        ```python
        import pulumi
        import pulumi_vsphere as vsphere

        datacenter = vsphere.get_datacenter(name=vsphere_datacenter)
        parent = vsphere.Folder("parent",
            path="test-parent",
            type="vm",
            datacenter_id=datacenter.id)
        folder = vsphere.Folder("folder",
            path=parent.path.apply(lambda path: f"{path}/test-folder"),
            type="vm",
            datacenter_id=datacenter.id)
        ```

        ## Import

        An existing folder can be imported into this resource via

        its full path, via the following command:

        [docs-import]: https://developer.hashicorp.com/terraform/cli/import

        ```sh
        $ pulumi import vsphere:index/folder:Folder folder /default-dc/vm/example-vm-folder
        ```

        The above command would import the folder from our examples above, the VM

        folder named `example-vm-folder` located in the datacenter named

        `default-dc`.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] custom_attributes: Map of custom attribute ids to attribute
               value strings to set for folder. See [here][docs-setting-custom-attributes]
               for a reference on how to set values for custom attributes.
               
               [docs-setting-custom-attributes]: /docs/providers/vsphere/r/custom_attribute.html#using-custom-attributes-in-a-supported-resource
               
               > **NOTE:** Custom attributes are unsupported on direct ESXi connections
               and require vCenter.
        :param pulumi.Input[builtins.str] datacenter_id: The ID of the datacenter the folder will be created in.
               Required for all folder types except for datacenter folders. Forces a new
               resource if changed.
        :param pulumi.Input[builtins.str] path: The path of the folder to be created. This is relative to
               the root of the type of folder you are creating, and the supplied datacenter.
               For example, given a default datacenter of `default-dc`, a folder of type
               `vm` (denoting a virtual machine folder), and a supplied folder of
               `test-folder`, the resulting path would be
               `/default-dc/vm/test-folder`.
               
               > **NOTE:** `path` can be modified - the resulting behavior is dependent on
               what section of `path` you are modifying. If you are modifying the parent (so
               any part before the last `/`), your folder will be moved to that new parent. If
               modifying the name (the part after the last `/`), your folder will be renamed.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] tags: The IDs of any tags to attach to this resource.
        :param pulumi.Input[builtins.str] type: The type of folder to create. Allowed options are
               `datacenter` for datacenter folders, `host` for host and cluster folders,
               `vm` for virtual machine folders, `datastore` for datastore folders, and
               `network` for network folders. Forces a new resource if changed.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: FolderArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        The `Folder` resource can be used to manage vSphere inventory folders.
        The resource supports creating folders of the 5 major types - datacenter
        folders, host and cluster folders, virtual machine folders, storage folders,
        and network folders.

        Paths are always relative to the specific type of folder you are creating.
        A subfolder is discovered by parsing the relative path specified in `path`, so
        `foo/bar` will create a folder named `bar` in the parent folder `foo`, as long
        as the folder `foo` exists.

        ## Example Usage

        The basic example below creates a virtual machine folder named
        `test-folder` in the default datacenter's VM hierarchy.

        ```python
        import pulumi
        import pulumi_vsphere as vsphere

        datacenter = vsphere.get_datacenter(name=vsphere_datacenter)
        folder = vsphere.Folder("folder",
            path="test-folder",
            type="vm",
            datacenter_id=datacenter.id)
        ```

        ### Example with Sub-folders

        The below example builds off of the above by first creating a folder named
        `test-parent`, and then locating `test-folder` in that
        folder. To ensure the parent is created first, we create an interpolation
        dependency off the parent's `path` attribute.

        Note that if you change parents (for example, went from the above basic
        configuration to this one), your folder will be moved to be under the correct
        parent.

        ```python
        import pulumi
        import pulumi_vsphere as vsphere

        datacenter = vsphere.get_datacenter(name=vsphere_datacenter)
        parent = vsphere.Folder("parent",
            path="test-parent",
            type="vm",
            datacenter_id=datacenter.id)
        folder = vsphere.Folder("folder",
            path=parent.path.apply(lambda path: f"{path}/test-folder"),
            type="vm",
            datacenter_id=datacenter.id)
        ```

        ## Import

        An existing folder can be imported into this resource via

        its full path, via the following command:

        [docs-import]: https://developer.hashicorp.com/terraform/cli/import

        ```sh
        $ pulumi import vsphere:index/folder:Folder folder /default-dc/vm/example-vm-folder
        ```

        The above command would import the folder from our examples above, the VM

        folder named `example-vm-folder` located in the datacenter named

        `default-dc`.

        :param str resource_name: The name of the resource.
        :param FolderArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(FolderArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 custom_attributes: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 datacenter_id: Optional[pulumi.Input[builtins.str]] = None,
                 path: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 type: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = FolderArgs.__new__(FolderArgs)

            __props__.__dict__["custom_attributes"] = custom_attributes
            __props__.__dict__["datacenter_id"] = datacenter_id
            if path is None and not opts.urn:
                raise TypeError("Missing required property 'path'")
            __props__.__dict__["path"] = path
            __props__.__dict__["tags"] = tags
            if type is None and not opts.urn:
                raise TypeError("Missing required property 'type'")
            __props__.__dict__["type"] = type
        super(Folder, __self__).__init__(
            'vsphere:index/folder:Folder',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            custom_attributes: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            datacenter_id: Optional[pulumi.Input[builtins.str]] = None,
            path: Optional[pulumi.Input[builtins.str]] = None,
            tags: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            type: Optional[pulumi.Input[builtins.str]] = None) -> 'Folder':
        """
        Get an existing Folder resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] custom_attributes: Map of custom attribute ids to attribute
               value strings to set for folder. See [here][docs-setting-custom-attributes]
               for a reference on how to set values for custom attributes.
               
               [docs-setting-custom-attributes]: /docs/providers/vsphere/r/custom_attribute.html#using-custom-attributes-in-a-supported-resource
               
               > **NOTE:** Custom attributes are unsupported on direct ESXi connections
               and require vCenter.
        :param pulumi.Input[builtins.str] datacenter_id: The ID of the datacenter the folder will be created in.
               Required for all folder types except for datacenter folders. Forces a new
               resource if changed.
        :param pulumi.Input[builtins.str] path: The path of the folder to be created. This is relative to
               the root of the type of folder you are creating, and the supplied datacenter.
               For example, given a default datacenter of `default-dc`, a folder of type
               `vm` (denoting a virtual machine folder), and a supplied folder of
               `test-folder`, the resulting path would be
               `/default-dc/vm/test-folder`.
               
               > **NOTE:** `path` can be modified - the resulting behavior is dependent on
               what section of `path` you are modifying. If you are modifying the parent (so
               any part before the last `/`), your folder will be moved to that new parent. If
               modifying the name (the part after the last `/`), your folder will be renamed.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] tags: The IDs of any tags to attach to this resource.
        :param pulumi.Input[builtins.str] type: The type of folder to create. Allowed options are
               `datacenter` for datacenter folders, `host` for host and cluster folders,
               `vm` for virtual machine folders, `datastore` for datastore folders, and
               `network` for network folders. Forces a new resource if changed.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _FolderState.__new__(_FolderState)

        __props__.__dict__["custom_attributes"] = custom_attributes
        __props__.__dict__["datacenter_id"] = datacenter_id
        __props__.__dict__["path"] = path
        __props__.__dict__["tags"] = tags
        __props__.__dict__["type"] = type
        return Folder(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="customAttributes")
    def custom_attributes(self) -> pulumi.Output[Optional[Mapping[str, builtins.str]]]:
        """
        Map of custom attribute ids to attribute
        value strings to set for folder. See [here][docs-setting-custom-attributes]
        for a reference on how to set values for custom attributes.

        [docs-setting-custom-attributes]: /docs/providers/vsphere/r/custom_attribute.html#using-custom-attributes-in-a-supported-resource

        > **NOTE:** Custom attributes are unsupported on direct ESXi connections
        and require vCenter.
        """
        return pulumi.get(self, "custom_attributes")

    @property
    @pulumi.getter(name="datacenterId")
    def datacenter_id(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The ID of the datacenter the folder will be created in.
        Required for all folder types except for datacenter folders. Forces a new
        resource if changed.
        """
        return pulumi.get(self, "datacenter_id")

    @property
    @pulumi.getter
    def path(self) -> pulumi.Output[builtins.str]:
        """
        The path of the folder to be created. This is relative to
        the root of the type of folder you are creating, and the supplied datacenter.
        For example, given a default datacenter of `default-dc`, a folder of type
        `vm` (denoting a virtual machine folder), and a supplied folder of
        `test-folder`, the resulting path would be
        `/default-dc/vm/test-folder`.

        > **NOTE:** `path` can be modified - the resulting behavior is dependent on
        what section of `path` you are modifying. If you are modifying the parent (so
        any part before the last `/`), your folder will be moved to that new parent. If
        modifying the name (the part after the last `/`), your folder will be renamed.
        """
        return pulumi.get(self, "path")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence[builtins.str]]]:
        """
        The IDs of any tags to attach to this resource.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output[builtins.str]:
        """
        The type of folder to create. Allowed options are
        `datacenter` for datacenter folders, `host` for host and cluster folders,
        `vm` for virtual machine folders, `datastore` for datastore folders, and
        `network` for network folders. Forces a new resource if changed.
        """
        return pulumi.get(self, "type")

